/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JavaLaunchableTester
extends PropertyTester {
    private static final String PROPERTY_HAS_MAIN = "hasMain";
    private static final String PROPERTY_HAS_METHOD = "hasMethod";
    private static final String PROPERTY_EXTENDS_CLASS = "extendsClass";
    private static final String PROPERTY_IS_CONTAINER = "isContainer";
    private static final String PROPERTY_PROJECT_NATURE = "hasProjectNature";
    private static final String PROPERTY_EXTENDS_INTERFACE = "extendsInterface";
    private static final String PROPERTY_BUILDPATH_REFERENCE = "buildpathReference";
    private static Map fgModifiers = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        fgModifiers.put("public", new Integer(1));
        fgModifiers.put("protected", new Integer(4));
        fgModifiers.put("private", new Integer(2));
        fgModifiers.put("static", new Integer(8));
        fgModifiers.put("final", new Integer(16));
        fgModifiers.put("synchronized", new Integer(32));
        fgModifiers.put("abstract", new Integer(1024));
        fgModifiers.put("native", new Integer(256));
    }

    private IType getType(IJavaElement element) throws JavaModelException {
        IType type = null;
        if (element instanceof ICompilationUnit) {
            type = ((ICompilationUnit)element).findPrimaryType();
        } else if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        } else if (element instanceof IType) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasMain(IJavaElement element) {
        try {
            IType type = this.getType(element);
            if (type == null) return false;
            if (!type.exists()) return false;
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (true) {
                if (i >= methods.length) {
                    return false;
                }
                if (methods[i].isMainMethod()) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private boolean hasMethod(IJavaElement element, Object[] args) {
        try {
            IType type;
            if (args.length > 1 && (type = this.getType(element)) != null && type.exists()) {
                String name = (String)args[0];
                String signature = (String)args[1];
                String[] parms = Signature.getParameterTypes((String)signature);
                String returnType = Signature.getReturnType((String)signature);
                IMethod candidate = type.getMethod(name, parms);
                if (candidate.exists() && candidate.getReturnType().equals(returnType) && args.length > 2) {
                    String modifierText = (String)args[2];
                    String[] modifiers = modifierText.split(" ");
                    int flags = 0;
                    int j = 0;
                    while (j < modifiers.length) {
                        String modifier = modifiers[j];
                        Integer flag = (Integer)fgModifiers.get(modifier);
                        if (flag != null) {
                            flags |= flag.intValue();
                        }
                        ++j;
                    }
                    if (candidate.getFlags() == flags) {
                        return true;
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private boolean hasProjectNature(IJavaElement element, String ntype) {
        try {
            IResource resource;
            if (element != null && (resource = element.getResource()) != null) {
                IProject proj = resource.getProject();
                return proj.isAccessible() && proj.hasNature(ntype);
            }
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasSuperclass(IJavaElement element, String qname) {
        try {
            IType type = this.getType(element);
            if (type == null) return false;
            IType[] stypes = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()).getAllSuperclasses(type);
            int i = 0;
            while (true) {
                if (i >= stypes.length) {
                    return false;
                }
                if (stypes[i].getFullyQualifiedName().equals(qname)) return true;
                if (stypes[i].getElementName().equals(qname)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private boolean hasItemOnBuildPath(IJavaElement element, Object[] args) {
        if (element != null && args != null) {
            IJavaProject project = element.getJavaProject();
            HashSet<IJavaProject> searched = new HashSet<IJavaProject>();
            searched.add(project);
            return this.hasItemsOnBuildPath(project, searched, args);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasItemsOnBuildPath(IJavaProject project, Set searched, Object[] args) {
        try {
            ArrayList<IJavaProject> projects = new ArrayList<IJavaProject>();
            if (project != null && project.exists()) {
                IClasspathEntry[] entries = project.getResolvedClasspath(true);
                int i = 0;
                while (i < entries.length) {
                    IClasspathEntry entry = entries[i];
                    IPath path = entry.getPath();
                    String spath = path.toPortableString();
                    int j = 0;
                    while (j < args.length) {
                        if (spath.lastIndexOf((String)args[j]) != -1) {
                            return true;
                        }
                        ++j;
                    }
                    if (entry.getEntryKind() == 2) {
                        String name = entry.getPath().lastSegment();
                        IProject dep = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        IJavaProject javaProject = JavaCore.create((IProject)dep);
                        if (!searched.contains(javaProject)) {
                            projects.add(javaProject);
                        }
                    }
                    ++i;
                }
            }
            Iterator iterator = projects.iterator();
            while (iterator.hasNext()) {
                IJavaProject jp = (IJavaProject)iterator.next();
                searched.add(jp);
                if (!this.hasItemsOnBuildPath(jp, searched, args)) continue;
                return true;
            }
            return false;
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean implementsInterface(IJavaElement element, String qname) {
        try {
            IType type = this.getType(element);
            if (type == null) return false;
            IType[] itypes = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()).getAllInterfaces();
            int i = 0;
            while (true) {
                if (i >= itypes.length) {
                    return false;
                }
                if (itypes[i].getFullyQualifiedName().equals(qname)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_IS_CONTAINER.equals(property)) {
            if (receiver instanceof IAdaptable) {
                IResource resource;
                IAdaptable iAdaptable = (IAdaptable)receiver;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                    return resource instanceof IContainer;
                }
            }
            return false;
        }
        IJavaElement element = null;
        if (receiver instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)receiver;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null && !element.exists()) {
                return false;
            }
        }
        if (PROPERTY_HAS_MAIN.equals(property)) {
            return this.hasMain(element);
        }
        if (PROPERTY_HAS_METHOD.equals(property)) {
            return this.hasMethod(element, args);
        }
        if (PROPERTY_BUILDPATH_REFERENCE.equals(property)) {
            return this.hasItemOnBuildPath(element, args);
        }
        if (PROPERTY_EXTENDS_CLASS.equals(property)) {
            return this.hasSuperclass(element, (String)args[0]);
        }
        if (PROPERTY_PROJECT_NATURE.equals(property)) {
            return this.hasProjectNature(element, (String)args[0]);
        }
        if (PROPERTY_EXTENDS_INTERFACE.equals(property)) {
            return this.implementsInterface(element, (String)args[0]);
        }
        return false;
    }
}

