/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.viewers;

import org.eclipse.jface.internal.databinding.internal.viewers.MultiMappingAndListBinding;
import org.eclipse.jface.internal.databinding.internal.viewers.MultiMappingAndSetBinding;
import org.eclipse.jface.internal.databinding.provisional.BindSpec;
import org.eclipse.jface.internal.databinding.provisional.Binding;
import org.eclipse.jface.internal.databinding.provisional.BindingException;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.factories.IBindingFactory;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IObservableMultiMappingWithDomain;
import org.eclipse.jface.internal.databinding.provisional.observable.set.IObservableSet;
import org.eclipse.jface.internal.databinding.provisional.viewers.IObservableCollectionWithLabels;

public class ViewersBindingFactory
implements IBindingFactory {
    public Binding createBinding(DataBindingContext dataBindingContext, IObservable targetObservable, IObservable modelObservable, BindSpec bindSpec) {
        if (bindSpec == null) {
            bindSpec = new BindSpec(null, null, null, null);
        }
        if (targetObservable instanceof IObservableList && targetObservable instanceof IObservableCollectionWithLabels) {
            IObservableMultiMappingWithDomain model;
            if (modelObservable instanceof IObservableMultiMappingWithDomain && (model = (IObservableMultiMappingWithDomain)modelObservable).getDomain() instanceof IObservableList) {
                IObservableList modelList = (IObservableList)model.getDomain();
                IObservableCollectionWithLabels target = (IObservableCollectionWithLabels)targetObservable;
                IObservableList targetList = (IObservableList)targetObservable;
                dataBindingContext.fillBindSpecDefaults(dataBindingContext, bindSpec, targetList.getElementType(), modelList.getElementType());
                MultiMappingAndListBinding binding = new MultiMappingAndListBinding(dataBindingContext, targetList, target, modelList, model, bindSpec);
                return binding;
            }
            throw new BindingException("incompatible updatables: target is observable list with labels, model is " + modelObservable.getClass().getName());
        }
        if (targetObservable instanceof IObservableSet && targetObservable instanceof IObservableCollectionWithLabels) {
            IObservableMultiMappingWithDomain model;
            if (modelObservable instanceof IObservableMultiMappingWithDomain && (model = (IObservableMultiMappingWithDomain)modelObservable).getDomain() instanceof IObservableSet) {
                IObservableSet modelSet = (IObservableSet)model.getDomain();
                IObservableCollectionWithLabels target = (IObservableCollectionWithLabels)targetObservable;
                IObservableSet targetSet = (IObservableSet)targetObservable;
                dataBindingContext.fillBindSpecDefaults(dataBindingContext, bindSpec, targetSet.getElementType(), modelSet.getElementType());
                MultiMappingAndSetBinding binding = new MultiMappingAndSetBinding(dataBindingContext, targetSet, target, modelSet, model, bindSpec);
                return binding;
            }
            throw new BindingException("incompatible updatables: target is observable set with labels, model is " + modelObservable.getClass().getName());
        }
        return null;
    }
}

