/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.core.subscribers.SubscriberChangeSetCollector;
import org.osgi.service.prefs.Preferences;

public class ActiveChangeSet
extends DiffChangeSet {
    private static final String CTX_TITLE = "title";
    private static final String CTX_COMMENT = "comment";
    private static final String CTX_RESOURCES = "resources";
    private String comment;
    private final SubscriberChangeSetCollector manager;

    public ActiveChangeSet(SubscriberChangeSetCollector manager, String title) {
        super(title);
        this.manager = manager;
    }

    public String getTitle() {
        return this.getName();
    }

    public void setTitle(String title) {
        this.setName(title);
        this.getManager().fireNameChangedEvent(this);
    }

    public String getComment() {
        if (this.comment == null) {
            return this.getTitle();
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment != null && comment.equals(this.getTitle()) ? null : comment;
    }

    protected boolean isValidChange(IDiff diff) {
        return this.getManager().isModified(diff);
    }

    private void addResource(IResource resource) throws CoreException {
        Subscriber subscriber = this.getManager().getSubscriber();
        IDiff diff = subscriber.getDiff(resource);
        if (diff != null) {
            this.add(diff);
        }
    }

    private SubscriberChangeSetCollector getManager() {
        return this.manager;
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void save(Preferences prefs) {
        prefs.put(CTX_TITLE, this.getTitle());
        if (this.comment != null) {
            prefs.put(CTX_COMMENT, this.comment);
        }
        if (!this.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            IResource[] resources = this.getResources();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                buffer.append(resource.getFullPath().toString());
                buffer.append('\n');
                ++i;
            }
            prefs.put(CTX_RESOURCES, buffer.toString());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(Preferences prefs) {
        this.setName(prefs.get(CTX_TITLE, ""));
        this.comment = prefs.get(CTX_COMMENT, null);
        String resourcePaths = prefs.get(CTX_RESOURCES, null);
        if (resourcePaths == null) return;
        ResourceDiffTree tree = this.internalGetDiffTree();
        try {
            tree.beginInput();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            StringTokenizer tokenizer = new StringTokenizer(resourcePaths, "\n");
            while (tokenizer.hasMoreTokens()) {
                String next = tokenizer.nextToken();
                if (next.trim().length() <= 0) continue;
                IResource resource = this.getResource(root, next);
                try {
                    if (resource == null || this.manager.getSubscriber().getSyncInfo(resource) == null) continue;
                    try {
                        this.addResource(resource);
                    }
                    catch (CoreException e) {
                        TeamPlugin.log(e);
                    }
                }
                catch (TeamException e) {
                    TeamPlugin.log(e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            tree.endInput(null);
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        tree.endInput(null);
    }

    private IResource getResource(IWorkspaceRoot root, String next) {
        Object resource = root.findMember(next);
        if (resource == null) {
            Path path = new Path(null, next);
            resource = next.charAt(next.length() - 1) == '/' ? (path.segmentCount() == 1 ? root.getProject(path.lastSegment()) : root.getFolder((IPath)path)) : root.getFile((IPath)path);
        }
        return resource;
    }

    public void add(IResource[] resources) throws CoreException {
        ArrayList<IDiff> toAdd = new ArrayList<IDiff>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            IDiff diff = this.getManager().getDiff(resource);
            if (diff != null) {
                toAdd.add(diff);
            }
            ++i;
        }
        if (!toAdd.isEmpty()) {
            this.add(toAdd.toArray(new IDiff[toAdd.size()]));
        }
    }
}

