/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;

public abstract class ChangeSetCollector {
    private ListenerList listeners = new ListenerList(1);
    private Set sets = new HashSet();

    protected Object[] getListeners() {
        return this.listeners.getListeners();
    }

    protected void fireNameChangedEvent(final ChangeSet set) {
        if (this.contains(set)) {
            Object[] listeners = this.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IChangeSetChangeListener listener = (IChangeSetChangeListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.nameChanged(set);
                    }
                });
                ++i;
            }
        }
    }

    protected void fireDefaultChangedEvent(final ChangeSet oldSet, final ChangeSet defaultSet) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IChangeSetChangeListener listener = (IChangeSetChangeListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.defaultSetChanged(oldSet, defaultSet);
                }
            });
            ++i;
        }
    }

    public void add(ChangeSet set) {
        if (!this.contains(set)) {
            this.sets.add(set);
            this.handleSetAdded(set);
        }
    }

    protected void handleSetAdded(final ChangeSet set) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IChangeSetChangeListener listener = (IChangeSetChangeListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.setAdded(set);
                }
            });
            ++i;
        }
    }

    public void remove(ChangeSet set) {
        if (this.contains(set)) {
            this.sets.remove(set);
            this.handleSetRemoved(set);
        }
    }

    protected void handleSetRemoved(final ChangeSet set) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IChangeSetChangeListener listener = (IChangeSetChangeListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.setRemoved(set);
                }
            });
            ++i;
        }
    }

    public boolean contains(ChangeSet set) {
        return this.sets.contains(set);
    }

    public void addListener(IChangeSetChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IChangeSetChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public ChangeSet[] getSets() {
        return this.sets.toArray(new ChangeSet[this.sets.size()]);
    }

    public void dispose() {
    }

    protected void fireResourcesChangedEvent(final ChangeSet changeSet, final IPath[] allAffectedResources) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IChangeSetChangeListener listener = (IChangeSetChangeListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.resourcesChanged(changeSet, allAffectedResources);
                }
            });
            ++i;
        }
    }
}

