/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.core.BackgroundEventHandler;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffTreeChangeSetCollector;
import org.eclipse.team.internal.core.subscribers.SubscriberResourceCollector;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SubscriberChangeSetCollector
extends DiffTreeChangeSetCollector
implements IDiffChangeListener {
    private static final String PREF_CHANGE_SETS = "changeSets";
    private static final String CTX_DEFAULT_SET = "defaultSet";
    private static final int RESOURCE_REMOVAL = 1;
    private static final int RESOURCE_CHANGE = 2;
    private ActiveChangeSet defaultSet;
    private EventHandler handler;
    private ResourceCollector collector;

    public SubscriberChangeSetCollector(Subscriber subscriber) {
        this.collector = new ResourceCollector(subscriber);
        this.load();
        this.handler = new EventHandler(NLS.bind((String)Messages.SubscriberChangeSetCollector_1, (Object[])new String[]{subscriber.getName()}), NLS.bind((String)Messages.SubscriberChangeSetCollector_2, (Object[])new String[]{subscriber.getName()}));
    }

    public boolean hasMembers(IResource resource) {
        ChangeSet[] sets = this.getSets();
        int i = 0;
        while (i < sets.length) {
            ActiveChangeSet set = (ActiveChangeSet)sets[i];
            if (set.getDiffTree().getChildren(resource.getFullPath()).length > 0) {
                return true;
            }
            ++i;
        }
        if (this.defaultSet != null) {
            return this.defaultSet.getDiffTree().getChildren(resource.getFullPath()).length > 0;
        }
        return false;
    }

    public void add(ChangeSet set) {
        Assert.isTrue((boolean)(set instanceof ActiveChangeSet));
        super.add(set);
    }

    protected void handleSetAdded(ChangeSet set) {
        Assert.isTrue((boolean)(set instanceof ActiveChangeSet));
        super.handleSetAdded(set);
        this.handleAddedResources(set, ((ActiveChangeSet)set).internalGetDiffTree().getDiffs());
    }

    protected boolean isSingleSetPerResource() {
        return true;
    }

    public ActiveChangeSet createSet(String title, IDiff[] diffs) {
        ActiveChangeSet commitSet = this.doCreateSet(title);
        if (diffs != null && diffs.length > 0) {
            commitSet.add(diffs);
        }
        return commitSet;
    }

    protected ActiveChangeSet doCreateSet(String name) {
        return new ActiveChangeSet(this, name);
    }

    public ActiveChangeSet createSet(String title, IFile[] files) throws CoreException {
        ArrayList<IDiff> infos = new ArrayList<IDiff>();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            IDiff diff = this.getDiff((IResource)file);
            if (diff != null) {
                infos.add(diff);
            }
            ++i;
        }
        return this.createSet(title, infos.toArray(new IDiff[infos.size()]));
    }

    public void makeDefault(ActiveChangeSet set) {
        if (!this.contains(set)) {
            this.add(set);
        }
        ActiveChangeSet oldSet = this.defaultSet;
        this.defaultSet = set;
        this.fireDefaultChangedEvent(oldSet, this.defaultSet);
    }

    public ActiveChangeSet getDefaultSet() {
        return this.defaultSet;
    }

    public boolean isDefault(ActiveChangeSet set) {
        return set == this.defaultSet;
    }

    protected IDiff getDiff(IResource resource) throws CoreException {
        Subscriber subscriber = this.getSubscriber();
        return subscriber.getDiff(resource);
    }

    public Subscriber getSubscriber() {
        return this.collector.getSubscriber();
    }

    protected boolean isModified(IDiff diff) {
        if (diff != null) {
            if (diff instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)diff;
                int dir = twd.getDirection();
                return dir == 256 || dir == 768;
            }
            return diff.getKind() != 0;
        }
        return false;
    }

    public void dispose() {
        this.handler.shutdown();
        this.collector.dispose();
        super.dispose();
        this.save();
    }

    private void save() {
        int i;
        Preferences prefs = this.getPreferences();
        try {
            String[] oldSetNames = prefs.childrenNames();
            i = 0;
            while (i < oldSetNames.length) {
                String string = oldSetNames[i];
                prefs.node(string).removeNode();
                ++i;
            }
        }
        catch (BackingStoreException e) {
            TeamPlugin.log(4, NLS.bind((String)"An error occurred purging the commit set state for {0}", (Object[])new String[]{this.getSubscriber().getName()}), e);
        }
        ChangeSet[] sets = this.getSets();
        i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (set instanceof ActiveChangeSet && !set.isEmpty()) {
                Preferences child = prefs.node(((ActiveChangeSet)set).getTitle());
                ((ActiveChangeSet)set).save(child);
            }
            ++i;
        }
        if (this.defaultSet != null) {
            prefs.put(CTX_DEFAULT_SET, this.defaultSet.getTitle());
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            TeamPlugin.log(4, NLS.bind((String)Messages.SubscriberChangeSetCollector_3, (Object[])new String[]{this.getSubscriber().getName()}), e);
        }
    }

    private void load() {
        Preferences prefs = this.getPreferences();
        String defaultSetTitle = prefs.get(CTX_DEFAULT_SET, null);
        try {
            String[] childNames = prefs.childrenNames();
            int i = 0;
            while (i < childNames.length) {
                String string = childNames[i];
                Preferences childPrefs = prefs.node(string);
                ActiveChangeSet set = this.createSet(string, childPrefs);
                if (!set.isEmpty()) {
                    if (this.defaultSet == null && defaultSetTitle != null && set.getTitle().equals(defaultSetTitle)) {
                        this.defaultSet = set;
                    }
                    this.add(set);
                }
                ++i;
            }
        }
        catch (BackingStoreException e) {
            TeamPlugin.log(4, NLS.bind((String)Messages.SubscriberChangeSetCollector_4, (Object[])new String[]{this.getSubscriber().getName()}), e);
        }
    }

    protected ActiveChangeSet createSet(String title, Preferences childPrefs) {
        ActiveChangeSet changeSet = this.doCreateSet(title);
        changeSet.init(childPrefs);
        return changeSet;
    }

    private Preferences getPreferences() {
        return SubscriberChangeSetCollector.getParentPreferences().node(this.getSubscriberIdentifier());
    }

    private static Preferences getParentPreferences() {
        return SubscriberChangeSetCollector.getTeamPreferences().node(PREF_CHANGE_SETS);
    }

    private static Preferences getTeamPreferences() {
        return new InstanceScope().getNode(TeamPlugin.getPlugin().getBundle().getSymbolicName());
    }

    protected String getSubscriberIdentifier() {
        return this.getSubscriber().getName();
    }

    private IPath[] getAllResources(IDiffChangeEvent event) {
        HashSet<IPath> allResources = new HashSet<IPath>();
        IDiff[] addedResources = event.getAdditions();
        int i = 0;
        while (i < addedResources.length) {
            IDiff diff = addedResources[i];
            allResources.add(diff.getPath());
            ++i;
        }
        IDiff[] changedResources = event.getChanges();
        int i2 = 0;
        while (i2 < changedResources.length) {
            IDiff diff = changedResources[i2];
            allResources.add(diff.getPath());
            ++i2;
        }
        IPath[] removals = event.getRemovals();
        int i3 = 0;
        while (i3 < removals.length) {
            IPath path = removals[i3];
            allResources.add(path);
            ++i3;
        }
        return allResources.toArray(new IPath[allResources.size()]);
    }

    private void handleAddedResources(ChangeSet set, IDiff[] diffs) {
        if (this.isSingleSetPerResource()) {
            IResource[] resources = new IResource[diffs.length];
            int i = 0;
            while (i < resources.length) {
                resources[i] = ((DiffChangeSet)set).getDiffTree().getResource(diffs[i]);
                ++i;
            }
            ChangeSet[] sets = this.getSets();
            int i2 = 0;
            while (i2 < sets.length) {
                ChangeSet otherSet = sets[i2];
                if (otherSet != set) {
                    otherSet.remove(resources);
                }
                ++i2;
            }
        }
    }

    private void handleSyncSetChange(IResourceDiffTree tree, IDiff[] addedDiffs, IPath[] allAffectedResources) {
        ChangeSet changeSet = this.getChangeSet(tree);
        if (tree.isEmpty() && changeSet != null) {
            this.remove(changeSet);
        }
        this.fireResourcesChangedEvent(changeSet, allAffectedResources);
        this.handleAddedResources(changeSet, addedDiffs);
    }

    protected IDiffChangeListener getDiffTreeListener() {
        return this;
    }

    public void waitUntilDone(IProgressMonitor monitor) {
        monitor.worked(1);
        while (this.handler.getEventHandlerJob().getState() != 0) {
            monitor.worked(1);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            Policy.checkCanceled(monitor);
        }
        monitor.worked(1);
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        IResourceDiffTree tree = (IResourceDiffTree)event.getTree();
        this.handleSyncSetChange(tree, event.getAdditions(), this.getAllResources(event));
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }

    private class EventHandler
    extends BackgroundEventHandler {
        private List dispatchEvents = new ArrayList();

        protected EventHandler(String jobName, String errorTitle) {
            super(jobName, errorTitle);
        }

        protected void processEvent(BackgroundEventHandler.Event event, IProgressMonitor monitor) throws CoreException {
            if (this.isShutdown()) {
                throw new OperationCanceledException();
            }
            this.dispatchEvents.add(event);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean doDispatchEvents(IProgressMonitor monitor) throws TeamException {
            if (this.dispatchEvents.isEmpty()) {
                return false;
            }
            if (this.isShutdown()) {
                throw new OperationCanceledException();
            }
            ResourceDiffTree[] locked = null;
            try {
                try {
                    locked = this.beginDispath();
                    Iterator iter = this.dispatchEvents.iterator();
                    while (iter.hasNext()) {
                        BackgroundEventHandler.Event event = (BackgroundEventHandler.Event)iter.next();
                        switch (event.getType()) {
                            case 1: {
                                this.handleRemove(event.getResource());
                                break;
                            }
                            case 2: {
                                this.handleChange(event.getResource(), ((BackgroundEventHandler.ResourceEvent)event).getDepth());
                                break;
                            }
                        }
                        if (!this.isShutdown()) continue;
                        throw new OperationCanceledException();
                    }
                }
                catch (CoreException e) {
                    throw TeamException.asTeamException(e);
                }
                Object var5_8 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    this.endDispatch(locked, monitor);
                    Object var7_12 = null;
                    this.dispatchEvents.clear();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var7_11 = null;
                    this.dispatchEvents.clear();
                    throw throwable2;
                }
            }
            try {}
            catch (Throwable throwable) {
                Object var7_13 = null;
                this.dispatchEvents.clear();
                throw throwable;
            }
            this.endDispatch(locked, monitor);
            Object var7_14 = null;
            this.dispatchEvents.clear();
            return true;
        }

        private ResourceDiffTree[] beginDispath() {
            ChangeSet[] sets = SubscriberChangeSetCollector.this.getSets();
            ArrayList<ResourceDiffTree> lockedSets = new ArrayList<ResourceDiffTree>();
            try {
                int i = 0;
                while (i < sets.length) {
                    ActiveChangeSet set = (ActiveChangeSet)sets[i];
                    ResourceDiffTree tree = set.internalGetDiffTree();
                    lockedSets.add(tree);
                    tree.beginInput();
                    ++i;
                }
                return lockedSets.toArray(new ResourceDiffTree[lockedSets.size()]);
            }
            catch (RuntimeException e) {
                try {
                    Iterator iter = lockedSets.iterator();
                    while (iter.hasNext()) {
                        ResourceDiffTree tree = (ResourceDiffTree)iter.next();
                        try {
                            tree.endInput(null);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {}
            }
            throw e;
        }

        private void endDispatch(ResourceDiffTree[] locked, IProgressMonitor monitor) {
            if (locked == null) {
                return;
            }
            monitor.beginTask(null, 100 * locked.length);
            int i = 0;
            while (i < locked.length) {
                ResourceDiffTree tree = locked[i];
                try {
                    tree.endInput(Policy.subMonitorFor(monitor, 100));
                }
                catch (RuntimeException e) {
                    TeamPlugin.log(4, Messages.SubscriberChangeSetCollector_0, e);
                    throw e;
                }
                ++i;
            }
            monitor.done();
        }

        protected synchronized void queueEvent(BackgroundEventHandler.Event event, boolean front) {
            super.queueEvent(event, front);
        }

        private void handleRemove(IResource resource) {
            ChangeSet[] sets = SubscriberChangeSetCollector.this.getSets();
            int i = 0;
            while (i < sets.length) {
                ChangeSet set = sets[i];
                if (!set.isEmpty()) {
                    set.rootRemoved(resource, 2);
                    if (set.isEmpty()) {
                        SubscriberChangeSetCollector.this.remove(set);
                    }
                }
                ++i;
            }
        }

        private void handleChange(IResource resource, int depth) throws CoreException {
            int i;
            IDiff diff = SubscriberChangeSetCollector.this.getDiff(resource);
            if (SubscriberChangeSetCollector.this.isModified(diff)) {
                ActiveChangeSet[] containingSets = this.getContainingSets(resource);
                if (containingSets.length == 0) {
                    if (SubscriberChangeSetCollector.this.defaultSet != null) {
                        SubscriberChangeSetCollector.this.defaultSet.add(diff);
                    }
                } else {
                    i = 0;
                    while (i < containingSets.length) {
                        ActiveChangeSet set = containingSets[i];
                        set.add(diff);
                        ++i;
                    }
                }
            } else {
                this.removeFromAllSets(resource);
            }
            if (depth != 0) {
                IResource[] members = SubscriberChangeSetCollector.this.getSubscriber().members(resource);
                i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    this.handleChange(member, depth == 1 ? 0 : 2);
                    ++i;
                }
            }
        }

        private void removeFromAllSets(IResource resource) {
            ChangeSet set;
            ArrayList<ChangeSet> toRemove = new ArrayList<ChangeSet>();
            ChangeSet[] sets = SubscriberChangeSetCollector.this.getSets();
            int i = 0;
            while (i < sets.length) {
                set = sets[i];
                if (set.contains(resource)) {
                    set.remove(resource);
                    if (set.isEmpty()) {
                        toRemove.add(set);
                    }
                }
                ++i;
            }
            Iterator iter = toRemove.iterator();
            while (iter.hasNext()) {
                set = (ActiveChangeSet)iter.next();
                SubscriberChangeSetCollector.this.remove(set);
            }
        }

        private ActiveChangeSet[] getContainingSets(IResource resource) {
            HashSet<ChangeSet> result = new HashSet<ChangeSet>();
            ChangeSet[] sets = SubscriberChangeSetCollector.this.getSets();
            int i = 0;
            while (i < sets.length) {
                ChangeSet set = sets[i];
                if (set.contains(resource)) {
                    result.add(set);
                }
                ++i;
            }
            return result.toArray(new ActiveChangeSet[result.size()]);
        }
    }

    private class ResourceCollector
    extends SubscriberResourceCollector {
        public ResourceCollector(Subscriber subscriber) {
            super(subscriber);
        }

        protected void remove(IResource resource) {
            SubscriberChangeSetCollector.this.handler.queueEvent(new BackgroundEventHandler.ResourceEvent(resource, 1, 2), false);
        }

        protected void change(IResource resource, int depth) {
            SubscriberChangeSetCollector.this.handler.queueEvent(new BackgroundEventHandler.ResourceEvent(resource, 2, depth), false);
        }

        protected boolean hasMembers(IResource resource) {
            return SubscriberChangeSetCollector.this.hasMembers(resource);
        }
    }
}

