/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISiteWithMirrors;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.wizards.MirrorsDialog;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.IUpdateSearchResultCollectorFromMirror;
import org.eclipse.update.search.UpdateSearchRequest;

public class UpdateJob
extends Job {
    public static final Object FAMILY;
    public static final Object family;
    private IUpdateSearchResultCollector resultCollector;
    private UpdateSearchRequest searchRequest;
    private ArrayList updates;
    private boolean isUpdate;
    private boolean download;
    private boolean isAutomatic;
    private IStatus jobStatus = Status.OK_STATUS;
    private int mirrorIndex;

    static {
        family = FAMILY = new Object();
    }

    public UpdateJob(String name, boolean isAutomatic, boolean download) {
        this(name, isAutomatic, download, null);
    }

    public UpdateJob(String name, boolean isAutomatic, boolean download, IFeature[] features) {
        super(name);
        this.isUpdate = true;
        this.isAutomatic = isAutomatic;
        this.download = download;
        this.updates = new ArrayList();
        this.searchRequest = UpdateUtils.createNewUpdatesRequest((IFeature[])features);
        this.setPriority(50);
        this.mirrorIndex = 0;
    }

    public UpdateJob(String name, UpdateSearchRequest searchRequest) {
        super(name);
        this.searchRequest = searchRequest;
        this.updates = new ArrayList();
        this.setPriority(50);
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public boolean belongsTo(Object family) {
        return FAMILY == family;
    }

    public IStatus run(IProgressMonitor monitor) {
        this.jobStatus = this.isUpdate ? this.runUpdates(monitor) : this.runSearchForNew(monitor);
        return Status.OK_STATUS;
    }

    private IStatus runSearchForNew(IProgressMonitor monitor) {
        if (UpdateCore.DEBUG) {
            UpdateCore.debug((String)"Search for features started.");
        }
        try {
            if (this.resultCollector == null) {
                this.resultCollector = new ResultCollectorWithMirrors();
            }
            this.searchRequest.performSearch(this.resultCollector, monitor);
            if (UpdateCore.DEBUG) {
                UpdateCore.debug((String)("Automatic update search finished - " + this.updates.size() + " results."));
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    private IStatus runUpdates(IProgressMonitor monitor) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        if (UpdateCore.DEBUG) {
            if (this.isAutomatic) {
                UpdateCore.debug((String)"Automatic update search started.");
            } else {
                UpdateCore.debug((String)"Update search started.");
            }
        }
        if (this.resultCollector == null) {
            this.resultCollector = new ResultCollectorWithMirrors();
        }
        try {
            this.searchRequest.performSearch(this.resultCollector, monitor);
        }
        catch (CoreException e) {
            statusList.add(e.getStatus());
        }
        if (UpdateCore.DEBUG) {
            UpdateCore.debug((String)("Automatic update search finished - " + this.updates.size() + " results."));
        }
        if (this.updates.size() > 0 && this.download) {
            if (UpdateCore.DEBUG) {
                UpdateCore.debug((String)"Automatic download of updates started.");
            }
            int i = 0;
            while (i < this.updates.size()) {
                IInstallFeatureOperation op = (IInstallFeatureOperation)this.updates.get(i);
                IFeature feature = op.getFeature();
                try {
                    UpdateUtils.downloadFeatureContent((IConfiguredSite)op.getTargetSite(), (IFeature)feature, null, (IProgressMonitor)monitor);
                }
                catch (InstallAbortedException installAbortedException) {
                    return Status.CANCEL_STATUS;
                }
                catch (CoreException e) {
                    statusList.add(e.getStatus());
                    this.updates.remove(i);
                    --i;
                }
                ++i;
            }
            if (UpdateCore.DEBUG) {
                UpdateCore.debug((String)"Automatic download of updates finished.");
            }
        }
        if (statusList.size() == 0) {
            return Status.OK_STATUS;
        }
        if (statusList.size() == 1) {
            return (IStatus)statusList.get(0);
        }
        IStatus[] children = statusList.toArray(new IStatus[statusList.size()]);
        return new MultiStatus("org.eclipse.update.ui", 42, children, Messages.Search_networkProblems, null);
    }

    public IInstallFeatureOperation[] getUpdates() {
        return this.updates.toArray(new IInstallFeatureOperation[this.updates.size()]);
    }

    public IStatus getStatus() {
        return this.jobStatus;
    }

    public UpdateSearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    private class SearchResultCollector
    implements IUpdateSearchResultCollector {
        private SearchResultCollector() {
        }

        public void accept(IFeature feature) {
            IInstallFeatureOperation operation = OperationsManager.getOperationFactory().createInstallOperation(null, feature, null, null, null);
            UpdateJob.this.updates.add(operation);
        }
    }

    private class ResultCollectorWithMirrors
    extends SearchResultCollector
    implements IUpdateSearchResultCollectorFromMirror {
        private HashMap mirrors = new HashMap(0);

        private ResultCollectorWithMirrors() {
        }

        public IURLEntry getMirror(ISiteWithMirrors site, String siteName) {
            IURLEntry[] mirrorURLs;
            boolean automaticallyChooseMirrors;
            block6: {
                if (UpdateJob.this.isUpdate && UpdateJob.this.isAutomatic) {
                    return null;
                }
                if (this.mirrors.containsKey(site)) {
                    return (IURLEntry)this.mirrors.get(site);
                }
                try {
                    automaticallyChooseMirrors = UpdateCore.getPlugin().getPluginPreferences().getBoolean("org.eclipse.update.core.automaticallyChooseMirror");
                    mirrorURLs = site.getMirrorSiteEntries();
                    if (mirrorURLs.length != 0) break block6;
                    return null;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            if (automaticallyChooseMirrors) {
                return mirrorURLs[UpdateJob.this.mirrorIndex];
            }
            IURLEntry[] returnValue = new IURLEntry[1];
            UpdateUI.getStandardDisplay().syncExec(new Runnable(this, site, siteName, returnValue){
                final /* synthetic */ ResultCollectorWithMirrors this$1;
                private final /* synthetic */ ISiteWithMirrors val$site;
                private final /* synthetic */ String val$siteName;
                private final /* synthetic */ IURLEntry[] val$returnValue;
                {
                    this.this$1 = resultCollectorWithMirrors;
                    this.val$site = iSiteWithMirrors;
                    this.val$siteName = string;
                    this.val$returnValue = iURLEntryArray;
                }

                public void run() {
                    MirrorsDialog dialog = new MirrorsDialog(UpdateUI.getActiveWorkbenchShell(), this.val$site, this.val$siteName);
                    dialog.create();
                    dialog.open();
                    IURLEntry mirror = dialog.getMirror();
                    ResultCollectorWithMirrors.access$0(this.this$1).put(this.val$site, mirror);
                    this.val$returnValue[0] = mirror;
                }
            });
            return returnValue[0];
        }

        static /* synthetic */ HashMap access$0(ResultCollectorWithMirrors resultCollectorWithMirrors) {
            return resultCollectorWithMirrors.mirrors;
        }
    }
}

