/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.jface.dialogs.DialogMessageArea;
import org.eclipse.jface.dialogs.ImageAndMessageArea;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class PreferenceMessageArea
extends DialogMessageArea {
    private String lastMessageText;
    private int lastMessageType;
    private CLabel titleLabel;
    private ImageAndMessageArea messageArea;
    private static final String ELLIPSIS = "...";
    private PreferenceDialog preferenceDialog;
    private static int titleLabelOffset = -1;

    public PreferenceMessageArea(PreferenceDialog preferenceDialog) {
        this.preferenceDialog = preferenceDialog;
    }

    public void createContents(Composite parent) {
        this.titleLabel = new CLabel(parent, 0);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.messageArea = new ImageAndMessageArea(this.preferenceDialog.formTitleComposite, 0);
        this.messageArea.setFont(JFaceResources.getDialogFont());
        this.messageArea.setVisible(false);
    }

    public void setMessageLayoutData(Object layoutData) {
        ((FormData)layoutData).top = null;
        ((FormData)layoutData).right = new FormAttachment(100, -this.getTitleLabelOffset());
        this.messageArea.setLayoutData(layoutData);
    }

    private int getTitleLabelOffset() {
        if (titleLabelOffset == -1) {
            int offsetCalc = this.preferenceDialog.formTitleComposite.getBounds().width - this.titleLabel.getBounds().width;
            if (offsetCalc > 0) {
                titleLabelOffset = offsetCalc;
                return titleLabelOffset;
            }
            return 0;
        }
        return titleLabelOffset;
    }

    public void updateText(String newMessage, int newType) {
        Image newImage = null;
        switch (newType) {
            case 0: {
                if (newMessage == null) {
                    this.restoreTitle();
                } else {
                    this.showTitle(newMessage, null);
                }
                return;
            }
            case 1: {
                newImage = JFaceResources.getImage("dialog_messasge_info_image");
                break;
            }
            case 2: {
                newImage = JFaceResources.getImage("dialog_messasge_warning_image");
                break;
            }
            case 3: {
                newImage = JFaceResources.getImage("dialog_message_error_image");
            }
        }
        this.messageArea.setVisible(true);
        this.messageArea.moveAbove(null);
        this.messageArea.setImage(newImage);
        this.messageArea.setText(PreferenceMessageArea.shortenText(newMessage, (Control)this.messageArea, newImage.getBounds().width + 4));
        this.messageArea.setToolTipText(newMessage);
        this.lastMessageText = newMessage;
        int bottom = this.messageArea.getParent().getBounds().height;
        Rectangle titleLabelBounds = this.titleLabel.getBounds();
        if (Policy.getAnimator().getAnimationState() == 0 || Policy.getAnimator().getAnimationState() == 3) {
            if (Policy.getAnimator().getAnimationState() == 0) {
                this.messageArea.setBounds(titleLabelBounds.x, bottom, titleLabelBounds.width, this.messageArea.computeSize((int)-1, (int)-1).y);
            }
            Policy.getAnimator().setAnimationState(1);
            Policy.getAnimator().setVisible(true, (Control)this.messageArea);
        }
        this.setMessageLayoutData(this.messageArea.getLayoutData());
    }

    public void restoreTitle() {
        this.titleLabel.setVisible(true);
        if (Policy.getAnimator().getAnimationState() == 1 || Policy.getAnimator().getAnimationState() == 2) {
            Policy.getAnimator().setAnimationState(3);
            Policy.getAnimator().setVisible(false, (Control)this.messageArea);
        }
        this.lastMessageText = null;
        this.lastMessageType = 0;
    }

    private static String shortenText(String textValue, Control control, int offset) {
        int pivot;
        if (textValue == null) {
            return null;
        }
        GC gc = new GC((Drawable)control);
        int maxWidth = control.getBounds().width - 5 - offset;
        if (gc.textExtent((String)textValue).x < maxWidth) {
            gc.dispose();
            return textValue;
        }
        int length = textValue.length();
        int start = pivot = length / 2;
        int end = pivot + 1;
        while (start >= 0 && end < length) {
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            String s = String.valueOf(s1) + ELLIPSIS + s2;
            int l = gc.textExtent((String)s).x;
            if (l < maxWidth) {
                gc.dispose();
                return s;
            }
            --start;
            ++end;
        }
        gc.dispose();
        return textValue;
    }

    public void clearErrorMessage() {
        if (this.lastMessageText == null) {
            this.restoreTitle();
        } else {
            this.updateText(this.lastMessageText, this.lastMessageType);
        }
    }

    public void setTitleLayoutData(Object layoutData) {
        this.titleLabel.setLayoutData(layoutData);
    }

    public void showTitle(String titleMessage, Image titleImage) {
        this.titleLabel.setImage(titleImage);
        this.titleLabel.setText(titleMessage);
        this.restoreTitle();
    }
}

