/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.xhtml.BundleUtil;
import org.eclipse.help.internal.xhtml.XHTMLSupport;
import org.eclipse.help.search.ISearchIndex;
import org.eclipse.help.search.LuceneSearchParticipant;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XHTMLSearchParticipant
extends LuceneSearchParticipant {
    private static String XHTML1_TRANSITIONAL = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    private static String XHTML1_STRICT = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
    private static String XHTML1_FRAMESET = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd";
    private Stack stack = new Stack();
    private SAXParser parser;
    private Set filters;
    protected static Hashtable dtdMap = new Hashtable();

    static {
        String dtdBaseLocation = "dtds/xhtml1-20020801/";
        String dtdLocation = String.valueOf(dtdBaseLocation) + "xhtml1-transitional.dtd";
        URL dtdURL_T = BundleUtil.getResourceAsURL((String)dtdLocation, (String)"org.eclipse.help.base");
        dtdMap.put(XHTML1_TRANSITIONAL, dtdURL_T);
        dtdLocation = String.valueOf(dtdBaseLocation) + "xhtml1-strict.dtd";
        URL dtdURL_S = BundleUtil.getResourceAsURL((String)dtdLocation, (String)"org.eclipse.help.base");
        dtdMap.put(XHTML1_STRICT, dtdURL_S);
        dtdLocation = String.valueOf(dtdBaseLocation) + "xhtml1-frameset.dtd";
        URL dtdURL_F = BundleUtil.getResourceAsURL((String)dtdLocation, (String)"org.eclipse.help.base");
        dtdMap.put(XHTML1_FRAMESET, dtdURL_F);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus addDocument(ISearchIndex index, String pluginId, String name, URL url, String id, Document doc) {
        IStatus iStatus;
        this.filters = new HashSet();
        InputStream stream = null;
        try {
            try {
                String summary;
                if (this.parser == null) {
                    this.parser = SAXParserFactory.newInstance().newSAXParser();
                }
                this.stack.clear();
                ParsedXMLContent parsed = new ParsedXMLContent(index.getLocale());
                XMLHandler handler = new XMLHandler(parsed);
                stream = url.openStream();
                this.parser.parse(stream, (DefaultHandler)handler);
                doc.add(Field.Text((String)"contents", (Reader)parsed.newContentReader()));
                doc.add(Field.Text((String)"exact_contents", (Reader)parsed.newContentReader()));
                String title = parsed.getTitle();
                if (title != null) {
                    this.addTitle(title, doc);
                }
                if ((summary = parsed.getSummary()) != null) {
                    doc.add(Field.UnIndexed((String)"summary", (String)summary));
                }
                if (doc.getField("filters") == null && this.filters.size() > 0) {
                    this.filters = this.generalizeFilters(this.filters);
                    doc.add(Field.UnIndexed((String)"filters", (String)this.serializeFilters(this.filters)));
                }
                iStatus = Status.OK_STATUS;
                Object var12_15 = null;
                if (stream == null) return iStatus;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.help.base", 4, "Exception occurred while adding document " + name + " to index.", (Throwable)e);
                Object var12_16 = null;
                if (stream == null) return status;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                stream = null;
                return status;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (stream == null) throw throwable;
            try {}
            catch (IOException iOException) {}
            stream.close();
            stream = null;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        stream.close();
        stream = null;
        return iStatus;
    }

    protected void handleText(String text, ParsedXMLContent data) {
        String stackPath = this.getElementStackPath();
        Path path = new Path(stackPath);
        if (path.segment(1).equalsIgnoreCase("body")) {
            data.addText(text);
            data.addToSummary(text);
        } else if (path.segment(1).equalsIgnoreCase("head")) {
            data.setTitle(text);
        }
    }

    protected String getTopElement() {
        return (String)this.stack.peek();
    }

    protected String getElementStackPath() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.stack.size()) {
            if (i > 0) {
                buf.append("/");
            }
            buf.append((String)this.stack.get(i));
            ++i;
        }
        return buf.toString();
    }

    private Set generalizeFilters(Set filters) {
        HashSet<String> processed = new HashSet<String>();
        Iterator iter = filters.iterator();
        while (iter.hasNext()) {
            String filter = (String)iter.next();
            int index = filter.indexOf(61);
            if (index <= 0) continue;
            String[] tokens = filter.split("!?=");
            String name = tokens[0];
            String value = tokens[1];
            if (value != null && value.length() > 0 && value.charAt(0) == '!') {
                value = value.substring(1);
            }
            if (XHTMLSupport.getFilterProcessor().isMultiValue(name)) {
                processed.add(String.valueOf(name) + '=' + value);
                continue;
            }
            processed.add(name);
        }
        return processed;
    }

    private String serializeFilters(Set set) {
        StringBuffer buf = new StringBuffer();
        Iterator iter = set.iterator();
        boolean firstIter = true;
        while (iter.hasNext()) {
            if (!firstIter) {
                buf.append(',');
            }
            firstIter = false;
            buf.append(iter.next());
        }
        return buf.toString();
    }

    private static class ParsedXMLContent {
        private StringBuffer buffer = new StringBuffer();
        private StringBuffer summary = new StringBuffer();
        private String title;
        private String locale;
        private static int SUMMARY_LENGTH = 200;

        public ParsedXMLContent(String locale) {
            this.locale = locale;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void addToSummary(String text) {
            if (this.summary.length() >= SUMMARY_LENGTH) {
                return;
            }
            if (this.summary.length() > 0) {
                this.summary.append(" ");
            }
            this.summary.append(text);
            if (this.summary.length() > SUMMARY_LENGTH) {
                this.summary.delete(SUMMARY_LENGTH, this.summary.length());
            }
        }

        public void addText(String text) {
            if (this.buffer.length() > 0) {
                this.buffer.append(" ");
            }
            this.buffer.append(text);
        }

        public Reader newContentReader() {
            return new StringReader(this.buffer.toString());
        }

        public String getSummary() {
            return this.summary.toString();
        }

        public String getTitle() {
            return this.title;
        }
    }

    private class XMLHandler
    extends DefaultHandler {
        public ParsedXMLContent data;

        public XMLHandler(ParsedXMLContent data) {
            this.data = data;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            XHTMLSearchParticipant.this.stack.push(qName);
            String filterAttribute = attributes.getValue("filter");
            if (filterAttribute != null) {
                XHTMLSearchParticipant.this.filters.add(filterAttribute);
            }
            if (qName.equalsIgnoreCase("filter")) {
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                if (name != null && value != null) {
                    XHTMLSearchParticipant.this.filters.add(String.valueOf(name) + '=' + value);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            String top = (String)XHTMLSearchParticipant.this.stack.peek();
            if (top != null && top.equals(qName)) {
                XHTMLSearchParticipant.this.stack.pop();
            }
        }

        public void characters(char[] characters, int start, int length) throws SAXException {
            if (length == 0) {
                return;
            }
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < length) {
                buff.append(characters[start + i]);
                ++i;
            }
            String text = buff.toString().trim();
            if (text.length() > 0) {
                XHTMLSearchParticipant.this.handleText(text, this.data);
            }
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (systemId.equals(XHTML1_TRANSITIONAL) || systemId.equals(XHTML1_STRICT) || systemId.equals(XHTML1_FRAMESET)) {
                try {
                    URL dtdURL = (URL)dtdMap.get(systemId);
                    InputSource in = new InputSource(dtdURL.openStream());
                    in.setSystemId(dtdURL.toExternalForm());
                    return in;
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
            return null;
        }
    }
}

