/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpoints;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DeleteWorkingsetsMessageDialog
extends MessageDialog {
    private boolean fDeleteWorkingsets = false;
    private boolean fDeleteBreakpoints = true;
    private Button fDeleteWS;
    private Button fDeleteBPS;
    private static final String DIALOG_SETTINGS = "DeleteBreakpointsDialogSettings";
    private static final String DELETE_BREAKPOINTS = "DeleteBreakpoints";
    private static final String DELETE_WORKINGSETS = "DeleteWorkingSets";

    public DeleteWorkingsetsMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        IDialogSettings section = this.getDialogSettings();
        this.fDeleteBreakpoints = section.getBoolean(DELETE_BREAKPOINTS);
        this.fDeleteWorkingsets = section.getBoolean(DELETE_WORKINGSETS);
    }

    protected Control createCustomArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        Font font = parent.getFont();
        this.fDeleteWS = new Button(comp, 32);
        this.fDeleteWS.setText(ActionMessages.DeleteWorkingsetsMessageDialog_0);
        this.fDeleteWS.setFont(font);
        this.fDeleteWS.setSelection(this.fDeleteWorkingsets);
        this.fDeleteBPS = new Button(comp, 32);
        this.fDeleteBPS.setText(ActionMessages.DeleteWorkingsetsMessageDialog_1);
        this.fDeleteBPS.setFont(font);
        this.fDeleteBPS.setSelection(this.fDeleteBreakpoints);
        return comp;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.fDeleteBreakpoints = this.fDeleteBPS.getSelection();
            this.fDeleteWorkingsets = this.fDeleteWS.getSelection();
            IDialogSettings dialogSettings = this.getDialogSettings();
            dialogSettings.put(DELETE_BREAKPOINTS, this.fDeleteBreakpoints);
            dialogSettings.put(DELETE_WORKINGSETS, this.fDeleteWorkingsets);
        }
        super.buttonPressed(buttonId);
    }

    public boolean deleteWorkingset() {
        return this.fDeleteWorkingsets;
    }

    public boolean deleteAllBreakpoints() {
        return this.fDeleteBreakpoints;
    }

    protected IDialogSettings getDialogSettings() {
        DebugUIPlugin plugin = DebugUIPlugin.getDefault();
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS);
        if (section == null) {
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS);
            section.put(DELETE_BREAKPOINTS, true);
            section.put(DELETE_WORKINGSETS, false);
        }
        return section;
    }
}

