/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousDisconnectAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;

public class DisconnectAdapter
implements IAsynchronousDisconnectAdapter {
    public void canDisconnect(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof IDisconnect), (String)"element must be instance of IDisconnect");
        Job job = new Job("canDisconnect"){

            protected IStatus run(IProgressMonitor monitor) {
                IDisconnect disconnect = (IDisconnect)element;
                requestMonitor.setResult(disconnect.canDisconnect());
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void isDisconnected(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof IDisconnect), (String)"element must be instance of IDisconnect");
        Job job = new Job("isDisconnected"){

            protected IStatus run(IProgressMonitor monitor) {
                IDisconnect disconnect = (IDisconnect)element;
                requestMonitor.setResult(disconnect.isDisconnected());
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void disconnect(final Object element, final IAsynchronousRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof IDisconnect), (String)"element must be instance of IDisconnect");
        Job job = new Job("isDisconnected"){

            protected IStatus run(IProgressMonitor monitor) {
                IDisconnect disconnect = (IDisconnect)element;
                try {
                    disconnect.disconnect();
                }
                catch (DebugException e) {
                    requestMonitor.setStatus(e.getStatus());
                }
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

