/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDropToFrame;
import org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousDropToFrameAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.jface.util.Assert;

public class DropToFrameAdapter
implements IAsynchronousDropToFrameAdapter {
    public void canDropToFrame(final Object element, final IBooleanRequestMonitor monitor) {
        Assert.isTrue((boolean)(element instanceof IDropToFrame), (String)"element must be an instance of IDropToFrame");
        Job job = new Job("canDropToFrame"){

            protected IStatus run(IProgressMonitor pm) {
                if (!pm.isCanceled()) {
                    IDropToFrame dropToFrame = (IDropToFrame)element;
                    monitor.setResult(dropToFrame.canDropToFrame());
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void dropToFrame(final Object element, final IAsynchronousRequestMonitor monitor) {
        Assert.isTrue((boolean)(element instanceof IDropToFrame), (String)"element must be an instance of IDropToFrame");
        Job job = new Job("dropToFrame"){

            protected IStatus run(IProgressMonitor pm) {
                if (!pm.isCanceled()) {
                    IDropToFrame dropToFrame = (IDropToFrame)element;
                    try {
                        dropToFrame.dropToFrame();
                    }
                    catch (DebugException e) {
                        monitor.setStatus(e.getStatus());
                    }
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

