/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.context.AbstractDebugContextAction;
import org.eclipse.debug.internal.ui.actions.context.ActionRequestMonitor;
import org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousSuspendResumeAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.jface.resource.ImageDescriptor;

public class ResumeAction
extends AbstractDebugContextAction {
    static /* synthetic */ Class class$0;

    protected void doAction(Object element) {
        if (element instanceof IAdaptable) {
            IAsynchronousSuspendResumeAdapter suspendResumer;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousSuspendResumeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((suspendResumer = (IAsynchronousSuspendResumeAdapter)adaptable.getAdapter((Class)clazz)) != null) {
                suspendResumer.resume(element, new ActionRequestMonitor());
            }
        }
    }

    protected void isEnabledFor(Object element, IBooleanRequestMonitor monitor) {
        if (element instanceof IAdaptable) {
            IAsynchronousSuspendResumeAdapter suspendResumer;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousSuspendResumeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((suspendResumer = (IAsynchronousSuspendResumeAdapter)adaptable.getAdapter((Class)clazz)) != null) {
                suspendResumer.canResume(element, monitor);
            }
        }
    }

    protected void doActionForAllThreads(Object object) throws DebugException {
        if (this.isEnabledForAllThreads(object)) {
            IDebugElement debugElement = (IDebugElement)object;
            IThread[] threads = debugElement.getDebugTarget().getThreads();
            int i = 0;
            while (i < threads.length) {
                IThread thread = threads[i];
                if (thread.canResume()) {
                    thread.resume();
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEnabledForAllThreads(Object element) {
        if (!(element instanceof IDebugElement)) return false;
        IDebugElement debugElement = (IDebugElement)element;
        try {
            IThread[] threads = debugElement.getDebugTarget().getThreads();
            int i = 0;
            while (true) {
                if (i >= threads.length) {
                    return false;
                }
                if (threads[i].canResume()) {
                    return true;
                }
                ++i;
            }
        }
        catch (DebugException debugException) {}
        return false;
    }

    protected String getStatusMessage() {
        return ActionMessages.ResumeActionDelegate_Exceptions_occurred_attempting_to_resume__2;
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.ResumeActionDelegate_Resume_failed__1;
    }

    public String getText() {
        return ActionMessages.ResumeAction_0;
    }

    public String getHelpContextId() {
        return "resume_action_context";
    }

    public String getId() {
        return "org.eclipse.debug.ui.debugview.toolbar.resume";
    }

    public String getToolTipText() {
        return ActionMessages.ResumeAction_3;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_DLCL_RESUME");
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_RESUME");
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_RESUME");
    }
}

