/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousStepAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;

public class StepAdapter
implements IAsynchronousStepAdapter {
    public void canStepInto(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof IStep), (String)"element must be instance of IStep");
        Job job = new Job("canStepInto"){

            protected IStatus run(IProgressMonitor monitor) {
                IStep step = (IStep)element;
                requestMonitor.setResult(step.canStepInto());
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void canStepOver(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof IStep), (String)"element must be instance of IStep");
        Job job = new Job("canStepOver"){

            protected IStatus run(IProgressMonitor monitor) {
                IStep step = (IStep)element;
                requestMonitor.setResult(step.canStepOver());
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void canStepReturn(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof IStep), (String)"element must be instance of IStep");
        Job job = new Job("canStepReturn"){

            protected IStatus run(IProgressMonitor monitor) {
                IStep step = (IStep)element;
                requestMonitor.setResult(step.canStepReturn());
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void isStepping(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof IStep), (String)"element must be instance of IStep");
        Job job = new Job("isStepping"){

            protected IStatus run(IProgressMonitor monitor) {
                IStep step = (IStep)element;
                requestMonitor.setResult(step.isStepping());
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void stepInto(final Object element, final IAsynchronousRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof IStep), (String)"element must be instance of IStep");
        Job job = new Job("stepInto"){

            protected IStatus run(IProgressMonitor monitor) {
                IStep step = (IStep)element;
                try {
                    step.stepInto();
                }
                catch (DebugException e) {
                    requestMonitor.setStatus(e.getStatus());
                }
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void stepOver(final Object element, final IAsynchronousRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof IStep), (String)"element must be instance of IStep");
        Job job = new Job("stepOver"){

            protected IStatus run(IProgressMonitor monitor) {
                IStep step = (IStep)element;
                try {
                    step.stepOver();
                }
                catch (DebugException e) {
                    requestMonitor.setStatus(e.getStatus());
                }
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void stepReturn(final Object element, final IAsynchronousRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof IStep), (String)"element must be instance of IStep");
        Job job = new Job("stepReturn"){

            protected IStatus run(IProgressMonitor monitor) {
                IStep step = (IStep)element;
                try {
                    step.stepReturn();
                }
                catch (DebugException e) {
                    requestMonitor.setStatus(e.getStatus());
                }
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

