/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousTerminateAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;

public class TerminateAdapter
implements IAsynchronousTerminateAdapter {
    public void canTerminate(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof ITerminate), (String)"element must be instance of ITerminate");
        Job job = new Job("canTerminate"){

            protected IStatus run(IProgressMonitor monitor) {
                ITerminate terminate = (ITerminate)element;
                requestMonitor.setResult(terminate.canTerminate());
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void isTerminated(final Object element, final IBooleanRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof ITerminate), (String)"element must be instance of ITerminate");
        Job job = new Job("isTerminated"){

            protected IStatus run(IProgressMonitor monitor) {
                ITerminate terminate = (ITerminate)element;
                requestMonitor.setResult(terminate.isTerminated());
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void terminate(final Object element, final IAsynchronousRequestMonitor requestMonitor) {
        Assert.isTrue((boolean)(element instanceof ITerminate), (String)"element must be instance of ITerminate");
        Job job = new Job("terminate"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (element instanceof IProcess) {
                        TerminateAdapter.this.killTargets((IProcess)element);
                    }
                    ((ITerminate)element).terminate();
                }
                catch (DebugException e) {
                    requestMonitor.setStatus(e.getStatus());
                }
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void killTargets(IProcess process) throws DebugException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            IProcess[] processes = launch.getProcesses();
            int j = 0;
            while (j < processes.length) {
                IProcess process2 = processes[j];
                if (process2.equals(process)) {
                    IDebugTarget[] debugTargets = launch.getDebugTargets();
                    int k = 0;
                    while (k < debugTargets.length) {
                        IDebugTarget target = debugTargets[k];
                        if (target.canTerminate()) {
                            target.terminate();
                        }
                        ++k;
                    }
                    return;
                }
                ++j;
            }
            ++i;
        }
    }
}

