/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.elements.adapters.AsynchronousDebugLabelAdapter;
import org.eclipse.debug.internal.ui.elements.adapters.VariableColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbenchPart;

public class VariableLabelAdapter
extends AsynchronousDebugLabelAdapter {
    protected String[] getLabels(Object element, IPresentationContext context) throws CoreException {
        String viewId;
        IWorkbenchPart part = context.getPart();
        String[] ids = context.getColumns();
        if (part != null && ids != null && ("org.eclipse.debug.ui.VariableView".equals(viewId = part.getSite().getId()) || "org.eclipse.debug.ui.RegisterView".equals(viewId))) {
            IVariable variable = (IVariable)element;
            IValue value = variable.getValue();
            String[] columns = new String[ids.length];
            int i = 0;
            while (i < ids.length) {
                columns[i] = this.getColumnText(variable, value, ids[i], context);
                ++i;
            }
            return columns;
        }
        return super.getLabels(element, context);
    }

    protected String getColumnText(IVariable variable, IValue value, String columnId, IPresentationContext context) throws CoreException {
        if (VariableColumnPresentation.COLUMN_VARIABLE_NAME.equals(columnId)) {
            return this.getVariableName(variable, context);
        }
        if (VariableColumnPresentation.COLUMN_VARIABLE_TYPE.equals(columnId)) {
            return this.getVariableTypeName(variable, context);
        }
        if (VariableColumnPresentation.COLUMN_VARIABLE_VALUE.equals(columnId)) {
            return this.getValueText(variable, value, context);
        }
        if (VariableColumnPresentation.COLUMN_VALUE_TYPE.equals(columnId)) {
            return this.getValueTypeName(variable, value, context);
        }
        return null;
    }

    protected String getVariableName(IVariable variable, IPresentationContext context) throws CoreException {
        return variable.getName();
    }

    protected String getVariableTypeName(IVariable variable, IPresentationContext context) throws CoreException {
        return variable.getReferenceTypeName();
    }

    protected String getValueTypeName(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        return value.getReferenceTypeName();
    }

    protected String getValueText(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        return value.getValueString();
    }

    protected RGB[] getForegrounds(Object element, IPresentationContext context) throws CoreException {
        int numElements = this.getNumElements(context);
        if (numElements == 1 && element instanceof IVariable) {
            IVariable variable = (IVariable)element;
            try {
                if (variable.hasValueChanged()) {
                    Object[] rgbs = new RGB[numElements];
                    Arrays.fill(rgbs, DebugUIPlugin.getPreferenceColor("org.eclipse.debug.ui.changedDebugElement").getRGB());
                    return rgbs;
                }
            }
            catch (DebugException debugException) {}
        }
        return super.getForegrounds(element, context);
    }

    protected RGB[] getBackgrounds(Object element, IPresentationContext context) throws CoreException {
        int numElements = this.getNumElements(context);
        if (numElements > 1 && element instanceof IVariable) {
            IVariable variable = (IVariable)element;
            try {
                if (variable.hasValueChanged()) {
                    Object[] rgbs = new RGB[numElements];
                    Arrays.fill(rgbs, DebugUIPlugin.getPreferenceColor(IInternalDebugUIConstants.PREF_CHANGED_VALUE_BACKGROUND).getRGB());
                    return rgbs;
                }
            }
            catch (DebugException debugException) {}
        }
        return super.getBackgrounds(element, context);
    }
}

