/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class DeleteLaunchConfigurations
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        IProject project;
        Object[] configs;
        String pref = DebugUIPlugin.getDefault().getPreferenceStore().getString(IInternalDebugUIConstants.PREF_DELETE_CONFIGS_ON_PROJECT_DELETE);
        if (source instanceof IProject && (configs = this.collectAssociatedLaunches(project = (IProject)source)).length > 0) {
            if (pref.equals("prompt")) {
                ListSelectionDialog lsd = new ListSelectionDialog(DebugUIPlugin.getShell(), (Object)new AdaptableList((IAdaptable[])configs), (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)DebugUITools.newDebugModelPresentation(), LaunchConfigurationsMessages.DeleteLaunchConfigurations_0);
                lsd.setInitialSelections(configs);
                lsd.setTitle(LaunchConfigurationsMessages.DeleteLaunchConfigurations_1);
                if (lsd.open() == 0) {
                    this.doDelete(lsd.getResult());
                }
            } else if (pref.equals("always")) {
                this.doDelete(this.collectAssociatedLaunches(project));
            }
        }
        return null;
    }

    private ILaunchConfiguration[] collectAssociatedLaunches(IProject project) {
        ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            IResource[] resources = null;
            int i = 0;
            while (i < configs.length) {
                resources = configs[i].getMappedResources();
                if (resources != null) {
                    int j = 0;
                    while (j < resources.length) {
                        if (resources[j].equals((Object)project)) {
                            list.add(configs[i]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return list.toArray(new ILaunchConfiguration[list.size()]);
    }

    private void doDelete(Object[] launches) {
        try {
            int i = 0;
            while (i < launches.length) {
                ((ILaunchConfiguration)launches[i]).delete();
                ++i;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }
}

