/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.preferences.PerspectivePreferencePage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LaunchConfigurationTabGroupViewer
extends Viewer {
    private ILaunchConfigurationDialog fDialog;
    private Object fInput;
    private ILaunchConfiguration fOriginal;
    private ILaunchConfigurationWorkingCopy fWorkingCopy;
    private Composite fViewerControl;
    private Composite fVisibleArea;
    private Label fNameLabel;
    private Text fNameWidget;
    private Composite fTabComposite;
    private CTabFolder fTabFolder;
    private ILaunchConfigurationTabGroup fTabGroup;
    private ILaunchConfigurationType fTabType;
    private int fCurrentTabIndex = -1;
    private Button fApplyButton;
    private Button fRevertButton;
    private boolean fDisposingTabs = false;
    private boolean fInitializingTabs = false;
    private boolean fRedraw = true;
    private String fDescription = null;
    private Composite fTabPlaceHolder = null;
    private Composite fGettingStarted = null;
    private ViewForm fViewform;

    public LaunchConfigurationTabGroupViewer(Composite parent, ILaunchConfigurationDialog dialog) {
        this.fDialog = dialog;
        this.createControl(parent);
    }

    public void dispose() {
        this.disposeTabGroup();
    }

    protected void disposeTabGroup() {
        if (this.getTabGroup() != null) {
            this.getTabGroup().dispose();
            this.fTabGroup = null;
            this.fTabType = null;
        }
    }

    private void createControl(Composite parent) {
        this.fViewerControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.fViewerControl.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        this.fViewerControl.setLayoutData((Object)gd);
        this.fViewform = new ViewForm(this.fViewerControl, 0x800800);
        layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.fViewform.setLayout((Layout)layout);
        gd = new GridData(1808);
        this.fViewform.setLayoutData((Object)gd);
        this.setVisibleArea((Composite)this.fViewform);
        this.fViewform.setTopLeft(null);
        Composite mainComp = new Composite((Composite)this.fViewform, 0x800000);
        layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        mainComp.setLayout((Layout)layout);
        this.fViewform.setContent((Control)mainComp);
        this.fTabPlaceHolder = new Composite(mainComp, 0);
        this.fTabPlaceHolder.setLayout((Layout)new StackLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fTabPlaceHolder.setLayoutData((Object)gd);
        this.fGettingStarted = new Composite(this.fTabPlaceHolder, 0);
        this.fGettingStarted.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        this.fGettingStarted.setLayoutData((Object)gd);
        this.createGettingStarted(this.fGettingStarted);
        this.fTabComposite = new Composite(this.fTabPlaceHolder, 0);
        layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 5;
        this.fTabComposite.setLayout((Layout)layout);
        gd = new GridData(1808);
        this.fTabComposite.setLayoutData((Object)gd);
        this.fNameLabel = new Label(this.fTabComposite, 16640);
        this.fNameLabel.setText(LaunchConfigurationsMessages.LaunchConfigurationDialog__Name__16);
        this.fNameLabel.setLayoutData((Object)new GridData(32));
        this.fNameWidget = new Text(this.fTabComposite, 2052);
        this.fNameWidget.setLayoutData((Object)new GridData(768));
        this.fNameWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchConfigurationTabGroupViewer.this.handleNameModified();
            }
        });
        this.createTabFolder(this.fTabComposite);
        Composite buttonComp = new Composite(mainComp, 0);
        GridLayout buttonCompLayout = new GridLayout();
        buttonCompLayout.numColumns = 2;
        buttonComp.setLayout((Layout)buttonCompLayout);
        gd = new GridData(128);
        gd.horizontalSpan = 2;
        buttonComp.setLayoutData((Object)gd);
        this.fApplyButton = new Button(buttonComp, 8);
        this.fApplyButton.setText(LaunchConfigurationsMessages.LaunchConfigurationDialog__Apply_17);
        gd = new GridData(128);
        this.fApplyButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fApplyButton);
        this.fApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LaunchConfigurationTabGroupViewer.this.handleApplyPressed();
            }
        });
        this.fRevertButton = new Button(buttonComp, 8);
        this.fRevertButton.setText(LaunchConfigurationsMessages.LaunchConfigurationDialog_Revert_2);
        gd = new GridData(128);
        this.fRevertButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fRevertButton);
        this.fRevertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LaunchConfigurationTabGroupViewer.this.handleRevertPressed();
            }
        });
        Dialog.applyDialogFont((Control)parent);
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    private void createGettingStarted(Composite parent) {
        Font font = parent.getFont();
        GridData gd = null;
        this.createWrapLabel(parent, null, LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_1);
        this.createWrapLabel(parent, DebugUITools.getImage("IMG_ELCL_NEW_CONFIG"), LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_2);
        this.createWrapLabel(parent, DebugUITools.getImage("IMG_ELCL_DUPLICATE_CONFIG"), LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_6);
        this.createWrapLabel(parent, DebugUITools.getImage("IMG_ELCL_DELETE_CONFIG"), LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_4);
        this.createWrapLabel(parent, DebugUITools.getImage("IMG_ELCL_FILTER_CONFIGS"), LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_8);
        this.createWrapLabel(parent, DebugUITools.getImage("IMG_OVR_TRANSPARENT"), LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_3);
        this.createSpacer(parent, 2);
        Link link = new Link(parent, 16448);
        link.setText(LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_5);
        link.setFont(font);
        gd = new GridData(768);
        gd.widthHint = parent.getBounds().width - 30;
        link.setLayoutData((Object)gd);
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SWTUtil.showPreferencePage("org.eclipse.debug.ui.PerspectivePreferencePage", (IPreferencePage)new PerspectivePreferencePage());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createWrapLabel(Composite parent, Image image, String text) {
        CLabel lbl = new CLabel(parent, 64);
        lbl.setImage(image);
        lbl.setFont(parent.getFont());
        lbl.setText(text);
        GridData gd = new GridData(768);
        gd.widthHint = parent.getBounds().width - 30;
        lbl.setLayoutData((Object)gd);
    }

    private void createTabFolder(Composite parent) {
        if (this.fTabFolder == null) {
            Display display = this.getShell().getDisplay();
            Color c1 = display.getSystemColor(31);
            Color c2 = display.getSystemColor(32);
            this.fTabFolder = new CTabFolder(parent, 0x900008);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            this.fTabFolder.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
            this.fTabFolder.setSelectionForeground(this.getShell().getDisplay().getSystemColor(30));
            this.fTabFolder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
            this.fTabFolder.setLayoutData((Object)gd);
            this.fTabFolder.setBorderVisible(true);
            this.fTabFolder.setFont(parent.getFont());
            this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (!LaunchConfigurationTabGroupViewer.this.fInitializingTabs) {
                        LaunchConfigurationTabGroupViewer.this.handleTabSelected();
                    }
                }
            });
        }
    }

    protected Button getApplyButton() {
        return this.fApplyButton;
    }

    protected Button getRevertButton() {
        return this.fRevertButton;
    }

    protected CTabFolder getTabFolder() {
        return this.fTabFolder;
    }

    public void setName(String name) {
        if (this.getWorkingCopy() != null) {
            if (name == null) {
                name = "";
            }
            this.fNameWidget.setText(name.trim());
            this.refreshStatus();
        }
    }

    public Control getControl() {
        return this.fViewerControl;
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        if (this.getActiveTab() == null) {
            return new StructuredSelection();
        }
        return new StructuredSelection((Object)this.getActiveTab());
    }

    public void refresh() {
        if (this.fInitializingTabs) {
            return;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (!this.fInitializingTabs && tabs != null) {
            this.getActiveTab().performApply(this.getWorkingCopy());
            this.updateButtons();
            int i = 0;
            while (i < tabs.length) {
                ILaunchConfigurationTab tab = tabs[i];
                tab.isValid((ILaunchConfiguration)this.getWorkingCopy());
                boolean error = tab.getErrorMessage() != null;
                CTabItem item = this.fTabFolder.getItem(i);
                this.setTabIcon(item, error, tab);
                ++i;
            }
        }
    }

    private void updateButtons() {
        boolean dirty = this.isDirty();
        this.fApplyButton.setEnabled(dirty && this.canSave());
        this.fRevertButton.setEnabled(dirty);
    }

    private void setTabIcon(CTabItem tabItem, boolean error, ILaunchConfigurationTab tab) {
        Image image = null;
        image = error ? DebugUIPlugin.getDefault().getLaunchConfigurationManager().getErrorTabImage(tab) : tab.getImage();
        tabItem.setImage(image);
    }

    public void setInput(Object input) {
        if (input == null) {
            if (this.fInput == null) {
                return;
            }
            this.inputChanged(input);
        } else if (!input.equals(this.fInput)) {
            this.inputChanged(input);
        }
    }

    protected void inputChanged(Object input) {
        this.fInput = input;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    if (LaunchConfigurationTabGroupViewer.this.fInput instanceof ILaunchConfiguration) {
                        ILaunchConfiguration configuration = (ILaunchConfiguration)LaunchConfigurationTabGroupViewer.this.fInput;
                        LaunchConfigurationTabGroupViewer.this.setOriginal(configuration);
                        LaunchConfigurationTabGroupViewer.this.setWorkingCopy(configuration.getWorkingCopy());
                        LaunchConfigurationTabGroupViewer.this.displayInstanceTabs();
                    } else if (LaunchConfigurationTabGroupViewer.this.fInput instanceof ILaunchConfigurationType) {
                        LaunchConfigurationTabGroupViewer.this.fDescription = LaunchConfigurationTabGroupViewer.this.getDescription((ILaunchConfigurationType)LaunchConfigurationTabGroupViewer.this.fInput);
                        LaunchConfigurationTabGroupViewer.this.setNoInput();
                        LaunchConfigurationTabGroupViewer.this.refreshStatus();
                    } else {
                        LaunchConfigurationTabGroupViewer.this.setNoInput();
                    }
                    LaunchConfigurationTabGroupViewer.this.setRedraw(true);
                }
                catch (CoreException ce) {
                    LaunchConfigurationTabGroupViewer.this.errorDialog(ce);
                    LaunchConfigurationTabGroupViewer.this.setNoInput();
                    LaunchConfigurationTabGroupViewer.this.setRedraw(true);
                }
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
    }

    private void setNoInput() {
        this.setOriginal(null);
        this.setWorkingCopy(null);
        this.disposeExistingTabs();
        this.updateButtons();
        this.updateVisibleControls(false);
    }

    private void updateVisibleControls(boolean visible) {
        this.fApplyButton.setVisible(visible);
        this.fRevertButton.setVisible(visible);
        if (visible) {
            ((StackLayout)this.fTabPlaceHolder.getLayout()).topControl = this.fTabComposite;
            this.fTabComposite.layout();
        } else {
            ((StackLayout)this.fTabPlaceHolder.getLayout()).topControl = this.fGettingStarted;
        }
        this.fTabPlaceHolder.layout(true);
    }

    protected void setFocusOnName() {
        this.fNameWidget.setFocus();
    }

    private void setRedraw(boolean b) {
        if (this.fRedraw != b) {
            this.fRedraw = b;
            this.getVisibleArea().setRedraw(this.fRedraw);
        }
    }

    protected void displayInstanceTabs() {
        this.fInitializingTabs = true;
        ILaunchConfigurationType type = null;
        try {
            type = this.getWorkingCopy().getType();
            this.showInstanceTabsFor(type);
        }
        catch (CoreException e) {
            this.errorDialog(e);
            this.fInitializingTabs = false;
            return;
        }
        this.updateVisibleControls(true);
        this.fNameWidget.setText(this.getWorkingCopy().getName());
        ILaunchConfigurationTabGroup tabGroup = this.getTabGroup();
        if (tabGroup == null) {
            Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, MessageFormat.format(LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_No_tabs_defined_for_launch_configuration_type__0__1, type.getName()), null);
            CoreException e = new CoreException((IStatus)status);
            this.errorDialog(e);
            this.fInitializingTabs = false;
            return;
        }
        tabGroup.initializeFrom((ILaunchConfiguration)this.getWorkingCopy());
        this.fNameWidget.setText(this.getWorkingCopy().getName());
        this.fCurrentTabIndex = this.fTabFolder.getSelectionIndex();
        this.fInitializingTabs = false;
        if (!this.getVisibleArea().isVisible()) {
            this.getVisibleArea().setVisible(true);
        }
        this.refreshStatus();
    }

    private void showInstanceTabsFor(ILaunchConfigurationType configType) {
        if (this.getTabType() != null && this.getTabType().equals(configType)) {
            return;
        }
        Class<?> tabKind = null;
        if (this.getActiveTab() != null) {
            tabKind = this.getActiveTab().getClass();
        }
        ILaunchConfigurationTabGroup group = null;
        try {
            group = this.createGroup(configType);
        }
        catch (CoreException ce) {
            DebugUIPlugin.errorDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Error_19, LaunchConfigurationsMessages.LaunchConfigurationDialog_Exception_occurred_creating_launch_configuration_tabs_27, ce);
            return;
        }
        this.showTabsFor(group);
        this.fTabGroup = group;
        this.fTabType = configType;
        ILaunchConfigurationTab[] tabs = this.getTabs();
        this.setActiveTab(tabs[0]);
        int i = 0;
        while (i < tabs.length) {
            ILaunchConfigurationTab tab = tabs[i];
            if (tab.getClass().equals(tabKind)) {
                this.setActiveTab(tab);
                break;
            }
            ++i;
        }
        this.fDescription = this.getDescription(configType);
    }

    private String getDescription(ILaunchConfigurationType configType) {
        String description = null;
        if (configType != null) {
            String mode = this.fDialog.getMode();
            description = LaunchConfigurationPresentationManager.getDefault().getDescription(configType, mode);
        }
        if (description == null) {
            description = "";
        }
        return description;
    }

    private void showTabsFor(ILaunchConfigurationTabGroup tabGroup) {
        this.setRedraw(false);
        this.disposeExistingTabs();
        this.fTabGroup = tabGroup;
        ILaunchConfigurationTab[] tabs = tabGroup.getTabs();
        CTabItem tab = null;
        String name = "";
        int i = 0;
        while (i < tabs.length) {
            tab = new CTabItem(this.fTabFolder, 2048);
            name = tabs[i].getName();
            if (name == null) {
                name = LaunchConfigurationsMessages.LaunchConfigurationDialog_unspecified_28;
            }
            tab.setText(name);
            Image image = tabs[i].getImage();
            tab.setImage(image);
            tabs[i].createControl((Composite)tab.getParent());
            Control control = tabs[i].getControl();
            if (control != null) {
                tab.setControl(control);
            }
            ++i;
        }
    }

    protected ILaunchConfigurationTabGroup createGroup(final ILaunchConfigurationType configType) throws CoreException {
        final Object[] finalArray = new Object[2];
        Runnable runnable = new Runnable(){

            public void run() {
                ILaunchConfigurationTabGroup tabGroup = null;
                try {
                    tabGroup = LaunchConfigurationPresentationManager.getDefault().getTabGroup(configType, LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode());
                    finalArray[0] = tabGroup;
                }
                catch (CoreException ce) {
                    finalArray[1] = ce;
                    return;
                }
                tabGroup.createTabs(LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog(), LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode());
                ILaunchConfigurationTab[] tabs = tabGroup.getTabs();
                int i = 0;
                while (i < tabs.length) {
                    tabs[i].setLaunchConfigurationDialog(LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog());
                    ++i;
                }
            }
        };
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)runnable);
        if (finalArray[1] != null) {
            throw (CoreException)((Object)finalArray[1]);
        }
        return (ILaunchConfigurationTabGroup)finalArray[0];
    }

    public void setSelection(ISelection selection, boolean reveal) {
        IStructuredSelection structuredSelection;
        Object object;
        if (this.getWorkingCopy() != null && selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ILaunchConfigurationTab) {
            ILaunchConfigurationTab[] tabs = this.getTabs();
            int i = 0;
            if (i < tabs.length) {
                ILaunchConfigurationTab tab = tabs[i];
                if (tab.equals(object)) {
                    this.fCurrentTabIndex = i;
                    this.fTabFolder.setSelection(i);
                }
                return;
            }
        }
    }

    public ILaunchConfigurationTab[] getTabs() {
        if (this.getTabGroup() != null) {
            return this.getTabGroup().getTabs();
        }
        return null;
    }

    public ILaunchConfigurationTab getActiveTab() {
        int pageIndex;
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (this.fTabFolder != null && tabs != null && (pageIndex = this.fTabFolder.getSelectionIndex()) >= 0) {
            return tabs[pageIndex];
        }
        return null;
    }

    public boolean isDirty() {
        ILaunchConfigurationWorkingCopy workingCopy = this.getWorkingCopy();
        if (workingCopy == null) {
            return false;
        }
        if (workingCopy.getOriginal() == null) {
            return true;
        }
        ILaunchConfiguration original = this.getOriginal();
        return !original.contentsEqual((ILaunchConfiguration)workingCopy);
    }

    protected void refreshStatus() {
        if (!this.fInitializingTabs) {
            this.getLaunchConfigurationDialog().updateButtons();
            this.getLaunchConfigurationDialog().updateMessage();
        }
    }

    protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.fDialog;
    }

    private void setOriginal(ILaunchConfiguration configuration) {
        this.fOriginal = configuration;
    }

    protected ILaunchConfiguration getOriginal() {
        return this.fOriginal;
    }

    private void setWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    protected ILaunchConfigurationWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public boolean canSave() {
        if (this.fInitializingTabs) {
            return false;
        }
        try {
            this.verifyName();
        }
        catch (CoreException coreException) {
            return false;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs == null) {
            return false;
        }
        int i = 0;
        while (i < tabs.length) {
            if (!tabs[i].canSave()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canLaunch() {
        if (this.fInitializingTabs) {
            return false;
        }
        if (this.getWorkingCopy() == null) {
            return false;
        }
        try {
            this.verifyName();
        }
        catch (CoreException coreException) {
            return false;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs == null) {
            return false;
        }
        int i = 0;
        while (i < tabs.length) {
            if (!tabs[i].isValid((ILaunchConfiguration)this.getWorkingCopy())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getErrorMesssage() {
        if (this.fInitializingTabs) {
            return null;
        }
        if (this.getWorkingCopy() == null) {
            return null;
        }
        try {
            this.verifyName();
        }
        catch (CoreException ce) {
            return ce.getStatus().getMessage();
        }
        String message = null;
        ILaunchConfigurationTab activeTab = this.getActiveTab();
        if (activeTab == null) {
            return null;
        }
        message = activeTab.getErrorMessage();
        if (message != null) {
            return message;
        }
        ILaunchConfigurationTab[] allTabs = this.getTabs();
        int i = 0;
        while (i < allTabs.length) {
            ILaunchConfigurationTab tab = allTabs[i];
            if (tab != activeTab && (message = tab.getErrorMessage()) != null) {
                StringBuffer temp = new StringBuffer();
                temp.append('[');
                temp.append(DebugUIPlugin.removeAccelerators(tab.getName()));
                temp.append("]: ");
                temp.append(message);
                return temp.toString();
            }
            ++i;
        }
        return null;
    }

    public String getMessage() {
        String tabMessage;
        if (this.fInitializingTabs) {
            return null;
        }
        String message = this.fDescription;
        ILaunchConfigurationTab tab = this.getActiveTab();
        if (tab != null && (tabMessage = tab.getMessage()) != null) {
            message = tabMessage;
        }
        return message;
    }

    protected void verifyName() throws CoreException {
        if (this.fNameWidget.isVisible()) {
            String currentName = this.fNameWidget.getText().trim();
            if (currentName.length() < 1) {
                throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, LaunchConfigurationsMessages.LaunchConfigurationDialog_Name_required_for_launch_configuration_11, null));
            }
            IStatus status = ResourcesPlugin.getWorkspace().validateName(currentName, 1);
            if (status.getCode() != 0) {
                throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, status.getMessage(), null));
            }
            char[] disallowedChars = new char[]{'@', '&'};
            int i = 0;
            while (i < disallowedChars.length) {
                char c = disallowedChars[i];
                if (currentName.indexOf(c) > -1) {
                    throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, MessageFormat.format(LaunchConfigurationsMessages.LaunchConfigurationTabGroupViewer_0, new String(new char[]{c}), currentName), null));
                }
                ++i;
            }
            if (!this.getOriginal().getName().equals(currentName) && DebugPlugin.getDefault().getLaunchManager().isExistingLaunchConfigurationName(currentName)) {
                throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, LaunchConfigurationsMessages.LaunchConfigurationDialog_Launch_configuration_already_exists_with_this_name_12, null));
            }
        }
    }

    private void disposeExistingTabs() {
        this.fDisposingTabs = true;
        CTabItem[] oldTabs = this.fTabFolder.getItems();
        int i = 0;
        while (i < oldTabs.length) {
            oldTabs[i].dispose();
            ++i;
        }
        this.createTabFolder(this.fTabComposite);
        this.disposeTabGroup();
        this.fDisposingTabs = false;
    }

    private ILaunchConfigurationType getTabType() {
        return this.fTabType;
    }

    public ILaunchConfigurationTabGroup getTabGroup() {
        return this.fTabGroup;
    }

    protected void handleTabSelected() {
        if (this.fDisposingTabs || this.fInitializingTabs) {
            return;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (this.fCurrentTabIndex == this.fTabFolder.getSelectionIndex() || tabs == null || tabs.length == 0 || this.fCurrentTabIndex > tabs.length - 1) {
            return;
        }
        if (this.fCurrentTabIndex != -1) {
            ILaunchConfigurationTab tab = tabs[this.fCurrentTabIndex];
            ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy();
            if (wc != null) {
                tab.deactivated(wc);
                this.getActiveTab().activated(wc);
            }
        }
        this.fCurrentTabIndex = this.fTabFolder.getSelectionIndex();
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(event);
    }

    protected void handleNameModified() {
        this.getWorkingCopy().rename(this.fNameWidget.getText().trim());
        this.refreshStatus();
    }

    protected void handleApplyPressed() {
        try {
            Text widget = this.fNameWidget;
            String name = widget.getText();
            String trimmed = name.trim();
            this.fInitializingTabs = true;
            if (!name.equals(trimmed)) {
                widget.setText(trimmed);
            }
            this.getWorkingCopy().rename(trimmed);
            this.getTabGroup().performApply(this.getWorkingCopy());
            this.fInitializingTabs = false;
            if (this.isDirty()) {
                this.getWorkingCopy().doSave();
            }
            this.updateButtons();
        }
        catch (CoreException e) {
            DebugUIPlugin.errorDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Launch_Configuration_Error_46, LaunchConfigurationsMessages.LaunchConfigurationDialog_Exception_occurred_while_saving_launch_configuration_47, e);
            return;
        }
    }

    protected void handleRevertPressed() {
        this.inputChanged(this.getOriginal());
    }

    protected void errorDialog(CoreException exception) {
        ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)exception.getStatus());
    }

    protected void setVisibleArea(Composite control) {
        this.fVisibleArea = control;
    }

    protected Composite getVisibleArea() {
        return this.fVisibleArea;
    }

    public void setActiveTab(ILaunchConfigurationTab tab) {
        ILaunchConfigurationTab[] tabs = this.getTabs();
        int i = 0;
        while (i < tabs.length) {
            ILaunchConfigurationTab configurationTab = tabs[i];
            if (configurationTab.equals(tab)) {
                this.setActiveTab(i);
                return;
            }
            ++i;
        }
    }

    public void setActiveTab(int index) {
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (index >= 0 && index < tabs.length) {
            this.fTabFolder.setSelection(index);
            this.handleTabSelected();
        }
    }
}

