/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.elements.adapters.AsynchronousDebugLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.AsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.ChildrenRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.LabelRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelProxyFactoryAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;

public abstract class AsynchronousModel {
    private ModelNode fRoot;
    private Map fElementToNodes = new HashMap();
    private Map fModelProxies = new HashMap();
    private AsynchronousViewer fViewer;
    private boolean fDisposed = false;
    private List fPendingUpdates = new ArrayList();
    private List fViewerUpdates = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public AsynchronousModel(AsynchronousViewer viewer) {
        this.fViewer = viewer;
    }

    public void init(Object root) {
        if (root != null) {
            this.fRoot = new ModelNode(null, root);
            this.mapElement(root, this.fRoot);
        }
    }

    protected AsynchronousViewer getViewer() {
        return this.fViewer;
    }

    public synchronized void dispose() {
        this.fDisposed = true;
        this.cancelPendingUpdates();
        this.disposeAllModelProxies();
        this.fPendingUpdates.clear();
        ModelNode rootNode = this.getRootNode();
        if (rootNode != null) {
            rootNode.dispose();
        }
        this.fElementToNodes.clear();
    }

    public synchronized boolean isDisposed() {
        return this.fDisposed;
    }

    protected synchronized void cancelPendingUpdates() {
        Iterator updates = this.fPendingUpdates.iterator();
        while (updates.hasNext()) {
            IAsynchronousRequestMonitor update = (IAsynchronousRequestMonitor)updates.next();
            updates.remove();
            update.setCanceled(true);
        }
        this.fPendingUpdates.clear();
    }

    public synchronized void installModelProxy(Object element) {
        IModelProxy proxy;
        IModelProxyFactoryAdapter modelProxyFactory;
        if (!this.fModelProxies.containsKey(element) && (modelProxyFactory = this.getModelProxyFactoryAdapter(element)) != null && (proxy = modelProxyFactory.createModelProxy(element, this.getPresentationContext())) != null) {
            proxy.init(this.getPresentationContext());
            this.fModelProxies.put(element, proxy);
            this.getViewer().modelProxyAdded(proxy);
            proxy.installed();
        }
    }

    protected synchronized void disposeModelProxy(Object element) {
        IModelProxy proxy = (IModelProxy)this.fModelProxies.remove(element);
        if (proxy != null) {
            this.getViewer().modelProxyRemoved(proxy);
            proxy.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAllModelProxies() {
        Map map = this.fModelProxies;
        synchronized (map) {
            Iterator updatePolicies = this.fModelProxies.values().iterator();
            while (updatePolicies.hasNext()) {
                IModelProxy proxy = (IModelProxy)updatePolicies.next();
                this.getViewer().modelProxyRemoved(proxy);
                proxy.dispose();
            }
            this.fModelProxies.clear();
        }
    }

    protected IPresentationContext getPresentationContext() {
        return this.fViewer.getPresentationContext();
    }

    protected IModelProxyFactoryAdapter getModelProxyFactoryAdapter(Object element) {
        IModelProxyFactoryAdapter adapter = null;
        if (element instanceof IModelProxyFactoryAdapter) {
            adapter = (IModelProxyFactoryAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IModelProxyFactoryAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IModelProxyFactoryAdapter)adaptable.getAdapter((Class)clazz);
        }
        return adapter;
    }

    protected synchronized void mapElement(Object element, ModelNode node) {
        ModelNode[] nodes = this.getNodes(element);
        node.remap(element);
        if (nodes == null) {
            this.fElementToNodes.put(element, new ModelNode[]{node});
        } else {
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i] == node) {
                    return;
                }
                ++i;
            }
            ModelNode[] old = nodes;
            ModelNode[] newNodes = new ModelNode[old.length + 1];
            System.arraycopy(old, 0, newNodes, 0, old.length);
            newNodes[old.length] = node;
            this.fElementToNodes.put(element, newNodes);
        }
        this.installModelProxy(element);
    }

    protected synchronized void unmapNode(ModelNode node) {
        Object element = node.getElement();
        ModelNode[] nodes = (ModelNode[])this.fElementToNodes.get(element);
        if (nodes == null) {
            return;
        }
        if (nodes.length == 1) {
            this.fElementToNodes.remove(element);
            this.disposeModelProxy(element);
        } else {
            int i = 0;
            while (i < nodes.length) {
                ModelNode node2 = nodes[i];
                if (node2 == node) {
                    ModelNode[] newNodes = new ModelNode[nodes.length - 1];
                    System.arraycopy(nodes, 0, newNodes, 0, i);
                    if (i < newNodes.length) {
                        System.arraycopy(nodes, i + 1, newNodes, i, newNodes.length - i);
                    }
                    this.fElementToNodes.put(element, newNodes);
                }
                ++i;
            }
        }
    }

    public ModelNode[] getNodes(Object element) {
        return (ModelNode[])this.fElementToNodes.get(element);
    }

    public ModelNode getRootNode() {
        return this.fRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestScheduled(IAsynchronousRequestMonitor update) {
        AsynchronousRequestMonitor absUpdate = (AsynchronousRequestMonitor)update;
        List list = this.fPendingUpdates;
        synchronized (list) {
            ListIterator updates = this.fPendingUpdates.listIterator();
            while (updates.hasNext()) {
                AsynchronousRequestMonitor pendingUpdate = (AsynchronousRequestMonitor)updates.next();
                if (!absUpdate.contains(pendingUpdate)) continue;
                updates.remove();
                pendingUpdate.setCanceled(true);
            }
            this.fPendingUpdates.add(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestComplete(IAsynchronousRequestMonitor update) {
        List list = this.fPendingUpdates;
        synchronized (list) {
            this.fPendingUpdates.remove(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void viewerUpdateScheduled(IAsynchronousRequestMonitor update) {
        List list = this.fViewerUpdates;
        synchronized (list) {
            this.fViewerUpdates.add(update);
        }
    }

    protected Object[] filter(Object parent, Object[] elements) {
        ViewerFilter[] filters = this.getViewer().getFilters();
        if (filters != null) {
            ArrayList<Object> filtered = new ArrayList<Object>(elements.length);
            int i = 0;
            while (i < elements.length) {
                boolean add = true;
                int j = 0;
                while (j < filters.length) {
                    add = filters[j].select((Viewer)this.getViewer(), parent, elements[i]);
                    if (!add) break;
                    ++j;
                }
                if (add) {
                    filtered.add(elements[i]);
                }
                ++i;
            }
            return filtered.toArray();
        }
        return elements;
    }

    protected void updateLabel(ModelNode node) {
        Object element = node.getElement();
        IAsynchronousLabelAdapter adapter = this.getLabelAdapter(element);
        if (adapter != null) {
            LabelRequestMonitor labelUpdate = new LabelRequestMonitor(node, this);
            this.requestScheduled(labelUpdate);
            adapter.retrieveLabel(element, this.getPresentationContext(), labelUpdate);
        }
    }

    protected IAsynchronousLabelAdapter getLabelAdapter(Object element) {
        IAsynchronousLabelAdapter adapter = null;
        if (element instanceof IAsynchronousLabelAdapter) {
            adapter = (IAsynchronousLabelAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousLabelAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IAsynchronousLabelAdapter)adaptable.getAdapter((Class)clazz);
        }
        if (adapter == null) {
            return new AsynchronousDebugLabelAdapter();
        }
        return adapter;
    }

    protected IAsynchronousContentAdapter getContentAdapter(Object element) {
        IAsynchronousContentAdapter adapter = null;
        if (element instanceof IAsynchronousContentAdapter) {
            adapter = (IAsynchronousContentAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IAsynchronousContentAdapter)adaptable.getAdapter((Class)clazz);
        }
        return adapter;
    }

    public void updateChildren(ModelNode parent) {
        Object element = parent.getElement();
        IAsynchronousContentAdapter adapter = this.getContentAdapter(element);
        if (adapter != null) {
            ChildrenRequestMonitor update = new ChildrenRequestMonitor(parent, this);
            this.requestScheduled(update);
            adapter.retrieveChildren(element, this.getPresentationContext(), update);
        }
    }

    protected void preservingSelection(Runnable update) {
        this.getViewer().preservingSelection(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void viewerUpdateComplete(IAsynchronousRequestMonitor monitor) {
        List list = this.fViewerUpdates;
        synchronized (list) {
            this.fViewerUpdates.remove(monitor);
        }
        this.getViewer().updateComplete(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCanceled(AsynchronousRequestMonitor monitor) {
        List list = this.fPendingUpdates;
        synchronized (list) {
            this.fPendingUpdates.remove(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPendingUpdates() {
        List list = this.fViewerUpdates;
        synchronized (list) {
            return !this.fPendingUpdates.isEmpty() || !this.fViewerUpdates.isEmpty();
        }
    }

    protected abstract void add(ModelNode var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildren(final ModelNode parentNode, List kids) {
        final Object[] children = this.filter(parentNode.getElement(), kids.toArray());
        final AsynchronousViewer viewer = this.getViewer();
        ViewerSorter sorter = viewer.getSorter();
        if (sorter != null) {
            sorter.sort((Viewer)viewer, children);
        }
        ModelNode[] prevKids = null;
        ModelNode[] newChildren = null;
        AsynchronousModel asynchronousModel = this;
        synchronized (asynchronousModel) {
            if (this.isDisposed()) {
                return;
            }
            prevKids = parentNode.getChildrenNodes();
            if (prevKids == null) {
                newChildren = new ModelNode[children.length];
                int i = 0;
                while (i < children.length) {
                    ModelNode node = new ModelNode(parentNode, children[i]);
                    this.mapElement(children[i], node);
                    newChildren[i] = node;
                    ++i;
                }
                parentNode.setChildren(newChildren);
            } else {
                int i = 0;
                while (i < prevKids.length) {
                    ModelNode kid = prevKids[i];
                    if (i >= children.length) {
                        kid.dispose();
                        this.unmapNode(kid);
                    } else {
                        ModelNode prevNode = prevKids[i];
                        Object nextChild = children[i];
                        if (!prevNode.getElement().equals(nextChild)) {
                            this.unmapNode(prevNode);
                        }
                        this.mapElement(nextChild, prevNode);
                    }
                    ++i;
                }
                if (children.length > prevKids.length) {
                    newChildren = new ModelNode[children.length];
                    System.arraycopy(prevKids, 0, newChildren, 0, prevKids.length);
                    i = prevKids.length;
                    while (i < children.length) {
                        Object child = children[i];
                        ModelNode childNode = new ModelNode(parentNode, child);
                        this.mapElement(child, childNode);
                        newChildren[i] = childNode;
                        ++i;
                    }
                    parentNode.setChildren(newChildren);
                }
                if (children.length < prevKids.length) {
                    newChildren = new ModelNode[children.length];
                    System.arraycopy(prevKids, 0, newChildren, 0, children.length);
                    parentNode.setChildren(newChildren);
                }
            }
        }
        final ModelNode[] finalPrevKids = prevKids;
        this.preservingSelection(new Runnable(){

            public void run() {
                if (finalPrevKids != null) {
                    int i = 0;
                    while (i < finalPrevKids.length) {
                        ModelNode kid = finalPrevKids[i];
                        if (i >= children.length) {
                            viewer.nodeDisposed(kid);
                        } else {
                            viewer.nodeChanged(kid);
                        }
                        ++i;
                    }
                }
                viewer.nodeChildrenChanged(parentNode);
            }
        });
    }
}

