/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.UIJob;

public class AddMemoryBlocksComposite
implements ISelectionListener,
IDebugEventSetListener {
    private IViewPart fViewPart;
    private PageBook fComposite;
    private AddMemoryBlockPage fExtendedPage;
    private AddMemoryBlockPage fSimplePage;
    static /* synthetic */ Class class$0;

    public AddMemoryBlocksComposite(IViewPart viewPart) {
        this.fViewPart = viewPart;
    }

    public Control createComposite(Composite parent) {
        this.fComposite = new PageBook(parent, 4);
        GridData pagebookData = new GridData();
        pagebookData.grabExcessHorizontalSpace = true;
        pagebookData.grabExcessVerticalSpace = false;
        pagebookData.horizontalAlignment = 4;
        pagebookData.verticalAlignment = 128;
        this.fComposite.setLayoutData((Object)pagebookData);
        this.fExtendedPage = new AddMemoryBlockPage(false);
        this.fSimplePage = new AddMemoryBlockPage(true);
        this.showPageWithLength(false);
        IAdaptable debugContext = DebugUITools.getDebugContext();
        if (debugContext != null) {
            StructuredSelection sel = new StructuredSelection((Object)debugContext);
            this.update((ISelection)sel);
        } else {
            this.update((ISelection)StructuredSelection.EMPTY);
        }
        this.fViewPart.getViewSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getMemoryBlockManager().addListener((IMemoryBlockListener)this.fExtendedPage);
        DebugPlugin.getDefault().getMemoryBlockManager().addListener((IMemoryBlockListener)this.fSimplePage);
        return this.fComposite;
    }

    public void showPageWithLength(boolean showLengthFields) {
        if (showLengthFields) {
            this.fComposite.showPage(this.fSimplePage.getControl());
            this.fExtendedPage.becomesHidden();
            this.fSimplePage.becomesVisible();
        } else {
            this.fComposite.showPage(this.fExtendedPage.getControl());
            this.fSimplePage.becomesHidden();
            this.fExtendedPage.becomesVisible();
        }
    }

    public void dispose() {
        this.fViewPart.getViewSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getMemoryBlockManager().removeListener((IMemoryBlockListener)this.fExtendedPage);
        DebugPlugin.getDefault().getMemoryBlockManager().removeListener((IMemoryBlockListener)this.fSimplePage);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.update(selection);
    }

    public void update(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj == null) {
                this.fExtendedPage.fAddButton.setEnabled(false);
                this.fSimplePage.fAddButton.setEnabled(false);
                return;
            }
            this.fExtendedPage.update(selection);
            this.fSimplePage.update(selection);
            if (obj instanceof IDebugElement) {
                IMemoryBlockRetrieval retrieval;
                IDebugElement elm = (IDebugElement)obj;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((retrieval = (IMemoryBlockRetrieval)elm.getAdapter((Class)clazz)) == null) {
                    retrieval = elm.getDebugTarget();
                }
                if (retrieval == null) {
                    return;
                }
                if (!(retrieval instanceof IMemoryBlockRetrievalExtension)) {
                    this.showPageWithLength(true);
                } else {
                    this.showPageWithLength(false);
                }
            }
        }
    }

    private MemoryView getMemoryView() {
        if (this.fViewPart instanceof MemoryView) {
            return (MemoryView)this.fViewPart;
        }
        return null;
    }

    private void addDefaultRenderings(IMemoryBlock memoryBlock) {
        IMemoryRenderingType primaryType = DebugUITools.getMemoryRenderingManager().getPrimaryRenderingType(memoryBlock);
        IMemoryRenderingType[] renderingTypes = DebugUITools.getMemoryRenderingManager().getDefaultRenderingTypes(memoryBlock);
        try {
            if (primaryType != null) {
                this.createRenderingInContainer(memoryBlock, primaryType, "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
            } else if (renderingTypes.length > 0) {
                primaryType = renderingTypes[0];
                this.createRenderingInContainer(memoryBlock, renderingTypes[0], "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
            }
        }
        catch (CoreException e1) {
            DebugUIPlugin.log(e1);
        }
        int i = 0;
        while (i < renderingTypes.length) {
            try {
                boolean create = true;
                if (primaryType != null && primaryType.getId().equals(renderingTypes[i].getId())) {
                    create = false;
                }
                if (create) {
                    this.createRenderingInContainer(memoryBlock, renderingTypes[i], "org.eclipse.debug.ui.MemoryView.RenderingViewPane.2");
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            ++i;
        }
    }

    private void createRenderingInContainer(IMemoryBlock memoryBlock, IMemoryRenderingType primaryType, String paneId) throws CoreException {
        IMemoryRendering rendering = primaryType.createRendering();
        IMemoryRenderingContainer container = this.getMemoryView().getContainer(paneId);
        rendering.init(container, memoryBlock);
        container.addMemoryRendering(rendering);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IDebugElement elm;
            IAdaptable context;
            if (events[i].getKind() == 8 && events[i].getSource() instanceof ITerminate && (context = DebugUITools.getDebugContext()) != null && context instanceof IDebugElement && ((elm = (IDebugElement)context).getDebugTarget().isDisconnected() || elm.getDebugTarget().isTerminated())) {
                UIJob job = new UIJob("Update"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AddMemoryBlocksComposite.this.update((ISelection)StructuredSelection.EMPTY);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
            ++i;
        }
    }

    private class AddMemoryBlockPage
    implements IMemoryBlockListener {
        private Composite fPageComposite;
        private Combo fExpression;
        private Text fLengthTxt;
        private Button fAddButton;
        private boolean fShowLength;
        static /* synthetic */ Class class$0;

        private AddMemoryBlockPage(boolean createLengthFields) {
            this.fShowLength = createLengthFields;
            this.createPage((Composite)AddMemoryBlocksComposite.this.fComposite, createLengthFields);
        }

        private Control createPage(Composite parent, boolean createLengthFields) {
            Composite composite;
            this.fPageComposite = composite = new Composite(parent, 4);
            GridLayout addLayout = new GridLayout();
            addLayout.numColumns = createLengthFields ? 3 : 2;
            addLayout.makeColumnsEqualWidth = false;
            composite.setLayout((Layout)addLayout);
            Label expr = new Label(composite, 0);
            expr.setText(DebugUIMessages.AddMemoryBlocksComposite_0);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = false;
            data.grabExcessVerticalSpace = false;
            data.verticalAlignment = 0x1000000;
            data.horizontalAlignment = 16384;
            expr.setLayoutData((Object)data);
            if (createLengthFields) {
                Label length = new Label(composite, 0);
                length.setText(DebugUIMessages.AddMemoryBlocksComposite_1);
                data = new GridData();
                data.grabExcessHorizontalSpace = false;
                data.grabExcessVerticalSpace = false;
                data.verticalAlignment = 0x1000000;
                data.horizontalAlignment = 16384;
                length.setLayoutData((Object)data);
            }
            new Label(composite, 0);
            this.fExpression = new Combo(composite, 0);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = false;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1024;
            this.fExpression.setLayoutData((Object)data);
            this.fExpression.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ AddMemoryBlockPage this$1;
                {
                    this.this$1 = addMemoryBlockPage;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (AddMemoryBlockPage.access$0(this.this$1)) {
                        AddMemoryBlockPage.access$1(this.this$1);
                    }
                }
            });
            this.fillHistory();
            if (createLengthFields) {
                this.fLengthTxt = new Text(composite, 2052);
                data = new GridData();
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = false;
                data.horizontalAlignment = 4;
                data.verticalAlignment = 1024;
                this.fLengthTxt.setLayoutData((Object)data);
                this.fLengthTxt.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ AddMemoryBlockPage this$1;
                    {
                        this.this$1 = addMemoryBlockPage;
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        if (AddMemoryBlockPage.access$0(this.this$1)) {
                            AddMemoryBlockPage.access$1(this.this$1);
                        }
                    }
                });
            }
            this.fAddButton = new Button(composite, 0);
            this.fAddButton.setImage(DebugUITools.getImage("IMG_ELCL_MONITOR_EXPRESSION"));
            this.fAddButton.setToolTipText(DebugUIMessages.AddMemoryBlocksComposite_2);
            data = new GridData();
            data.grabExcessHorizontalSpace = false;
            data.grabExcessVerticalSpace = false;
            data.verticalAlignment = 128;
            this.fAddButton.setLayoutData((Object)data);
            this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ AddMemoryBlockPage this$1;
                {
                    this.this$1 = addMemoryBlockPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    AddMemoryBlockPage.access$1(this.this$1);
                }
            });
            return composite;
        }

        private void fillHistory() {
            String[] history = MemoryViewUtil.getHistory();
            if (history.length > 0) {
                String txt = this.fExpression.getText();
                this.fExpression.removeAll();
                int j = 0;
                while (j < history.length) {
                    this.fExpression.add(history[j]);
                    ++j;
                }
                this.fExpression.setText(txt);
            }
        }

        private void addMemoryBlocks() {
            IMemoryBlockRetrieval standardMemRetrieval;
            IAdaptable debugContext = DebugUITools.getDebugContext();
            if (debugContext == null) {
                return;
            }
            IDebugElement elm = null;
            if (debugContext instanceof IDebugElement) {
                elm = (IDebugElement)debugContext;
            }
            if (elm == null) {
                return;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((standardMemRetrieval = (IMemoryBlockRetrieval)elm.getAdapter((Class)clazz)) == null) {
                standardMemRetrieval = elm.getDebugTarget();
            }
            if (standardMemRetrieval == null) {
                return;
            }
            String input = this.fExpression.getText();
            ArrayList<String> expressions = new ArrayList<String>();
            if (input.length() == 0) {
                expressions.add("");
            } else {
                StringTokenizer tokenizer = new StringTokenizer(input, ",");
                while (tokenizer.hasMoreTokens()) {
                    expressions.add(tokenizer.nextToken());
                }
            }
            boolean error = false;
            String[] expressionsArray = expressions.toArray(new String[expressions.size()]);
            int i = 0;
            while (i < expressionsArray.length) {
                String expression = expressionsArray[i].trim();
                MemoryViewUtil.addHistory(expression);
                try {
                    if (standardMemRetrieval instanceof IMemoryBlockRetrievalExtension) {
                        IMemoryBlockRetrievalExtension memRetrieval = (IMemoryBlockRetrievalExtension)standardMemRetrieval;
                        IMemoryBlockExtension memBlock = memRetrieval.getExtendedMemoryBlock(expression, (Object)elm);
                        if (memBlock != null) {
                            IMemoryBlock[] memArray = new IMemoryBlock[]{memBlock};
                            MemoryView view = AddMemoryBlocksComposite.this.getMemoryView();
                            if (view != null) {
                                view.registerMemoryBlocks(memArray);
                            }
                            MemoryViewUtil.getMemoryBlockManager().addMemoryBlocks(memArray);
                            AddMemoryBlocksComposite.this.addDefaultRenderings((IMemoryBlock)memBlock);
                        } else {
                            error = true;
                            MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, DebugUIMessages.AddMemoryBlockAction_noMemoryBlock, null);
                        }
                    } else {
                        String hexPrefix;
                        if ((expression = expression.toUpperCase()).startsWith(hexPrefix = "0X")) {
                            expression = expression.substring(hexPrefix.length());
                        }
                        BigInteger address = new BigInteger(expression, 16);
                        long longAddress = address.longValue();
                        String strLength = this.fLengthTxt.getText();
                        long length = Long.parseLong(strLength);
                        if (length <= 0L) {
                            error = true;
                            String message = String.valueOf(DebugUIMessages.AddMemoryBlockAction_failed) + "\n" + DebugUIMessages.AddMemoryBlockAction_input_invalid;
                            MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, message, null);
                        } else {
                            IMemoryBlock memBlock = standardMemRetrieval.getMemoryBlock(longAddress, length);
                            if (memBlock instanceof IMemoryBlockExtension) {
                                Status status = new Status(2, DebugUIPlugin.getUniqueIdentifier(), 0, "IMemoryBlockRetrieval returns IMemoryBlockExtension.  This may result in unexpected behavior.", null);
                                DebugUIPlugin.log((IStatus)status);
                            }
                            if (memBlock != null) {
                                IMemoryBlock[] memArray = new IMemoryBlock[]{memBlock};
                                MemoryView view = AddMemoryBlocksComposite.this.getMemoryView();
                                if (view != null) {
                                    view.registerMemoryBlocks(memArray);
                                }
                                MemoryViewUtil.getMemoryBlockManager().addMemoryBlocks(memArray);
                                AddMemoryBlocksComposite.this.addDefaultRenderings(memBlock);
                            } else {
                                error = true;
                                MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, DebugUIMessages.AddMemoryBlockAction_noMemoryBlock, null);
                            }
                        }
                    }
                }
                catch (DebugException e1) {
                    error = true;
                    MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, DebugUIMessages.AddMemoryBlockAction_failed, (Exception)((Object)e1));
                }
                catch (NumberFormatException numberFormatException) {
                    error = true;
                    String message = String.valueOf(DebugUIMessages.AddMemoryBlockAction_failed) + "\n" + DebugUIMessages.AddMemoryBlockAction_input_invalid;
                    MemoryViewUtil.openError(DebugUIMessages.AddMemoryBlockAction_title, message, null);
                }
                ++i;
            }
            if (!error) {
                this.fExpression.setText("");
                if (this.fShowLength) {
                    this.fLengthTxt.setText("");
                }
            }
        }

        private void becomesVisible() {
        }

        private void becomesHidden() {
        }

        private Control getControl() {
            return this.fPageComposite;
        }

        private boolean validate() {
            if (this.fAddButton.isEnabled()) {
                if (this.fShowLength) {
                    return this.fExpression.getText() != null && this.fLengthTxt.getText() != null && this.fLengthTxt.getText().length() > 0;
                }
                return this.fExpression.getText() != null;
            }
            return false;
        }

        private void update(ISelection selection) {
            if (MemoryViewUtil.isValidSelection(selection)) {
                this.fAddButton.setEnabled(true);
            } else {
                this.fAddButton.setEnabled(false);
            }
        }

        public void memoryBlocksAdded(IMemoryBlock[] memory) {
            this.fillHistory();
        }

        public void memoryBlocksRemoved(IMemoryBlock[] memory) {
        }

        static /* synthetic */ boolean access$0(AddMemoryBlockPage addMemoryBlockPage) {
            return addMemoryBlockPage.validate();
        }

        static /* synthetic */ void access$1(AddMemoryBlockPage addMemoryBlockPage) {
            addMemoryBlockPage.addMemoryBlocks();
        }
    }
}

