/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.memory.provisional.MemoryViewPresentationContext;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.RetargetAddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.ViewPaneSelectionProvider;
import org.eclipse.debug.internal.ui.views.variables.ViewerState;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class MemoryBlocksTreeViewPane
implements ISelectionListener,
ISelectionChangedListener,
IMemoryViewPane,
IMemoryRenderingContainer {
    public static final String PANE_ID = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".MemoryView.MemoryBlocksTreeViewPane";
    private IViewPart fParent;
    private AsynchronousTreeViewer fTreeViewer;
    protected IMemoryBlockRetrieval fRetrieval;
    private ViewPaneSelectionProvider fSelectionProvider;
    private AddMemoryBlockAction fAddMemoryBlockAction;
    private IAction fRemoveMemoryBlockAction;
    private IAction fRemoveAllMemoryBlocksAction;
    private String fPaneId;
    private boolean fVisible = true;
    private TreeViewPaneContextListener fDebugContextListener;
    private ViewPaneEventHandler fEvtHandler;
    private Hashtable fViewerState = new Hashtable();
    private String fLabel;
    static /* synthetic */ Class class$0;

    public MemoryBlocksTreeViewPane(IViewPart parent) {
        this.fParent = parent;
        this.fSelectionProvider = new ViewPaneSelectionProvider();
    }

    public Control createViewPane(Composite parent, String paneId, String label) {
        this.fPaneId = paneId;
        this.fTreeViewer = new AsynchronousTreeViewer(parent);
        this.fLabel = label;
        IMemoryRenderingSite site = this.getMemoryRenderingSite();
        MemoryViewPresentationContext presentationContext = new MemoryViewPresentationContext(site, this, null);
        this.fTreeViewer.setContext(presentationContext);
        IAdaptable context = DebugUITools.getDebugContext();
        IMemoryBlockRetrieval retrieval = this.getMemoryBlockRetrieval(context);
        this.fTreeViewer.setInput(retrieval);
        this.fRetrieval = retrieval;
        this.fParent.getViewSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.fParent.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        this.fDebugContextListener = new TreeViewPaneContextListener();
        DebugContextManager.getDefault().addDebugContextListener(this.fDebugContextListener, this.fParent.getSite().getWorkbenchWindow());
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection treeSelected = event.getSelection();
                MemoryBlocksTreeViewPane.this.fSelectionProvider.setSelection(treeSelected);
            }
        });
        this.populateViewPane();
        this.fEvtHandler = new ViewPaneEventHandler();
        MenuManager mgr = this.createContextMenuManager();
        Menu menu = mgr.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fTreeViewer.getControl().setLayoutData((Object)data);
        this.updateActionsEnablement();
        return this.fTreeViewer.getControl();
    }

    private void populateViewPane() {
        IMemoryBlock[] memoryBlocks;
        ISelection selected = this.fParent.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (selected instanceof IStructuredSelection) {
            IMemoryBlockRetrieval retrieval;
            Object obj = ((IStructuredSelection)selected).getFirstElement();
            this.fRetrieval = retrieval = this.getMemoryBlockRetrieval(obj);
        }
        ISelection selection = null;
        if (this.fParent.getSite().getSelectionProvider() != null) {
            selection = this.fParent.getSite().getSelectionProvider().getSelection();
        }
        IMemoryBlock memoryBlock = null;
        if (selection == null) {
            return;
        }
        memoryBlock = this.getMemoryBlock(selection);
        if (memoryBlock == null && (memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fRetrieval)).length > 0) {
            memoryBlock = memoryBlocks[0];
        }
        TreePath[] paths = this.getTreePaths(memoryBlock);
        if (memoryBlock != null && paths != null && paths.length > 0) {
            this.fTreeViewer.setSelection((ISelection)new TreeSelection(paths));
        }
    }

    private IMemoryBlock getMemoryBlock(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        if (selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return null;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (elem instanceof IMemoryBlock) {
            return (IMemoryBlock)elem;
        }
        if (elem instanceof IMemoryRendering) {
            return ((IMemoryRendering)elem).getMemoryBlock();
        }
        return null;
    }

    protected MenuManager createContextMenuManager() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)MemoryBlocksTreeViewPane.this.fAddMemoryBlockAction);
                manager.add(MemoryBlocksTreeViewPane.this.fRemoveMemoryBlockAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.fParent.getSite().registerContextMenu(this.getId(), menuMgr, (ISelectionProvider)this.fSelectionProvider);
        return menuMgr;
    }

    public void dispose() {
        this.fParent.getViewSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.fParent.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.fAddMemoryBlockAction.dispose();
        DebugContextManager.getDefault().removeDebugContextListener(this.fDebugContextListener, this.fParent.getSite().getWorkbenchWindow());
        this.fEvtHandler.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IMemoryBlock && part == this.fParent) {
            ISelection treeSel = this.fTreeViewer.getSelection();
            if (treeSel instanceof IStructuredSelection && ((IStructuredSelection)treeSel).getFirstElement() == obj) {
                return;
            }
            if (selection instanceof TreeSelection) {
                this.fTreeViewer.setSelection(selection);
            } else {
                TreePath[] paths = this.getTreePaths(obj);
                if (paths != null) {
                    this.fTreeViewer.setSelection((ISelection)new TreeSelection(paths));
                }
            }
        }
    }

    private TreePath[] getTreePaths(Object selectedObj) {
        return this.fTreeViewer.getTreePaths(selectedObj);
    }

    private IMemoryBlockRetrieval getMemoryBlockRetrieval(Object obj) {
        IAdaptable adaptable = (IAdaptable)obj;
        IMemoryBlockRetrieval retrieval = null;
        if (adaptable != null) {
            IDebugTarget debugTarget;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((retrieval = (IMemoryBlockRetrieval)adaptable.getAdapter((Class)clazz)) == null && obj instanceof IDebugElement && (debugTarget = ((IDebugElement)obj).getDebugTarget()) != null) {
                retrieval = debugTarget;
            }
        }
        return retrieval;
    }

    public String getId() {
        return this.fPaneId;
    }

    public IAction[] getActions() {
        if (this.fAddMemoryBlockAction == null) {
            this.fAddMemoryBlockAction = new RetargetAddMemoryBlockAction((IMemoryRenderingSite)this.fParent);
        }
        if (this.fRemoveMemoryBlockAction == null) {
            this.fRemoveMemoryBlockAction = new TreeViewerRemoveMemoryBlocksAction();
        }
        if (this.fRemoveAllMemoryBlocksAction == null) {
            this.fRemoveAllMemoryBlocksAction = new TreeViewerRemoveAllMemoryBlocksAction();
        }
        this.updateActionsEnablement();
        return new IAction[]{this.fAddMemoryBlockAction, this.fRemoveMemoryBlockAction, this.fRemoveAllMemoryBlocksAction};
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        if (this.fSelectionProvider == null) {
            this.fSelectionProvider = new ViewPaneSelectionProvider();
        }
        this.fSelectionProvider.addSelectionChangedListener(listener);
    }

    public void removeSelctionListener(ISelectionChangedListener listener) {
        if (this.fSelectionProvider == null) {
            return;
        }
        this.fSelectionProvider.removeSelectionChangedListener(listener);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    public void restoreViewPane() {
        this.populateViewPane();
        this.updateActionsEnablement();
    }

    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    public void setVisible(boolean visible) {
        if (this.fVisible != visible) {
            this.fVisible = visible;
            if (this.fVisible) {
                this.fTreeViewer.refresh();
                this.fTreeViewer.getControl().setFocus();
            }
        }
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    private void updateActionsEnablement() {
        if (this.fRemoveMemoryBlockAction == null) {
            return;
        }
        if (this.fRemoveAllMemoryBlocksAction == null) {
            return;
        }
        if (this.fRetrieval != null) {
            IMemoryBlock[] memBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fRetrieval);
            if (memBlocks.length > 0) {
                this.fRemoveMemoryBlockAction.setEnabled(true);
                this.fRemoveAllMemoryBlocksAction.setEnabled(true);
            } else {
                this.fRemoveMemoryBlockAction.setEnabled(false);
                this.fRemoveAllMemoryBlocksAction.setEnabled(false);
            }
        } else {
            this.fRemoveMemoryBlockAction.setEnabled(false);
            this.fRemoveAllMemoryBlocksAction.setEnabled(false);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.fParent.getSite().getSelectionProvider()) {
            this.selectionChanged((IWorkbenchPart)this.fParent, event.getSelection());
        }
    }

    public AsynchronousTreeViewer getViewer() {
        return this.fTreeViewer;
    }

    public IMemoryRenderingSite getMemoryRenderingSite() {
        if (this.fParent instanceof IMemoryRenderingSite) {
            return (IMemoryRenderingSite)this.fParent;
        }
        return null;
    }

    public void addMemoryRendering(IMemoryRendering rendering) {
    }

    public void removeMemoryRendering(IMemoryRendering rendering) {
    }

    public IMemoryRendering[] getRenderings() {
        return new IMemoryRendering[0];
    }

    public IMemoryRendering getActiveRendering() {
        return null;
    }

    public String getLabel() {
        return this.fLabel;
    }

    class TreeViewerRemoveMemoryBlocksAction
    extends Action {
        TreeViewerRemoveMemoryBlocksAction() {
            this.setText(DebugUIMessages.RemoveMemoryBlockAction_title);
            this.setToolTipText(DebugUIMessages.RemoveMemoryBlockAction_tooltip);
            this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_REMOVE_MEMORY"));
            this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_REMOVE_MEMORY"));
            this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_REMOVE_MEMORY"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".RemoveMemoryBlockAction_context");
            this.setEnabled(true);
        }

        public void run() {
            ISelection selected = MemoryBlocksTreeViewPane.this.fTreeViewer.getSelection();
            if (selected != null && selected instanceof IStructuredSelection) {
                Object[] selectedMemBlks = ((IStructuredSelection)selected).toArray();
                ArrayList<Object> memoryBlocks = new ArrayList<Object>();
                int i = 0;
                while (i < selectedMemBlks.length) {
                    if (selectedMemBlks[i] instanceof IMemoryBlock) {
                        memoryBlocks.add(selectedMemBlks[i]);
                    }
                    ++i;
                }
                DebugPlugin.getDefault().getMemoryBlockManager().removeMemoryBlocks(memoryBlocks.toArray(new IMemoryBlock[memoryBlocks.size()]));
            }
        }
    }

    class TreeViewerRemoveAllMemoryBlocksAction
    extends Action {
        TreeViewerRemoveAllMemoryBlocksAction() {
            this.setText(DebugUIMessages.MemoryBlocksTreeViewPane_2);
            this.setToolTipText(DebugUIMessages.MemoryBlocksTreeViewPane_2);
            this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_REMOVE_ALL"));
            this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_REMOVE_ALL"));
            this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_REMOVE_ALL"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".RemoveAllMemoryBlocksAction_context");
        }

        public void run() {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            boolean proceed = MessageDialog.openQuestion((Shell)window.getShell(), (String)DebugUIMessages.MemoryBlocksTreeViewPane_0, (String)DebugUIMessages.MemoryBlocksTreeViewPane_1);
            if (proceed) {
                IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(MemoryBlocksTreeViewPane.this.fRetrieval);
                DebugPlugin.getDefault().getMemoryBlockManager().removeMemoryBlocks(memoryBlocks);
            }
        }
    }

    class ViewPaneEventHandler
    implements IMemoryBlockListener,
    IDebugEventSetListener {
        private boolean fDisposed = false;

        public ViewPaneEventHandler() {
            DebugPlugin.getDefault().getMemoryBlockManager().addListener((IMemoryBlockListener)this);
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }

        public void dispose() {
            this.fDisposed = true;
            MemoryBlocksTreeViewPane.this.fTreeViewer.dispose();
            DebugPlugin.getDefault().getMemoryBlockManager().removeListener((IMemoryBlockListener)this);
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        }

        public void memoryBlocksAdded(IMemoryBlock[] memory) {
            if (this.fDisposed) {
                return;
            }
            MemoryBlocksTreeViewPane.this.updateActionsEnablement();
        }

        public void memoryBlocksRemoved(IMemoryBlock[] memory) {
            if (this.fDisposed) {
                return;
            }
            MemoryBlocksTreeViewPane.this.updateActionsEnablement();
        }

        protected void doHandleDebugEvent(DebugEvent event) {
            if (this.fDisposed) {
                return;
            }
            if (event.getKind() == 8) {
                IMemoryBlockRetrieval retrieval;
                IMemoryBlockRetrieval srcRetrieval = MemoryBlocksTreeViewPane.this.getMemoryBlockRetrieval(event.getSource());
                if (srcRetrieval == MemoryBlocksTreeViewPane.this.fRetrieval) {
                    UIJob job = new UIJob(this, "setInput"){
                        final /* synthetic */ ViewPaneEventHandler this$1;
                        {
                            this.this$1 = viewPaneEventHandler;
                        }

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (MemoryBlocksTreeViewPane.access$0(ViewPaneEventHandler.access$0(this.this$1)).getContentProvider() == null) {
                                return Status.OK_STATUS;
                            }
                            MemoryBlocksTreeViewPane.access$0(ViewPaneEventHandler.access$0(this.this$1)).setInput(null);
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
                if ((retrieval = MemoryBlocksTreeViewPane.this.getMemoryBlockRetrieval(event.getSource())) != null) {
                    MemoryBlocksTreeViewPane.this.fViewerState.remove(retrieval);
                }
            }
        }

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                this.doHandleDebugEvent(events[i]);
                ++i;
            }
        }

        static /* synthetic */ MemoryBlocksTreeViewPane access$0(ViewPaneEventHandler viewPaneEventHandler) {
            return viewPaneEventHandler.MemoryBlocksTreeViewPane.this;
        }
    }

    class MemoryViewerState
    extends ViewerState {
        private Hashtable fPathMap = new Hashtable();
        private AsynchronousTreeViewer fViewer;

        public MemoryViewerState(AsynchronousTreeViewer viewer) {
            super(viewer);
            this.fViewer = viewer;
        }

        protected IPath encodeElement(TreeItem item) throws DebugException {
            if (this.fViewer != null) {
                IPath path = super.encodeElement(item);
                TreePath[] paths = this.fViewer.getTreePaths(item.getData());
                if (paths.length > 0) {
                    this.fPathMap.put(path, paths[0]);
                }
                return path;
            }
            return null;
        }

        protected TreePath decodePath(IPath path, AsynchronousTreeViewer viewer) throws DebugException {
            return (TreePath)this.fPathMap.get(path);
        }
    }

    class TreeViewPaneContextListener
    implements IDebugContextListener {
        TreeViewPaneContextListener() {
        }

        public void contextActivated(ISelection selection, IWorkbenchPart part) {
            Object obj;
            if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
                IAdaptable context = (IAdaptable)obj;
                IMemoryBlockRetrieval retrieval = MemoryBlocksTreeViewPane.this.getMemoryBlockRetrieval(context);
                if (retrieval != null && MemoryBlocksTreeViewPane.this.fTreeViewer != null && retrieval != MemoryBlocksTreeViewPane.this.fRetrieval) {
                    if (MemoryBlocksTreeViewPane.this.fRetrieval != null) {
                        MemoryViewerState state = (MemoryViewerState)MemoryBlocksTreeViewPane.this.fViewerState.get(MemoryBlocksTreeViewPane.this.fRetrieval);
                        if (state == null) {
                            state = new MemoryViewerState(MemoryBlocksTreeViewPane.this.fTreeViewer);
                        }
                        state.saveState(MemoryBlocksTreeViewPane.this.fTreeViewer);
                        MemoryBlocksTreeViewPane.this.fViewerState.put(MemoryBlocksTreeViewPane.this.fRetrieval, state);
                    }
                    MemoryBlocksTreeViewPane.this.fRetrieval = retrieval;
                    MemoryBlocksTreeViewPane.this.fTreeViewer.setInput(MemoryBlocksTreeViewPane.this.fRetrieval);
                    MemoryViewerState newState = (MemoryViewerState)MemoryBlocksTreeViewPane.this.fViewerState.get(MemoryBlocksTreeViewPane.this.fRetrieval);
                    if (newState != null) {
                        newState.restoreState(MemoryBlocksTreeViewPane.this.fTreeViewer);
                    }
                }
                MemoryBlocksTreeViewPane.this.updateActionsEnablement();
            }
        }

        public void contextChanged(ISelection selection, IWorkbenchPart part) {
        }
    }
}

