/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.scripting;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.history.SelectRefactoringHistoryControl;
import org.eclipse.ltk.internal.ui.refactoring.scripting.CreateRefactoringScriptWizard;
import org.eclipse.ltk.internal.ui.refactoring.scripting.RefactoringScriptLocationControl;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ScriptingMessages;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public final class CreateRefactoringScriptWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "CreateRefactoringScriptWizardPage";
    private SelectRefactoringHistoryControl fHistoryControl = null;
    private RefactoringScriptLocationControl fLocationControl = null;
    private final CreateRefactoringScriptWizard fWizard;

    public CreateRefactoringScriptWizardPage(CreateRefactoringScriptWizard wizard) {
        super(PAGE_NAME);
        Assert.isNotNull((Object)((Object)wizard));
        this.fWizard = wizard;
        this.setTitle(ScriptingMessages.CreateRefactoringScriptWizard_title);
        this.setDescription(ScriptingMessages.CreateRefactoringScriptWizard_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.fHistoryControl = new SelectRefactoringHistoryControl(composite, new RefactoringHistoryControlConfiguration(null, true, true)){

            protected final void handleDeselectAll() {
                super.handleDeselectAll();
                CreateRefactoringScriptWizardPage.this.fWizard.setRefactoringDescriptors(EMPTY_DESCRIPTORS);
            }

            protected final void handleSelectAll() {
                super.handleSelectAll();
                RefactoringHistory history = this.getInput();
                if (history != null) {
                    CreateRefactoringScriptWizardPage.this.fWizard.setRefactoringDescriptors(history.getDescriptors());
                }
            }
        };
        this.fHistoryControl.createControl();
        this.fHistoryControl.setInput(this.fWizard.getRefactoringHistory());
        this.fHistoryControl.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CreateRefactoringScriptWizardPage.this.fWizard.setRefactoringDescriptors(CreateRefactoringScriptWizardPage.this.fHistoryControl.getCheckedDescriptors());
            }
        });
        Label label = new Label(composite, 0);
        label.setText(ScriptingMessages.CreateRefactoringScriptWizardPage_destination_caption);
        GridData data = new GridData(40);
        data.horizontalIndent = 0;
        data.horizontalSpan = 1;
        data.verticalIndent = this.convertVerticalDLUsToPixels(4);
        label.setLayoutData((Object)data);
        this.fLocationControl = new RefactoringScriptLocationControl((IWizard)this.fWizard, composite){

            protected void handleBrowseExternalLocation() {
                FileDialog file = new FileDialog(this.getShell(), 4096);
                file.setText(ScriptingMessages.CreateRefactoringScriptWizardPage_browse_destination);
                file.setFilterNames(new String[]{ScriptingMessages.ScriptLocationControl_filter_name_script, ScriptingMessages.ScriptLocationControl_filter_name_wildcard});
                file.setFilterExtensions(new String[]{ScriptingMessages.ScriptLocationControl_filter_extension_script, ScriptingMessages.ScriptLocationControl_filter_extension_wildcard});
                String path = file.open();
                if (path != null) {
                    if (!path.endsWith(ScriptingMessages.CreateRefactoringScriptWizardPage_script_extension)) {
                        path = String.valueOf(path) + ScriptingMessages.CreateRefactoringScriptWizardPage_script_extension;
                    }
                    this.fExternalLocationControl.setText(path);
                }
            }

            protected final void handleClipboardScriptChanged() {
                super.handleClipboardScriptChanged();
                CreateRefactoringScriptWizardPage.this.fWizard.setRefactoringScript(null);
                CreateRefactoringScriptWizardPage.this.fWizard.setUseClipboard(this.fFromClipboardButton.getSelection());
                CreateRefactoringScriptWizardPage.this.setErrorMessage(null);
                CreateRefactoringScriptWizardPage.this.setPageComplete(true);
            }

            protected final void handleExternalLocationChanged() {
                super.handleExternalLocationChanged();
                CreateRefactoringScriptWizardPage.this.fWizard.setRefactoringScript(null);
                CreateRefactoringScriptWizardPage.this.fWizard.setUseClipboard(false);
                CreateRefactoringScriptWizardPage.this.setErrorMessage(null);
                CreateRefactoringScriptWizardPage.this.setPageComplete(true);
                CreateRefactoringScriptWizardPage.this.handleLocationChanged();
            }
        };
        this.fLocationControl.loadHistory();
        this.setPageComplete(false);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.refactoring_create_script_page");
    }

    private void handleLocationChanged() {
        URI uri = this.fLocationControl.getRefactoringScript();
        if (uri == null) {
            this.setErrorMessage(ScriptingMessages.ApplyRefactoringScriptWizardPage_invalid_location);
            this.setPageComplete(false);
            this.fWizard.setRefactoringScript(null);
        } else {
            this.fWizard.setRefactoringScript(uri);
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public void performFinish() {
        this.fLocationControl.saveHistory();
    }
}

