/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class FileSystem
implements INameEnvironment,
SuffixConstants {
    Classpath[] classpaths;
    Set knownFileNames;

    public FileSystem(String[] classpathNames, String[] initialFileNames, String encoding) {
        this(classpathNames, initialFileNames, encoding, null);
    }

    public FileSystem(String[] classpathNames, String[] initialFileNames, String encoding, int[] classpathDirectoryModes) {
        int classpathSize = classpathNames.length;
        this.classpaths = new Classpath[classpathSize];
        int counter = 0;
        int i = 0;
        while (i < classpathSize) {
            Classpath classpath = FileSystem.getClasspath(classpathNames[i], encoding, classpathDirectoryModes == null ? 0 : classpathDirectoryModes[i], null);
            try {
                classpath.initialize();
                this.classpaths[counter++] = classpath;
            }
            catch (IOException iOException) {}
            ++i;
        }
        if (counter != classpathSize) {
            this.classpaths = new Classpath[counter];
            System.arraycopy(this.classpaths, 0, this.classpaths, 0, counter);
        }
        this.initializeKnownFileNames(initialFileNames);
    }

    FileSystem(Classpath[] paths, String[] initialFileNames) {
        int length = paths.length;
        int counter = 0;
        this.classpaths = new Classpath[length];
        int i = 0;
        while (i < length) {
            Classpath classpath = paths[i];
            try {
                classpath.initialize();
                this.classpaths[counter++] = classpath;
            }
            catch (IOException iOException) {}
            ++i;
        }
        if (counter != length) {
            this.classpaths = new Classpath[counter];
            System.arraycopy(this.classpaths, 0, this.classpaths, 0, counter);
        }
        this.initializeKnownFileNames(initialFileNames);
    }

    static Classpath getClasspath(String classpathName, String encoding, int classpathDirectoryMode, AccessRuleSet accessRuleSet) {
        ClasspathLocation result = null;
        File file = new File(FileSystem.convertPathSeparators(classpathName));
        if (file.isDirectory()) {
            if (file.exists()) {
                result = new ClasspathDirectory(file, encoding, classpathDirectoryMode, accessRuleSet);
            }
        } else {
            String lowercaseClasspathName = classpathName.toLowerCase();
            if (lowercaseClasspathName.endsWith(".jar") || lowercaseClasspathName.endsWith(".zip")) {
                result = new ClasspathJar(file, true, accessRuleSet);
            }
        }
        return result;
    }

    private void initializeKnownFileNames(String[] initialFileNames) {
        this.knownFileNames = new HashSet(initialFileNames.length * 2);
        int i = initialFileNames.length;
        while (--i >= 0) {
            char[] fileName = initialFileNames[i].toCharArray();
            char[] matchingPathName = null;
            int lastIndexOf = CharOperation.lastIndexOf('.', fileName);
            if (lastIndexOf != -1) {
                fileName = CharOperation.subarray(fileName, 0, lastIndexOf);
            }
            CharOperation.replace(fileName, '\\', '/');
            int j = 0;
            while (j < this.classpaths.length) {
                char[] matchCandidate = this.classpaths[j].normalizedPath();
                if (this.classpaths[j] instanceof ClasspathDirectory && CharOperation.prefixEquals(matchCandidate, fileName) && (matchingPathName == null || matchCandidate.length < matchingPathName.length)) {
                    matchingPathName = matchCandidate;
                }
                ++j;
            }
            if (matchingPathName == null) {
                this.knownFileNames.add(new String(fileName));
            } else {
                this.knownFileNames.add(new String(CharOperation.subarray(fileName, matchingPathName.length, fileName.length)));
            }
            matchingPathName = null;
        }
    }

    public void cleanup() {
        int i = 0;
        int max = this.classpaths.length;
        while (i < max) {
            this.classpaths[i].reset();
            ++i;
        }
    }

    private static String convertPathSeparators(String path) {
        return File.separatorChar == '/' ? path.replace('\\', '/') : path.replace('/', '\\');
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName) {
        if (this.knownFileNames.contains(qualifiedTypeName)) {
            return null;
        }
        String qualifiedBinaryFileName = String.valueOf(qualifiedTypeName) + ".class";
        String qualifiedPackageName = qualifiedTypeName.length() == typeName.length ? "" : qualifiedBinaryFileName.substring(0, qualifiedTypeName.length() - typeName.length - 1);
        String qp2 = File.separatorChar == '/' ? qualifiedPackageName : qualifiedPackageName.replace('/', File.separatorChar);
        NameEnvironmentAnswer suggestedAnswer = null;
        if (qualifiedPackageName == qp2) {
            int i = 0;
            int length = this.classpaths.length;
            while (i < length) {
                NameEnvironmentAnswer answer = this.classpaths[i].findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName);
                if (answer != null) {
                    if (!answer.ignoreIfBetter()) {
                        if (answer.isBetter(suggestedAnswer)) {
                            return answer;
                        }
                    } else if (answer.isBetter(suggestedAnswer)) {
                        suggestedAnswer = answer;
                    }
                }
                ++i;
            }
        } else {
            String qb2 = qualifiedBinaryFileName.replace('/', File.separatorChar);
            int i = 0;
            int length = this.classpaths.length;
            while (i < length) {
                NameEnvironmentAnswer answer;
                Classpath p = this.classpaths[i];
                NameEnvironmentAnswer nameEnvironmentAnswer = answer = p instanceof ClasspathJar ? p.findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName) : p.findClass(typeName, qp2, qb2);
                if (answer != null) {
                    if (!answer.ignoreIfBetter()) {
                        if (answer.isBetter(suggestedAnswer)) {
                            return answer;
                        }
                    } else if (answer.isBetter(suggestedAnswer)) {
                        suggestedAnswer = answer;
                    }
                }
                ++i;
            }
        }
        if (suggestedAnswer != null) {
            return suggestedAnswer;
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1]);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith(packageName, typeName, '/')), typeName);
        }
        return null;
    }

    public ClasspathJar getClasspathJar(File file) throws IOException {
        return new ClasspathJar(file, true, null);
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        String qp2;
        String qualifiedPackageName = new String(CharOperation.concatWith(compoundName, packageName, '/'));
        String string = qp2 = File.separatorChar == '/' ? qualifiedPackageName : qualifiedPackageName.replace('/', File.separatorChar);
        if (qualifiedPackageName == qp2) {
            int i = 0;
            int length = this.classpaths.length;
            while (i < length) {
                if (this.classpaths[i].isPackage(qualifiedPackageName)) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            int length = this.classpaths.length;
            while (i < length) {
                Classpath p = this.classpaths[i];
                if (p instanceof ClasspathJar ? p.isPackage(qualifiedPackageName) : p.isPackage(qp2)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    static interface Classpath {
        public NameEnvironmentAnswer findClass(char[] var1, String var2, String var3);

        public boolean isPackage(String var1);

        public void reset();

        public char[] normalizedPath();

        public String getPath();

        public void initialize() throws IOException;
    }
}

