/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;

public class NullInfoRegistry
extends UnconditionalFlowInfo {
    public NullInfoRegistry(UnconditionalFlowInfo upstream) {
        if ((upstream.tagBits & 2) != 0) {
            long b1nb2 = upstream.nullAssignmentStatusBit1 & (upstream.nullAssignmentStatusBit2 ^ 0xFFFFFFFFFFFFFFFFL);
            long b3 = upstream.nullAssignmentValueBit1;
            long b4 = upstream.nullAssignmentValueBit2;
            this.nullAssignmentStatusBit1 = b1nb2 & b3 & (b4 ^ 0xFFFFFFFFFFFFFFFFL);
            long a1 = this.nullAssignmentStatusBit1;
            this.nullAssignmentStatusBit2 = b1nb2 & (b3 ^ 0xFFFFFFFFFFFFFFFFL) & b4;
            long a2 = this.nullAssignmentStatusBit2;
            this.nullAssignmentValueBit1 = b1nb2 & b3 & b4;
            long a3 = this.nullAssignmentValueBit1;
            if ((a1 | a2 | a3) != 0L) {
                this.tagBits |= 2;
            }
            if (upstream.extra != null) {
                this.extra = new long[6][];
                int length = upstream.extra[2].length;
                int i = 2;
                while (i < 6) {
                    this.extra[i] = new long[length];
                    ++i;
                }
                i = 0;
                while (i < length) {
                    b1nb2 = upstream.extra[2][i] & (upstream.extra[3][i] ^ 0xFFFFFFFFFFFFFFFFL);
                    b3 = upstream.extra[4][i];
                    b4 = upstream.extra[5][i];
                    this.extra[2][i] = b1nb2 & b3 & (b4 ^ 0xFFFFFFFFFFFFFFFFL);
                    a1 = this.extra[2][i];
                    this.extra[3][i] = b1nb2 & (b3 ^ 0xFFFFFFFFFFFFFFFFL) & b4;
                    a2 = this.extra[3][i];
                    this.extra[4][i] = b1nb2 & b3 & b4;
                    a3 = this.extra[4][i];
                    if ((a1 | a2 | a3) != 0L) {
                        this.tagBits |= 2;
                    }
                    ++i;
                }
            }
        }
    }

    public NullInfoRegistry add(NullInfoRegistry other) {
        block10: {
            if ((other.tagBits & 2) == 0) {
                return this;
            }
            this.tagBits |= 2;
            this.nullAssignmentStatusBit1 |= other.nullAssignmentStatusBit1;
            this.nullAssignmentStatusBit2 |= other.nullAssignmentStatusBit2;
            this.nullAssignmentValueBit1 |= other.nullAssignmentValueBit1;
            this.nullAssignmentValueBit2 |= other.nullAssignmentValueBit2;
            if (other.extra == null) break block10;
            if (this.extra == null) {
                this.extra = new long[6][];
                int i = 2;
                int length = other.extra[2].length;
                while (i < 6) {
                    this.extra[i] = new long[length];
                    System.arraycopy(other.extra[i], 0, this.extra[i], 0, length);
                    ++i;
                }
            } else {
                int i;
                int otherLength = other.extra[2].length;
                int length = this.extra[2].length;
                if (otherLength > length) {
                    i = 2;
                    while (i < 6) {
                        this.extra[i] = new long[otherLength];
                        System.arraycopy(this.extra[i], 0, this.extra[i], 0, length);
                        System.arraycopy(other.extra[i], length, this.extra[i], length, otherLength - length);
                        ++i;
                    }
                } else if (otherLength < length) {
                    length = otherLength;
                }
                i = 2;
                while (i < 6) {
                    int j = 0;
                    while (j < length) {
                        long[] lArray = this.extra[i];
                        int n = j;
                        lArray[n] = lArray[n] | other.extra[i][j];
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return this;
    }

    public void markAsComparedEqualToNonNull(LocalVariableBinding local) {
        this.tagBits |= 2;
        int position = local.id + this.maxFieldCount;
        if (position < 64) {
            this.nullAssignmentValueBit2 |= 1L << position;
        } else {
            int vectorIndex = position / 64 - 1;
            if (this.extra == null) {
                int length = vectorIndex + 1;
                this.extra = new long[6][];
                int j = 2;
                while (j < 6) {
                    this.extra[j] = new long[length];
                    ++j;
                }
            } else {
                int oldLength = this.extra[2].length;
                if (vectorIndex >= oldLength) {
                    int newLength = vectorIndex + 1;
                    int j = 2;
                    while (j < 6) {
                        this.extra[j] = new long[newLength];
                        System.arraycopy(this.extra[j], 0, this.extra[j], 0, oldLength);
                        ++j;
                    }
                }
            }
            long[] lArray = this.extra[5];
            int n = vectorIndex;
            lArray[n] = lArray[n] | 1L << position % 64;
        }
    }

    public void markAsDefinitelyNonNull(LocalVariableBinding local) {
        this.tagBits |= 2;
        int position = local.id + this.maxFieldCount;
        if (position < 64) {
            this.nullAssignmentStatusBit2 |= 1L << position;
        } else {
            int vectorIndex = position / 64 - 1;
            if (this.extra == null) {
                int length = vectorIndex + 1;
                this.extra = new long[6][];
                int j = 2;
                while (j < 6) {
                    this.extra[j] = new long[length];
                    ++j;
                }
            } else {
                int oldLength = this.extra[2].length;
                if (vectorIndex >= oldLength) {
                    int newLength = vectorIndex + 1;
                    int j = 2;
                    while (j < 6) {
                        this.extra[j] = new long[newLength];
                        System.arraycopy(this.extra[j], 0, this.extra[j], 0, oldLength);
                        ++j;
                    }
                }
            }
            long[] lArray = this.extra[3];
            int n = vectorIndex;
            lArray[n] = lArray[n] | 1L << position % 64;
        }
    }

    public void markAsDefinitelyNull(LocalVariableBinding local) {
        this.tagBits |= 2;
        int position = local.id + this.maxFieldCount;
        if (position < 64) {
            this.nullAssignmentStatusBit1 |= 1L << position;
        } else {
            int vectorIndex = position / 64 - 1;
            if (this.extra == null) {
                int length = vectorIndex + 1;
                this.extra = new long[6][];
                int j = 2;
                while (j < 6) {
                    this.extra[j] = new long[length];
                    ++j;
                }
            } else {
                int oldLength = this.extra[2].length;
                if (vectorIndex >= oldLength) {
                    int newLength = vectorIndex + 1;
                    int j = 2;
                    while (j < 6) {
                        this.extra[j] = new long[newLength];
                        System.arraycopy(this.extra[j], 0, this.extra[j], 0, oldLength);
                        ++j;
                    }
                }
            }
            long[] lArray = this.extra[2];
            int n = vectorIndex;
            lArray[n] = lArray[n] | 1L << position % 64;
        }
    }

    public void markAsDefinitelyUnknown(LocalVariableBinding local) {
        this.tagBits |= 2;
        int position = local.id + this.maxFieldCount;
        if (position < 64) {
            this.nullAssignmentValueBit1 |= 1L << position;
        } else {
            int vectorIndex = position / 64 - 1;
            if (this.extra == null) {
                int length = vectorIndex + 1;
                this.extra = new long[6][];
                int j = 2;
                while (j < 6) {
                    this.extra[j] = new long[length];
                    ++j;
                }
            } else {
                int oldLength = this.extra[2].length;
                if (vectorIndex >= oldLength) {
                    int newLength = vectorIndex + 1;
                    int j = 2;
                    while (j < 6) {
                        this.extra[j] = new long[newLength];
                        System.arraycopy(this.extra[j], 0, this.extra[j], 0, oldLength);
                        ++j;
                    }
                }
            }
            long[] lArray = this.extra[4];
            int n = vectorIndex;
            lArray[n] = lArray[n] | 1L << position % 64;
        }
    }

    public UnconditionalFlowInfo mitigateNullInfoOf(FlowInfo flowInfo) {
        if ((this.tagBits & 2) == 0) {
            return flowInfo.unconditionalInits();
        }
        boolean newCopy = false;
        UnconditionalFlowInfo source = flowInfo.unconditionalInits();
        long s1 = source.nullAssignmentStatusBit1;
        long s2 = source.nullAssignmentStatusBit2;
        long a1 = this.nullAssignmentStatusBit1;
        long a3 = this.nullAssignmentValueBit1;
        long m1 = s1 & s2 & (a1 | a3);
        long a2 = this.nullAssignmentStatusBit2;
        long a4 = this.nullAssignmentValueBit2;
        long m2 = (s1 ^ 0xFFFFFFFFFFFFFFFFL) & s2 & (a2 | a3 | a4);
        long s3 = source.nullAssignmentValueBit1;
        long s4 = source.nullAssignmentValueBit2;
        long m3 = s1 & (s2 ^ 0xFFFFFFFFFFFFFFFFL) & (s3 & (s4 ^ 0xFFFFFFFFFFFFFFFFL) & (a2 | a3 | a4) | s4 & ((s3 ^ 0xFFFFFFFFFFFFFFFFL) & a3 | a1));
        if ((m1 | m2 | m3) != 0L) {
            newCopy = true;
            source = source.unconditionalCopy();
            source.nullAssignmentStatusBit1 &= (m1 | m3) ^ 0xFFFFFFFFFFFFFFFFL;
            source.nullAssignmentStatusBit2 &= (m1 | m2) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (this.extra != null && source.extra != null) {
            int sourceLength = source.extra[0].length;
            int length = this.extra[2].length;
            if (sourceLength < length) {
                length = sourceLength;
            }
            int i = 0;
            while (i < length) {
                s1 = source.extra[2][i];
                s2 = source.extra[3][i];
                a1 = this.extra[2][i];
                a3 = this.extra[4][i];
                m1 = s1 & s2 & (a1 | a3);
                a2 = this.extra[3][i];
                a4 = this.extra[5][i];
                m2 = (s1 ^ 0xFFFFFFFFFFFFFFFFL) & s2 & (a2 | a3 | a4);
                s3 = source.extra[4][i];
                s4 = source.extra[5][i];
                m3 = s1 & (s2 ^ 0xFFFFFFFFFFFFFFFFL) & (s3 & (s4 ^ 0xFFFFFFFFFFFFFFFFL) & (a2 | a3 | a4) | s4 & ((s3 ^ 0xFFFFFFFFFFFFFFFFL) & a3 | a1));
                if ((m1 | m2 | m3) != 0L) {
                    if (!newCopy) {
                        newCopy = true;
                        source = source.unconditionalCopy();
                    }
                    long[] lArray = source.extra[2];
                    int n = i;
                    lArray[n] = lArray[n] & ((m1 | m3) ^ 0xFFFFFFFFFFFFFFFFL);
                    long[] lArray2 = source.extra[3];
                    int n2 = i;
                    lArray2[n2] = lArray2[n2] & ((m1 | m2) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++i;
            }
        }
        return source;
    }

    public String toString() {
        if (this.extra == null) {
            return "NullInfoRegistry<nullS1: " + this.nullAssignmentStatusBit1 + ", nullS2: " + this.nullAssignmentStatusBit2 + ", nullV1: " + this.nullAssignmentValueBit1 + ", nullV2: " + this.nullAssignmentValueBit2 + ">";
        }
        String nullS1 = "NullInfoRegistry<nullS1:[" + this.nullAssignmentStatusBit1;
        String nullS2 = "], nullS2:[" + this.nullAssignmentStatusBit2;
        String nullV1 = "], nullV1:[" + this.nullAssignmentValueBit1;
        String nullV2 = "], nullV2:[" + this.nullAssignmentValueBit2;
        int i = 0;
        int ceil = this.extra[0].length > 3 ? 3 : this.extra[0].length;
        while (i < ceil) {
            nullS1 = String.valueOf(nullS1) + "," + this.extra[2][i];
            nullS2 = String.valueOf(nullS2) + "," + this.extra[3][i];
            nullV1 = String.valueOf(nullV1) + "," + this.extra[4][i];
            nullV2 = String.valueOf(nullV2) + "," + this.extra[5][i];
            ++i;
        }
        if (ceil < this.extra[0].length) {
            nullS1 = String.valueOf(nullS1) + ",...";
            nullS2 = String.valueOf(nullS2) + ",...";
            nullV1 = String.valueOf(nullV1) + ",...";
            nullV2 = String.valueOf(nullV2) + ",...";
        }
        return String.valueOf(nullS1) + nullS2 + nullV1 + nullV2 + "]>";
    }
}

