/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;
import org.eclipse.jdt.internal.core.builder.BatchImageBuilder;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.CompilationParticipantResult;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.jdt.internal.core.util.Messages;

public class IncrementalImageBuilder
extends AbstractImageBuilder {
    protected ArrayList sourceFiles;
    protected ArrayList previousSourceFiles;
    protected StringSet qualifiedStrings;
    protected StringSet simpleStrings;
    protected SimpleLookupTable secondaryTypesToRemove;
    protected boolean hasStructuralChanges;
    protected int compileLoop;
    public static int MaxCompileLoop = 5;

    protected IncrementalImageBuilder(JavaBuilder javaBuilder) {
        super(javaBuilder, true, null);
        this.nameEnvironment.isIncrementalBuild = true;
        this.newState.copyFrom(javaBuilder.lastState);
    }

    protected IncrementalImageBuilder(BatchImageBuilder batchBuilder) {
        super(batchBuilder.javaBuilder, true, batchBuilder.newState);
        this.nameEnvironment.isIncrementalBuild = true;
        this.resetCollections();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean build(SimpleLookupTable deltas) {
        if (JavaBuilder.DEBUG) {
            System.out.println("INCREMENTAL build");
        }
        try {
            try {
                this.resetCollections();
                this.notifier.subTask(Messages.build_analyzingDeltas);
                sourceDelta = (IResourceDelta)deltas.get(this.javaBuilder.currentProject);
                if (sourceDelta != null && !this.findSourceFiles(sourceDelta)) {
lbl10:
                    // 5 sources

                    while (true) {
                        var10_5 = null;
                        this.cleanUp();
                        return false;
                    }
                }
                this.notifier.updateProgressDelta(0.1f);
                keyTable = deltas.keyTable;
                valueTable = deltas.valueTable;
                i = 0;
                l = valueTable.length;
                while (true) {
                    if (i >= l) break;
                    delta = (IResourceDelta)valueTable[i];
                    if (delta != null && (classFoldersAndJars = (ClasspathLocation[])this.javaBuilder.binaryLocationsPerProject.get(p = (IProject)keyTable[i])) != null && !this.findAffectedSourceFiles(delta, classFoldersAndJars, p)) ** GOTO lbl10
                    ++i;
                }
                this.notifier.updateProgressDelta(0.1f);
                this.notifier.subTask(Messages.build_analyzingSources);
                this.addAffectedSourceFiles();
                this.notifier.updateProgressDelta(0.05f);
                this.compileLoop = 0;
                increment = 0.4f;
                while (true) {
                    block14: {
                        block13: {
                            if (this.sourceFiles.size() > 0) break block13;
                            if (this.hasStructuralChanges && this.javaBuilder.javaProject.hasCycleMarker()) {
                                this.javaBuilder.mustPropagateStructuralChanges();
                            }
                            break;
                        }
                        if (++this.compileLoop <= IncrementalImageBuilder.MaxCompileLoop) break block14;
                        if (JavaBuilder.DEBUG) {
                            System.out.println("ABORTING incremental build... exceeded loop count");
                        }
                        ** GOTO lbl10
                    }
                    this.notifier.checkCancel();
                    allSourceFiles = new SourceFile[this.sourceFiles.size()];
                    this.sourceFiles.toArray(allSourceFiles);
                    this.resetCollections();
                    this.workQueue.addAll(allSourceFiles);
                    this.notifier.setProgressPerCompilationUnit(increment / (float)allSourceFiles.length);
                    increment /= 2.0f;
                    this.compile(allSourceFiles);
                    this.removeSecondaryTypes();
                    this.addAffectedSourceFiles();
                }
            }
            catch (AbortIncrementalBuildException e) {
                if (!JavaBuilder.DEBUG) ** GOTO lbl10
                System.out.println("ABORTING incremental build... problem with " + e.qualifiedTypeName + ". Likely renamed inside its existing source file.");
                ** continue;
            }
            catch (CoreException e) {
                throw this.internalException(e);
            }
        }
        catch (Throwable var11_17) {
            var10_6 = null;
            this.cleanUp();
            throw var11_17;
        }
        {
            var10_7 = null;
            this.cleanUp();
            return true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void buildAfterBatchBuild() {
        if (JavaBuilder.DEBUG) {
            System.out.println("INCREMENTAL build after batch build @ " + new Date(System.currentTimeMillis()));
        }
        try {
            try {
                this.addAffectedSourceFiles();
                while (this.sourceFiles.size() > 0) {
                    this.notifier.checkCancel();
                    SourceFile[] allSourceFiles = new SourceFile[this.sourceFiles.size()];
                    this.sourceFiles.toArray(allSourceFiles);
                    this.resetCollections();
                    this.notifier.setProgressPerCompilationUnit(0.08f / (float)allSourceFiles.length);
                    this.workQueue.addAll(allSourceFiles);
                    this.compile(allSourceFiles);
                    this.removeSecondaryTypes();
                    this.addAffectedSourceFiles();
                }
            }
            catch (CoreException e) {
                throw this.internalException(e);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.cleanUp();
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.cleanUp();
            return;
        }
    }

    protected void addAffectedSourceFiles() {
        if (this.qualifiedStrings.elementSize == 0 && this.simpleStrings.elementSize == 0) {
            return;
        }
        this.addAffectedSourceFiles(this.qualifiedStrings, this.simpleStrings);
    }

    protected void addAffectedSourceFiles(char[] secondaryTypeName) {
        int index = CharOperation.lastIndexOf('/', secondaryTypeName);
        String packageName = index == -1 ? null : new String(CharOperation.subarray(secondaryTypeName, 0, index));
        StringSet packageNames = new StringSet(1);
        packageNames.add(packageName);
        String typeName = new String(index == -1 ? secondaryTypeName : CharOperation.subarray(secondaryTypeName, index + 1, secondaryTypeName.length));
        StringSet typeNames = new StringSet(1);
        typeNames.add(typeName);
        this.addAffectedSourceFiles(packageNames, typeNames);
    }

    private void addAffectedSourceFiles(StringSet qualifiedSet, StringSet simpleSet) {
        char[][] internedSimpleNames;
        char[][][] internedQualifiedNames = ReferenceCollection.internQualifiedNames(qualifiedSet);
        if (internedQualifiedNames.length < qualifiedSet.elementSize) {
            internedQualifiedNames = null;
        }
        if ((internedSimpleNames = ReferenceCollection.internSimpleNames(simpleSet)).length < simpleSet.elementSize) {
            internedSimpleNames = null;
        }
        Object[] keyTable = this.newState.references.keyTable;
        Object[] valueTable = this.newState.references.valueTable;
        int i = 0;
        int l = valueTable.length;
        while (i < l) {
            String typeLocator;
            IFile file;
            SourceFile sourceFile;
            ReferenceCollection refs = (ReferenceCollection)valueTable[i];
            if (!(refs == null || !refs.includes(internedQualifiedNames, internedSimpleNames) || (sourceFile = this.findSourceFile(file = this.javaBuilder.currentProject.getFile(typeLocator = (String)keyTable[i]))) == null || this.sourceFiles.contains(sourceFile) || this.compiledAllAtOnce && this.previousSourceFiles != null && this.previousSourceFiles.contains(sourceFile))) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("  adding affected source file " + typeLocator);
                }
                this.sourceFiles.add(sourceFile);
            }
            ++i;
        }
    }

    protected void addDependentsOf(IPath path, boolean isStructuralChange) {
        if (isStructuralChange && !this.hasStructuralChanges) {
            this.newState.tagAsStructurallyChanged();
            this.hasStructuralChanges = true;
        }
        path = path.setDevice(null);
        String packageName = path.removeLastSegments(1).toString();
        this.qualifiedStrings.add(packageName);
        String typeName = path.lastSegment();
        int memberIndex = typeName.indexOf(36);
        if (memberIndex > 0) {
            typeName = typeName.substring(0, memberIndex);
        }
        if (this.simpleStrings.add(typeName) && JavaBuilder.DEBUG) {
            System.out.println("  will look for dependents of " + typeName + " in " + packageName);
        }
    }

    protected boolean checkForClassFileChanges(IResourceDelta binaryDelta, ClasspathMultiDirectory md, int segmentCount) throws CoreException {
        IResource resource = binaryDelta.getResource();
        boolean isExcluded = (md.exclusionPatterns != null || md.inclusionPatterns != null) && org.eclipse.jdt.internal.core.util.Util.isExcluded(resource, md.inclusionPatterns, md.exclusionPatterns);
        switch (resource.getType()) {
            case 2: {
                if (isExcluded && md.inclusionPatterns == null) {
                    return true;
                }
                IResourceDelta[] children = binaryDelta.getAffectedChildren();
                int i = 0;
                int l = children.length;
                while (i < l) {
                    this.checkForClassFileChanges(children[i], md, segmentCount);
                    ++i;
                }
                return true;
            }
            case 1: {
                if (isExcluded || !Util.isClassFileName(resource.getName())) break;
                IPath typePath = resource.getFullPath().removeFirstSegments(segmentCount).removeFileExtension();
                if (this.newState.isKnownType(typePath.toString())) {
                    if (JavaBuilder.DEBUG) {
                        System.out.println("MOST DO FULL BUILD. Found change to class file " + typePath);
                    }
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    protected void cleanUp() {
        super.cleanUp();
        this.sourceFiles = null;
        this.previousSourceFiles = null;
        this.qualifiedStrings = null;
        this.simpleStrings = null;
        this.secondaryTypesToRemove = null;
        this.hasStructuralChanges = false;
        this.compileLoop = 0;
    }

    protected void deleteGeneratedFiles(IFile[] deletedGeneratedFiles) {
        try {
            int j = deletedGeneratedFiles.length;
            while (--j >= 0) {
                SourceFile sourceFile = this.findSourceFile(deletedGeneratedFiles[j]);
                if (sourceFile == null) continue;
                String typeLocator = sourceFile.typeLocator();
                int mdSegmentCount = sourceFile.sourceLocation.sourceFolder.getFullPath().segmentCount();
                IPath typePath = sourceFile.resource.getFullPath().removeFirstSegments(mdSegmentCount).removeFileExtension();
                char[][] definedTypeNames = this.newState.getDefinedTypeNamesFor(typeLocator);
                if (definedTypeNames == null) {
                    this.removeClassFile(typePath, sourceFile.sourceLocation.binaryFolder);
                } else {
                    this.addDependentsOf(typePath, true);
                    if (definedTypeNames.length > 0) {
                        IPath packagePath = typePath.removeLastSegments(1);
                        int d = 0;
                        int l = definedTypeNames.length;
                        while (d < l) {
                            this.removeClassFile(packagePath.append(new String(definedTypeNames[d])), sourceFile.sourceLocation.binaryFolder);
                            ++d;
                        }
                    }
                }
                this.newState.removeLocator(typeLocator);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected boolean findAffectedSourceFiles(IResourceDelta delta, ClasspathLocation[] classFoldersAndJars, IProject prereqProject) {
        int i = 0;
        int l = classFoldersAndJars.length;
        while (i < l) {
            IResourceDelta binaryDelta;
            IPath p;
            ClasspathLocation bLocation = classFoldersAndJars[i];
            if (bLocation != null && (p = bLocation.getProjectRelativePath()) != null && (binaryDelta = delta.findMember(p)) != null) {
                if (bLocation instanceof ClasspathJar) {
                    if (JavaBuilder.DEBUG) {
                        System.out.println("ABORTING incremental build... found delta to jar/zip file");
                    }
                    return false;
                }
                if (binaryDelta.getKind() == 1 || binaryDelta.getKind() == 2) {
                    if (JavaBuilder.DEBUG) {
                        System.out.println("ABORTING incremental build... found added/removed binary folder");
                    }
                    return false;
                }
                int segmentCount = binaryDelta.getFullPath().segmentCount();
                IResourceDelta[] children = binaryDelta.getAffectedChildren();
                StringSet structurallyChangedTypes = null;
                if (bLocation.isOutputFolder()) {
                    structurallyChangedTypes = this.newState.getStructurallyChangedTypes(this.javaBuilder.getLastState(prereqProject));
                }
                int j = 0;
                int m = children.length;
                while (j < m) {
                    this.findAffectedSourceFiles(children[j], segmentCount, structurallyChangedTypes);
                    ++j;
                }
                this.notifier.checkCancel();
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void findAffectedSourceFiles(IResourceDelta binaryDelta, int segmentCount, StringSet structurallyChangedTypes) {
        resource = binaryDelta.getResource();
        switch (resource.getType()) {
            case 2: {
                switch (binaryDelta.getKind()) {
                    case 1: 
                    case 2: {
                        packagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        packageName = packagePath.toString();
                        if (binaryDelta.getKind() != 1) ** GOTO lbl17
                        if (!this.newState.isKnownPackage(packageName)) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found added package " + packageName);
                            }
                            this.addDependentsOf(packagePath, false);
                            return;
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Skipped dependents of added package " + packageName);
                        }
                        ** GOTO lbl24
lbl17:
                        // 1 sources

                        if (!this.nameEnvironment.isPackage(packageName)) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found removed package " + packageName);
                            }
                            this.addDependentsOf(packagePath, false);
                            return;
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Skipped dependents of removed package " + packageName);
                        }
                    }
lbl24:
                    // 5 sources

                    case 4: {
                        children = binaryDelta.getAffectedChildren();
                        i = 0;
                        l = children.length;
                        while (i < l) {
                            this.findAffectedSourceFiles(children[i], segmentCount, structurallyChangedTypes);
                            ++i;
                        }
                        break;
                    }
                }
                return;
            }
            case 1: {
                if (!Util.isClassFileName(resource.getName())) break;
                typePath = resource.getFullPath().removeFirstSegments(segmentCount).removeFileExtension();
                switch (binaryDelta.getKind()) {
                    case 1: 
                    case 2: {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found added/removed class file " + typePath);
                        }
                        this.addDependentsOf(typePath, false);
                        return;
                    }
                    case 4: {
                        if ((binaryDelta.getFlags() & 256) == 0) {
                            return;
                        }
                        if (structurallyChangedTypes != null && !structurallyChangedTypes.includes(typePath.toString())) {
                            return;
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found changed class file " + typePath);
                        }
                        this.addDependentsOf(typePath, false);
                    }
                }
                return;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean findSourceFiles(IResourceDelta delta) throws CoreException {
        ArrayList<IContainer> visited = new ArrayList<IContainer>(this.sourceLocations.length);
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            ClasspathMultiDirectory md = this.sourceLocations[i];
            if (md.sourceFolder.equals((Object)this.javaBuilder.currentProject)) {
                int segmentCount = delta.getFullPath().segmentCount();
                IResourceDelta[] children = delta.getAffectedChildren();
                int j = 0;
                int m = children.length;
                while (j < m) {
                    if (!this.isExcludedFromProject(children[j].getFullPath()) && !this.findSourceFiles(children[j], md, segmentCount)) {
                        return false;
                    }
                    ++j;
                }
            } else {
                IResourceDelta sourceDelta;
                int m;
                int j;
                if (md.hasIndependentOutputFolder && !visited.contains(md.binaryFolder)) {
                    visited.add(md.binaryFolder);
                    IResourceDelta binaryDelta = delta.findMember(md.binaryFolder.getProjectRelativePath());
                    if (binaryDelta != null) {
                        int segmentCount = binaryDelta.getFullPath().segmentCount();
                        IResourceDelta[] children = binaryDelta.getAffectedChildren();
                        j = 0;
                        m = children.length;
                        while (j < m) {
                            if (!this.checkForClassFileChanges(children[j], md, segmentCount)) {
                                return false;
                            }
                            ++j;
                        }
                    }
                }
                if ((sourceDelta = delta.findMember(md.sourceFolder.getProjectRelativePath())) != null) {
                    if (sourceDelta.getKind() == 2) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("ABORTING incremental build... found removed source folder");
                        }
                        return false;
                    }
                    int segmentCount = sourceDelta.getFullPath().segmentCount();
                    IResourceDelta[] children = sourceDelta.getAffectedChildren();
                    try {
                        j = 0;
                        m = children.length;
                        while (j < m) {
                            if (!this.findSourceFiles(children[j], md, segmentCount)) {
                                return false;
                            }
                            ++j;
                        }
                    }
                    catch (CoreException e) {
                        if (e.getStatus().getCode() == 275) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("ABORTING incremental build... found renamed package");
                            }
                            return false;
                        }
                        throw e;
                    }
                }
            }
            this.notifier.checkCancel();
            ++i;
        }
        return true;
    }

    protected boolean findSourceFiles(IResourceDelta sourceDelta, ClasspathMultiDirectory md, int segmentCount) throws CoreException {
        IResource resource = sourceDelta.getResource();
        boolean isExcluded = (md.exclusionPatterns != null || md.inclusionPatterns != null) && org.eclipse.jdt.internal.core.util.Util.isExcluded(resource, md.inclusionPatterns, md.exclusionPatterns);
        switch (resource.getType()) {
            case 2: {
                if (isExcluded && md.inclusionPatterns == null) {
                    return true;
                }
                switch (sourceDelta.getKind()) {
                    case 1: {
                        if (!isExcluded) {
                            IPath addedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                            this.createFolder(addedPackagePath, md.binaryFolder);
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found added package " + addedPackagePath);
                            }
                            this.addDependentsOf(addedPackagePath, true);
                        }
                    }
                    case 4: {
                        IResourceDelta[] children = sourceDelta.getAffectedChildren();
                        int i = 0;
                        int l = children.length;
                        while (i < l) {
                            this.findSourceFiles(children[i], md, segmentCount);
                            ++i;
                        }
                        return true;
                    }
                    case 2: {
                        IFolder removedPackageFolder;
                        if (isExcluded) {
                            IResourceDelta[] children = sourceDelta.getAffectedChildren();
                            int i = 0;
                            int l = children.length;
                            while (i < l) {
                                this.findSourceFiles(children[i], md, segmentCount);
                                ++i;
                            }
                            return true;
                        }
                        IPath removedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        if (this.sourceLocations.length > 1) {
                            int i = 0;
                            int l = this.sourceLocations.length;
                            while (i < l) {
                                if (this.sourceLocations[i].sourceFolder.getFolder(removedPackagePath).exists()) {
                                    this.createFolder(removedPackagePath, md.binaryFolder);
                                    IResourceDelta[] removedChildren = sourceDelta.getAffectedChildren();
                                    int j = 0;
                                    int m = removedChildren.length;
                                    while (j < m) {
                                        this.findSourceFiles(removedChildren[j], md, segmentCount);
                                        ++j;
                                    }
                                    return true;
                                }
                                ++i;
                            }
                        }
                        if ((removedPackageFolder = md.binaryFolder.getFolder(removedPackagePath)).exists()) {
                            removedPackageFolder.delete(1, null);
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found removed package " + removedPackagePath);
                        }
                        this.addDependentsOf(removedPackagePath, true);
                        this.newState.removePackage(sourceDelta);
                    }
                }
                return true;
            }
            case 1: {
                if (isExcluded) {
                    return true;
                }
                String resourceName = resource.getName();
                if (org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(resourceName)) {
                    IPath typePath = resource.getFullPath().removeFirstSegments(segmentCount).removeFileExtension();
                    String typeLocator = resource.getProjectRelativePath().toString();
                    switch (sourceDelta.getKind()) {
                        case 1: {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Compile this added source file " + typeLocator);
                            }
                            this.sourceFiles.add(new SourceFile((IFile)resource, md, true));
                            String typeName = typePath.toString();
                            if (!this.newState.isDuplicateLocator(typeName, typeLocator)) {
                                if (JavaBuilder.DEBUG) {
                                    System.out.println("Found added source file " + typeName);
                                }
                                this.addDependentsOf(typePath, true);
                            }
                            return true;
                        }
                        case 2: {
                            char[][] definedTypeNames = this.newState.getDefinedTypeNamesFor(typeLocator);
                            if (definedTypeNames == null) {
                                this.removeClassFile(typePath, md.binaryFolder);
                                if ((sourceDelta.getFlags() & 0x2000) != 0) {
                                    IFile movedFile = this.javaBuilder.workspaceRoot.getFile(sourceDelta.getMovedToPath());
                                    JavaBuilder.removeProblemsAndTasksFor((IResource)movedFile);
                                }
                            } else {
                                if (JavaBuilder.DEBUG) {
                                    System.out.println("Found removed source file " + typePath.toString());
                                }
                                this.addDependentsOf(typePath, true);
                                if (definedTypeNames.length > 0) {
                                    IPath packagePath = typePath.removeLastSegments(1);
                                    int i = 0;
                                    int l = definedTypeNames.length;
                                    while (i < l) {
                                        this.removeClassFile(packagePath.append(new String(definedTypeNames[i])), md.binaryFolder);
                                        ++i;
                                    }
                                }
                            }
                            this.newState.removeLocator(typeLocator);
                            return true;
                        }
                        case 4: {
                            if ((sourceDelta.getFlags() & 0x100) == 0 && (sourceDelta.getFlags() & 0x100000) == 0) {
                                return true;
                            }
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Compile this changed source file " + typeLocator);
                            }
                            this.sourceFiles.add(new SourceFile((IFile)resource, md, true));
                        }
                    }
                    return true;
                }
                if (Util.isClassFileName(resourceName)) {
                    IPath typePath = resource.getFullPath().removeFirstSegments(segmentCount).removeFileExtension();
                    if (this.newState.isKnownType(typePath.toString())) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("MOST DO FULL BUILD. Found change to class file " + typePath);
                        }
                        return false;
                    }
                    return true;
                }
                if (!md.hasIndependentOutputFolder) break;
                if (this.javaBuilder.filterExtraResource(resource)) {
                    return true;
                }
                IPath resourcePath = resource.getFullPath().removeFirstSegments(segmentCount);
                IFile outputFile = md.binaryFolder.getFile(resourcePath);
                switch (sourceDelta.getKind()) {
                    case 1: {
                        if (outputFile.exists()) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Deleting existing file " + resourcePath);
                            }
                            outputFile.delete(1, null);
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Copying added file " + resourcePath);
                        }
                        this.createFolder(resourcePath.removeLastSegments(1), md.binaryFolder);
                        resource.copy(outputFile.getFullPath(), 1025, null);
                        org.eclipse.jdt.internal.core.util.Util.setReadOnly((IResource)outputFile, false);
                        return true;
                    }
                    case 2: {
                        if (outputFile.exists()) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Deleting removed file " + resourcePath);
                            }
                            outputFile.delete(1, null);
                        }
                        return true;
                    }
                    case 4: {
                        if ((sourceDelta.getFlags() & 0x100) == 0 && (sourceDelta.getFlags() & 0x100000) == 0) {
                            return true;
                        }
                        if (outputFile.exists()) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Deleting existing file " + resourcePath);
                            }
                            outputFile.delete(1, null);
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Copying changed file " + resourcePath);
                        }
                        this.createFolder(resourcePath.removeLastSegments(1), md.binaryFolder);
                        resource.copy(outputFile.getFullPath(), 1025, null);
                        org.eclipse.jdt.internal.core.util.Util.setReadOnly((IResource)outputFile, false);
                    }
                }
                return true;
            }
        }
        return true;
    }

    protected void finishedWith(String sourceLocator, CompilationResult result, char[] mainTypeName, ArrayList definedTypeNames, ArrayList duplicateTypeNames) {
        Object previousTypeNames = this.newState.getDefinedTypeNamesFor(sourceLocator);
        if (previousTypeNames == null) {
            previousTypeNames = new char[][]{mainTypeName};
        }
        IPath packagePath = null;
        int i = 0;
        int l = ((char[][])previousTypeNames).length;
        while (i < l) {
            block7: {
                ArrayList<IPath> types;
                char[] previous = previousTypeNames[i];
                int j = 0;
                int m = definedTypeNames.size();
                while (j < m) {
                    if (!CharOperation.equals(previous, (char[])definedTypeNames.get(j))) {
                        ++j;
                        continue;
                    }
                    break block7;
                }
                SourceFile sourceFile = (SourceFile)result.getCompilationUnit();
                if (packagePath == null) {
                    int count = sourceFile.sourceLocation.sourceFolder.getFullPath().segmentCount();
                    packagePath = sourceFile.resource.getFullPath().removeFirstSegments(count).removeLastSegments(1);
                }
                if (this.secondaryTypesToRemove == null) {
                    this.secondaryTypesToRemove = new SimpleLookupTable();
                }
                if ((types = (ArrayList<IPath>)this.secondaryTypesToRemove.get(sourceFile.sourceLocation.binaryFolder)) == null) {
                    types = new ArrayList<IPath>(definedTypeNames.size());
                }
                types.add(packagePath.append(new String(previous)));
                this.secondaryTypesToRemove.put(sourceFile.sourceLocation.binaryFolder, types);
            }
            ++i;
        }
        super.finishedWith(sourceLocator, result, mainTypeName, definedTypeNames, duplicateTypeNames);
    }

    protected void processAnnotationResults(CompilationParticipantResult[] results) {
        int i = results.length;
        while (--i >= 0) {
            IFile[] addedGeneratedFiles;
            CompilationParticipantResult result = results[i];
            if (result == null) continue;
            IFile[] deletedGeneratedFiles = result.deletedFiles;
            if (deletedGeneratedFiles != null) {
                this.deleteGeneratedFiles(deletedGeneratedFiles);
            }
            if ((addedGeneratedFiles = result.addedFiles) != null) {
                int j = addedGeneratedFiles.length;
                while (--j >= 0) {
                    SourceFile sourceFile = this.findSourceFile(addedGeneratedFiles[j]);
                    if (sourceFile == null || this.sourceFiles.contains(sourceFile)) continue;
                    this.sourceFiles.add(sourceFile);
                }
            }
            this.recordParticipantResult(result);
        }
    }

    protected void removeClassFile(IPath typePath, IContainer outputFolder) throws CoreException {
        IFile classFile;
        if (typePath.lastSegment().indexOf(36) == -1) {
            this.newState.removeQualifiedTypeName(typePath.toString());
            if (JavaBuilder.DEBUG) {
                System.out.println("Found removed type " + typePath);
            }
            this.addDependentsOf(typePath, true);
        }
        if ((classFile = outputFolder.getFile(typePath.addFileExtension("class"))).exists()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Deleting class file of removed type " + typePath);
            }
            classFile.delete(1, null);
        }
    }

    protected void removeSecondaryTypes() throws CoreException {
        if (this.secondaryTypesToRemove != null) {
            Object[] keyTable = this.secondaryTypesToRemove.keyTable;
            Object[] valueTable = this.secondaryTypesToRemove.valueTable;
            int i = 0;
            int l = keyTable.length;
            while (i < l) {
                IContainer outputFolder = (IContainer)keyTable[i];
                if (outputFolder != null) {
                    ArrayList paths = (ArrayList)valueTable[i];
                    int j = 0;
                    int m = paths.size();
                    while (j < m) {
                        this.removeClassFile((IPath)paths.get(j), outputFolder);
                        ++j;
                    }
                }
                ++i;
            }
            this.secondaryTypesToRemove = null;
            if (this.previousSourceFiles != null && this.previousSourceFiles.size() > 1) {
                this.previousSourceFiles = null;
            }
        }
    }

    protected void resetCollections() {
        if (this.sourceFiles == null) {
            this.sourceFiles = new ArrayList(33);
            this.previousSourceFiles = null;
            this.qualifiedStrings = new StringSet(3);
            this.simpleStrings = new StringSet(3);
            this.hasStructuralChanges = false;
            this.compileLoop = 0;
        } else {
            this.previousSourceFiles = this.sourceFiles.isEmpty() ? null : (ArrayList)this.sourceFiles.clone();
            this.sourceFiles.clear();
            this.qualifiedStrings.clear();
            this.simpleStrings.clear();
            this.workQueue.clear();
        }
    }

    protected void updateProblemsFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IMarker[] markers = JavaBuilder.getProblemsFor((IResource)sourceFile.resource);
        CategorizedProblem[] problems = result.getProblems();
        if (problems == null && markers.length == 0) {
            return;
        }
        this.notifier.updateProblemCounts(markers, problems);
        JavaBuilder.removeProblemsFor((IResource)sourceFile.resource);
        this.storeProblemsFor(sourceFile, problems);
    }

    protected void updateTasksFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IMarker[] markers = JavaBuilder.getTasksFor((IResource)sourceFile.resource);
        CategorizedProblem[] tasks = result.getTasks();
        if (tasks == null && markers.length == 0) {
            return;
        }
        JavaBuilder.removeTasksFor((IResource)sourceFile.resource);
        this.storeTasksFor(sourceFile, tasks);
    }

    protected void writeClassFileBytes(byte[] bytes, IFile file, String qualifiedFileName, boolean isTopLevelType, boolean updateClassFile) throws CoreException {
        if (file.exists()) {
            if (this.writeClassFileCheck(file, qualifiedFileName, bytes) || updateClassFile) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Writing changed class file " + file.getName());
                }
                if (!file.isDerived()) {
                    file.setDerived(true);
                }
                file.setContents((InputStream)new ByteArrayInputStream(bytes), true, false, null);
            } else if (JavaBuilder.DEBUG) {
                System.out.println("Skipped over unchanged class file " + file.getName());
            }
        } else {
            if (isTopLevelType) {
                this.addDependentsOf((IPath)new Path(qualifiedFileName), true);
            }
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing new class file " + file.getName());
            }
            try {
                file.create((InputStream)new ByteArrayInputStream(bytes), 1025, null);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 275) {
                    throw new AbortCompilation(true, new AbortIncrementalBuildException(qualifiedFileName));
                }
                throw e;
            }
        }
    }

    protected boolean writeClassFileCheck(IFile file, String fileName, byte[] newBytes) throws CoreException {
        URI location;
        byte[] oldBytes;
        block9: {
            block8: {
                oldBytes = org.eclipse.jdt.internal.core.util.Util.getResourceContentsAsByteArray(file);
                if (newBytes.length != oldBytes.length) break block8;
                int i = newBytes.length;
                while (--i >= 0) {
                    if (newBytes[i] == oldBytes[i]) {
                        continue;
                    }
                    break block8;
                }
                return false;
            }
            location = file.getLocationURI();
            if (location != null) break block9;
            return false;
        }
        try {
            String filePath = location.getSchemeSpecificPart();
            ClassFileReader reader = new ClassFileReader(oldBytes, filePath.toCharArray());
            if (!reader.isLocal() && !reader.isAnonymous() && reader.hasStructuralChanges(newBytes)) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Type has structural changes " + fileName);
                }
                this.addDependentsOf((IPath)new Path(fileName), true);
                this.newState.wasStructurallyChanged(fileName);
            }
        }
        catch (ClassFormatException classFormatException) {
            this.addDependentsOf((IPath)new Path(fileName), true);
            this.newState.wasStructurallyChanged(fileName);
        }
        return true;
    }

    public String toString() {
        return "incremental image builder for:\n\tnew state: " + this.newState;
    }
}

