/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public abstract class RenameResourceOperation
extends AbstractWorkspaceOperation {
    String previousName;

    public RenameResourceOperation(IResource resource, String newName, String label) {
        super(label);
        this.previousName = newName;
        this.setTargetResources(new IResource[]{resource});
    }

    private IResource getResource() {
        return this.resources[0];
    }

    protected void doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.swapName(monitor, uiInfo);
    }

    protected void doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.swapName(monitor, uiInfo);
    }

    private IPath getProposedPath() {
        return this.getResource().getFullPath().removeLastSegments(1).append(this.previousName);
    }

    private void swapName(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        IResource resource = this.getResource();
        String currentName = resource.getName();
        IPath newPath = this.getProposedPath();
        monitor.beginTask(this.getLabel(), 100);
        IWorkspaceRoot workspaceRoot = resource.getWorkspace().getRoot();
        IResource newResource = workspaceRoot.findMember(newPath);
        if (newResource != null) {
            if (resource.getType() == 1 && newResource.getType() == 1) {
                IFile file = (IFile)resource;
                IFile newFile = (IFile)newResource;
                if (this.validateEdit(file, newFile, this.getShell(uiInfo))) {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 50);
                    newFile.setContents(file.getContents(), 2, (IProgressMonitor)subMonitor);
                    file.delete(2, (IProgressMonitor)subMonitor);
                }
                monitor.worked(100);
                return;
            }
            newResource.delete(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        if (resource.getType() == 4) {
            IProject project = (IProject)resource;
            IProjectDescription description = project.getDescription();
            description.setName(newPath.segment(0));
            project.move(description, 33, monitor);
        } else {
            resource.move(newPath, 34, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        this.previousName = currentName;
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, boolean undo) {
        IResource resource = this.getResource();
        IPath newPath = this.getProposedPath();
        factory.move(resource, newPath);
        return true;
    }

    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = this.computeRenameStatus();
        if (status.isOK()) {
            return super.computeUndoableStatus(monitor);
        }
        return status;
    }

    public IStatus computeRedoableStatus(IProgressMonitor monitor) {
        IStatus status = this.computeRenameStatus();
        if (status.isOK()) {
            return super.computeRedoableStatus(monitor);
        }
        return status;
    }

    private IStatus computeRenameStatus() {
        IResource resource = this.getResource();
        if (!resource.exists()) {
            return this.getErrorStatus(UndoMessages.RenameResourceOperation_ResourceDoesNotExist);
        }
        IPath proposedPath = this.getProposedPath();
        if (resource.getFullPath().equals((Object)proposedPath)) {
            return this.getErrorStatus(UndoMessages.RenameResourceOperation_SameName);
        }
        IStatus status = this.getWorkspace().validateName(this.previousName, resource.getType());
        if (!status.isOK()) {
            return status;
        }
        if (resource.getResourceAttributes().isReadOnly()) {
            return this.getWarningStatus(NLS.bind((String)UndoMessages.RenameResourceOperation_ReadOnly, (Object)resource.getName()), 0);
        }
        IResource newResource = this.getWorkspace().getRoot().findMember(proposedPath);
        if (newResource == null) {
            return this.getWarningStatus(NLS.bind((String)UndoMessages.RenameResourceOperation_ResourceAlreadyExists, (Object)proposedPath.toString()), 0);
        }
        return Status.OK_STATUS;
    }

    boolean validateEdit(IFile source, IFile destination, Shell shell) {
        if (destination.isReadOnly()) {
            IWorkspace workspace = this.getWorkspace();
            IStatus status = source.isReadOnly() ? workspace.validateEdit(new IFile[]{source, destination}, (Object)shell) : workspace.validateEdit(new IFile[]{destination}, (Object)shell);
            return status.isOK();
        }
        return true;
    }
}

