/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.ui.internal.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.apt.ui.internal.preferences.BaseConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class BasePreferencePage
extends PropertyAndPreferencePage {
    private BaseConfigurationBlock fConfigurationBlock;

    protected Control createPreferenceContent(Composite composite) {
        return this.getConfigurationBlock().createPreferenceContent(composite);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        String contextId = this.getContextHelpId();
        if (contextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), contextId);
        }
    }

    public void dispose() {
        if (this.getConfigurationBlock() != null) {
            this.getConfigurationBlock().dispose();
        }
        super.dispose();
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        if (this.getConfigurationBlock() != null) {
            this.getConfigurationBlock().useProjectSpecificSettings(useProjectSpecificSettings);
        }
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
    }

    protected BaseConfigurationBlock getConfigurationBlock() {
        return this.fConfigurationBlock;
    }

    protected String getContextHelpId() {
        return null;
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return this.getConfigurationBlock().hasProjectSpecificOptionsNoCache(project);
    }

    public void performApply() {
        if (this.getConfigurationBlock() != null) {
            this.getConfigurationBlock().performApply();
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.getConfigurationBlock() != null) {
            this.getConfigurationBlock().performDefaults();
        }
    }

    public boolean performOk() {
        if (this.getConfigurationBlock() != null && !this.getConfigurationBlock().performOk()) {
            return false;
        }
        return super.performOk();
    }

    protected void setConfigurationBlock(BaseConfigurationBlock configurationBlock) {
        this.fConfigurationBlock = configurationBlock;
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.setDescription(null);
    }
}

