/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.dialogs.DialogArea;
import org.eclipse.team.internal.ui.mapping.TeamViewerSorter;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentServiceListener;

public class ResourceMappingHierarchyArea
extends DialogArea
implements INavigatorContentServiceListener {
    private static final String TEAM_NAVIGATOR_CONTENT = "org.eclipse.team.ui.navigatorViewer";
    private String description;
    private CommonViewer viewer;
    private final ISynchronizationScope scope;
    private final ISynchronizationContext context;

    public static ResourceMappingHierarchyArea create(ISynchronizationScope scope, ISynchronizationContext context) {
        return new ResourceMappingHierarchyArea(scope, context);
    }

    private ResourceMappingHierarchyArea(ISynchronizationScope scope, ISynchronizationContext context) {
        this.scope = scope;
        this.context = context;
    }

    public void createArea(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        if (this.description != null) {
            this.createWrappingLabel(composite, this.description, 1);
        }
        this.viewer = new CommonViewer(TEAM_NAVIGATOR_CONTENT, composite, 2048);
        this.viewer.setSorter((ViewerSorter)new CommonViewerSorter());
        this.viewer.setSorter((ViewerSorter)new TeamViewerSorter((CommonViewerSorter)this.viewer.getSorter()));
        this.viewer.getNavigatorContentService().bindExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(this.scope), true);
        this.viewer.getNavigatorContentService().getActivationService().activateExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(this.scope), true);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 300;
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.getNavigatorContentService().addListener((INavigatorContentServiceListener)this);
        this.viewer.setInput(this.getInitialInput());
        this.viewer.refresh();
        Object[] objects = this.getRootModelObjects();
        this.viewer.setSelection((ISelection)new StructuredSelection(objects), true);
    }

    private Object getInitialInput() {
        if (this.context != null) {
            return this.context;
        }
        return this.scope;
    }

    private Object[] getRootModelObjects() {
        if (this.scope == null) {
            return new Object[0];
        }
        ResourceMapping[] mappings = this.scope.getMappings();
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            result.add(mapping.getModelObject());
            ++i;
        }
        return result.toArray(new Object[result.size()]);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void onLoad(INavigatorContentExtension anExtension) {
        anExtension.getStateModel().setProperty("org.eclipse.team.ui.synchronizationScope", (Object)this.scope);
        if (this.context != null) {
            anExtension.getStateModel().setProperty("org.eclipse.team.ui.synchronizationContext", (Object)this.context);
        }
    }
}

