/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelTraversalCalculator;
import org.eclipse.team.ui.mapping.SynchronizationContentProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class ResourceModelContentProvider
extends SynchronizationContentProvider
implements ITreePathContentProvider {
    private WorkbenchContentProvider provider;

    protected ITreeContentProvider getDelegateContentProvider() {
        if (this.provider == null) {
            this.provider = new WorkbenchContentProvider();
        }
        return this.provider;
    }

    protected String getModelProviderId() {
        return "org.eclipse.core.resources.modelProvider";
    }

    protected Object getModelRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected boolean isInScope(ISynchronizationScope scope, Object parent, Object elementOrPath) {
        Object object = this.internalGetElement(elementOrPath);
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            if (resource == null) {
                return false;
            }
            if (!resource.getProject().isAccessible()) {
                return false;
            }
            if (scope.contains(resource)) {
                return true;
            }
            if (this.hasChildrenInScope(scope, object, resource)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasChildrenInScope(ISynchronizationScope scope, Object object, IResource resource) {
        if (!resource.isAccessible()) {
            return false;
        }
        IResource[] roots = scope.getRoots();
        int i = 0;
        while (i < roots.length) {
            IResource root = roots[i];
            if (resource.getFullPath().isPrefixOf(root.getFullPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void init(ICommonContentExtensionSite site) {
        super.init(site);
        TeamUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        ISynchronizePageConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            configuration.setProperty("org.eclipse.team.ui.resourceModelraversalCalculator", new ResourceModelTraversalCalculator());
        }
    }

    public void dispose() {
        this.provider.dispose();
        super.dispose();
        TeamUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.ui.default_layout")) {
            this.refresh();
        }
        super.propertyChange(event);
    }

    protected Object[] getChildrenInContext(ISynchronizationContext context, Object parentOrPath, Object[] children) {
        Object parent = this.internalGetElement(parentOrPath);
        if (parent instanceof IResource) {
            IResource resource = (IResource)parent;
            if (resource.getType() == 4 && !resource.getProject().isAccessible()) {
                return new Object[0];
            }
            IResourceDiffTree diffTree = context.getDiffTree();
            Object[] allChildren = this.getTraversalCalculator().filterChildren(diffTree, resource, parentOrPath, children);
            return super.getChildrenInContext(context, parentOrPath, allChildren);
        }
        return super.getChildrenInContext(context, parentOrPath, children);
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object elementOrPath) {
        Object object = this.internalGetElement(elementOrPath);
        ISynchronizationScope scope = context.getScope();
        ResourceMapping mapping = scope.getMapping(object);
        if (mapping != null) {
            return scope.getTraversals(mapping);
        }
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            if (scope.contains(resource)) {
                ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
                ResourceTraversal[] traversals = scope.getTraversals();
                int i = 0;
                while (i < traversals.length) {
                    ResourceTraversal traversal = traversals[i];
                    if (traversal.contains(resource)) {
                        boolean include = false;
                        int depth = traversal.getDepth();
                        if (depth == 2) {
                            include = true;
                        } else {
                            IResource[] roots = traversal.getResources();
                            int j = 0;
                            while (j < roots.length) {
                                IResource root = roots[j];
                                if (root.equals((Object)resource)) {
                                    include = true;
                                    break;
                                }
                                if (root.getFullPath().equals((Object)resource.getFullPath().removeLastSegments(1)) && depth == 1) {
                                    include = true;
                                    depth = 0;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (include) {
                            int layoutDepth = this.getTraversalCalculator().getLayoutDepth(resource, this.internalGetPath(elementOrPath));
                            result.add(new ResourceTraversal(new IResource[]{resource}, Math.min(depth, layoutDepth), 0));
                        }
                    }
                    ++i;
                }
                return result.toArray(new ResourceTraversal[result.size()]);
            }
            ResourceMapping[] mappings = scope.getMappings("org.eclipse.core.resources.modelProvider");
            ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
            int i = 0;
            while (i < mappings.length) {
                ResourceMapping resourceMapping = mappings[i];
                if (resourceMapping.getModelObject() instanceof IResource) {
                    IResource root = (IResource)resourceMapping.getModelObject();
                    if (resource.getFullPath().isPrefixOf(root.getFullPath()) && (mapping = scope.getMapping((Object)root)) != null) {
                        ResourceTraversal[] traversals = scope.getTraversals(mapping);
                        result.addAll(Arrays.asList(traversals));
                    }
                }
                ++i;
            }
            return result.toArray(new ResourceTraversal[result.size()]);
        }
        return new ResourceTraversal[0];
    }

    protected boolean hasChildrenInContext(ISynchronizationContext context, Object elementOrPath) {
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof IContainer) {
            IResourceDiffTree tree;
            IContainer container = (IContainer)element;
            if (context != null && (tree = context.getDiffTree()).getChildren(container.getFullPath()).length > 0) {
                return true;
            }
        }
        return false;
    }

    public void propertyChanged(IDiffTree tree, int property, final IPath[] paths) {
        Utils.syncExec(new Runnable(){

            public void run() {
                ISynchronizationContext context = ResourceModelContentProvider.this.getContext();
                if (context != null) {
                    ResourceModelContentProvider.this.updateLabels(context, paths);
                }
            }
        }, (StructuredViewer)this.getViewer());
    }

    private IResource[] getResources(ISynchronizationContext context, IPath[] paths) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i = 0;
        while (i < paths.length) {
            IPath path = paths[i];
            IResource resource = this.getResource(context, path);
            if (resource != null) {
                resources.add(resource);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private IResource getResource(ISynchronizationContext context, IPath path) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource != null) {
            return resource;
        }
        if (context != null) {
            IResourceDiffTree diffTree = context.getDiffTree();
            IDiff node = diffTree.getDiff(path);
            if (node != null) {
                return diffTree.getResource(node);
            }
            if (diffTree.getChildren(path).length > 0) {
                if (path.segmentCount() == 1) {
                    return ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                }
                if (path.segmentCount() > 1) {
                    return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                }
            }
        }
        return null;
    }

    protected StructuredViewer getStructuredViewer() {
        return (StructuredViewer)this.getViewer();
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ISynchronizationContext) {
            parent = this.getModelRoot();
        }
        return super.getChildren(parent);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ISynchronizationContext) {
            element = this.getModelRoot();
        }
        return super.hasChildren(element);
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof ISynchronizationContext) {
            parent = this.getModelRoot();
        }
        return super.getElements(parent);
    }

    public Object getParent(Object elementOrPath) {
        ISynchronizationContext context;
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof IProject && (context = this.getContext()) != null) {
            return context;
        }
        return super.getParent(elementOrPath);
    }

    protected void refresh() {
        Utils.syncExec(new Runnable(){

            public void run() {
                TreeViewer treeViewer = (TreeViewer)ResourceModelContentProvider.this.getViewer();
                treeViewer.refresh();
            }
        }, this.getViewer().getControl());
    }

    protected void updateLabels(ISynchronizationContext context, IPath[] paths) {
        Object[] resources = this.getResources(context, paths);
        if (resources.length > 0) {
            ((AbstractTreeViewer)this.getViewer()).update(resources, null);
        }
    }

    protected ResourceModelTraversalCalculator getTraversalCalculator() {
        return (ResourceModelTraversalCalculator)this.getConfiguration().getProperty("org.eclipse.team.ui.resourceModelraversalCalculator");
    }

    protected boolean isVisible(IDiff diff) {
        return super.isVisible(diff);
    }

    public Object[] getChildren(TreePath parentPath) {
        return this.getChildren((Object)parentPath);
    }

    public boolean hasChildren(TreePath path) {
        return this.hasChildren((Object)path);
    }

    public TreePath[] getParents(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            IResource[] resourcePath = new IResource[resource.getFullPath().segmentCount()];
            int i = resourcePath.length - 1;
            while (i >= 0) {
                resourcePath[i] = resource;
                resource = resource.getParent();
                --i;
            }
            TreePath treePath = TreePath.EMPTY;
            int i2 = 0;
            while (i2 < resourcePath.length) {
                IResource r = resourcePath[i2];
                treePath = treePath.createChildPath((Object)r);
                ++i2;
            }
            return new TreePath[]{treePath};
        }
        return null;
    }

    private Object internalGetElement(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)elementOrPath;
            return tp.getLastSegment();
        }
        return elementOrPath;
    }

    private TreePath internalGetPath(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            return (TreePath)elementOrPath;
        }
        return null;
    }

    public void diffsChanged(final IDiffChangeEvent event, IProgressMonitor monitor) {
        Utils.syncExec(new Runnable(){

            public void run() {
                ResourceModelContentProvider.this.handleChange(event);
            }
        }, (StructuredViewer)this.getViewer());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleChange(IDiffChangeEvent event) {
        Set existingProjects = this.getVisibleProjects();
        IProject[] changedProjects = this.getChangedProjects(event);
        ArrayList<IProject> refreshes = new ArrayList<IProject>(changedProjects.length);
        ArrayList<IProject> additions = new ArrayList<IProject>(changedProjects.length);
        ArrayList<IProject> removals = new ArrayList<IProject>(changedProjects.length);
        int i = 0;
        while (i < changedProjects.length) {
            block13: {
                IProject project;
                block12: {
                    project = changedProjects[i];
                    if (!this.hasDiffs(event.getTree(), project)) break block12;
                    if (existingProjects.contains(project)) {
                        refreshes.add(project);
                        break block13;
                    } else if (this.hasVisibleChanges(event.getTree(), project)) {
                        additions.add(project);
                    }
                    break block13;
                }
                if (existingProjects.contains(project)) {
                    removals.add(project);
                }
            }
            ++i;
        }
        if (removals.isEmpty() && additions.isEmpty()) {
            if (refreshes.isEmpty()) return;
        }
        TreeViewer viewer = (TreeViewer)this.getViewer();
        Tree tree = viewer.getTree();
        try {
            tree.setRedraw(false);
            if (!additions.isEmpty()) {
                viewer.add(viewer.getInput(), additions.toArray());
            }
            if (!removals.isEmpty()) {
                viewer.remove(viewer.getInput(), removals.toArray());
            }
            if (!refreshes.isEmpty()) {
                viewer.remove(refreshes.toArray());
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            tree.setRedraw(true);
            throw throwable;
        }
        tree.setRedraw(true);
    }

    private boolean hasVisibleChanges(IDiffTree tree, IProject project) {
        return tree.hasMatchingDiffs(project.getFullPath(), new FastDiffFilter(){

            public boolean select(IDiff diff) {
                return ResourceModelContentProvider.this.isVisible(diff);
            }
        });
    }

    private boolean hasDiffs(IDiffTree tree, IProject project) {
        return tree.getChildren(project.getFullPath()).length > 0;
    }

    private IProject[] getChangedProjects(IDiffChangeEvent event) {
        HashSet<IProject> result = new HashSet<IProject>();
        IDiff[] changes = event.getChanges();
        int i = 0;
        while (i < changes.length) {
            IDiff diff = changes[i];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null) {
                result.add(resource.getProject());
            }
            ++i;
        }
        IDiff[] additions = event.getAdditions();
        int i2 = 0;
        while (i2 < additions.length) {
            IDiff diff = additions[i2];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null) {
                result.add(resource.getProject());
            }
            ++i2;
        }
        IPath[] removals = event.getRemovals();
        int i3 = 0;
        while (i3 < removals.length) {
            IPath path = removals[i3];
            if (path.segmentCount() > 0) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                result.add(project);
            }
            ++i3;
        }
        return result.toArray(new IProject[result.size()]);
    }

    private Set getVisibleProjects() {
        TreeViewer viewer = (TreeViewer)this.getViewer();
        Tree tree = viewer.getTree();
        TreeItem[] children = tree.getItems();
        HashSet<IResource> result = new HashSet<IResource>();
        int i = 0;
        while (i < children.length) {
            TreeItem control = children[i];
            Object data = control.getData();
            IResource resource = Utils.getResource(data);
            if (resource.getType() == 4) {
                result.add(resource);
            }
            ++i;
        }
        return result;
    }
}

