/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.DialogSynchronizePageSite;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.PageSaveablePart;
import org.eclipse.team.ui.mapping.ISaveableCompareModel;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;

public class ParticipantPageSaveablePart
extends PageSaveablePart
implements IContentChangeListener {
    private ISynchronizeParticipant participant;
    private ISynchronizePageConfiguration pageConfiguration;
    private Image titleImage;
    private IPageBookViewPage page;
    private DialogSynchronizePageSite site;
    private IPropertyChangeListener listener;
    private Viewer viewer;
    static /* synthetic */ Class class$0;

    public ParticipantPageSaveablePart(Shell shell, CompareConfiguration cc, ISynchronizePageConfiguration pageConfiguration, ISynchronizeParticipant participant) {
        super(shell, cc);
        this.participant = participant;
        this.pageConfiguration = pageConfiguration;
    }

    public void dispose() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        if (this.page != null) {
            this.page.dispose();
        }
        if (this.site != null) {
            this.site.dispose();
        }
        this.pageConfiguration.removePropertyChangeListener(this.listener);
        super.dispose();
    }

    public Image getTitleImage() {
        if (this.titleImage == null) {
            this.titleImage = this.participant.getImageDescriptor().createImage();
        }
        return this.titleImage;
    }

    public String getTitle() {
        return this.participant.getName();
    }

    public boolean isDirty() {
        ModelSynchronizeParticipant msp;
        ISaveableCompareModel currentBuffer;
        if (this.participant instanceof ModelSynchronizeParticipant && (currentBuffer = (msp = (ModelSynchronizeParticipant)this.participant).getActiveModel()) != null) {
            return currentBuffer.isDirty();
        }
        return super.isDirty();
    }

    public void contentChanged(IContentChangeNotifier source) {
        try {
            if (source instanceof DiffNode) {
                ParticipantPageSaveablePart.commit((IProgressMonitor)new NullProgressMonitor(), (DiffNode)source);
            } else if (source instanceof LocalResourceTypedElement) {
                ((LocalResourceTypedElement)source).commit((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IProgressMonitor pm) {
        super.doSave(pm);
        Object input = this.viewer.getInput();
        if (!(input instanceof ISynchronizeModelElement)) return;
        ISynchronizeModelElement root = (ISynchronizeModelElement)input;
        if (root == null) return;
        if (!(root instanceof DiffNode)) return;
        try {
            try {
                ParticipantPageSaveablePart.commit(pm, (DiffNode)root);
            }
            catch (CoreException e) {
                Utils.handle(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setDirty(false);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.setDirty(false);
    }

    protected Control createPage(Composite parent, ToolBarManager toolBarManager) {
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.team.ui.P_PAGE_DESCRIPTION")) {
                    ParticipantPageSaveablePart.this.updateDescription();
                }
            }
        };
        this.pageConfiguration.addPropertyChangeListener(this.listener);
        this.updateDescription();
        this.page = this.participant.createPage(this.pageConfiguration);
        this.site = new DialogSynchronizePageSite(this.getShell(), true);
        ((SynchronizePageConfiguration)this.pageConfiguration).setSite(this.site);
        this.site.createActionBars((IToolBarManager)toolBarManager);
        try {
            ((ISynchronizePage)this.page).init(this.pageConfiguration.getSite());
        }
        catch (PartInitException partInitException) {}
        this.page.createControl(parent);
        this.initializeDiffViewer(((ISynchronizePage)this.page).getViewer());
        this.page.setActionBars(this.site.getActionBars());
        toolBarManager.update(true);
        this.viewer = ((ISynchronizePage)this.page).getViewer();
        this.setNavigator(this.pageConfiguration);
        return this.page.getControl();
    }

    protected final ISelectionProvider getSelectionProvider() {
        return ((ISynchronizePage)this.page).getViewer();
    }

    private void updateDescription() {
        String description = (String)this.pageConfiguration.getProperty("org.eclipse.team.ui.P_PAGE_DESCRIPTION");
        if (description != null) {
            this.setPageDescription(description);
        }
    }

    private void initializeDiffViewer(Viewer viewer) {
        if (viewer instanceof StructuredViewer) {
            ((StructuredViewer)viewer).addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    ISelection s = event.getSelection();
                    SyncInfoModelElement node = ParticipantPageSaveablePart.this.getElement(s);
                    if (node == null) {
                        ICompareInput input = ParticipantPageSaveablePart.this.getCompareInput(s);
                        if (input != null) {
                            ParticipantPageSaveablePart.this.prepareCompareInput(input);
                        }
                    } else {
                        ParticipantPageSaveablePart.this.prepareCompareInput(node);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void prepareInput(ICompareInput input, CompareConfiguration configuration, IProgressMonitor monitor) throws InvocationTargetException {
        monitor.beginTask(TeamUIMessages.SyncInfoCompareInput_3, 100);
        monitor.setTaskName(TeamUIMessages.SyncInfoCompareInput_3);
        try {
            try {
                this.checkForBufferChange(this.pageConfiguration.getSite().getShell(), input, false, monitor);
                if (input instanceof SyncInfoModelElement) {
                    SyncInfoModelElement node = (SyncInfoModelElement)input;
                    IResource resource = node.getResource();
                    if (resource != null && resource.getType() == 1) {
                        this.participant.prepareCompareInput(node, configuration, monitor);
                    }
                } else {
                    ISynchronizationCompareInput adapter = this.asModelCompareInput(input);
                    if (adapter != null) {
                        adapter.prepareInput(configuration, Policy.subMonitorFor(monitor, 90));
                    }
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        monitor.done();
    }

    private void checkForBufferChange(Shell shell, ICompareInput input, boolean cancelAllowed, IProgressMonitor monitor) throws CoreException {
        ISynchronizeParticipant participant = this.pageConfiguration.getParticipant();
        if (participant instanceof ModelSynchronizeParticipant) {
            ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)participant;
            if (input instanceof ISynchronizationCompareInput) {
                ISynchronizationCompareInput mci = (ISynchronizationCompareInput)input;
                msp.checkForBufferChange(shell, mci, cancelAllowed, monitor);
            }
        }
    }

    private ISynchronizationCompareInput asModelCompareInput(ICompareInput input) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.ui.mapping.ISynchronizationCompareInput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ISynchronizationCompareInput)Utils.getAdapter(input, clazz);
    }

    private SyncInfoModelElement getElement(ISelection selection) {
        ICompareInput input = this.getCompareInput(selection);
        if (input instanceof SyncInfoModelElement) {
            return (SyncInfoModelElement)input;
        }
        return null;
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        ITypedElement right;
        ITypedElement left = node.getLeft();
        if (left instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)right).commit(pm);
        }
        IDiffElement[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            ParticipantPageSaveablePart.commit(pm, (DiffNode)children[i]);
            ++i;
        }
    }

    public ISynchronizePageConfiguration getPageConfiguration() {
        return this.pageConfiguration;
    }

    public ISynchronizeParticipant getParticipant() {
        return this.participant;
    }

    protected ICompareInput getCompareInput(ISelection selection) {
        IStructuredSelection ss;
        ICompareInput compareInput = super.getCompareInput(selection);
        if (compareInput != null) {
            return compareInput;
        }
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            Object o = ss.getFirstElement();
            if (this.participant instanceof ModelSynchronizeParticipant) {
                ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)this.participant;
                return msp.asCompareInput(o);
            }
        }
        return null;
    }
}

