/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSiteFactory;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.NavigatorActionService;

public final class CommonNavigatorManager
implements ISelectionChangedListener {
    private final CommonNavigator commonNavigator;
    private final INavigatorContentService contentService;
    private NavigatorActionService actionService;
    private final IDescriptionProvider commonDescriptionProvider;
    private final IStatusLineManager statusLineManager;
    private final ILabelProvider labelProvider;

    public CommonNavigatorManager(CommonNavigator aNavigator) {
        this.commonNavigator = aNavigator;
        this.contentService = this.commonNavigator.getNavigatorContentService();
        this.statusLineManager = this.commonNavigator.getViewSite().getActionBars().getStatusLineManager();
        this.commonDescriptionProvider = this.contentService.createCommonDescriptionProvider();
        this.labelProvider = (ILabelProvider)this.commonNavigator.getCommonViewer().getLabelProvider();
        this.init();
    }

    private void init() {
        CommonViewer commonViewer = this.commonNavigator.getCommonViewer();
        commonViewer.addSelectionChangedListener(this);
        this.updateStatusBar(commonViewer.getSelection());
        ICommonViewerWorkbenchSite commonViewerSite = CommonViewerSiteFactory.createCommonViewerSite(this.commonNavigator.getViewSite());
        this.actionService = new NavigatorActionService(commonViewerSite, (StructuredViewer)commonViewer, commonViewer.getNavigatorContentService());
        this.initContextMenu();
        this.initViewMenu();
        final RetargetAction openAction = new RetargetAction("org.eclipse.ui.navigator.Open", CommonNavigatorMessages.Open_action_label);
        this.commonNavigator.getViewSite().getPage().addPartListener((IPartListener)openAction);
        openAction.setActionDefinitionId("org.eclipse.ui.navigator.Open");
        this.commonNavigator.getCommonViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                openAction.run();
            }
        });
        this.actionService.setContext(new ActionContext((ISelection)new StructuredSelection(commonViewer.getInput())));
        this.actionService.fillActionBars(this.commonNavigator.getViewSite().getActionBars());
    }

    public void dispose() {
        this.commonNavigator.getCommonViewer().removeSelectionChangedListener(this);
        this.actionService.dispose();
    }

    public void selectionChanged(SelectionChangedEvent anEvent) {
        this.updateStatusBar(anEvent.getSelection());
        if (anEvent.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)anEvent.getSelection();
            this.actionService.setContext(new ActionContext((ISelection)structuredSelection));
            this.actionService.fillActionBars(this.commonNavigator.getViewSite().getActionBars());
        }
    }

    public void restoreState(IMemento aMemento) {
        this.actionService.restoreState(aMemento);
    }

    public void saveState(IMemento aMemento) {
        this.actionService.saveState(aMemento);
    }

    protected void fillContextMenu(IMenuManager aMenuManager) {
        ISelection selection = this.commonNavigator.getCommonViewer().getSelection();
        this.actionService.setContext(new ActionContext(selection));
        this.actionService.fillContextMenu(aMenuManager);
    }

    protected void initContextMenu() {
        MenuManager menuMgr = new MenuManager(this.contentService.getViewerDescriptor().getPopupMenuId());
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CommonNavigatorManager.this.fillContextMenu(manager);
            }
        });
        CommonViewer commonViewer = this.commonNavigator.getCommonViewer();
        Menu menu = menuMgr.createContextMenu((Control)commonViewer.getTree());
        commonViewer.getTree().setMenu(menu);
        this.actionService.prepareMenuForPlatformContributions(menuMgr, (ISelectionProvider)commonViewer, false);
    }

    protected void initViewMenu() {
        IMenuManager viewMenu = this.commonNavigator.getViewSite().getActionBars().getMenuManager();
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IContributionItem)new Separator("additions-end"));
    }

    protected void updateStatusBar(ISelection aSelection) {
        Image img = null;
        if (aSelection != null && !aSelection.isEmpty() && aSelection instanceof IStructuredSelection) {
            img = this.labelProvider.getImage(((IStructuredSelection)aSelection).getFirstElement());
        }
        this.statusLineManager.setMessage(img, this.commonDescriptionProvider.getDescription(aSelection));
    }

    public NavigatorActionService getNavigatorActionService() {
        return this.actionService;
    }
}

