/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.ContributorTrackingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.internal.navigator.extensions.OverridePolicy;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;

public class NavigatorContentServiceContentProvider
implements ITreeContentProvider,
ITreePathContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final NavigatorContentService contentService;
    private final boolean isContentServiceSelfManaged;
    private Viewer viewer;

    public NavigatorContentServiceContentProvider(String aViewerId) {
        this.contentService = new NavigatorContentService(aViewerId);
        this.isContentServiceSelfManaged = true;
    }

    public NavigatorContentServiceContentProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.isContentServiceSelfManaged = false;
    }

    public synchronized Object[] getElements(Object anInputElement) {
        Set rootContentExtensions = this.contentService.findRootContentExtensions(anInputElement);
        if (rootContentExtensions.size() == 0) {
            return NO_CHILDREN;
        }
        ContributorTrackingSet finalElementsSet = new ContributorTrackingSet(this.contentService);
        ContributorTrackingSet localSet = new ContributorTrackingSet(this.contentService);
        Object[] contributedChildren = null;
        Iterator itr = rootContentExtensions.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension foundExtension = (NavigatorContentExtension)itr.next();
            try {
                if (this.shouldDeferToOverridePath(foundExtension.getDescriptor(), rootContentExtensions)) continue;
                contributedChildren = foundExtension.internalGetContentProvider().getElements(anInputElement);
                localSet.setContents(contributedChildren);
                NavigatorContentExtension[] overridingExtensions = foundExtension.getOverridingExtensionsForTriggerPoint(anInputElement);
                if (overridingExtensions.length > 0) {
                    localSet = this.pipelineElements(anInputElement, overridingExtensions, localSet);
                }
                finalElementsSet.addAll(localSet);
            }
            catch (RuntimeException re) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), re);
            }
            catch (Error e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), e);
            }
        }
        return finalElementsSet.toArray();
    }

    public synchronized Object[] getChildren(Object aParentElement) {
        return this.internalGetChildren(aParentElement);
    }

    private Object[] internalGetChildren(Object aParentElementOrPath) {
        Object aParentElement = this.internalAsElement(aParentElementOrPath);
        Set enabledExtensions = this.contentService.findContentExtensionsByTriggerPoint(aParentElement);
        if (enabledExtensions.size() == 0) {
            return NO_CHILDREN;
        }
        ContributorTrackingSet finalChildrenSet = new ContributorTrackingSet(this.contentService);
        ContributorTrackingSet localSet = new ContributorTrackingSet(this.contentService);
        Object[] contributedChildren = null;
        Iterator itr = enabledExtensions.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension foundExtension = (NavigatorContentExtension)itr.next();
            try {
                if (this.shouldDeferToOverridePath(foundExtension.getDescriptor(), enabledExtensions)) continue;
                contributedChildren = foundExtension.internalGetContentProvider().getChildren(aParentElementOrPath);
                NavigatorContentExtension[] overridingExtensions = foundExtension.getOverridingExtensionsForTriggerPoint(aParentElement);
                localSet.setContents(contributedChildren);
                if (overridingExtensions.length > 0) {
                    localSet = this.pipelineChildren(aParentElement, overridingExtensions, localSet);
                }
                finalChildrenSet.addAll(localSet);
            }
            catch (RuntimeException re) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), re);
            }
            catch (Error e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), e);
            }
        }
        return finalChildrenSet.toArray();
    }

    private ContributorTrackingSet pipelineChildren(Object aParentOrPath, NavigatorContentExtension[] theOverridingExtensions, ContributorTrackingSet theCurrentChildren) {
        ContributorTrackingSet pipelinedChildren = theCurrentChildren;
        int i = 0;
        while (i < theOverridingExtensions.length) {
            if (theOverridingExtensions[i].getContentProvider() instanceof IPipelinedTreeContentProvider) {
                IPipelinedTreeContentProvider pipelinedContentProvider = (IPipelinedTreeContentProvider)theOverridingExtensions[i].getContentProvider();
                pipelinedChildren.setContributor((NavigatorContentDescriptor)theOverridingExtensions[i].getDescriptor());
                pipelinedContentProvider.getPipelinedChildren(aParentOrPath, pipelinedChildren);
                pipelinedChildren.setContributor(null);
                NavigatorContentExtension[] overridingExtensions = theOverridingExtensions[i].getOverridingExtensionsForTriggerPoint(aParentOrPath);
                if (overridingExtensions.length > 0) {
                    pipelinedChildren = this.pipelineChildren(aParentOrPath, overridingExtensions, pipelinedChildren);
                }
            }
            ++i;
        }
        return pipelinedChildren;
    }

    private ContributorTrackingSet pipelineElements(Object anInputElement, NavigatorContentExtension[] theOverridingExtensions, ContributorTrackingSet theCurrentElements) {
        ContributorTrackingSet pipelinedElements = theCurrentElements;
        int i = 0;
        while (i < theOverridingExtensions.length) {
            if (theOverridingExtensions[i].getContentProvider() instanceof IPipelinedTreeContentProvider) {
                IPipelinedTreeContentProvider pipelinedContentProvider = (IPipelinedTreeContentProvider)theOverridingExtensions[i].getContentProvider();
                pipelinedElements.setContributor((NavigatorContentDescriptor)theOverridingExtensions[i].getDescriptor());
                pipelinedContentProvider.getPipelinedElements(anInputElement, pipelinedElements);
                pipelinedElements.setContributor(null);
                NavigatorContentExtension[] overridingExtensions = theOverridingExtensions[i].getOverridingExtensionsForTriggerPoint(anInputElement);
                if (overridingExtensions.length > 0) {
                    pipelinedElements = this.pipelineElements(anInputElement, overridingExtensions, pipelinedElements);
                }
            }
            ++i;
        }
        return pipelinedElements;
    }

    private boolean shouldDeferToOverridePath(INavigatorContentDescriptor aDescriptor, Set theEnabledExtensions) {
        return aDescriptor.getSuppressedExtensionId() != null && aDescriptor.getOverridePolicy() == OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt && theEnabledExtensions.contains(this.contentService.getExtension(aDescriptor.getOverriddenDescriptor()));
    }

    public synchronized Object getParent(Object anElement) {
        Set extensions = this.contentService.findContentExtensionsWithPossibleChild(anElement);
        Iterator itr = extensions.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension foundExtension = (NavigatorContentExtension)itr.next();
            try {
                if (this.shouldDeferToOverridePath(foundExtension.getDescriptor(), extensions)) continue;
                Object parent = foundExtension.internalGetContentProvider().getParent(anElement);
                NavigatorContentExtension[] overridingExtensions = foundExtension.getOverridingExtensionsForPossibleChild(anElement);
                if (overridingExtensions.length > 0) {
                    parent = this.pipelineParent(anElement, overridingExtensions, parent);
                }
                if (parent == null) continue;
                return parent;
            }
            catch (RuntimeException re) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), re);
            }
            catch (Error e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), e);
            }
        }
        return null;
    }

    private Object pipelineParent(Object anInputElement, NavigatorContentExtension[] theOverridingExtensions, Object aSuggestedParent) {
        int i = 0;
        while (i < theOverridingExtensions.length) {
            if (theOverridingExtensions[i].getContentProvider() instanceof IPipelinedTreeContentProvider) {
                IPipelinedTreeContentProvider pipelinedContentProvider = (IPipelinedTreeContentProvider)theOverridingExtensions[i].getContentProvider();
                aSuggestedParent = pipelinedContentProvider.getPipelinedParent(anInputElement, aSuggestedParent);
                NavigatorContentExtension[] overridingExtensions = theOverridingExtensions[i].getOverridingExtensionsForTriggerPoint(anInputElement);
                if (overridingExtensions.length > 0) {
                    aSuggestedParent = this.pipelineParent(anInputElement, overridingExtensions, aSuggestedParent);
                }
            }
            ++i;
        }
        return aSuggestedParent;
    }

    public synchronized boolean hasChildren(Object anElement) {
        Set resultInstances = this.contentService.findContentExtensionsByTriggerPoint(anElement);
        Iterator itr = resultInstances.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension ext = (NavigatorContentExtension)itr.next();
            if (!ext.isLoaded()) {
                return true;
            }
            if (!ext.internalGetContentProvider().hasChildren(anElement)) continue;
            return true;
        }
        return false;
    }

    public synchronized void dispose() {
        if (this.isContentServiceSelfManaged) {
            this.contentService.dispose();
        }
    }

    public synchronized void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
        this.contentService.updateService(aViewer, anOldInput, aNewInput);
    }

    public Object[] getChildren(TreePath parentPath) {
        return this.internalGetChildren(parentPath);
    }

    public boolean hasChildren(TreePath path) {
        Object anElement = this.internalAsElement(path);
        Set resultInstances = this.contentService.findContentExtensionsByTriggerPoint(anElement);
        Iterator itr = resultInstances.iterator();
        while (itr.hasNext()) {
            ITreePathContentProvider tpcp;
            NavigatorContentExtension ext = (NavigatorContentExtension)itr.next();
            if (!ext.isLoaded()) {
                return true;
            }
            ITreeContentProvider cp = ext.internalGetContentProvider();
            if (!(cp instanceof ITreePathContentProvider ? (tpcp = (ITreePathContentProvider)cp).hasChildren(path) : cp.hasChildren(anElement))) continue;
            return true;
        }
        return false;
    }

    public TreePath[] getParents(Object anElement) {
        Set extensions = this.contentService.findContentExtensionsWithPossibleChild(anElement);
        HashSet result = new HashSet();
        Iterator itr = extensions.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension foundExtension = (NavigatorContentExtension)itr.next();
            try {
                ITreeContentProvider tcp;
                if (this.shouldDeferToOverridePath(foundExtension.getDescriptor(), extensions) || !((tcp = foundExtension.internalGetContentProvider()) instanceof ITreePathContentProvider)) continue;
                ITreePathContentProvider tpcp = (ITreePathContentProvider)tcp;
                Object[] parents = tpcp.getParents(anElement);
                Set parentPaths = this.asSet(parents);
                NavigatorContentExtension[] overridingExtensions = foundExtension.getOverridingExtensionsForPossibleChild(anElement);
                if (overridingExtensions.length > 0) {
                    parentPaths = this.pipelineParents(anElement, overridingExtensions, parentPaths);
                }
                result.addAll(parentPaths);
            }
            catch (RuntimeException re) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), re);
            }
            catch (Error e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Could_not_provide_children_for_element, (Object[])new Object[]{foundExtension.getDescriptor().getId()}), e);
            }
        }
        return result.toArray(new TreePath[result.size()]);
    }

    private Set asSet(Object[] objects) {
        HashSet<Object> parentPaths = new HashSet<Object>();
        parentPaths.addAll(Arrays.asList(objects));
        return parentPaths;
    }

    private Set pipelineParents(Object anInputElement, NavigatorContentExtension[] theOverridingExtensions, Set theParentPaths) {
        int i = 0;
        while (i < theOverridingExtensions.length) {
            if (theOverridingExtensions[i].getContentProvider() instanceof IPipelinedTreeContentProvider) {
                NavigatorContentExtension[] overridingExtensions;
                IPipelinedTreeContentProvider pipelinedContentProvider = (IPipelinedTreeContentProvider)theOverridingExtensions[i].getContentProvider();
                Set<Collection> adjustedParentPaths = new HashSet<Collection>();
                if (theParentPaths.isEmpty()) {
                    Object aSuggestedParent = pipelinedContentProvider.getPipelinedParent(anInputElement, null);
                    if (aSuggestedParent != null) {
                        Collection newPaths = this.getPathsForElement(pipelinedContentProvider, aSuggestedParent);
                        adjustedParentPaths.add(newPaths);
                    }
                } else {
                    HashSet<Object> pipedParents = new HashSet<Object>();
                    Iterator iter = theParentPaths.iterator();
                    while (iter.hasNext()) {
                        TreePath parentPath = (TreePath)iter.next();
                        Object parentElement = this.internalAsElement(parentPath);
                        if (pipedParents.contains(parentElement)) continue;
                        pipedParents.add(parentElement);
                        Object aSuggestedParent = pipelinedContentProvider.getPipelinedParent(anInputElement, parentElement);
                        if (aSuggestedParent != parentElement) {
                            Collection newPaths = this.getPathsForElement(pipelinedContentProvider, aSuggestedParent);
                            adjustedParentPaths.add(newPaths);
                            continue;
                        }
                        adjustedParentPaths.add((Collection)parentPath);
                    }
                }
                if ((overridingExtensions = theOverridingExtensions[i].getOverridingExtensionsForTriggerPoint(anInputElement)).length > 0) {
                    adjustedParentPaths = this.pipelineParents(anInputElement, overridingExtensions, adjustedParentPaths);
                }
                theParentPaths = adjustedParentPaths;
            }
            ++i;
        }
        return theParentPaths;
    }

    private Collection getPathsForElement(ITreeContentProvider aContentProvider, Object anElement) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (aContentProvider instanceof ITreePathContentProvider) {
            ITreePathContentProvider tpcp = (ITreePathContentProvider)aContentProvider;
            TreePath[] paths = tpcp.getParents(anElement);
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                result.add(path.createChildPath(anElement));
                ++i;
            }
        } else {
            result.add(TreePath.EMPTY.createChildPath(anElement));
        }
        return result;
    }

    private Object internalAsElement(Object parentElementOrPath) {
        if (parentElementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)parentElementOrPath;
            if (tp.getSegmentCount() > 0) {
                return tp.getLastSegment();
            }
            return this.viewer.getInput();
        }
        return parentElementOrPath;
    }
}

