/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.ILinkHelperExtPtConstants;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperDescriptor;
import org.eclipse.ui.internal.navigator.extensions.RegistryReader;
import org.eclipse.ui.navigator.ILinkHelper;

public class LinkHelperManager {
    private static final ILinkHelper[] NO_LINK_HELPERS = new ILinkHelper[0];
    private static final LinkHelperManager instance = new LinkHelperManager();
    private List descriptors;

    public static LinkHelperManager getInstance() {
        return instance;
    }

    private LinkHelperManager() {
        new LinkHelperRegistry().readRegistry();
    }

    public ILinkHelper[] getLinkHelpersFor(IStructuredSelection aSelection) {
        return NO_LINK_HELPERS;
    }

    public ILinkHelper[] getLinkHelpersFor(IEditorInput input) {
        ArrayList helpersList = new ArrayList();
        ILinkHelper[] helpers = new ILinkHelper[]{};
        if (helpersList.size() > 0) {
            helpers = new ILinkHelper[helpersList.size()];
            helpersList.toArray(helpers);
        }
        return helpers;
    }

    protected List getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new ArrayList();
        }
        return this.descriptors;
    }

    private class LinkHelperRegistry
    extends RegistryReader
    implements ILinkHelperExtPtConstants {
        private LinkHelperRegistry() {
            super(NavigatorPlugin.PLUGIN_ID, "linkHelper");
        }

        public boolean readElement(IConfigurationElement element) {
            if ("linkHelper".equals(element.getName())) {
                LinkHelperManager.this.getDescriptors().add(new LinkHelperDescriptor(element));
                return true;
            }
            return false;
        }
    }
}

