/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ui;

/**
 * Internal images for team ui.
 * 
 * @since 3.0
 */
public interface ITeamUIImages {

	// local toolbars (colour)
	/**
	 * Identifies an incoming change.
	 */
	public final String IMG_DLG_SYNC_INCOMING = "elcl16/incom_synch.gif"; //$NON-NLS-1$
	/**
	 * Identifies an outgoing change.
	 */
	public final String IMG_DLG_SYNC_OUTGOING = "elcl16/outgo_synch.gif"; //$NON-NLS-1$
	/**
	 * Identifies a conflicting change.
	 */
	public final String IMG_DLG_SYNC_CONFLICTING = "elcl16/conflict_synch.gif"; //$NON-NLS-1$
	/**
	 * Identifies a refresh action.
	 */
	public final String IMG_REFRESH = "elcl16/refresh.gif"; //$NON-NLS-1$
	/**
	 * Identifies a refresh with repository action.
	 */
	public final String IMG_REFRESH_REMOTE = "elcl16/refresh_remote.gif"; //$NON-NLS-1$
	/**
	 * Identifies a link with action.
	 */
	public final String IMG_LINK_WITH = "elcl16/synced.gif"; //$NON-NLS-1$
	/**
	 * Identifies an ignore white space action.
	 */
	public final String IMG_IGNORE_WHITESPACE = "elcl16/ignorews_edit.gif"; //$NON-NLS-1$
	/**
	 * Identifies a collapse all action.
	 */
	public final String IMG_COLLAPSE_ALL = "elcl16/collapseall.gif"; //$NON-NLS-1$
	/**
	 * Identifies the incoming mode for synchronizing.
	 */
	public final String IMG_SYNC_MODE_CATCHUP = "elcl16/catchup_rls.gif"; //$NON-NLS-1$
	/**
	 * Identifies the outgoing mode for synchronizing.
	 */
	public final String IMG_SYNC_MODE_RELEASE = "elcl16/release_rls.gif"; //$NON-NLS-1$
	/**
	 * Identifies the both mode for synchronizing.
	 */
	public final String IMG_SYNC_MODE_FREE = "elcl16/catchuprelease_rls.gif"; //$NON-NLS-1$
	/**
	 * Identifies an incoming change.
	 */
	public final String IMG_DLG_SYNC_INCOMING_DISABLED = "dlcl16/incom_synch.gif"; //$NON-NLS-1$
	/**
	 * Identifies an outgoing change.
	 */
	public final String IMG_DLG_SYNC_OUTGOING_DISABLED = "dlcl16/outgo_synch.gif"; //$NON-NLS-1$
	/**
	 * Identifies a conflicting change.
	 */
	public final String IMG_DLG_SYNC_CONFLICTING_DISABLED = "dlcl16/conflict_synch.gif"; //$NON-NLS-1$
	/**
	 * Identifies a refresh action.
	 */
	public final String IMG_REFRESH_DISABLED = "dlcl16/refresh.gif"; //$NON-NLS-1$
	/**
	 * Identifies a refresh with repository action.
	 */
	public final String IMG_REFRESH_REMOTE_DISABLED = "dlcl16/refresh_remote.gif"; //$NON-NLS-1$
	/**
	 * Identifies a link with action.
	 */
	public final String IMG_LINK_WITH_DISABLED = "dlcl16/synced.gif"; //$NON-NLS-1$
	/**
	 * Identifies an ignore white space action.
	 */
	public final String IMG_IGNORE_WHITESPACE_DISABLED = "dlcl16/ignorews_edit.gif"; //$NON-NLS-1$
	/**
	 * Identifies a collapse all action.
	 */
	public final String IMG_COLLAPSE_ALL_DISABLED = "dlcl16/collapseall.gif"; //$NON-NLS-1$
	/**
	 * Identifies the incoming mode for synchronizing.
	 */
	public final String IMG_SYNC_MODE_CATCHUP_DISABLED = "dlcl16/catchup_rls.gif"; //$NON-NLS-1$
	/**
	 * Identifies the outgoing mode for synchronizing.
	 */
	public final String IMG_SYNC_MODE_RELEASE_DISABLED = "dlcl16/release_rls.gif"; //$NON-NLS-1$
	/**
	 * Identifies the both mode for synchronizing.
	 */
	public final String IMG_SYNC_MODE_FREE_DISABLED = "dlcl16/catchuprelease_rls.gif"; //$NON-NLS-1$
	/**
	 * Identifies an incoming change.
	 */
	public final String IMG_DLG_SYNC_INCOMING_ENABLED = "elcl16/incom_synch.gif"; //$NON-NLS-1$
	/**
	 * Identifies an outgoing change.
	 */
	public final String IMG_DLG_SYNC_OUTGOING_ENABLED = "elcl16/outgo_synch.gif"; //$NON-NLS-1$
	/**
	 * Identifies a conflicting change.
	 */
	public final String IMG_DLG_SYNC_CONFLICTING_ENABLED = "elcl16/conflict_synch.gif"; //$NON-NLS-1$
	/**
	 * Identifies a refresh action.
	 */
	public final String IMG_REFRESH_ENABLED = "elcl16/refresh.gif"; //$NON-NLS-1$
	/**
	 * Identifies a refresh with repository action.
	 */
	public final String IMG_REFRESH_REMOTE_ENABLED = "elcl16/refresh_remote.gif"; //$NON-NLS-1$
	/**
	 * Identifies a link with action.
	 */
	public final String IMG_LINK_WITH_ENABLED = "elcl16/synced.gif"; //$NON-NLS-1$
	/**
	 * Identifies an ignore white space action.
	 */
	public final String IMG_IGNORE_WHITESPACE_ENABLED = "elcl16/ignorews_edit.gif"; //$NON-NLS-1$
	/**
	 * Identifies a collapse all action.
	 */
	public final String IMG_COLLAPSE_ALL_ENABLED = "elcl16/collapseall.gif"; //$NON-NLS-1$
	/**
	 * Identifies the incoming mode for synchronizing.
	 */
	public final String IMG_SYNC_MODE_CATCHUP_ENABLED = "elcl16/catchup_rls.gif"; //$NON-NLS-1$
	/**
	 * Identifies the outgoing mode for synchronizing.
	 */
	public final String IMG_SYNC_MODE_RELEASE_ENABLED = "elcl16/release_rls.gif"; //$NON-NLS-1$
	/**
	 * Identifies the both mode for synchronizing.
	 */
	public final String IMG_SYNC_MODE_FREE_ENABLED = "elcl16/catchuprelease_rls.gif"; //$NON-NLS-1$
	/**
	 * Share projects banner.
	 */
	public final String IMG_WIZBAN_SHARE = "wizban/share_wizban.png"; //$NON-NLS-1$
	/**
	 * Import project set banner.
	 */
	public final String IMG_PROJECTSET_IMPORT_BANNER = "wizban/import_projectset_wizban.png"; //$NON-NLS-1$
	/**
	 * Export project set banner.
	 */
	public final String IMG_PROJECTSET_EXPORT_BANNER = "wizban/export_projectset_wizban.png"; //$NON-NLS-1$
	/**
	 * Icon for authentication dialogs.
	 */
	public final String IMG_KEY_LOCK = "wizban/keylock.gif"; //$NON-NLS-1$
	/**
	 * Pinned icon
	 */
	public final String IMG_PINNED = "elcl16/pin.gif";  //$NON-NLS-1$
	/**
	 * Previous history 
	 */
	public final String IMG_PREVIOUS = "elcl16/prev_nav.gif"; //$NON-NLS-1$
	
	//objects
	public final String IMG_SITE_ELEMENT = "elcl16/site_element.gif"; //$NON-NLS-1$
	public final String IMG_CHANGE_FILTER = "elcl16/change_filter.gif"; //$NON-NLS-1$	 
	public final String IMG_COMPRESSED_FOLDER = "obj/compressed_folder_obj.gif"; //$NON-NLS-1$
	public final String IMG_HIERARCHICAL = "elcl16/hierarchicalLayout.gif"; //$NON-NLS-1$
	public final String IMG_FLAT = "elcl16/flatLayout.gif"; //$NON-NLS-1$
	public final String IMG_SYNC_VIEW = "eview16/synch_synch.gif"; //$NON-NLS-1$
	public final String IMG_CHANGE_SET = "obj/changeset_obj.gif"; //$NON-NLS-1$


}
