/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.eval;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Scalar;
import org.eclipse.test.internal.performance.eval.StatisticsUtil;

public class StatisticsSession {
    private final DataPoint[] fDataPoints;
    private final Map fStatistics = new HashMap();

    public StatisticsSession(DataPoint[] datapoints) {
        this.fDataPoints = datapoints;
    }

    public double getAverage(Dim dimension) {
        return this.getStats((Dim)dimension).average;
    }

    public long getSum(Dim dimension) {
        return this.getStats((Dim)dimension).sum;
    }

    public long getCount(Dim dimension) {
        return this.getStats((Dim)dimension).count;
    }

    public double getStddev(Dim dimension) {
        return this.getStats((Dim)dimension).stddev;
    }

    double getStderr_mean(Dim dimension) {
        return this.getStats((Dim)dimension).stddev / Math.sqrt(this.getStats((Dim)dimension).count);
    }

    double getStudentsT(Dim dimension, StatisticsUtil.Percentile percentile) {
        int df = (int)this.getStats((Dim)dimension).count - 1;
        return StatisticsUtil.getStudentsT(df, percentile);
    }

    public double[] getConfidenceInterval(Dim dimension, StatisticsUtil.Percentile percentile) {
        double mean = this.getAverage(dimension);
        double stat_err = this.getStderr_mean(dimension);
        double t = this.getStudentsT(dimension, percentile);
        double[] interval = new double[]{mean - t * stat_err, mean + t * stat_err};
        return interval;
    }

    private Statistics getStats(Dim dimension) {
        Statistics stats = (Statistics)this.fStatistics.get(dimension);
        if (stats == null) {
            stats = this.computeStats(dimension);
            this.fStatistics.put(dimension, stats);
        }
        return stats;
    }

    private Statistics computeStats(Dim dimension) {
        Statistics stats;
        HashSet<Integer> steps = new HashSet<Integer>();
        int j = 0;
        while (j < this.fDataPoints.length) {
            DataPoint dp = this.fDataPoints[j];
            steps.add(new Integer(dp.getStep()));
            ++j;
        }
        if (steps.contains(new Integer(-3))) {
            stats = this.computeStatsFromAggregates(dimension);
        } else if (steps.contains(new Integer(1))) {
            stats = this.computeStatsFromMeasurements(dimension, steps);
        } else {
            Assert.fail((String)"illegal data set: contains neither AVERAGE nor AFTER values.");
            stats = null;
        }
        return stats;
    }

    private Statistics computeStatsFromAggregates(Dim dimension) {
        Statistics stats = new Statistics();
        long aggregateCount = 0L;
        double averageSum = 0.0;
        long countSum = 0L;
        double stdevSum = 0.0;
        int i = 0;
        while (i < this.fDataPoints.length) {
            DataPoint point = this.fDataPoints[i];
            Scalar scalar = point.getScalar(dimension);
            if (scalar != null) {
                Integer aggregate = new Integer(point.getStep());
                long magnitude = scalar.getMagnitude();
                switch (aggregate) {
                    case -3: {
                        averageSum += (double)magnitude;
                        ++aggregateCount;
                        break;
                    }
                    case -5: {
                        stdevSum += Double.longBitsToDouble(magnitude);
                        break;
                    }
                    case -4: {
                        countSum += magnitude;
                        break;
                    }
                    default: {
                        Assert.fail((String)"only average, stdev and size are supported in aggregate mode");
                    }
                }
            }
            ++i;
        }
        stats.average = averageSum / (double)aggregateCount;
        stats.stddev = stdevSum / (double)aggregateCount;
        stats.count = countSum;
        stats.sum = Math.round((double)stats.count * stats.average);
        return stats;
    }

    private Statistics computeStatsFromMeasurements(Dim dimension, Set steps) {
        int i;
        long[] mags;
        Statistics stats = new Statistics();
        switch (steps.size()) {
            case 1: {
                mags = new long[this.fDataPoints.length];
                i = 0;
                while (i < this.fDataPoints.length) {
                    Scalar sc = this.fDataPoints[i].getScalar(dimension);
                    mags[i] = sc == null ? 0L : sc.getMagnitude();
                    ++i;
                }
                break;
            }
            case 2: {
                int count = this.fDataPoints.length / 2;
                mags = new long[count];
                int i2 = 0;
                while (i2 < count) {
                    long magnitude;
                    DataPoint before = this.fDataPoints[2 * i2];
                    Assert.assertTrue((String)"wrong order of steps", (before.getStep() == 0 ? 1 : 0) != 0);
                    DataPoint after = this.fDataPoints[2 * i2 + 1];
                    Assert.assertTrue((String)"wrong order of steps", (after.getStep() == 1 ? 1 : 0) != 0);
                    Scalar delta = this.getDelta(before, after, dimension);
                    mags[i2] = magnitude = delta.getMagnitude();
                    ++i2;
                }
                break;
            }
            default: {
                Assert.fail((String)"cannot handle more than two steps in measurement mode");
                return null;
            }
        }
        i = 0;
        while (i < mags.length) {
            stats.sum += mags[i];
            ++stats.count;
            ++i;
        }
        if (stats.count > 0L) {
            stats.average = (double)stats.sum / (double)stats.count;
            double squaredDeviations = 0.0;
            int i3 = 0;
            while (i3 < mags.length) {
                double deviation = stats.average - (double)mags[i3];
                squaredDeviations += deviation * deviation;
                ++i3;
            }
            stats.stddev = Math.sqrt(squaredDeviations / (double)stats.count - 1.0);
        } else {
            stats.average = 0.0;
            stats.stddev = 0.0;
        }
        return stats;
    }

    private Scalar getDelta(DataPoint before, DataPoint after, Dim dimension) {
        Scalar one = before.getScalar(dimension);
        Assert.assertTrue((String)("reference has no value for dimension " + dimension), (one != null ? 1 : 0) != 0);
        Scalar two = after.getScalar(dimension);
        Assert.assertTrue((String)("reference has no value for dimension " + dimension), (two != null ? 1 : 0) != 0);
        return new Scalar(one.getDimension(), two.getMagnitude() - one.getMagnitude());
    }

    public boolean contains(Dim dimension) {
        if (this.fDataPoints.length > 0) {
            return this.fDataPoints[0].contains(dimension);
        }
        return false;
    }

    static final class Statistics {
        public long count;
        public long sum;
        public double average;
        public double stddev;

        Statistics() {
        }
    }
}

