/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.test.EclipseTestRunner;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;

public class UITestApplication
implements IPlatformRunnable,
ITestHarness {
    private static final String DEFAULT_APP_3_0 = "org.eclipse.ui.ide.workbench";
    private static final String DEFAULT_APP_PRE_3_0 = "org.eclipse.ui.workbench";
    private boolean fInDeprecatedMode = false;
    private TestableObject fTestableObject;
    private int fTestRunnerResult = -1;

    public Object run(Object args) throws Exception {
        IPlatformRunnable application = this.getApplication((String[])args);
        Assert.assertNotNull((Object)application);
        Object result = this.fInDeprecatedMode ? this.runDeprecatedApplication(application, args) : this.runApplication(application, args);
        if (!IPlatformRunnable.EXIT_OK.equals(result)) {
            System.err.println("UITestRunner: Unexpected result from running application " + application + ": " + result);
        }
        return new Integer(this.fTestRunnerResult);
    }

    private IPlatformRunnable getApplication(String[] args) throws CoreException {
        Object runnable;
        IConfigurationElement[] runs;
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", this.getApplicationToRun(args));
        if (extension == null) {
            extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", DEFAULT_APP_PRE_3_0);
            this.fInDeprecatedMode = true;
        }
        Assert.assertNotNull((Object)extension);
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0 && (runnable = runs[0].createExecutableExtension("class")) instanceof IPlatformRunnable) {
            return (IPlatformRunnable)runnable;
        }
        return null;
    }

    private String getApplicationToRun(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-testApplication") && i < args.length - 1) {
                return args[i + 1];
            }
            ++i;
        }
        return DEFAULT_APP_3_0;
    }

    private Object runApplication(IPlatformRunnable application, Object args) throws Exception {
        this.fTestableObject = PlatformUI.getTestableObject();
        this.fTestableObject.setTestHarness((ITestHarness)this);
        return application.run(args);
    }

    private Object runDeprecatedApplication(IPlatformRunnable object, final Object args) throws Exception {
        Assert.assertTrue((boolean)(object instanceof IWorkbench));
        final IWorkbench workbench = (IWorkbench)object;
        final boolean[] started = new boolean[1];
        workbench.addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow w) {
                if (started[0]) {
                    return;
                }
                w.getShell().getDisplay().asyncExec(new Runnable(this, started, args, workbench){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ boolean[] val$started;
                    private final /* synthetic */ Object val$args;
                    private final /* synthetic */ IWorkbench val$workbench;
                    {
                        this.this$1 = var1_1;
                        this.val$started = blArray;
                        this.val$args = object;
                        this.val$workbench = iWorkbench;
                    }

                    public void run() {
                        this.val$started[0] = true;
                        try {
                            UITestApplication.access$0(1.access$0(this.this$1), EclipseTestRunner.run((String[])this.val$args));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        this.val$workbench.close();
                    }
                });
            }

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            static /* synthetic */ UITestApplication access$0(1 var0) {
                return var0.UITestApplication.this;
            }
        });
        return ((IPlatformRunnable)workbench).run(args);
    }

    public void runTests() {
        this.fTestableObject.testingStarting();
        this.fTestableObject.runTest(new Runnable(){

            public void run() {
                try {
                    UITestApplication.this.fTestRunnerResult = EclipseTestRunner.run(Platform.getCommandLineArgs());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.fTestableObject.testingFinished();
    }
}

