/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class EPackageRegistryImpl
extends HashMap
implements EPackage.Registry {
    protected EPackage.Registry delegateRegistry;
    protected static Map classLoaderToRegistryMap = new WeakHashMap();

    public static EPackage.Registry createGlobalRegistry() {
        try {
            String className = System.getProperty("org.eclipse.emf.ecore.EPackage.Registry.INSTANCE");
            if (className == null) {
                if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
                    return new Delegator();
                }
                return new EPackageRegistryImpl();
            }
            return (EPackage.Registry)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
            return new EPackageRegistryImpl();
        }
    }

    public EPackageRegistryImpl() {
    }

    public EPackageRegistryImpl(EPackage.Registry delegateRegistry) {
        this.delegateRegistry = delegateRegistry;
    }

    public EPackage getEPackage(String nsURI) {
        Object ePackage = this.get(nsURI);
        if (ePackage instanceof EPackage) {
            EPackage result = (EPackage)ePackage;
            if (result.getNsURI() == null) {
                this.initialize(result);
            }
            return result;
        }
        if (ePackage instanceof EPackage.Descriptor) {
            EPackage.Descriptor ePackageDescriptor = (EPackage.Descriptor)ePackage;
            EPackage result = ePackageDescriptor.getEPackage();
            if (result != null) {
                this.put(nsURI, result);
                this.initialize(result);
            }
            return result;
        }
        return this.delegatedGetEPackage(nsURI);
    }

    protected void initialize(EPackage ePackage) {
    }

    protected EPackage delegatedGetEPackage(String nsURI) {
        if (this.delegateRegistry != null) {
            return this.delegateRegistry.getEPackage(nsURI);
        }
        return null;
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.delegateRegistry != null && this.delegateRegistry.containsKey(key);
    }

    public static synchronized EPackage.Registry getRegistry(ClassLoader classLoader) {
        EPackage.Registry result = (EPackage.Registry)classLoaderToRegistryMap.get(classLoader);
        if (result == null) {
            if (classLoader == null) {
                result = null;
            } else {
                result = new EPackageRegistryImpl(EPackageRegistryImpl.getRegistry(classLoader.getParent()));
                classLoaderToRegistryMap.put(classLoader, result);
            }
        }
        return result;
    }

    public static class Delegator
    implements EPackage.Registry {
        static /* synthetic */ Class class$0;

        protected EPackage.Registry delegateRegistry(ClassLoader classLoader) {
            return EPackageRegistryImpl.getRegistry(classLoader);
        }

        protected EPackage.Registry delegateRegistry() {
            return this.delegateRegistry(Thread.currentThread().getContextClassLoader());
        }

        public EPackage getEPackage(String key) {
            return this.delegateRegistry().getEPackage(key);
        }

        public int size() {
            return this.delegateRegistry().size();
        }

        public boolean isEmpty() {
            return this.delegateRegistry().isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.delegateRegistry().containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.delegateRegistry().containsValue(value);
        }

        public Object get(Object key) {
            return this.delegateRegistry().get(key);
        }

        public Object put(Object key, Object value) {
            Class<?> valueClass = value.getClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.impl.EPackageImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (valueClass == clazz) {
                return this.delegateRegistry().put(key, value);
            }
            String valueClassName = valueClass.getName();
            ClassLoader result = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = result.getParent();
            while (classLoader != null) {
                try {
                    Class<?> loadedClass = classLoader.loadClass(valueClassName);
                    if (loadedClass != valueClass) break;
                    result = classLoader;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    break;
                }
                classLoader = classLoader.getParent();
            }
            return this.delegateRegistry(result).put(key, value);
        }

        public Object remove(Object key) {
            return this.delegateRegistry().remove(key);
        }

        public void putAll(Map map) {
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public void clear() {
            this.delegateRegistry().clear();
        }

        public Set keySet() {
            return this.delegateRegistry().keySet();
        }

        public Collection values() {
            return this.delegateRegistry().values();
        }

        public Set entrySet() {
            return this.delegateRegistry().entrySet();
        }
    }
}

