/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.io.PrintStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class EcoreUtil {
    protected static final String GEN_MODEL_PACKAGE_NS_URI = "http://www.eclipse.org/emf/2002/GenModel";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public static Adapter getExistingAdapter(Notifier notifier, Object type) {
        return EcoreUtil.getAdapter((List)notifier.eAdapters(), type);
    }

    public static Adapter getRegisteredAdapter(EObject eObject, Object type) {
        AdapterFactory factory;
        ResourceSet resourceSet;
        Resource resource;
        Adapter result = EcoreUtil.getExistingAdapter(eObject, type);
        if (result == null && (resource = eObject.eResource()) != null && (resourceSet = resource.getResourceSet()) != null && (factory = EcoreUtil.getAdapterFactory((List)resourceSet.getAdapterFactories(), type)) != null) {
            result = factory.adaptNew((Notifier)eObject, type);
        }
        return result;
    }

    public static Adapter getRegisteredAdapter(Resource resource, Object type) {
        AdapterFactory factory;
        ResourceSet resourceSet;
        Adapter result = EcoreUtil.getExistingAdapter(resource, type);
        if (result == null && (resourceSet = resource.getResourceSet()) != null && (factory = EcoreUtil.getAdapterFactory((List)resourceSet.getAdapterFactories(), type)) != null) {
            result = factory.adaptNew((Notifier)resource, type);
        }
        return result;
    }

    public static Adapter getAdapter(List adapters, Object type) {
        int i = 0;
        int size = adapters.size();
        while (i < size) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (adapter.isAdapterForType(type)) {
                return adapter;
            }
            ++i;
        }
        return null;
    }

    public static AdapterFactory getAdapterFactory(List adapterFactories, Object type) {
        Iterator iter = adapterFactories.iterator();
        while (iter.hasNext()) {
            AdapterFactory factory = (AdapterFactory)iter.next();
            if (!factory.isFactoryForType(type)) continue;
            return factory;
        }
        return null;
    }

    public static EObject resolve(EObject proxy, ResourceSet resourceSet) {
        URI proxyURI = ((InternalEObject)proxy).eProxyURI();
        if (proxyURI != null) {
            try {
                EObject resolvedObject = null;
                if (resourceSet != null) {
                    resolvedObject = resourceSet.getEObject(proxyURI, true);
                } else {
                    Resource resource;
                    EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(proxyURI.trimFragment().toString());
                    if (ePackage != null && (resource = ePackage.eResource()) != null) {
                        resolvedObject = resource.getEObject(proxyURI.fragment().toString());
                    }
                }
                if (resolvedObject != null && resolvedObject != proxy) {
                    return EcoreUtil.resolve(resolvedObject, resourceSet);
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        return proxy;
    }

    public static EObject resolve(EObject proxy, Resource resourceContext) {
        return EcoreUtil.resolve(proxy, resourceContext != null ? resourceContext.getResourceSet() : null);
    }

    public static EObject resolve(EObject proxy, EObject objectContext) {
        Resource resourceContext = objectContext != null ? objectContext.eResource() : null;
        return EcoreUtil.resolve(proxy, resourceContext != null ? resourceContext.getResourceSet() : null);
    }

    public static Object getObjectByType(Collection objects, EClassifier type) {
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (!type.isInstance(object)) continue;
            return object;
        }
        return null;
    }

    public static Collection getObjectsByType(Collection objects, EClassifier type) {
        ArrayList result = new ArrayList();
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (!type.isInstance(object)) continue;
            result.add(object);
        }
        return result;
    }

    public static EObject copy(EObject eObject) {
        Copier copier = new Copier();
        EObject result = copier.copy(eObject);
        copier.copyReferences();
        return result;
    }

    public static Collection copyAll(Collection eObjects) {
        Copier copier = new Copier();
        Collection result = copier.copyAll(eObjects);
        copier.copyReferences();
        return result;
    }

    public static EObject getRootContainer(EObject eObject) {
        EObject result = eObject;
        EObject parent = eObject;
        while (parent != null) {
            result = parent;
            parent = parent.eContainer();
        }
        return result;
    }

    public static boolean isAncestor(EObject ancestorEObject, EObject eObject) {
        while (eObject != null) {
            if (eObject == ancestorEObject) {
                return true;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    public static boolean isAncestor(Resource ancestorResource, EObject eObject) {
        return eObject.eResource() == ancestorResource;
    }

    public static boolean isAncestor(ResourceSet ancestorResourceSet, EObject eObject) {
        Resource resource = eObject.eResource();
        return resource != null && resource.getResourceSet() == ancestorResourceSet;
    }

    public static boolean isAncestor(Collection ancestorEMFObjects, EObject eObject) {
        if (ancestorEMFObjects.contains(eObject)) {
            return true;
        }
        EObject container = eObject.eContainer();
        while (container != null) {
            if (ancestorEMFObjects.contains(container)) {
                return true;
            }
            eObject = container;
            container = container.eContainer();
        }
        Resource resource = eObject.eResource();
        if (resource != null) {
            if (ancestorEMFObjects.contains(resource)) {
                return true;
            }
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null && ancestorEMFObjects.contains(resourceSet)) {
                return true;
            }
        }
        return false;
    }

    public static TreeIterator getAllContents(Collection emfObjects) {
        return new ContentTreeIterator(emfObjects);
    }

    public static String getIdentification(EObject eObject) {
        StringBuffer result = new StringBuffer(eObject.getClass().getName());
        EClass eClass = eObject.eClass();
        if (eClass.getInstanceClassName() == null) {
            result.append('/');
            result.append(eClass.getEPackage().getNsURI());
            result.append('#');
            result.append(eClass.getName());
        }
        result.append('@');
        result.append(Integer.toHexString(eObject.hashCode()));
        result.append('{');
        result.append(EcoreUtil.getURI(eObject));
        result.append('}');
        return result.toString();
    }

    public static URI getURI(EObject eObject) {
        URI proxyURI = ((InternalEObject)eObject).eProxyURI();
        if (proxyURI != null) {
            return proxyURI;
        }
        EObject eRootContainer = EcoreUtil.getRootContainer(eObject);
        Resource resource = eRootContainer.eResource();
        if (resource != null) {
            return resource.getURI().appendFragment(resource.getURIFragment(eObject));
        }
        StringBuffer result = new StringBuffer("#//");
        ArrayList<String> uriFragmentPath = new ArrayList<String>();
        EObject container = eObject.eContainer();
        while (container != null) {
            uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment(eObject.eContainmentFeature(), eObject));
            eObject = container;
            container = eObject.eContainer();
        }
        int size = uriFragmentPath.size();
        if (size > 0) {
            int i = size - 1;
            while (true) {
                result.append((String)uriFragmentPath.get(i));
                if (i == 0) break;
                result.append('/');
                --i;
            }
        }
        return URI.createURI((String)result.toString());
    }

    public static int indexOf(List list, Object o, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int size = list.size();
        int i = fromIndex;
        while (i < size) {
            Object element = list.get(i);
            if (o == null ? element == null : o == element || o.equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void setEList(EList eList, Collection prototypeCollection) {
        EcoreUtil.setEList(eList, new ArrayList(prototypeCollection));
    }

    public static void setEList(EList eList, List prototypeList) {
        int index = 0;
        Iterator objects = prototypeList.iterator();
        while (objects.hasNext()) {
            Object prototypeObject = objects.next();
            if (eList.size() <= index) {
                eList.add(prototypeObject);
            } else {
                boolean done;
                do {
                    done = true;
                    Object targetObject = eList.get(index);
                    if (!(targetObject == null ? prototypeObject != null : !targetObject.equals(prototypeObject))) continue;
                    int position = EcoreUtil.indexOf((List)eList, prototypeObject, index);
                    if (position != -1) {
                        int targetIndex = EcoreUtil.indexOf(prototypeList, targetObject, index);
                        if (targetIndex == -1) {
                            eList.remove(index);
                            done = false;
                            continue;
                        }
                        if (targetIndex > position) {
                            if (eList.size() <= targetIndex) {
                                targetIndex = eList.size() - 1;
                            }
                            eList.move(targetIndex, index);
                            done = false;
                            continue;
                        }
                        eList.move(index, position);
                        continue;
                    }
                    eList.add(index, prototypeObject);
                } while (!done);
            }
            ++index;
        }
        int i = eList.size();
        while (i > index) {
            eList.remove(--i);
        }
    }

    public static void remove(EStructuralFeature.Setting setting, Object value) {
        if (setting.getEStructuralFeature().isMany()) {
            ((List)setting.get(false)).remove(value);
        } else {
            setting.unset();
        }
    }

    public static void replace(EStructuralFeature.Setting setting, Object oldValue, Object newValue) {
        if (setting.getEStructuralFeature().isMany()) {
            List list = (List)setting.get(false);
            list.set(list.indexOf(oldValue), newValue);
        } else {
            setting.set(newValue);
        }
    }

    public static void remove(EObject eObject, EStructuralFeature eStructuralFeature, Object value) {
        if (eStructuralFeature.isMany()) {
            ((List)eObject.eGet(eStructuralFeature)).remove(value);
        } else {
            eObject.eUnset(eStructuralFeature);
        }
    }

    public static void replace(EObject eObject, EStructuralFeature eStructuralFeature, Object oldValue, Object newValue) {
        if (eStructuralFeature.isMany()) {
            List list = (List)eObject.eGet(eStructuralFeature);
            list.set(list.indexOf(oldValue), newValue);
        } else {
            eObject.eSet(eStructuralFeature, newValue);
        }
    }

    public static void remove(EObject eObject) {
        EObject container = eObject.eContainer();
        if (container != null) {
            EReference feature = eObject.eContainmentFeature();
            if (feature.isMany()) {
                ((EList)container.eGet(feature)).remove((Object)eObject);
            } else {
                container.eUnset(feature);
            }
        } else {
            Resource resource = eObject.eResource();
            if (resource != null) {
                resource.getContents().remove((Object)eObject);
            }
        }
    }

    public static void replace(EObject eObject, EObject replacementEObject) {
        EObject container = eObject.eContainer();
        if (container != null) {
            EReference feature = eObject.eContainmentFeature();
            if (feature.isMany()) {
                List list = (List)container.eGet(feature);
                list.set(list.indexOf(eObject), replacementEObject);
            } else {
                container.eSet(feature, replacementEObject);
            }
        } else {
            Resource resource = eObject.eResource();
            if (resource != null) {
                EList list = resource.getContents();
                list.set(list.indexOf(eObject), replacementEObject);
            }
        }
    }

    public static EObject create(EClass eClass) {
        return eClass.getEPackage().getEFactoryInstance().create(eClass);
    }

    public static Object createFromString(EDataType eDataType, String literal) {
        return eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, literal);
    }

    public static String convertToString(EDataType eDataType, Object value) {
        return eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, value);
    }

    public static String getID(EObject eObject) {
        EClass eClass = eObject.eClass();
        EAttribute eIDAttribute = eClass.getEIDAttribute();
        return eIDAttribute == null || !eObject.eIsSet(eIDAttribute) ? null : EcoreUtil.convertToString(eIDAttribute.getEAttributeType(), eObject.eGet(eIDAttribute));
    }

    public static void setID(EObject eObject, String id) {
        EClass eClass = eObject.eClass();
        EAttribute eIDAttribute = eClass.getEIDAttribute();
        if (eIDAttribute == null) {
            throw new IllegalArgumentException("The object doesn't have an ID feature.");
        }
        if (id == null) {
            eObject.eUnset(eIDAttribute);
        } else {
            eObject.eSet(eIDAttribute, EcoreUtil.createFromString(eIDAttribute.getEAttributeType(), id));
        }
    }

    public static Class wrapperClassFor(Class javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (javaClass.isPrimitive()) {
            if (javaClass == Boolean.TYPE) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (javaClass == Integer.TYPE) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (javaClass == Float.TYPE) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (javaClass == Double.TYPE) {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (javaClass == Long.TYPE) {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (javaClass == Short.TYPE) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (javaClass == Byte.TYPE) {
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = class$6 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("java.lang.Character");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        return javaClass;
    }

    public static String getDocumentation(EModelElement eModelElement) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(GEN_MODEL_PACKAGE_NS_URI);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get((Object)"documentation");
    }

    public static void setDocumentation(EModelElement eModelElement, String documentation) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(GEN_MODEL_PACKAGE_NS_URI);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(GEN_MODEL_PACKAGE_NS_URI);
            eModelElement.getEAnnotations().add((Object)eAnnotation);
        }
        eAnnotation.getDetails().put((Object)"documentation", (Object)documentation);
    }

    public static List getConstraints(EModelElement eModelElement) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (eAnnotation == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer((String)eAnnotation.getDetails().get((Object)"constraints"));
        while (stringTokenizer.hasMoreTokens()) {
            String constraint = stringTokenizer.nextToken();
            result.add(constraint);
        }
        return result;
    }

    public static void setConstraints(EModelElement eModelElement, List constraints) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (constraints == null || constraints.isEmpty()) {
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)"constraints");
            }
        } else {
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
                eModelElement.getEAnnotations().add((Object)eAnnotation);
            }
            StringBuffer value = new StringBuffer();
            Iterator i = constraints.iterator();
            while (i.hasNext()) {
                value.append(i.next());
                if (!i.hasNext()) continue;
                value.append(' ');
            }
            eAnnotation.getDetails().put((Object)"constraints", (Object)value.toString());
        }
    }

    public static String getAnnotation(EModelElement eModelElement, String sourceURI, String key) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(sourceURI);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get((Object)key);
    }

    public static void setAnnotation(EModelElement eModelElement, String sourceURI, String key, String value) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(sourceURI);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(sourceURI);
            eModelElement.getEAnnotations().add((Object)eAnnotation);
        }
        eAnnotation.getDetails().put((Object)key, (Object)value);
    }

    public static String generateUUID() {
        return UUID.generate();
    }

    public static void freeze(EPackage ePackage) {
        try {
            ((EPackageImpl)ePackage).freeze();
        }
        catch (ClassCastException classCastException) {}
    }

    public static class Copier
    extends HashMap {
        public Collection copyAll(Collection eObjects) {
            ArrayList<EObject> result = new ArrayList<EObject>(eObjects.size());
            Iterator i = eObjects.iterator();
            while (i.hasNext()) {
                result.add(this.copy((EObject)i.next()));
            }
            return result;
        }

        public EObject copy(EObject eObject) {
            EObject copyEObject = this.createCopy(eObject);
            this.put(eObject, copyEObject);
            Iterator i = eObject.eClass().getEAllStructuralFeatures().iterator();
            while (i.hasNext()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)i.next();
                if (!eStructuralFeature.isChangeable() || eStructuralFeature.isDerived()) continue;
                if (eStructuralFeature instanceof EAttribute) {
                    this.copyAttribute((EAttribute)eStructuralFeature, eObject, copyEObject);
                    continue;
                }
                EReference eReference = (EReference)eStructuralFeature;
                if (!eReference.isContainment()) continue;
                this.copyContainment(eReference, eObject, copyEObject);
            }
            return copyEObject;
        }

        protected EObject createCopy(EObject eObject) {
            return EcoreUtil.create(this.getTarget(eObject.eClass()));
        }

        protected EClass getTarget(EClass eClass) {
            return eClass;
        }

        protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
            return eStructuralFeature;
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet(eReference)) {
                if (eReference.isMany()) {
                    ((List)copyEObject.eGet(this.getTarget(eReference))).addAll(this.copyAll((List)eObject.eGet(eReference)));
                } else {
                    EObject childEObject = (EObject)eObject.eGet(eReference);
                    copyEObject.eSet(this.getTarget(eReference), childEObject == null ? null : this.copy(childEObject));
                }
            }
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet(eAttribute)) {
                if (FeatureMapUtil.isFeatureMap(eAttribute)) {
                    FeatureMap featureMap = (FeatureMap)eObject.eGet(eAttribute);
                    Iterator i = featureMap.iterator();
                    while (i.hasNext()) {
                        Object value;
                        FeatureMap.Entry entry = (FeatureMap.Entry)i.next();
                        EStructuralFeature feature = entry.getEStructuralFeature();
                        if (!(feature instanceof EReference) || !((EReference)feature).isContainment() || (value = entry.getValue()) == null) continue;
                        this.copy((EObject)value);
                    }
                } else if (eAttribute.isMany()) {
                    ((List)copyEObject.eGet(this.getTarget(eAttribute))).addAll((List)eObject.eGet(eAttribute));
                } else {
                    copyEObject.eSet(this.getTarget(eAttribute), eObject.eGet(eAttribute));
                }
            }
        }

        public void copyReferences() {
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                EObject eObject = (EObject)entry.getKey();
                EObject copyEObject = (EObject)entry.getValue();
                EClass eClass = eObject.eClass();
                Iterator j = eClass.getEAllStructuralFeatures().iterator();
                while (j.hasNext()) {
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)j.next();
                    if (!eStructuralFeature.isChangeable() || eStructuralFeature.isDerived()) continue;
                    if (eStructuralFeature instanceof EReference) {
                        EReference eReference = (EReference)eStructuralFeature;
                        if (eReference.isContainment()) continue;
                        this.copyReference(eReference, eObject, copyEObject);
                        continue;
                    }
                    if (!FeatureMapUtil.isFeatureMap(eStructuralFeature)) continue;
                    FeatureMap featureMap = (FeatureMap)eObject.eGet(eStructuralFeature);
                    FeatureMap copyFeatureMap = (FeatureMap)copyEObject.eGet(this.getTarget(eStructuralFeature));
                    Iterator k = featureMap.iterator();
                    while (k.hasNext()) {
                        FeatureMap.Entry featureMapEntry = (FeatureMap.Entry)k.next();
                        EStructuralFeature feature = featureMapEntry.getEStructuralFeature();
                        if (feature instanceof EReference) {
                            Object referencedEObject = featureMapEntry.getValue();
                            Object copyReferencedEObject = this.get(referencedEObject);
                            copyFeatureMap.add(feature, copyReferencedEObject == null ? referencedEObject : copyReferencedEObject);
                            continue;
                        }
                        copyFeatureMap.add(featureMapEntry);
                    }
                }
            }
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            boolean isBidirectional;
            boolean bl = isBidirectional = eReference.getEOpposite() != null;
            if (eReference.isMany()) {
                InternalEList value = (InternalEList)copyEObject.eGet(this.getTarget(eReference));
                int index = 0;
                Iterator k = ((List)eObject.eGet(eReference)).iterator();
                while (k.hasNext()) {
                    Object referencedEObject = k.next();
                    Object copyReferencedEObject = this.get(referencedEObject);
                    if (copyReferencedEObject == null) {
                        if (isBidirectional) continue;
                        value.addUnique(index, referencedEObject);
                        ++index;
                        continue;
                    }
                    if (isBidirectional) {
                        int position = value.indexOf(copyReferencedEObject);
                        if (position == -1) {
                            value.addUnique(index, copyReferencedEObject);
                        } else if (index != position) {
                            value.move(index, copyReferencedEObject);
                        }
                    } else {
                        value.addUnique(index, copyReferencedEObject);
                    }
                    ++index;
                }
            } else {
                Object referencedEObject = eObject.eGet(eReference);
                if (referencedEObject == null) {
                    if (eObject.eIsSet(eReference)) {
                        copyEObject.eSet(this.getTarget(eReference), null);
                    }
                } else {
                    Object copyReferencedEObject = this.get(referencedEObject);
                    if (copyReferencedEObject == null) {
                        if (!isBidirectional) {
                            copyEObject.eSet(this.getTarget(eReference), referencedEObject);
                        }
                    } else {
                        copyEObject.eSet(this.getTarget(eReference), copyReferencedEObject);
                    }
                }
            }
        }
    }

    public static class ContentTreeIterator
    extends AbstractTreeIterator {
        protected Collection emfObjects;
        protected ResourcesIterator resourceSetIterator;

        protected ContentTreeIterator(Collection emfObjects) {
            super((Object)emfObjects, false);
            this.emfObjects = emfObjects;
        }

        public Iterator getChildren(Object object) {
            if (object instanceof EObject) {
                return this.getEObjectChildren((EObject)object);
            }
            if (object instanceof Resource) {
                return this.getResourceChildren((Resource)object);
            }
            if (object instanceof ResourceSet) {
                return this.getResourceSetChildren((ResourceSet)object);
            }
            if (object == this.emfObjects) {
                return this.emfObjects.iterator();
            }
            return this.getObjectChildren(object);
        }

        protected Iterator getEObjectChildren(EObject eObject) {
            return eObject.eContents().iterator();
        }

        protected Iterator getResourceChildren(Resource resource) {
            return resource.getContents().iterator();
        }

        public boolean hasNext() {
            Iterator iterator;
            if (!this.includeRoot && this.data == null) {
                this.nextPruneIterator = this.getChildren(this.object);
                this.add(this.nextPruneIterator);
                iterator = this.nextPruneIterator;
            } else {
                if (this.data == null) {
                    return true;
                }
                if (this.isEmpty()) {
                    return false;
                }
                iterator = (Iterator)this.data[this.size - 1];
            }
            if (iterator == this.resourceSetIterator && !this.resourceSetIterator.reallyHasNext()) {
                this.next();
                return this.hasNext();
            }
            return iterator.hasNext();
        }

        protected Iterator getResourceSetChildren(ResourceSet resourceSet) {
            this.resourceSetIterator = new ResourcesIterator((List)resourceSet.getResources());
            return this.resourceSetIterator;
        }

        protected Iterator getObjectChildren(Object object) {
            return ECollections.EMPTY_ELIST.iterator();
        }

        protected static class ResourcesIterator
        implements Iterator {
            protected List resources;
            protected int index = 0;

            public ResourcesIterator(List resources) {
                this.resources = resources;
            }

            public boolean reallyHasNext() {
                return this.index < this.resources.size();
            }

            public boolean hasNext() {
                return this.index <= this.resources.size();
            }

            public Object next() {
                if (this.index >= this.resources.size()) {
                    ++this.index;
                    return null;
                }
                return this.resources.get(this.index++);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class CrossReferencer
    extends HashMap {
        protected Collection emfObjects;

        protected CrossReferencer(EObject eObject) {
            this.emfObjects = Collections.singleton(eObject);
        }

        protected CrossReferencer(Resource resource) {
            this.emfObjects = Collections.singleton(resource);
        }

        protected CrossReferencer(ResourceSet resourceSet) {
            this.emfObjects = Collections.singleton(resourceSet);
        }

        protected CrossReferencer(Collection emfObjects) {
            this.emfObjects = emfObjects;
        }

        protected boolean containment(EObject eObject) {
            return true;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return true;
        }

        protected boolean resolve() {
            return true;
        }

        protected Collection newCollection() {
            return new ArrayList();
        }

        protected Collection getCollection(Object key) {
            Collection result = (Collection)this.get(key);
            if (result == null) {
                result = this.newCollection();
                this.put(key, result);
            }
            return result;
        }

        protected TreeIterator newContentsIterator() {
            return new ContentTreeIterator(this.emfObjects);
        }

        protected void crossReference() {
            TreeIterator contents = this.newContentsIterator();
            while (contents.hasNext()) {
                Object content = contents.next();
                if (!(content instanceof EObject)) continue;
                EObject eObject = (EObject)content;
                if (this.containment(eObject)) {
                    this.handleCrossReference(eObject);
                    continue;
                }
                contents.prune();
            }
        }

        protected EContentsEList.FeatureIterator getCrossReferences(EObject eObject) {
            return (EContentsEList.FeatureIterator)(this.resolve() ? eObject.eCrossReferences().iterator() : ((InternalEList)eObject.eCrossReferences()).basicIterator());
        }

        protected void handleCrossReference(EObject eObject) {
            InternalEObject internalEObject = (InternalEObject)eObject;
            EContentsEList.FeatureIterator crossReferences = this.getCrossReferences(internalEObject);
            while (crossReferences.hasNext()) {
                EObject crossReferencedEObject = (EObject)crossReferences.next();
                EReference eReference = (EReference)crossReferences.feature();
                if (!this.crossReference(internalEObject, eReference, crossReferencedEObject)) continue;
                this.getCollection(crossReferencedEObject).add(internalEObject.eSetting(eReference));
            }
        }

        protected void done() {
            this.emfObjects = null;
        }

        public static Map find(Collection emfObjects) {
            CrossReferencer result = new CrossReferencer(emfObjects);
            result.crossReference();
            result.done();
            return result;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("{");
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                EObject eObject = (EObject)entry.getKey();
                result.append(EcoreUtil.getIdentification(eObject));
                result.append("=[");
                Collection collection = (Collection)entry.getValue();
                Iterator j = collection.iterator();
                while (j.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)j.next();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    result.append(eStructuralFeature.getName());
                    result.append("<-");
                    result.append(EcoreUtil.getIdentification(setting.getEObject()));
                    if (!j.hasNext()) continue;
                    result.append(", ");
                }
                result.append(']');
            }
            result.append('}');
            return result.toString();
        }

        public static void print(PrintStream out, Map crossReferenceMap) {
            out.println('{');
            Iterator i = crossReferenceMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                EObject eObject = (EObject)entry.getKey();
                out.print(" ");
                out.print(EcoreUtil.getIdentification(eObject));
                Collection collection = (Collection)entry.getValue();
                if (collection.isEmpty()) {
                    out.println(" =[]");
                    continue;
                }
                out.println(" =[");
                Iterator j = collection.iterator();
                while (j.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)j.next();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    out.print("   ");
                    out.print(eStructuralFeature.getName());
                    out.print("<-");
                    out.print(EcoreUtil.getIdentification(setting.getEObject()));
                    if (!j.hasNext()) continue;
                    out.println(",");
                }
                out.println(']');
            }
            out.println('}');
        }

        public static void print(PrintStream out, Collection settings) {
            if (settings.isEmpty()) {
                out.println("[]");
            } else {
                out.println("[");
                Iterator j = settings.iterator();
                while (j.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)j.next();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    out.print(" ");
                    out.print(eStructuralFeature.getName());
                    out.print("<-");
                    out.print(EcoreUtil.getIdentification(setting.getEObject()));
                    if (!j.hasNext()) continue;
                    out.println(",");
                }
                out.println(']');
            }
        }
    }

    public static class ExternalCrossReferencer
    extends CrossReferencer {
        protected ExternalCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected ExternalCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected ExternalCrossReferencer(Resource resource) {
            super(Collections.singleton(resource));
        }

        protected ExternalCrossReferencer(ResourceSet resourceSet) {
            super(Collections.singleton(resourceSet));
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return !EcoreUtil.isAncestor(this.emfObjects, crossReferencedEObject);
        }

        protected Map findExternalCrossReferences() {
            this.crossReference();
            this.done();
            return this;
        }

        public static Map find(EObject eObject) {
            return new ExternalCrossReferencer(eObject).findExternalCrossReferences();
        }

        public static Map find(Resource resource) {
            return new ExternalCrossReferencer(resource).findExternalCrossReferences();
        }

        public static Map find(ResourceSet resourceSet) {
            return new ExternalCrossReferencer(resourceSet).findExternalCrossReferences();
        }

        public static Map find(Collection emfObjectsToSearch) {
            return new ExternalCrossReferencer(emfObjectsToSearch).findExternalCrossReferences();
        }
    }

    public static class UsageCrossReferencer
    extends CrossReferencer {
        protected Collection eObjectsOfInterest;

        protected UsageCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected UsageCrossReferencer(Resource resource) {
            super(resource);
        }

        protected UsageCrossReferencer(ResourceSet resourceSet) {
            super(resourceSet);
        }

        protected UsageCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return this.eObjectsOfInterest.contains(crossReferencedEObject);
        }

        protected Collection findUsage(EObject eObject) {
            this.eObjectsOfInterest = Collections.singleton(eObject);
            this.crossReference();
            this.eObjectsOfInterest = null;
            this.done();
            return this.getCollection(eObject);
        }

        protected Map findAllUsage(Collection eObjectsOfInterest) {
            this.eObjectsOfInterest = eObjectsOfInterest;
            this.crossReference();
            this.eObjectsOfInterest = null;
            this.done();
            return this;
        }

        public static Collection find(EObject eObjectOfInterest, EObject eObject) {
            return new UsageCrossReferencer(eObject).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, Resource resource) {
            return new UsageCrossReferencer(resource).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, ResourceSet resourceSet) {
            return new UsageCrossReferencer(resourceSet).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, Collection emfObjectsToSearch) {
            return new UsageCrossReferencer(emfObjectsToSearch).findUsage(eObjectOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, EObject eObject) {
            return new UsageCrossReferencer(eObject).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, Resource resource) {
            return new UsageCrossReferencer(resource).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, ResourceSet resourceSet) {
            return new UsageCrossReferencer(resourceSet).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, Collection emfObjectsToSearch) {
            return new UsageCrossReferencer(emfObjectsToSearch).findAllUsage(eObjectsOfInterest);
        }
    }

    public static class ProxyCrossReferencer
    extends CrossReferencer {
        protected ProxyCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected ProxyCrossReferencer(Resource resource) {
            super(Collections.singleton(resource));
        }

        protected ProxyCrossReferencer(ResourceSet resourceSet) {
            super(Collections.singleton(resourceSet));
        }

        protected ProxyCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean resolve() {
            return false;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return crossReferencedEObject.eIsProxy();
        }

        protected Map findProxyCrossReferences() {
            this.crossReference();
            this.done();
            return this;
        }

        public static Map find(EObject eObject) {
            return new ProxyCrossReferencer(eObject).findProxyCrossReferences();
        }

        public static Map find(Resource resource) {
            return new ProxyCrossReferencer(resource).findProxyCrossReferences();
        }

        public static Map find(ResourceSet resourceSet) {
            return new ProxyCrossReferencer(resourceSet).findProxyCrossReferences();
        }

        public static Map find(Collection emfObjects) {
            return new ProxyCrossReferencer(emfObjects).findProxyCrossReferences();
        }
    }

    public static class UnresolvedProxyCrossReferencer
    extends CrossReferencer {
        protected UnresolvedProxyCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected UnresolvedProxyCrossReferencer(Resource resource) {
            super(Collections.singleton(resource));
        }

        protected UnresolvedProxyCrossReferencer(ResourceSet resourceSet) {
            super(Collections.singleton(resourceSet));
        }

        protected UnresolvedProxyCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return crossReferencedEObject.eIsProxy();
        }

        protected Map findUnresolvedProxyCrossReferences() {
            this.crossReference();
            this.done();
            return this;
        }

        public static Map find(EObject eObject) {
            return new UnresolvedProxyCrossReferencer(eObject).findUnresolvedProxyCrossReferences();
        }

        public static Map find(Resource resource) {
            return new UnresolvedProxyCrossReferencer(resource).findUnresolvedProxyCrossReferences();
        }

        public static Map find(ResourceSet resourceSet) {
            return new UnresolvedProxyCrossReferencer(resourceSet).findUnresolvedProxyCrossReferences();
        }

        public static Map find(Collection emfObjects) {
            return new UnresolvedProxyCrossReferencer(emfObjects).findUnresolvedProxyCrossReferences();
        }
    }

    private static final class UUID {
        private static final char[] BASE64_DIGITS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        private static final long EPOCH_ADJUSTMENT = new GregorianCalendar(1970, 0, 1, 0, 0, 0).getTime().getTime() - new GregorianCalendar(1582, 9, 15, 0, 0, 0).getTime().getTime();
        private static long lastTime = System.currentTimeMillis() + EPOCH_ADJUSTMENT;
        private static short clockSequence;
        private static short timeAdjustment;
        private static final byte[] uuid;
        private static final char[] buffer;

        static {
            uuid = new byte[16];
            buffer = new char[23];
            SecureRandom random = new SecureRandom();
            clockSequence = (short)random.nextInt(16384);
            UUID.updateClockSequence();
            byte[] nodeAddress = new byte[6];
            random.nextBytes(nodeAddress);
            nodeAddress[0] = (byte)(nodeAddress[0] | 0xFFFFFF80);
            int i = 0;
            while (i < 6) {
                UUID.uuid[i + 10] = nodeAddress[i];
                ++i;
            }
            UUID.buffer[0] = 95;
        }

        public static synchronized String generate() {
            UUID.updateCurrentTime();
            int i = 0;
            while (i < 5) {
                UUID.buffer[4 * i + 1] = BASE64_DIGITS[uuid[i * 3] >> 2 & 0x3F];
                UUID.buffer[4 * i + 2] = BASE64_DIGITS[uuid[i * 3] << 4 & 0x30 | uuid[i * 3 + 1] >> 4 & 0xF];
                UUID.buffer[4 * i + 3] = BASE64_DIGITS[uuid[i * 3 + 1] << 2 & 0x3C | uuid[i * 3 + 2] >> 6 & 3];
                UUID.buffer[4 * i + 4] = BASE64_DIGITS[uuid[i * 3 + 2] & 0x3F];
                ++i;
            }
            UUID.buffer[21] = BASE64_DIGITS[uuid[15] >> 2 & 0x3F];
            UUID.buffer[22] = BASE64_DIGITS[uuid[15] << 4 & 0x30];
            return new String(buffer);
        }

        UUID() {
        }

        private static void updateClockSequence() {
            UUID.uuid[8] = (byte)(clockSequence >> 8 & 0x3F | 0x80);
            UUID.uuid[9] = (byte)(clockSequence & 0xFF);
        }

        private static void updateCurrentTime() {
            long currentTime = System.currentTimeMillis() + EPOCH_ADJUSTMENT;
            if (lastTime > currentTime) {
                if (16384 == (clockSequence = (short)(clockSequence + 1))) {
                    clockSequence = 0;
                }
                UUID.updateClockSequence();
            } else if (lastTime == currentTime) {
                if ((timeAdjustment = (short)(timeAdjustment + 1)) > 9999) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                    timeAdjustment = 0;
                    currentTime = System.currentTimeMillis() + EPOCH_ADJUSTMENT;
                    if (lastTime == currentTime) {
                        throw new Error("Clock failure in generating a UUID.");
                    }
                }
            } else {
                timeAdjustment = 0;
            }
            lastTime = currentTime;
            currentTime *= 10000L;
            currentTime += (long)timeAdjustment;
            currentTime |= 0x1000000000000000L;
            int i = 0;
            while (i < 4) {
                UUID.uuid[i] = (byte)(currentTime >> 8 * (3 - i) & 0xFFL);
                ++i;
            }
            i = 0;
            while (i < 2) {
                UUID.uuid[i + 4] = (byte)(currentTime >> 8 * (1 - i) + 32 & 0xFFL);
                ++i;
            }
            i = 0;
            while (i < 2) {
                UUID.uuid[i + 6] = (byte)(currentTime >> 8 * (1 - i) + 48 & 0xFFL);
                ++i;
            }
        }
    }
}

