/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;

public class AddCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = EMFEditPlugin.INSTANCE.getString("_UI_AddCommand_label");
    protected static final String DESCRIPTION = EMFEditPlugin.INSTANCE.getString("_UI_AddCommand_description");
    protected static final String DESCRIPTION_FOR_LIST = EMFEditPlugin.INSTANCE.getString("_UI_AddCommand_description_for_list");
    protected EObject owner;
    protected EStructuralFeature feature;
    protected EList ownerList;
    protected Collection collection;
    protected int index;
    protected Collection affectedObjects;
    static /* synthetic */ Class class$0;

    public static Command create(EditingDomain domain, Object owner, Object feature, Object value) {
        return AddCommand.create(domain, owner, feature, Collections.singleton(value), -1);
    }

    public static Command create(EditingDomain domain, Object owner, Object feature, Object value, int index) {
        return AddCommand.create(domain, owner, feature, Collections.singleton(value), index);
    }

    public static Command create(EditingDomain domain, Object owner, Object feature, Collection collection) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.command.AddCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return domain.createCommand(clazz, new CommandParameter(owner, feature, collection, -1));
    }

    public static Command create(EditingDomain domain, Object owner, Object feature, Collection collection, int index) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.command.AddCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return domain.createCommand(clazz, new CommandParameter(owner, feature, collection, index));
    }

    public AddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        this(domain, owner, feature, Collections.singleton(value), -1);
    }

    public AddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        this(domain, owner, feature, Collections.singleton(value), index);
    }

    public AddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection collection) {
        this(domain, owner, feature, collection, -1);
    }

    public AddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection collection, int index) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.feature = feature;
        this.collection = collection;
        this.index = index;
        this.ownerList = AbstractOverrideableCommand.getOwnerList(owner, feature);
    }

    public AddCommand(EditingDomain domain, EList list, Object value) {
        this(domain, list, Collections.singleton(value), -1);
    }

    public AddCommand(EditingDomain domain, EList list, Object value, int index) {
        this(domain, list, Collections.singleton(value), index);
    }

    public AddCommand(EditingDomain domain, EList list, Collection collection) {
        this(domain, list, collection, -1);
    }

    public AddCommand(EditingDomain domain, EList list, Collection collection, int index) {
        super(domain, LABEL, DESCRIPTION_FOR_LIST);
        this.collection = collection;
        this.index = index;
        this.ownerList = list;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public EList getOwnerList() {
        return this.ownerList;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public int getIndex() {
        return this.index;
    }

    protected boolean isUserElement(EStructuralFeature entryFeature) {
        return entryFeature != XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text() && entryFeature != XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_CDATA() && entryFeature != XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Comment();
    }

    protected boolean prepare() {
        if (this.ownerList == null || this.collection == null || this.collection.size() == 0 || this.index != -1 && (this.index < 0 || this.index > this.ownerList.size())) {
            return false;
        }
        if (this.feature != null) {
            FeatureMapUtil.Validator validator = null;
            boolean documentRoot = false;
            HashSet<EStructuralFeature> entryFeatures = null;
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)this.feature)) {
                EClass eClass = this.owner.eClass();
                validator = FeatureMapUtil.getValidator((EClass)eClass, (EStructuralFeature)this.feature);
                documentRoot = ExtendedMetaData.INSTANCE.getDocumentRoot(eClass.getEPackage()) == eClass;
                boolean mixed = documentRoot || ExtendedMetaData.INSTANCE.getContentKind(eClass) == 3;
                entryFeatures = new HashSet<EStructuralFeature>();
                Iterator i = this.ownerList.iterator();
                while (i.hasNext()) {
                    EStructuralFeature entryFeature = ((FeatureMap.Entry)i.next()).getEStructuralFeature();
                    if (mixed && !this.isUserElement(entryFeature)) continue;
                    entryFeatures.add(entryFeature);
                }
            }
            Iterator objects = this.collection.iterator();
            while (objects.hasNext()) {
                Object object = objects.next();
                boolean containment = false;
                if (!this.feature.getEType().isInstance(object)) {
                    return false;
                }
                if (this.feature.isUnique() && this.ownerList.contains(object)) {
                    return false;
                }
                if (validator != null) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)object;
                    EStructuralFeature entryFeature = entry.getEStructuralFeature();
                    boolean bl = containment = entryFeature instanceof EReference && ((EReference)entryFeature).isContainment();
                    if (!validator.isValid(entryFeature) || !entryFeature.getEType().isInstance(entry.getValue())) {
                        return false;
                    }
                    if (documentRoot) {
                        if (this.isUserElement(entryFeature)) {
                            if (!entryFeatures.isEmpty()) {
                                return false;
                            }
                            entryFeatures.add(entryFeature);
                        }
                    } else if (!entryFeatures.add(entryFeature) && !entryFeature.isMany()) {
                        return false;
                    }
                }
                if (!(containment |= this.feature instanceof EReference && ((EReference)this.feature).isContainment())) continue;
                EObject container = this.owner;
                while (container != null) {
                    if (object == container) {
                        return false;
                    }
                    container = container.eContainer();
                }
            }
        }
        return this.owner == null || !this.domain.isReadOnly(this.owner.eResource());
    }

    public void doExecute() {
        if (this.index == -1) {
            this.ownerList.addAll(this.collection);
        } else {
            this.ownerList.addAll(this.index, this.collection);
        }
        this.affectedObjects = this.collection;
    }

    public void doUndo() {
        int i = this.index != -1 ? this.index : this.ownerList.size() - this.collection.size();
        this.ownerList.subList(i, i + this.collection.size()).clear();
        this.affectedObjects = this.owner == null ? Collections.EMPTY_SET : Collections.singleton(this.owner);
    }

    public void doRedo() {
        if (this.index == -1) {
            this.ownerList.addAll(this.collection);
        } else {
            this.ownerList.addAll(this.index, this.collection);
        }
        this.affectedObjects = this.collection;
    }

    public Collection doGetResult() {
        return this.collection;
    }

    public Collection doGetAffectedObjects() {
        return this.affectedObjects;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (feature: " + this.feature + ")");
        result.append(" (ownerList: " + this.ownerList + ")");
        result.append(" (collection: " + this.collection + ")");
        result.append(" (index: " + this.index + ")");
        result.append(" (affectedObjects:" + this.affectedObjects + ")");
        return result.toString();
    }
}

