/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.ecore.genmodel.GenProviderKind;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenBaseImpl;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenClassifierImpl;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenModelImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class GenClassImpl
extends GenClassifierImpl
implements GenClass {
    protected static final GenProviderKind PROVIDER_EDEFAULT = GenProviderKind.SINGLETON_LITERAL;
    protected GenProviderKind provider = PROVIDER_EDEFAULT;
    protected static final boolean IMAGE_EDEFAULT = true;
    protected boolean image = true;
    protected EClass ecoreClass = null;
    protected EList genFeatures = null;
    protected EList genOperations = null;
    protected GenFeature labelFeature = null;
    public static final List INTRINSIC_CONSTRAINTS = Arrays.asList("EveryMultiplicityConforms", "EveryDataValueConforms", "EveryReferenceIsContained", "EveryProxyResolves");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected GenClassImpl() {
    }

    protected EClass eStaticClass() {
        return GenModelPackage.eINSTANCE.getGenClass();
    }

    public GenProviderKind getProvider() {
        return this.provider;
    }

    public boolean isProviderSingleton() {
        return this.provider == GenProviderKind.SINGLETON_LITERAL;
    }

    public void setProvider(GenProviderKind newProvider) {
        GenProviderKind oldProvider = this.provider;
        GenProviderKind genProviderKind = this.provider = newProvider == null ? PROVIDER_EDEFAULT : newProvider;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldProvider, (Object)this.provider));
        }
    }

    public boolean isImage() {
        return this.image;
    }

    public void setImage(boolean newImage) {
        boolean oldImage = this.image;
        this.image = newImage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldImage, this.image));
        }
    }

    public EClass getEcoreClass() {
        if (this.ecoreClass != null && this.ecoreClass.eIsProxy()) {
            EClass oldEcoreClass = this.ecoreClass;
            this.ecoreClass = (EClass)this.eResolveProxy((InternalEObject)this.ecoreClass);
            if (this.ecoreClass != oldEcoreClass && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldEcoreClass, (Object)this.ecoreClass));
            }
        }
        return this.ecoreClass;
    }

    public EClass basicGetEcoreClass() {
        return this.ecoreClass;
    }

    public void setEcoreClass(EClass newEcoreClass) {
        EClass oldEcoreClass = this.ecoreClass;
        this.ecoreClass = newEcoreClass;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldEcoreClass, (Object)this.ecoreClass));
        }
    }

    public EList getGenFeatures() {
        if (this.genFeatures == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.codegen.ecore.genmodel.GenFeature");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.genFeatures = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 4, 4);
        }
        return this.genFeatures;
    }

    public EList getGenOperations() {
        if (this.genOperations == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.emf.codegen.ecore.genmodel.GenOperation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.genOperations = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 5, 0);
        }
        return this.genOperations;
    }

    public EClassifier getEcoreClassifier() {
        return this.getEcoreClass();
    }

    public String getImportedMetaType() {
        return this.getGenModel().getImportedName("org.eclipse.emf.ecore.EClass");
    }

    public String getInterfaceName() {
        return this.getName();
    }

    public String getQualifiedInterfaceName() {
        return this.getInternalQualifiedInterfaceName().replace('$', '.');
    }

    protected String getInternalQualifiedInterfaceName() {
        return this.isExternalInterface() ? this.getEcoreClass().getInstanceClassName() : String.valueOf(this.getGenPackage().getInterfacePackageName()) + "." + this.getInterfaceName();
    }

    public String getImportedInstanceClassName() {
        return this.getImportedInterfaceName();
    }

    public String getImportedInterfaceName() {
        return this.getGenModel().getImportedName(this.getInternalQualifiedInterfaceName());
    }

    public String getClassName() {
        return this.getImplClassName(this.getInterfaceName());
    }

    public String getQualifiedClassName() {
        return String.valueOf(this.getGenPackage().getClassPackageName()) + "." + this.getClassName();
    }

    public String getImportedClassName() {
        return this.getGenModel().getImportedName(this.getQualifiedClassName());
    }

    public List getBaseGenClasses() {
        return this.collectGenClasses((List)this.getEcoreClass().getESuperTypes(), null);
    }

    public List getAllBaseGenClasses() {
        return this.collectGenClasses((List)this.getEcoreClass().getEAllSuperTypes(), null);
    }

    public List getSwitchGenClasses() {
        List result = this.collectGenClasses((List)this.getEcoreClass().getESuperTypes(), new GenBaseImpl.GenClassFilter(){

            public boolean accept(GenClass genClass) {
                return !genClass.isEObject();
            }
        });
        HashSet<GenClass> resultSet = new HashSet<GenClass>(result);
        int i = 0;
        while (i < result.size()) {
            GenClass base = (GenClass)result.get(i);
            Iterator iter = base.getBaseGenClasses().iterator();
            while (iter.hasNext()) {
                GenClass baseOfBase = (GenClass)iter.next();
                if (baseOfBase.isEObject() || !resultSet.add(baseOfBase)) continue;
                result.add(baseOfBase);
            }
            ++i;
        }
        return result;
    }

    public GenClass getBaseGenClass() {
        EList s = this.getEcoreClass().getESuperTypes();
        return s.isEmpty() ? null : this.findGenClass((EClass)s.iterator().next());
    }

    public GenClass getClassExtendsGenClass() {
        GenClass base = this.getBaseGenClass();
        while (base != this) {
            if (base == null || !base.isInterface()) {
                return base;
            }
            base = base.getBaseGenClass();
        }
        throw new RuntimeException("inheritance loop at " + this.getName());
    }

    public String getClassExtends() {
        String rootExtendsClass;
        GenClass extendsClass = this.getClassExtendsGenClass();
        if (extendsClass != null) {
            return " extends " + extendsClass.getImportedClassName();
        }
        if (!this.isEObject() && !GenBaseImpl.isBlank(rootExtendsClass = this.getGenModel().getRootExtendsClass())) {
            return " extends " + this.getGenModel().getImportedName(rootExtendsClass);
        }
        return "";
    }

    public boolean needsRootImplementsInterfaceOperations() {
        GenClass extendsClass;
        String rootImplementsInterface;
        return !this.isMapEntry() && !GenBaseImpl.isBlank(rootImplementsInterface = this.getGenModel().getRootImplementsInterface()) && (extendsClass = this.getClassExtendsGenClass()) != null && !rootImplementsInterface.equals(extendsClass.getGenModel().getRootImplementsInterface());
    }

    public String getClassImplements() {
        GenClass extendsClass;
        if (this.isMapEntry()) {
            return " implements " + this.getGenModel().getImportedName("org.eclipse.emf.common.util.BasicEMap$Entry");
        }
        String result = " implements " + this.getImportedInterfaceName();
        String rootImplementsInterface = this.getGenModel().getRootImplementsInterface();
        if (!GenBaseImpl.isBlank(rootImplementsInterface) && (extendsClass = this.getClassExtendsGenClass()) != null && !rootImplementsInterface.equals(extendsClass.getGenModel().getRootImplementsInterface())) {
            result = String.valueOf(result) + ", " + this.getGenModel().getImportedName(rootImplementsInterface);
        }
        return result;
    }

    public boolean needsRootExtendsInterfaceExtendsTag() {
        String rootExtendsInterface = this.getGenModel().getRootExtendsInterface();
        if (rootExtendsInterface == null) {
            rootExtendsInterface = "";
        }
        if (GenBaseImpl.isBlank(rootExtendsInterface) || this.getBaseGenClasses().isEmpty() && this.getGenPackage().isEcorePackage()) {
            return false;
        }
        Iterator iter = this.getAllBaseGenClasses().iterator();
        while (iter.hasNext()) {
            GenClass genClass = (GenClass)iter.next();
            if (genClass.getEcoreClass().getInstanceClassName() != null || !rootExtendsInterface.equals(genClass.getGenModel().getRootExtendsInterface())) continue;
            return false;
        }
        return !rootExtendsInterface.equals("org.eclipse.emf.ecore.EObject");
    }

    public String getInterfaceExtends() {
        String rootExtendsInterface = this.getGenModel().getRootExtendsInterface();
        if (rootExtendsInterface == null) {
            rootExtendsInterface = "";
        }
        if (this.getBaseGenClasses().isEmpty()) {
            if (this.getGenPackage().isEcorePackage()) {
                return "";
            }
            if (!GenBaseImpl.isBlank(rootExtendsInterface)) {
                return " extends " + this.getGenModel().getImportedName(rootExtendsInterface);
            }
            return "";
        }
        boolean needsRootExtendsInterface = true;
        Iterator iter = this.getAllBaseGenClasses().iterator();
        while (iter.hasNext()) {
            GenClass genClass = (GenClass)iter.next();
            if (genClass.getEcoreClass().getInstanceClassName() != null || !rootExtendsInterface.equals(genClass.getGenModel().getRootExtendsInterface())) continue;
            needsRootExtendsInterface = false;
            break;
        }
        StringBuffer result = new StringBuffer(" extends ");
        if (needsRootExtendsInterface && !GenBaseImpl.isBlank(rootExtendsInterface)) {
            result.append(this.getGenModel().getImportedName(rootExtendsInterface));
            result.append(", ");
        }
        Iterator iter2 = this.getBaseGenClasses().iterator();
        while (iter2.hasNext()) {
            result.append(((GenClass)iter2.next()).getImportedInterfaceName());
            if (!iter2.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public List getAllGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), null);
    }

    public List getInheritedGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), null, null);
    }

    public List getAllGenOperations() {
        return this.collectGenOperations(this.getAllBaseGenClasses(), (List)this.getGenOperations(), null);
    }

    public String getFeatureID(GenFeature genFeature) {
        return String.valueOf(this.getClassifierID()) + "__" + this.format(genFeature.getName(), '_', null, false).toUpperCase();
    }

    public String getQualifiedFeatureID(GenFeature genFeature) {
        return String.valueOf(this.getGenPackage().getImportedPackageInterfaceName()) + "." + this.getFeatureID(genFeature);
    }

    public String getFeatureValue(GenFeature genFeature) {
        List allFeatures = this.getAllGenFeatures();
        int i = allFeatures.indexOf(genFeature);
        GenClass base = this.getBaseGenClass();
        if (base == null) {
            return Integer.toString(i);
        }
        int baseCount = base.getFeatureCount();
        if (i < baseCount) {
            return this.getGenPackage() == base.getGenPackage() ? base.getFeatureID(genFeature) : base.getQualifiedFeatureID(genFeature);
        }
        String baseCountID = this.getGenPackage() == base.getGenPackage() ? base.getFeatureCountID() : base.getQualifiedFeatureCountID();
        return String.valueOf(baseCountID) + " + " + Integer.toString(i - baseCount);
    }

    public String getLocalFeatureIndex(GenFeature genFeature) {
        return Integer.toString(this.getEcoreClass().getEStructuralFeatures().indexOf((Object)genFeature.getEcoreFeature()));
    }

    public String getFeatureCountID() {
        return String.valueOf(this.getClassifierID()) + "_FEATURE_COUNT";
    }

    public String getQualifiedFeatureCountID() {
        return String.valueOf(this.getGenPackage().getImportedPackageInterfaceName()) + "." + this.getFeatureCountID();
    }

    public String getFeatureCountValue() {
        GenClass base = this.getBaseGenClass();
        if (base == null) {
            return Integer.toString(this.getFeatureCount());
        }
        String baseCountID = this.getGenPackage() == base.getGenPackage() ? base.getFeatureCountID() : base.getQualifiedFeatureCountID();
        return String.valueOf(baseCountID) + " + " + Integer.toString(this.getFeatureCount() - base.getFeatureCount());
    }

    public int getFeatureCount() {
        return this.getAllGenFeatures().size();
    }

    public boolean isEObject() {
        return this.getName().equals("EObject") && this.getGenPackage().isEcorePackage();
    }

    public boolean isEObjectExtension() {
        if (this.isMapEntry()) {
            return false;
        }
        Iterator iter = this.getAllBaseGenClasses().iterator();
        while (iter.hasNext()) {
            GenClass genClass = (GenClass)iter.next();
            if (!genClass.isEObjectExtension()) continue;
            return true;
        }
        return this.getGenPackage().isEcorePackage() || "org.eclipse.emf.ecore.EObject".equals(this.getGenModel().getRootExtendsInterface());
    }

    public boolean isAbstract() {
        return this.getEcoreClass().isAbstract() || this.getEcoreClass().isInterface();
    }

    public String getAbstractFlag() {
        String result = !this.isAbstract() ? "!" : "";
        return String.valueOf(result) + "IS_ABSTRACT";
    }

    public boolean isInterface() {
        return this.getEcoreClass().isInterface();
    }

    public String getInterfaceFlag() {
        String result = !this.getEcoreClass().isInterface() ? "!" : "";
        return String.valueOf(result) + "IS_INTERFACE";
    }

    public String getGeneratedInstanceClassFlag() {
        String result = this.isExternalInterface() ? "!" : "";
        return String.valueOf(result) + "IS_GENERATED_INSTANCE_CLASS";
    }

    public boolean isExternalInterface() {
        return this.getEcoreClass().getInstanceClassName() != null;
    }

    public boolean isMapEntry() {
        return GenBaseImpl.isJavaUtilMapEntry(this.getEcoreClass().getInstanceClassName()) && this.getEcoreClass().getEStructuralFeature("key") != null && this.getEcoreClass().getEStructuralFeature("value") != null;
    }

    public GenFeature getMapEntryKeyFeature() {
        return this.findGenFeature(this.getEcoreClass().getEStructuralFeature("key"));
    }

    public GenFeature getMapEntryValueFeature() {
        return this.findGenFeature(this.getEcoreClass().getEStructuralFeature("value"));
    }

    public List getImplementedGenClasses() {
        List allBases = this.getAllBaseGenClasses();
        GenClass extendedBase = this.getClassExtendsGenClass();
        int i = extendedBase == null ? 0 : allBases.indexOf(extendedBase) + 1;
        ArrayList<GenClassImpl> result = new ArrayList<GenClassImpl>(allBases.subList(i, allBases.size()));
        result.add(this);
        return result;
    }

    public List getImplementedGenFeatures() {
        return this.collectGenFeatures(this.getImplementedGenClasses(), null, null);
    }

    public List getImplementedGenOperations() {
        GenClass rootImplementsInterface;
        final List allGenFeatures = this.getAllGenFeatures();
        UniqueEList implementedGenClasses = new UniqueEList((Collection)this.getImplementedGenClasses());
        if (this.needsRootImplementsInterfaceOperations() && (rootImplementsInterface = this.getGenModel().getRootImplementsInterfaceGenClass()) != null) {
            UniqueEList allBaseClasses = new UniqueEList((Collection)rootImplementsInterface.getAllBaseGenClasses());
            Iterator i = allBaseClasses.iterator();
            while (i.hasNext()) {
                GenClass genClass = (GenClass)i.next();
                if (!genClass.isEObject()) continue;
                i.remove();
            }
            allBaseClasses.add(rootImplementsInterface);
            implementedGenClasses.addAll(allBaseClasses);
        }
        return this.collectGenOperations((List)implementedGenClasses, null, new GenBaseImpl.GenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                block5: {
                    block7: {
                        block6: {
                            block4: {
                                if (!genOperation.getName().startsWith("get") || !genOperation.getGenParameters().isEmpty()) break block4;
                                Iterator i = allGenFeatures.iterator();
                                while (i.hasNext()) {
                                    GenFeature genFeature = (GenFeature)i.next();
                                    if (!genFeature.getGetAccessor().equals(genOperation.getName())) continue;
                                    return false;
                                }
                                break block5;
                            }
                            if (!genOperation.getName().startsWith("set") || genOperation.getGenParameters().size() != 1) break block6;
                            GenParameter genParameter = (GenParameter)genOperation.getGenParameters().get(0);
                            Iterator i = allGenFeatures.iterator();
                            while (i.hasNext()) {
                                GenFeature genFeature = (GenFeature)i.next();
                                if (!genFeature.isChangeable() || genFeature.isListType() || !genOperation.getName().equals("set" + genFeature.getAccessorName()) || !genParameter.getType().equals(genFeature.getType())) continue;
                                return false;
                            }
                            break block5;
                        }
                        if (!genOperation.getName().startsWith("unset") || !genOperation.getGenParameters().isEmpty()) break block7;
                        Iterator i = allGenFeatures.iterator();
                        while (i.hasNext()) {
                            GenFeature genFeature = (GenFeature)i.next();
                            if (!genFeature.isChangeable() || !genFeature.isUnsettable() || !genOperation.getName().equals("unset" + genFeature.getAccessorName())) continue;
                            return false;
                        }
                        break block5;
                    }
                    if (!genOperation.getName().startsWith("isSet") || !genOperation.getGenParameters().isEmpty()) break block5;
                    Iterator i = allGenFeatures.iterator();
                    while (i.hasNext()) {
                        GenFeature genFeature = (GenFeature)i.next();
                        if (!genFeature.isChangeable() || !genFeature.isUnsettable() || !genOperation.getName().equals("isSet" + genFeature.getAccessorName())) continue;
                        return false;
                    }
                }
                return !genOperation.getGenClass().isEObject();
            }
        });
    }

    public List getESetGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isChangeable();
            }
        });
    }

    public List getEInverseAddGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isBidirectional() && !genFeature.isVolatile();
            }
        });
    }

    public List getEInverseRemoveGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isContains() || genFeature.isBidirectional() && !genFeature.getReverse().isVolatile() || genFeature.isFeatureMapType();
            }
        });
    }

    public List getEBasicRemoveFromContainerGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isContainer();
            }
        });
    }

    public List getToStringGenFeatures() {
        return this.collectGenFeatures(this.getImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return !genFeature.isVolatile() && !genFeature.isReferenceType();
            }
        });
    }

    public List getMixinGenClasses() {
        EList superTypes = this.getEcoreClass().getESuperTypes();
        if (superTypes.isEmpty() || superTypes.size() == 1 && !((EClass)superTypes.get(0)).isInterface()) {
            return Collections.EMPTY_LIST;
        }
        List allBases = this.getAllBaseGenClasses();
        ArrayList result = new ArrayList(allBases.size());
        GenClass baseGenClass = this.getBaseGenClass();
        if (baseGenClass.isInterface()) {
            result.addAll(baseGenClass.getMixinGenClasses());
        }
        int i = allBases.indexOf(baseGenClass) + 1;
        result.addAll(allBases.subList(i, allBases.size()));
        return result;
    }

    public List getMixinGenFeatures() {
        return this.collectGenFeatures(this.getMixinGenClasses(), null, null);
    }

    public void initialize(EClass eClass) {
        if (eClass != this.getEcoreClass()) {
            this.setEcoreClass(eClass);
            if (this.getLabelFeatureGen() != null && this.getLabelFeatureGen().eIsProxy()) {
                this.setLabelFeature(null);
            }
        }
        int localFeatureIndex = 0;
        Iterator iter = eClass.getEStructuralFeatures().iterator();
        block0: while (iter.hasNext()) {
            GenFeature genFeature;
            GenFeature genFeature2;
            Iterator j;
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iter.next();
            if (eStructuralFeature instanceof EAttribute) {
                EAttribute attribute = (EAttribute)eStructuralFeature;
                j = this.getGenFeatures().iterator();
                while (j.hasNext()) {
                    genFeature2 = (GenFeature)j.next();
                    if (genFeature2.getEcoreFeature() != attribute) continue;
                    genFeature2.initialize((EStructuralFeature)attribute);
                    this.getGenFeatures().move(localFeatureIndex++, (Object)genFeature2);
                    continue block0;
                }
                genFeature = this.ePackageGenModel().getGenModelFactory().createGenFeature();
                genFeature.initialize((EStructuralFeature)attribute);
                this.getGenFeatures().add(localFeatureIndex++, (Object)genFeature);
                continue;
            }
            EReference reference = (EReference)eStructuralFeature;
            j = this.getGenFeatures().iterator();
            while (j.hasNext()) {
                genFeature2 = (GenFeature)j.next();
                if (genFeature2.getEcoreFeature() != reference) continue;
                genFeature2.initialize((EStructuralFeature)reference);
                this.getGenFeatures().move(localFeatureIndex++, (Object)genFeature2);
                continue block0;
            }
            genFeature = this.ePackageGenModel().getGenModelFactory().createGenFeature();
            genFeature.initialize((EStructuralFeature)reference);
            this.getGenFeatures().add(localFeatureIndex++, (Object)genFeature);
        }
        iter = eClass.getEOperations().iterator();
        block3: while (iter.hasNext()) {
            EOperation operation = (EOperation)iter.next();
            Iterator j = this.getGenOperations().iterator();
            while (j.hasNext()) {
                GenOperation genOperation = (GenOperation)j.next();
                if (genOperation.getEcoreOperation() != operation) continue;
                genOperation.initialize(operation);
                continue block3;
            }
            GenOperation genOperation = this.ePackageGenModel().getGenModelFactory().createGenOperation();
            genOperation.initialize(operation);
            this.getGenOperations().add((Object)genOperation);
        }
    }

    protected boolean hasModelContribution() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate(IProgressMonitor progressMonitor) {
        block8: {
            block7: {
                try {
                    int fileCount;
                    if (!this.canGenerate()) {
                        Object var3_2 = null;
                        break block7;
                    }
                    int n = fileCount = this.isInterface() ? 1 : 2;
                    if (this.isExternalInterface()) {
                        --fileCount;
                    }
                    progressMonitor.beginTask("", fileCount);
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_Generating_message", new Object[]{this.getFormattedName()}));
                    if (!this.isExternalInterface()) {
                        progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaInterface_message", new Object[]{String.valueOf(this.getGenPackage().getInterfacePackageName()) + "." + this.getInterfaceName()}));
                        this.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), Generator.EMF_MODEL_PROJECT_STYLE, this.getGenModel().getEffectiveModelPluginVariables(), this.getGenModel().getModelDirectory(), this.getGenPackage().getInterfacePackageName(), this.getInterfaceName(), this.getGenModel().getInterfaceEmitter());
                    }
                    if (!this.isInterface()) {
                        progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{String.valueOf(this.getGenPackage().getClassPackageName()) + "." + this.getClassName()}));
                        this.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), Generator.EMF_MODEL_PROJECT_STYLE, this.getGenModel().getEffectiveModelPluginVariables(), this.getGenModel().getModelDirectory(), this.getGenPackage().getClassPackageName(), this.getClassName(), this.getGenModel().getClassEmitter());
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    progressMonitor.done();
                    throw throwable;
                }
            }
            progressMonitor.done();
            return;
        }
        Object var3_4 = null;
        progressMonitor.done();
    }

    public String getModelInfo() {
        StringBuffer result = new StringBuffer();
        if (this.isMapEntry()) {
            StringBuffer names = new StringBuffer();
            StringBuffer body = new StringBuffer();
            Iterator i = this.getGenFeatures().iterator();
            while (i.hasNext()) {
                GenFeature genFeature = (GenFeature)i.next();
                body.append(genFeature.getQualifiedModelInfo());
                body.append(' ');
                names.append(genFeature.getEcoreFeature().getName());
                names.append(' ');
            }
            String features = names.toString().trim();
            if (!features.equals("key value")) {
                this.appendModelSetting(result, "features", features);
            }
            result.append(body);
        } else if (this.isExternalInterface()) {
            this.appendModelSetting(result, "instanceClass", this.getEcoreClass().getInstanceClassName());
        } else {
            if (this.isInterface()) {
                this.appendModelSetting(result, "interface", "true");
            }
            if (this.isAbstract()) {
                this.appendModelSetting(result, "abstract", "true");
            }
            StringBuffer suppressedNames = new StringBuffer();
            StringBuffer suppressedInfo = new StringBuffer();
            Iterator iter = this.getGenFeatures().iterator();
            while (iter.hasNext()) {
                GenFeature genFeature = (GenFeature)iter.next();
                if (!genFeature.isSuppressedGetVisibility()) continue;
                suppressedNames.append(genFeature.getName());
                suppressedNames.append(' ');
                suppressedInfo.append(genFeature.getQualifiedModelInfo());
                suppressedInfo.append(' ');
            }
            if (suppressedNames.length() > 0) {
                this.appendModelSetting(result, "features", suppressedNames.toString().trim());
                result.append(suppressedInfo);
            }
        }
        return result.toString().trim();
    }

    public String getProviderClassName() {
        return String.valueOf(this.getName()) + "ItemProvider";
    }

    public String getQualifiedProviderClassName() {
        return String.valueOf(this.getGenPackage().getProviderPackageName()) + "." + this.getProviderClassName();
    }

    public String getImportedProviderClassName() {
        return this.getGenModel().getImportedName(this.getQualifiedProviderClassName());
    }

    public String getItemIconFileName() {
        return String.valueOf(this.getGenModel().getEditIconsDirectory()) + "/full/obj16/" + this.getName() + ".gif";
    }

    public String getCreateChildIconFileName(GenFeature feature, GenClass childClass) {
        GenClass parentClass = feature.getGenClass();
        return String.valueOf(this.getGenModel().getEditIconsDirectory()) + "/full/ctool16/" + "Create" + parentClass.getName() + "_" + feature.getName() + "_" + childClass.getName() + ".gif";
    }

    protected GenClass getProviderExtendsGenClass() {
        GenClass baseClass = this.getClassExtendsGenClass();
        while (!(baseClass == null || baseClass.getProvider() != GenProviderKind.NONE_LITERAL && baseClass.getGenModel().hasEditSupport())) {
            baseClass = baseClass.getClassExtendsGenClass();
        }
        return baseClass;
    }

    public String getProviderBaseClassName() {
        GenClass baseClass = this.getProviderExtendsGenClass();
        return baseClass != null ? baseClass.getImportedProviderClassName() : null;
    }

    public List getProviderImplementedGenClasses() {
        List allBases = this.getAllBaseGenClasses();
        GenClass extendedBase = this.getProviderExtendsGenClass();
        int i = extendedBase == null ? 0 : allBases.indexOf(extendedBase) + 1;
        ArrayList<GenClassImpl> result = new ArrayList<GenClassImpl>(allBases.subList(i, allBases.size()));
        result.add(this);
        return result;
    }

    protected List getProviderImplementedGenFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, null);
    }

    public List getLabelFeatureCandidates() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return !genFeature.isReferenceType() && !genFeature.isListType() && !genFeature.isMapType() && !genFeature.isSuppressedGetVisibility();
            }
        });
    }

    public List getPropertyFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isProperty();
            }
        });
    }

    public List getNotifyFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isNotify();
            }
        });
    }

    public List getLabelNotifyFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isNotify() && !genFeature.isChildren();
            }
        });
    }

    public List getContentNotifyFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isNotify() && genFeature.isChildren() && genFeature != GenClassImpl.this.getLabelFeature();
            }
        });
    }

    public List getLabelAndContentNotifyFeatures() {
        GenFeature feature = this.getLabelFeature();
        return feature != null && feature.isNotify() && feature.isChildren() ? Collections.singletonList(feature) : Collections.EMPTY_LIST;
    }

    public List getChildrenFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isChildren();
            }
        });
    }

    public List getAllChildrenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isChildren();
            }
        });
    }

    public List getCreateChildFeatures() {
        ArrayList<GenFeature> result = new ArrayList<GenFeature>();
        final GenFeature mixed = this.getMixedGenFeature();
        if (mixed != null && mixed.isCreateChild()) {
            result.add(mixed);
        }
        result.addAll(this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isCreateChild() && genFeature != mixed;
            }
        }));
        return result;
    }

    public List getAllCreateChildFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isCreateChild();
            }
        });
    }

    protected List getAllCreateChildFeaturesIncludingDelegation() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                while (genFeature != null) {
                    if (genFeature.isCreateChild()) {
                        return true;
                    }
                    genFeature = genFeature.getDelegateFeature();
                }
                return false;
            }
        });
    }

    public List getCrossPackageCreateChildFeatures() {
        GenClass base = this.getProviderExtendsGenClass();
        if (base == null || base.getGenPackage() == this.getGenPackage() || this.getGenModel().getAllGenPackagesWithClassifiers().contains(base.getGenPackage())) {
            return Collections.EMPTY_LIST;
        }
        return this.collectGenFeatures(base.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isCreateChild() && genFeature.isReferenceType();
            }
        });
    }

    public List getSharedClassCreateChildFeatures() {
        List childrenFeatures = this.getAllCreateChildFeatures();
        LinkedHashMap<GenClass, ArrayList<GenFeature>> classToFeatureMap = new LinkedHashMap<GenClass, ArrayList<GenFeature>>();
        List packages = this.getGenModel().getAllGenAndUsedGenPackagesWithClassifiers();
        Iterator iter = childrenFeatures.iterator();
        while (iter.hasNext()) {
            GenFeature f = (GenFeature)iter.next();
            List<GenFeature> fl = f.isFeatureMapType() ? f.getDelegatedFeatures() : Collections.singletonList(f);
            Iterator<GenFeature> fIter = fl.iterator();
            while (fIter.hasNext()) {
                GenFeature genFeature = fIter.next();
                List genClasses = this.getTypeGenClasses(genFeature.getEcoreFeature().getEType(), null, packages, -1);
                Iterator cIter = genClasses.iterator();
                while (cIter.hasNext()) {
                    GenClass genClass = (GenClass)cIter.next();
                    ArrayList<GenFeature> genFeatures = (ArrayList<GenFeature>)classToFeatureMap.get(genClass);
                    if (genFeatures == null) {
                        genFeatures = new ArrayList<GenFeature>(5);
                        classToFeatureMap.put(genClass, genFeatures);
                    }
                    genFeatures.add(genFeature);
                }
            }
        }
        UniqueEList result = new UniqueEList(childrenFeatures.size());
        Iterator iter2 = classToFeatureMap.values().iterator();
        while (iter2.hasNext()) {
            List genFeatures = (List)iter2.next();
            if (genFeatures.size() <= 1) continue;
            result.addAll(genFeatures);
        }
        return result;
    }

    public boolean hasFeatureMapCreateChildFeatures() {
        Iterator iter = this.getAllCreateChildFeatures().iterator();
        while (iter.hasNext()) {
            GenFeature genFeature = (GenFeature)iter.next();
            if (!genFeature.isFeatureMapType()) continue;
            return true;
        }
        return false;
    }

    public List getChildrenClasses(GenFeature genFeature) {
        return this.getTypeGenClasses(genFeature.getEcoreFeature().getEType(), this.getGenPackage(), this.getGenModel().getAllGenAndUsedGenPackagesWithClassifiers(), -1);
    }

    public List getCrossPackageChildrenClasses(GenFeature genFeature) {
        return this.getTypeGenClasses(genFeature.getEcoreFeature().getEType(), this.getGenPackage(), this.getGenModel().getAllGenPackagesWithClassifiers(), -1);
    }

    public GenFeature getLabelFeatureGen() {
        if (this.labelFeature != null && this.labelFeature.eIsProxy()) {
            GenFeature oldLabelFeature = this.labelFeature;
            this.labelFeature = (GenFeature)this.eResolveProxy((InternalEObject)this.labelFeature);
            if (this.labelFeature != oldLabelFeature && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldLabelFeature, (Object)this.labelFeature));
            }
        }
        return this.labelFeature;
    }

    public GenFeature getLabelFeature() {
        GenFeature labelFeature = this.getLabelFeatureGen();
        if (labelFeature != null) {
            return labelFeature;
        }
        Iterator iter = this.getLabelFeatureCandidates().iterator();
        while (iter.hasNext()) {
            String featureName;
            GenFeature feature = (GenFeature)iter.next();
            if (feature.isListType() || (featureName = feature.getName()) == null) continue;
            if (featureName.equalsIgnoreCase("name")) {
                labelFeature = feature;
                continue;
            }
            if (featureName.equalsIgnoreCase("id")) {
                if (labelFeature != null && labelFeature.getName().toLowerCase().endsWith("name")) continue;
                labelFeature = feature;
                continue;
            }
            if (featureName.toLowerCase().endsWith("name")) {
                if (labelFeature != null && (labelFeature.getName().toLowerCase().endsWith("name") || labelFeature.getName().equalsIgnoreCase("id"))) continue;
                labelFeature = feature;
                continue;
            }
            if (featureName.toLowerCase().indexOf("name") != -1) {
                if (labelFeature != null && (labelFeature.getName().toLowerCase().indexOf("name") != -1 || labelFeature.getName().equalsIgnoreCase("id"))) continue;
                labelFeature = feature;
                continue;
            }
            if (labelFeature != null) continue;
            labelFeature = feature;
        }
        return labelFeature;
    }

    public GenFeature basicGetLabelFeature() {
        return this.labelFeature;
    }

    public void setLabelFeature(GenFeature newLabelFeature) {
        GenFeature oldLabelFeature = this.labelFeature;
        this.labelFeature = newLabelFeature;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldLabelFeature, (Object)this.labelFeature));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getGenFeatures()).basicAdd((Object)otherEnd, msgs);
                }
                case 5: {
                    return ((InternalEList)this.getGenOperations()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getGenFeatures()).basicRemove((Object)otherEnd, msgs);
                }
                case 5: {
                    return ((InternalEList)this.getGenOperations()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getGenPackage();
            }
            case 1: {
                return this.getProvider();
            }
            case 2: {
                return this.isImage() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                if (resolve) {
                    return this.getEcoreClass();
                }
                return this.basicGetEcoreClass();
            }
            case 4: {
                return this.getGenFeatures();
            }
            case 5: {
                return this.getGenOperations();
            }
            case 6: {
                if (resolve) {
                    return this.getLabelFeature();
                }
                return this.basicGetLabelFeature();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getGenPackage() != null;
            }
            case 1: {
                return this.provider != PROVIDER_EDEFAULT;
            }
            case 2: {
                return !this.image;
            }
            case 3: {
                return this.ecoreClass != null;
            }
            case 4: {
                return this.genFeatures != null && !this.genFeatures.isEmpty();
            }
            case 5: {
                return this.genOperations != null && !this.genOperations.isEmpty();
            }
            case 6: {
                return this.labelFeature != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 1: {
                this.setProvider((GenProviderKind)((Object)newValue));
                return;
            }
            case 2: {
                this.setImage((Boolean)newValue);
                return;
            }
            case 3: {
                this.setEcoreClass((EClass)newValue);
                return;
            }
            case 4: {
                this.getGenFeatures().clear();
                this.getGenFeatures().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getGenOperations().clear();
                this.getGenOperations().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setLabelFeature((GenFeature)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 1: {
                this.setProvider(PROVIDER_EDEFAULT);
                return;
            }
            case 2: {
                this.setImage(true);
                return;
            }
            case 3: {
                this.setEcoreClass(null);
                return;
            }
            case 4: {
                this.getGenFeatures().clear();
                return;
            }
            case 5: {
                this.getGenOperations().clear();
                return;
            }
            case 6: {
                this.setLabelFeature(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (provider: ");
        result.append((Object)this.provider);
        result.append(", image: ");
        result.append(this.image);
        result.append(')');
        return result.toString();
    }

    public String getItemProviderAdapterFactoryClassName() {
        return this.getGenPackage().getItemProviderAdapterFactoryClassName();
    }

    public boolean canGenerateEdit() {
        return super.canGenerateEdit() && !this.isInterface();
    }

    public boolean canGenerateEditor() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateEdit(IProgressMonitor progressMonitor) {
        block9: {
            block8: {
                try {
                    if (!this.canGenerateEdit()) {
                        Object var6_2 = null;
                        break block8;
                    }
                    progressMonitor.beginTask("", 2 + this.getAllCreateChildFeatures().size());
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingProvider_message", new Object[]{this.getFormattedName()}));
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{String.valueOf(this.getGenPackage().getProviderPackageName()) + "." + this.getProviderClassName()}));
                    this.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), Generator.EMF_EDIT_PROJECT_STYLE, this.getGenModel().getEffectiveModelPluginVariables(), this.getGenModel().getEditDirectory(), this.getGenPackage().getProviderPackageName(), this.getProviderClassName(), this.getGenModel().getItemProviderEmitter());
                    if (this.isImage()) {
                        progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingItemIcon_message", new Object[]{this.getItemIconFileName()}));
                        this.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), Generator.EMF_EDIT_PROJECT_STYLE, this.getGenModel().getEffectiveModelPluginVariables(), this.getItemIconFileName(), ((GenModelImpl)this.getGenModel()).getItemGIFEmitter(), this.getName());
                    }
                    if (this.getGenModel().isCreationCommands()) {
                        Iterator iter = this.getAllCreateChildFeaturesIncludingDelegation().iterator();
                        while (iter.hasNext()) {
                            GenFeature feature = (GenFeature)iter.next();
                            Iterator cIter = this.getChildrenClasses(feature).iterator();
                            while (cIter.hasNext()) {
                                GenClass childClass = (GenClass)cIter.next();
                                progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingCreateChildIcon_message", new Object[]{this.getCreateChildIconFileName(feature, childClass)}));
                                this.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), Generator.EMF_EDIT_PROJECT_STYLE, this.getGenModel().getEffectiveModelPluginVariables(), this.getCreateChildIconFileName(feature, childClass), ((GenModelImpl)this.getGenModel()).getCreateChildGIFEmitter(), this.getName(), childClass.getName());
                            }
                        }
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var6_3 = null;
                    progressMonitor.done();
                    throw throwable;
                }
            }
            progressMonitor.done();
            return;
        }
        Object var6_4 = null;
        progressMonitor.done();
    }

    public boolean reconcile(GenClass oldGenClassVersion) {
        if (this.getEcoreClass().getName().equals(oldGenClassVersion.getEcoreClass().getName())) {
            Iterator j;
            Iterator i = this.getGenFeatures().iterator();
            block0: while (i.hasNext()) {
                GenFeature genFeature = (GenFeature)i.next();
                j = oldGenClassVersion.getGenFeatures().iterator();
                while (j.hasNext()) {
                    GenFeature oldGenFeatureVersion = (GenFeature)j.next();
                    if (genFeature.reconcile(oldGenFeatureVersion)) continue block0;
                }
            }
            i = this.getGenOperations().iterator();
            block2: while (i.hasNext()) {
                GenOperation genOperation = (GenOperation)i.next();
                j = oldGenClassVersion.getGenOperations().iterator();
                while (j.hasNext()) {
                    GenOperation oldGenOperation = (GenOperation)j.next();
                    if (genOperation.reconcile(oldGenOperation)) continue block2;
                }
            }
            this.reconcileSettings(oldGenClassVersion);
            return true;
        }
        return false;
    }

    protected void reconcileSettings(GenClass oldGenClassVersion) {
        EStructuralFeature newLabelFeature;
        this.setProvider(oldGenClassVersion.getProvider());
        this.setImage(oldGenClassVersion.isImage());
        GenFeature oldLabelFeature = ((GenClassImpl)oldGenClassVersion).getLabelFeatureGen();
        if (oldLabelFeature != null && (newLabelFeature = this.getEcoreClass().getEStructuralFeature(oldLabelFeature.getEcoreFeature().getName())) != null) {
            this.setLabelFeature(this.findGenFeature(newLabelFeature));
        }
    }

    public boolean reconcile() {
        EClass eClass = this.getEcoreClass();
        if (eClass == null || eClass.eIsProxy() || eClass.eResource() == null) {
            return false;
        }
        Iterator i = this.getGenFeatures().iterator();
        while (i.hasNext()) {
            GenFeature genFeature = (GenFeature)i.next();
            if (genFeature.reconcile()) continue;
            i.remove();
        }
        i = this.getGenOperations().iterator();
        while (i.hasNext()) {
            GenOperation genOperation = (GenOperation)i.next();
            if (genOperation.reconcile()) continue;
            i.remove();
        }
        return true;
    }

    public List getGenConstraints() {
        UniqueEList result = new UniqueEList((Collection)super.getGenConstraints());
        Iterator i = this.getGenOperations().iterator();
        while (i.hasNext()) {
            GenOperation genOperation = (GenOperation)i.next();
            if (!genOperation.isInvariant()) continue;
            result.add(genOperation.getName());
        }
        return result;
    }

    public List getAllGenConstraints() {
        ArrayList result = new ArrayList(INTRINSIC_CONSTRAINTS);
        result.addAll(this.collectGenConstraints(this.getAllBaseGenClasses(), this.getGenConstraints(), null));
        return result;
    }

    public GenClassifier getConstraintImplementor(String constraint) {
        if (this.getGenConstraints().contains(constraint)) {
            return this;
        }
        Iterator i = this.getBaseGenClasses().iterator();
        while (i.hasNext()) {
            GenClass baseGenClass = (GenClass)i.next();
            if (baseGenClass.getGenConstraints().contains(constraint)) {
                return baseGenClass;
            }
            if (!baseGenClass.getAllGenConstraints().contains(constraint)) continue;
            return baseGenClass.getConstraintImplementor(constraint);
        }
        return null;
    }

    public GenClassifier getConstraintDelegate(String constraint) {
        Iterator i = this.getBaseGenClasses().iterator();
        while (i.hasNext()) {
            GenClass baseGenClass = (GenClass)i.next();
            if (baseGenClass.getGenConstraints().contains(constraint)) {
                return baseGenClass;
            }
            if (!baseGenClass.getAllGenConstraints().contains(constraint)) continue;
            return baseGenClass.getConstraintImplementor(constraint);
        }
        return null;
    }

    public boolean hasOnlyDefaultConstraints() {
        Iterator i = this.getAllGenConstraints().iterator();
        while (i.hasNext()) {
            String genConstraint = (String)i.next();
            if (this.getConstraintImplementor(genConstraint) == null) continue;
            return false;
        }
        return true;
    }

    public GenOperation getInvariantOperation(String constraint) {
        Iterator j = this.getGenOperations().iterator();
        while (j.hasNext()) {
            GenOperation genOperation = (GenOperation)j.next();
            if (!genOperation.getName().equals(constraint) || !genOperation.isInvariant()) continue;
            return genOperation;
        }
        return null;
    }

    public boolean isDocumentRoot() {
        return this.getExtendedMetaData().getDocumentRoot(this.getEcoreClass().getEPackage()) == this.getEcoreClass();
    }

    protected boolean isMixed() {
        return this.getExtendedMetaData().getContentKind(this.getEcoreClass()) == 3;
    }

    public GenFeature getMixedGenFeature() {
        if (!this.isMixed()) {
            return null;
        }
        EAttribute mixedFeature = this.getExtendedMetaData().getMixedFeature(this.getEcoreClass());
        return mixedFeature != null ? this.findGenFeature((EStructuralFeature)mixedFeature) : null;
    }
}

