/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;

public class ItemPropertyDescriptor
implements IItemPropertyDescriptor,
IItemPropertyDescriptor.OverrideableCommandOwner {
    public static final Object BOOLEAN_VALUE_IMAGE = EMFEditPlugin.INSTANCE.getImage("full/obj16/BooleanValue");
    public static final Object GENERIC_VALUE_IMAGE = EMFEditPlugin.INSTANCE.getImage("full/obj16/GenericValue");
    public static final Object INTEGRAL_VALUE_IMAGE = EMFEditPlugin.INSTANCE.getImage("full/obj16/IntegralValue");
    public static final Object REAL_VALUE_IMAGE = EMFEditPlugin.INSTANCE.getImage("full/obj16/RealValue");
    public static final Object TEXT_VALUE_IMAGE = EMFEditPlugin.INSTANCE.getImage("full/obj16/TextValue");
    protected AdapterFactory adapterFactory;
    protected ResourceLocator resourceLocator;
    protected AdapterFactoryItemDelegator itemDelegator;
    protected boolean isSettable;
    protected String displayName;
    protected String description;
    protected EStructuralFeature feature;
    protected EReference[] parentReferences;
    protected String category;
    protected String[] filterFlags;
    protected Object staticImage;
    protected Object commandOwner;
    protected static final EcorePackage ecorePackage = EcorePackage.eINSTANCE;

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature) {
        this(adapterFactory, null, displayName, description, feature, true, null, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature) {
        this(adapterFactory, resourceLocator, displayName, description, feature, true, null, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable) {
        this(adapterFactory, null, displayName, description, feature, isSettable, null, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable) {
        this(adapterFactory, resourceLocator, displayName, description, feature, isSettable, null, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage) {
        this(adapterFactory, null, displayName, description, feature, isSettable, staticImage, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage) {
        this(adapterFactory, resourceLocator, displayName, description, feature, isSettable, staticImage, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category) {
        this(adapterFactory, null, displayName, description, feature, isSettable, null, category, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category) {
        this(adapterFactory, resourceLocator, displayName, description, feature, isSettable, null, category, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage, String category) {
        this(adapterFactory, null, displayName, description, feature, isSettable, staticImage, category, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage, String category) {
        this(adapterFactory, resourceLocator, displayName, description, feature, isSettable, staticImage, category, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category, String[] filterFlags) {
        this(adapterFactory, null, displayName, description, feature, isSettable, null, category, filterFlags);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, String category, String[] filterFlags) {
        this(adapterFactory, resourceLocator, displayName, description, feature, isSettable, null, category, filterFlags);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage, String category, String[] filterFlags) {
        this(adapterFactory, null, displayName, description, feature, isSettable, staticImage, category, filterFlags);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage, String category, String[] filterFlags) {
        this.adapterFactory = adapterFactory;
        this.resourceLocator = resourceLocator;
        this.itemDelegator = new ItemDelegator(adapterFactory, resourceLocator);
        this.displayName = displayName;
        this.description = description;
        this.feature = feature;
        this.isSettable = isSettable;
        this.staticImage = staticImage;
        this.category = category;
        this.filterFlags = filterFlags;
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences) {
        this(adapterFactory, null, displayName, description, parentReferences, true, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences) {
        this(adapterFactory, resourceLocator, displayName, description, parentReferences, true, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences, boolean isSettable) {
        this(adapterFactory, null, displayName, description, parentReferences, isSettable, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences, boolean isSettable) {
        this(adapterFactory, resourceLocator, displayName, description, parentReferences, isSettable, null, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category) {
        this(adapterFactory, null, displayName, description, parentReferences, isSettable, category, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category) {
        this(adapterFactory, resourceLocator, displayName, description, parentReferences, isSettable, category, null);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category, String[] filterFlags) {
        this(adapterFactory, null, displayName, description, parentReferences, isSettable, category, filterFlags);
    }

    public ItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EReference[] parentReferences, boolean isSettable, String category, String[] filterFlags) {
        this.adapterFactory = adapterFactory;
        this.resourceLocator = resourceLocator;
        this.itemDelegator = new ItemDelegator(adapterFactory, resourceLocator);
        this.displayName = displayName;
        this.description = description;
        this.parentReferences = parentReferences;
        this.isSettable = isSettable;
        this.category = category;
        this.filterFlags = filterFlags;
    }

    public String getCategory(Object object) {
        return this.category;
    }

    public String getDescription(Object object) {
        return this.description;
    }

    public String getDisplayName(Object object) {
        return this.displayName;
    }

    public String[] getFilterFlags(Object object) {
        return this.filterFlags;
    }

    public String getId(Object object) {
        return this.displayName;
    }

    public Object getHelpContextIds(Object object) {
        return new String[0];
    }

    protected Collection getComboBoxObjects(Object object) {
        if (object instanceof EObject) {
            if (this.parentReferences != null) {
                UniqueEList result = new UniqueEList();
                int i = 0;
                while (i < this.parentReferences.length) {
                    result.addAll(ItemPropertyDescriptor.getReachableObjectsOfType((EObject)object, this.parentReferences[i].getEType()));
                    ++i;
                }
                return result;
            }
            if (this.feature != null) {
                if (this.feature instanceof EReference) {
                    Collection result = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)object, this.feature.getEType());
                    if (!this.feature.isMany() && !result.contains(null)) {
                        result.add(null);
                    }
                    return result;
                }
                if (this.feature.getEType() instanceof EEnum) {
                    EEnum eEnum = (EEnum)this.feature.getEType();
                    ArrayList<Enumerator> enumerators = new ArrayList<Enumerator>();
                    Iterator iter = eEnum.getELiterals().iterator();
                    while (iter.hasNext()) {
                        enumerators.add(((EEnumLiteral)iter.next()).getInstance());
                    }
                    return enumerators;
                }
            }
        }
        return null;
    }

    public static Collection getReachableObjectsOfType(EObject object, EClassifier type) {
        HashSet visited = new HashSet();
        ArrayList result = new ArrayList();
        Resource resource = object.eResource();
        if (resource != null) {
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null) {
                TreeIterator i = resourceSet.getAllContents();
                while (i.hasNext()) {
                    Object child = i.next();
                    if (!(child instanceof EObject)) continue;
                    ItemPropertyDescriptor.collectReachableObjectsOfType(visited, result, (EObject)child, type);
                    i.prune();
                }
            } else {
                Iterator i = resource.getContents().iterator();
                while (i.hasNext()) {
                    ItemPropertyDescriptor.collectReachableObjectsOfType(visited, result, (EObject)i.next(), type);
                }
            }
        } else {
            ItemPropertyDescriptor.collectReachableObjectsOfType(visited, result, EcoreUtil.getRootContainer((EObject)object), type);
        }
        return result;
    }

    public static void collectReachableObjectsOfType(Collection visited, Collection result, EObject object, EClassifier type) {
        if (visited.add(object)) {
            EClass metaObject;
            EList eReferenceList;
            if (type.isInstance((Object)object)) {
                result.add(object);
            }
            if ((eReferenceList = (metaObject = object.eClass()).getEAllReferences()) != null) {
                Iterator eReferences = eReferenceList.iterator();
                while (eReferences.hasNext()) {
                    EReference eReference = (EReference)eReferences.next();
                    if (eReference.isMany()) {
                        Iterator referencedObjects = ((List)object.eGet((EStructuralFeature)eReference)).iterator();
                        while (referencedObjects.hasNext()) {
                            Object referencedObject = referencedObjects.next();
                            if (!(referencedObject instanceof EObject)) continue;
                            ItemPropertyDescriptor.collectReachableObjectsOfType(visited, result, (EObject)referencedObject, type);
                        }
                        continue;
                    }
                    Object referencedObject = object.eGet((EStructuralFeature)eReference);
                    if (!(referencedObject instanceof EObject)) continue;
                    ItemPropertyDescriptor.collectReachableObjectsOfType(visited, result, (EObject)referencedObject, type);
                }
            }
        }
    }

    public IItemLabelProvider getLabelProvider(Object object) {
        return this.itemDelegator;
    }

    public boolean isCompatibleWith(Object object, Object anotherObject, IItemPropertyDescriptor anotherItemPropertyDescriptor) {
        return false;
    }

    protected Object createPropertyValueWrapper(Object object, Object propertyValue) {
        return new PropertyValueWrapper(this.adapterFactory, object, propertyValue, null);
    }

    public static Object getDefaultValue(EClassifier eType) {
        if (eType.getEPackage() == EcorePackage.eINSTANCE) {
            switch (eType.getClassifierID()) {
                case 20: 
                case 21: {
                    return Boolean.FALSE;
                }
                case 22: 
                case 24: {
                    return new Byte(0);
                }
                case 25: 
                case 26: {
                    return new Character(' ');
                }
                case 29: 
                case 30: {
                    return new Double(0.0);
                }
                case 35: 
                case 36: {
                    return new Float(0.0);
                }
                case 37: 
                case 38: {
                    return new Integer(0);
                }
                case 41: 
                case 42: {
                    return new Long(0L);
                }
                case 46: 
                case 47: {
                    return new Short(0);
                }
                case 48: {
                    return "";
                }
            }
        } else if (eType instanceof EEnum) {
            return ((EEnumLiteral)((EEnum)eType).getELiterals().get(0)).getInstance();
        }
        return null;
    }

    protected Object getValue(EObject object, EStructuralFeature feature) {
        return object.eGet(feature);
    }

    public Object getPropertyValue(Object object) {
        EObject eObject = (EObject)object;
        if (this.feature instanceof EAttribute) {
            EAttribute attribute = (EAttribute)this.feature;
            Object result = this.getValue(eObject, (EStructuralFeature)attribute);
            if (result == null) {
                return ItemPropertyDescriptor.getDefaultValue(attribute.getEType());
            }
            return this.createPropertyValueWrapper(object, result);
        }
        if (this.parentReferences != null) {
            int i = 0;
            while (i < this.parentReferences.length) {
                Object result = this.getValue(eObject, (EStructuralFeature)this.parentReferences[i]);
                if (result != null) {
                    return this.createPropertyValueWrapper(object, result);
                }
                ++i;
            }
            return "";
        }
        return this.createPropertyValueWrapper(object, this.getValue(eObject, this.feature));
    }

    public boolean isPropertySet(Object object) {
        EObject eObject = (EObject)object;
        if (this.parentReferences != null) {
            int i = 0;
            while (i < this.parentReferences.length) {
                if (eObject.eGet((EStructuralFeature)this.parentReferences[i]) != null) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this.feature instanceof EAttribute ? (this.feature.isMany() ? !((List)eObject.eGet(this.feature)).isEmpty() : eObject.eIsSet(this.feature)) : eObject.eGet(this.feature) != null;
    }

    public boolean canSetProperty(Object object) {
        return this.isSettable;
    }

    public void setCommandOwner(Object commandOwner) {
        this.commandOwner = commandOwner;
    }

    public Object getCommandOwner() {
        return this.commandOwner;
    }

    protected Object getCommandOwner(Object fallback) {
        return this.commandOwner != null ? this.commandOwner : fallback;
    }

    public void resetPropertyValue(Object object) {
        EObject eObject = (EObject)object;
        EditingDomain editingDomain = this.getEditingDomain(object);
        if (this.parentReferences != null) {
            int i = 0;
            while (i < this.parentReferences.length) {
                EReference parentReference = this.parentReferences[i];
                if (eObject.eIsSet((EStructuralFeature)parentReference)) {
                    if (editingDomain == null) {
                        eObject.eUnset((EStructuralFeature)this.parentReferences[i]);
                    } else {
                        editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(eObject), parentReference, null));
                    }
                    break;
                }
                ++i;
            }
        } else if (editingDomain == null) {
            eObject.eUnset(this.feature);
        } else if (this.feature.isMany()) {
            editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(eObject), this.feature, Collections.EMPTY_LIST));
        } else {
            editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(eObject), this.feature, null));
        }
    }

    public EditingDomain getEditingDomain(Object object) {
        EObject eObject = (EObject)object;
        EditingDomain result = AdapterFactoryEditingDomain.getEditingDomainFor(eObject);
        if (result == null) {
            ComposeableAdapterFactory rootAdapterFactory;
            if (this.adapterFactory instanceof IEditingDomainProvider) {
                result = ((IEditingDomainProvider)this.adapterFactory).getEditingDomain();
            }
            if (result == null && this.adapterFactory instanceof ComposeableAdapterFactory && (rootAdapterFactory = ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory()) instanceof IEditingDomainProvider) {
                result = ((IEditingDomainProvider)((Object)rootAdapterFactory)).getEditingDomain();
            }
        }
        return result;
    }

    public void setPropertyValue(Object object, Object value) {
        EObject eObject = (EObject)object;
        EditingDomain editingDomain = this.getEditingDomain(object);
        if (this.parentReferences != null) {
            Command removeCommand = null;
            int i = 0;
            while (i < this.parentReferences.length) {
                Object oldValue = eObject.eGet((EStructuralFeature)this.parentReferences[i]);
                if (oldValue != null) {
                    EReference parentReference = this.parentReferences[i];
                    if (oldValue == value) {
                        return;
                    }
                    if (parentReference.getEType().isInstance(value)) {
                        if (editingDomain == null) {
                            eObject.eSet((EStructuralFeature)parentReference, value);
                        } else {
                            editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(eObject), parentReference, value));
                        }
                        return;
                    }
                    if (editingDomain == null) {
                        eObject.eSet((EStructuralFeature)parentReference, null);
                        break;
                    }
                    removeCommand = SetCommand.create(editingDomain, this.getCommandOwner(eObject), parentReference, null);
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < this.parentReferences.length) {
                EReference parentReference = this.parentReferences[i];
                if (parentReference.getEType().isInstance(value)) {
                    if (editingDomain == null) {
                        eObject.eSet((EStructuralFeature)this.parentReferences[i], value);
                    } else if (removeCommand != null) {
                        CompoundCommand compoundCommand = new CompoundCommand(Integer.MIN_VALUE);
                        compoundCommand.append(removeCommand);
                        compoundCommand.append(SetCommand.create(editingDomain, this.getCommandOwner(eObject), parentReference, value));
                        editingDomain.getCommandStack().execute((Command)compoundCommand);
                    } else {
                        editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(eObject), parentReference, value));
                    }
                    break;
                }
                ++i;
            }
        } else if (editingDomain == null) {
            eObject.eSet(this.feature, value);
        } else {
            editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(eObject), this.feature, value));
        }
    }

    public Object getFeature(Object object) {
        if (this.feature != null) {
            return this.feature;
        }
        if (this.parentReferences != null) {
            return this.parentReferences;
        }
        return null;
    }

    public boolean isMany(Object object) {
        return this.parentReferences == null && this.feature != null && this.feature.isMany();
    }

    public Collection getChoiceOfValues(Object object) {
        return this.getComboBoxObjects(object);
    }

    protected class ItemDelegator
    extends AdapterFactoryItemDelegator {
        protected ResourceLocator resourceLocator;

        public ItemDelegator(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public ItemDelegator(AdapterFactory adapterFactory, ResourceLocator resourceLocator) {
            super(adapterFactory);
            this.resourceLocator = resourceLocator;
        }

        public String getText(Object object) {
            EDataType eDataType;
            if (ItemPropertyDescriptor.this.feature instanceof EAttribute && (eDataType = ((EAttribute)ItemPropertyDescriptor.this.feature).getEAttributeType()).isSerializable()) {
                if (ItemPropertyDescriptor.this.isMany(object)) {
                    if (object instanceof List) {
                        StringBuffer result = new StringBuffer();
                        Iterator i = ((List)object).iterator();
                        while (i.hasNext()) {
                            Object value = i.next();
                            result.append(this.convert(eDataType, value));
                            if (!i.hasNext()) continue;
                            result.append(", ");
                        }
                        return result.toString();
                    }
                } else if (eDataType.isInstance(object)) {
                    return this.convert(eDataType, object);
                }
            }
            return super.getText(object);
        }

        protected String convert(EDataType eDataType, Object value) {
            if (this.resourceLocator != null) {
                if (eDataType instanceof EEnum) {
                    try {
                        return this.resourceLocator.getString("_UI_" + eDataType.getName() + "_" + ((AbstractEnumerator)value).getName() + "_literal");
                    }
                    catch (MissingResourceException missingResourceException) {
                    }
                } else if (value instanceof Boolean) {
                    try {
                        return this.resourceLocator.getString(Boolean.TRUE.equals(value) ? "_UI_Boolean_true_literal" : "_UI_Boolean_false_literal");
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
            }
            return EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
        }

        public Object getImage(Object object) {
            return ItemPropertyDescriptor.this.staticImage == null ? super.getImage(object) : ItemPropertyDescriptor.this.staticImage;
        }
    }

    public static class PropertyValueWrapper
    implements IItemLabelProvider,
    IItemPropertySource {
        protected Object object;
        protected Object propertyValue;
        protected Object nestedPropertySource;
        protected AdapterFactoryItemDelegator itemDelegator;

        public PropertyValueWrapper(AdapterFactory adapterFactory, Object object, Object propertyValue, Object nestedPropertySource) {
            this.object = object;
            this.propertyValue = propertyValue;
            this.nestedPropertySource = nestedPropertySource;
            this.itemDelegator = new AdapterFactoryItemDelegator(adapterFactory);
        }

        public String getText(Object thisObject) {
            return this.itemDelegator.getText(this.propertyValue);
        }

        public Object getImage(Object thisObject) {
            return this.itemDelegator.getImage(this.propertyValue);
        }

        public List getPropertyDescriptors(Object thisObject) {
            List list = this.itemDelegator.getPropertyDescriptors(this.nestedPropertySource);
            if (list != null) {
                ArrayList<IItemPropertyDescriptor> result = new ArrayList<IItemPropertyDescriptor>(list.size());
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    IItemPropertyDescriptor itemPropertyDescriptor = (IItemPropertyDescriptor)i.next();
                    result.add(this.createPropertyDescriptorDecorator(this.nestedPropertySource, itemPropertyDescriptor));
                }
                return result;
            }
            return Collections.EMPTY_LIST;
        }

        public IItemPropertyDescriptor getPropertyDescriptor(Object thisObject, Object propertyId) {
            return this.createPropertyDescriptorDecorator(this.nestedPropertySource, this.itemDelegator.getPropertyDescriptor(this.nestedPropertySource, propertyId));
        }

        public Object getEditableValue(Object thisObject) {
            return this.propertyValue;
        }

        protected IItemPropertyDescriptor createPropertyDescriptorDecorator(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            return new ItemPropertyDescriptorDecorator(object, itemPropertyDescriptor);
        }
    }
}

