/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: SDOPackage.java,v 1.3 2004/12/15 21:22:13 marcelop Exp $
 */
package org.eclipse.emf.ecore.sdo;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.change.ChangePackage;

import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.ecore.sdo.SDOFactory
 * @generated
 */
public interface SDOPackage extends EPackage{
  /**
   * The package name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNAME = "sdo";

  /**
   * The package namespace URI.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_URI = "http://www.eclipse.org/emf/2003/SDO";

  /**
   * The package namespace name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_PREFIX = "sdo";

  /**
   * The singleton instance of the package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  SDOPackage eINSTANCE = org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl.init();

  /**
   * The meta object id for the '{@link org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl <em>EData Object</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getEDataObject()
   * @generated
   */
  int EDATA_OBJECT = 3;

  /**
   * The meta object id for the '{@link commonj.sdo.DataGraph <em>Data Graph</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see commonj.sdo.DataGraph
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getDataGraph()
   * @generated
   */
  int DATA_GRAPH = 7;

  /**
   * The meta object id for the '{@link org.eclipse.emf.ecore.sdo.impl.EDataGraphImpl <em>EData Graph</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.sdo.impl.EDataGraphImpl
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getEDataGraph()
   * @generated
   */
  int EDATA_GRAPH = 2;

  /**
   * The meta object id for the '{@link commonj.sdo.ChangeSummary <em>Change Summary</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see commonj.sdo.ChangeSummary
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getChangeSummary()
   * @generated
   */
  int CHANGE_SUMMARY = 5;

  /**
   * The meta object id for the '{@link org.eclipse.emf.ecore.sdo.impl.EChangeSummaryImpl <em>EChange Summary</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.sdo.impl.EChangeSummaryImpl
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getEChangeSummary()
   * @generated
   */
  int ECHANGE_SUMMARY = 0;

  /**
   * The feature id for the '<em><b>Object Changes</b></em>' map.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY__OBJECT_CHANGES = ChangePackage.CHANGE_DESCRIPTION__OBJECT_CHANGES;

  /**
   * The feature id for the '<em><b>Objects To Detach</b></em>' reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY__OBJECTS_TO_DETACH = ChangePackage.CHANGE_DESCRIPTION__OBJECTS_TO_DETACH;

  /**
   * The feature id for the '<em><b>Objects To Attach</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY__OBJECTS_TO_ATTACH = ChangePackage.CHANGE_DESCRIPTION__OBJECTS_TO_ATTACH;

  /**
   * The feature id for the '<em><b>Resource Changes</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY__RESOURCE_CHANGES = ChangePackage.CHANGE_DESCRIPTION__RESOURCE_CHANGES;

  /**
   * The feature id for the '<em><b>Logging</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY__LOGGING = ChangePackage.CHANGE_DESCRIPTION_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Data Graph</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY__DATA_GRAPH = ChangePackage.CHANGE_DESCRIPTION_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Changed Data Objects</b></em>' reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY__CHANGED_DATA_OBJECTS = ChangePackage.CHANGE_DESCRIPTION_FEATURE_COUNT + 2;

  /**
   * The feature id for the '<em><b>EData Graph</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY__EDATA_GRAPH = ChangePackage.CHANGE_DESCRIPTION_FEATURE_COUNT + 3;

  /**
   * The meta object id for the '{@link commonj.sdo.Property <em>Property</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see commonj.sdo.Property
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getProperty()
   * @generated
   */
  int PROPERTY = 11;

  /**
   * The meta object id for the '{@link org.eclipse.emf.ecore.sdo.impl.EPropertyImpl <em>EProperty</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.sdo.impl.EPropertyImpl
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getEProperty()
   * @generated
   */
  int EPROPERTY = 4;

  /**
   * The meta object id for the '{@link commonj.sdo.Type <em>Type</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see commonj.sdo.Type
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getType()
   * @generated
   */
  int TYPE = 13;

  /**
   * The meta object id for the '{@link org.eclipse.emf.ecore.sdo.impl.ETypeImpl <em>EType</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.sdo.impl.ETypeImpl
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getEType()
   * @generated
   */
  int ETYPE = 10;

  /**
   * The meta object id for the '{@link commonj.sdo.Sequence <em>Sequence</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see commonj.sdo.Sequence
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getSequence()
   * @generated
   */
  int SEQUENCE = 12;

  /**
   * The meta object id for the '{@link commonj.sdo.DataObject <em>Data Object</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see commonj.sdo.DataObject
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getDataObject()
   * @generated
   */
  int DATA_OBJECT = 8;

  /**
   * The number of structural features of the the '<em>EChange Summary</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY_FEATURE_COUNT = ChangePackage.CHANGE_DESCRIPTION_FEATURE_COUNT + 4;

  /**
   * The meta object id for the '{@link commonj.sdo.ChangeSummary.Setting <em>Change Summary Setting</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see commonj.sdo.ChangeSummary.Setting
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getChangeSummarySetting()
   * @generated
   */
  int CHANGE_SUMMARY_SETTING = 6;

  /**
   * The meta object id for the '{@link org.eclipse.emf.ecore.sdo.impl.EChangeSummarySettingImpl <em>EChange Summary Setting</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.sdo.impl.EChangeSummarySettingImpl
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getEChangeSummarySetting()
   * @generated
   */
  int ECHANGE_SUMMARY_SETTING = 1;

  /**
   * The feature id for the '<em><b>Feature Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY_SETTING__FEATURE_NAME = ChangePackage.FEATURE_CHANGE__FEATURE_NAME;

  /**
   * The feature id for the '<em><b>Data Value</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY_SETTING__DATA_VALUE = ChangePackage.FEATURE_CHANGE__DATA_VALUE;

  /**
   * The feature id for the '<em><b>Set</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY_SETTING__SET = ChangePackage.FEATURE_CHANGE__SET;

  /**
   * The feature id for the '<em><b>Value</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY_SETTING__VALUE = ChangePackage.FEATURE_CHANGE__VALUE;

  /**
   * The feature id for the '<em><b>Feature</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY_SETTING__FEATURE = ChangePackage.FEATURE_CHANGE__FEATURE;

  /**
   * The feature id for the '<em><b>Reference Value</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY_SETTING__REFERENCE_VALUE = ChangePackage.FEATURE_CHANGE__REFERENCE_VALUE;

  /**
   * The feature id for the '<em><b>List Changes</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY_SETTING__LIST_CHANGES = ChangePackage.FEATURE_CHANGE__LIST_CHANGES;

  /**
   * The feature id for the '<em><b>Property</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY_SETTING__PROPERTY = ChangePackage.FEATURE_CHANGE_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the the '<em>EChange Summary Setting</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ECHANGE_SUMMARY_SETTING_FEATURE_COUNT = ChangePackage.FEATURE_CHANGE_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Root Object</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_GRAPH__ROOT_OBJECT = 0;

  /**
   * The feature id for the '<em><b>Change Summary</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_GRAPH__CHANGE_SUMMARY = 1;

  /**
   * The number of structural features of the the '<em>Data Graph</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_GRAPH_FEATURE_COUNT = 2;

  /**
   * The feature id for the '<em><b>Root Object</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_GRAPH__ROOT_OBJECT = DATA_GRAPH__ROOT_OBJECT;

  /**
   * The feature id for the '<em><b>Change Summary</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_GRAPH__CHANGE_SUMMARY = DATA_GRAPH__CHANGE_SUMMARY;

  /**
   * The feature id for the '<em><b>Resource Set</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_GRAPH__RESOURCE_SET = DATA_GRAPH_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Root Resource</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_GRAPH__ROOT_RESOURCE = DATA_GRAPH_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>EChange Summary</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_GRAPH__ECHANGE_SUMMARY = DATA_GRAPH_FEATURE_COUNT + 2;

  /**
   * The feature id for the '<em><b>ERoot Object</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_GRAPH__EROOT_OBJECT = DATA_GRAPH_FEATURE_COUNT + 3;

  /**
   * The number of structural features of the the '<em>EData Graph</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_GRAPH_FEATURE_COUNT = DATA_GRAPH_FEATURE_COUNT + 4;

  /**
   * The number of structural features of the the '<em>EData Object</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_FEATURE_COUNT = EcorePackage.EOBJECT_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PROPERTY__NAME = 0;

  /**
   * The feature id for the '<em><b>Many</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PROPERTY__MANY = 1;

  /**
   * The feature id for the '<em><b>Containment</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PROPERTY__CONTAINMENT = 2;

  /**
   * The feature id for the '<em><b>Default</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PROPERTY__DEFAULT = 3;

  /**
   * The feature id for the '<em><b>Type</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PROPERTY__TYPE = 4;

  /**
   * The feature id for the '<em><b>Containing Type</b></em>' container reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PROPERTY__CONTAINING_TYPE = 5;

  /**
   * The number of structural features of the the '<em>Property</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PROPERTY_FEATURE_COUNT = 6;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EPROPERTY__NAME = PROPERTY__NAME;

  /**
   * The feature id for the '<em><b>Many</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EPROPERTY__MANY = PROPERTY__MANY;

  /**
   * The feature id for the '<em><b>Containment</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EPROPERTY__CONTAINMENT = PROPERTY__CONTAINMENT;

  /**
   * The feature id for the '<em><b>Default</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EPROPERTY__DEFAULT = PROPERTY__DEFAULT;

  /**
   * The feature id for the '<em><b>Type</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EPROPERTY__TYPE = PROPERTY__TYPE;

  /**
   * The feature id for the '<em><b>Containing Type</b></em>' container reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EPROPERTY__CONTAINING_TYPE = PROPERTY__CONTAINING_TYPE;

  /**
   * The feature id for the '<em><b>EStructural Feature</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EPROPERTY__ESTRUCTURAL_FEATURE = PROPERTY_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the the '<em>EProperty</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EPROPERTY_FEATURE_COUNT = PROPERTY_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Logging</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHANGE_SUMMARY__LOGGING = 0;

  /**
   * The feature id for the '<em><b>Data Graph</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHANGE_SUMMARY__DATA_GRAPH = 1;

  /**
   * The feature id for the '<em><b>Changed Data Objects</b></em>' reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHANGE_SUMMARY__CHANGED_DATA_OBJECTS = 2;

  /**
   * The number of structural features of the the '<em>Change Summary</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHANGE_SUMMARY_FEATURE_COUNT = 3;

  /**
   * The feature id for the '<em><b>Property</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHANGE_SUMMARY_SETTING__PROPERTY = 0;

  /**
   * The number of structural features of the the '<em>Change Summary Setting</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CHANGE_SUMMARY_SETTING_FEATURE_COUNT = 1;

  /**
   * The number of structural features of the the '<em>Data Object</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_OBJECT_FEATURE_COUNT = 0;


  /**
   * The number of structural features of the the '<em>Sequence</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int SEQUENCE_FEATURE_COUNT = 0;


  /**
   * The meta object id for the '{@link org.eclipse.emf.ecore.sdo.util.ESequence <em>ESequence</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.sdo.util.ESequence
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getESequence()
   * @generated
   */
  int ESEQUENCE = 9;

  /**
   * The number of structural features of the the '<em>ESequence</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ESEQUENCE_FEATURE_COUNT = SEQUENCE_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TYPE__NAME = 0;

  /**
   * The feature id for the '<em><b>URI</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TYPE__URI = 1;

  /**
   * The feature id for the '<em><b>Instance Class</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TYPE__INSTANCE_CLASS = 2;

  /**
   * The feature id for the '<em><b>Properties</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TYPE__PROPERTIES = 3;

  /**
   * The number of structural features of the the '<em>Type</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TYPE_FEATURE_COUNT = 4;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ETYPE__NAME = TYPE__NAME;

  /**
   * The feature id for the '<em><b>URI</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ETYPE__URI = TYPE__URI;

  /**
   * The feature id for the '<em><b>Instance Class</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ETYPE__INSTANCE_CLASS = TYPE__INSTANCE_CLASS;

  /**
   * The feature id for the '<em><b>Properties</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ETYPE__PROPERTIES = TYPE__PROPERTIES;

  /**
   * The feature id for the '<em><b>EClassifier</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ETYPE__ECLASSIFIER = TYPE_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the the '<em>EType</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ETYPE_FEATURE_COUNT = TYPE_FEATURE_COUNT + 1;

  /**
   * The meta object id for the '{@link org.eclipse.emf.ecore.sdo.InternalEDataObject <em>Internal EData Object</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.sdo.InternalEDataObject
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getInternalEDataObject()
   * @generated
   */
  int INTERNAL_EDATA_OBJECT = 14;

  /**
   * The number of structural features of the the '<em>Internal EData Object</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INTERNAL_EDATA_OBJECT_FEATURE_COUNT = EDATA_OBJECT_FEATURE_COUNT + 0;

  /**
   * The meta object id for the '{@link org.eclipse.emf.ecore.sdo.impl.EDataObjectAnyTypeImpl <em>EData Object Any Type</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.sdo.impl.EDataObjectAnyTypeImpl
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getEDataObjectAnyType()
   * @generated
   */
  int EDATA_OBJECT_ANY_TYPE = 15;

  /**
   * The feature id for the '<em><b>Mixed</b></em>' attribute list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_ANY_TYPE__MIXED = XMLTypePackage.ANY_TYPE__MIXED;

  /**
   * The feature id for the '<em><b>Any</b></em>' attribute list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_ANY_TYPE__ANY = XMLTypePackage.ANY_TYPE__ANY;

  /**
   * The feature id for the '<em><b>Any Attribute</b></em>' attribute list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_ANY_TYPE__ANY_ATTRIBUTE = XMLTypePackage.ANY_TYPE__ANY_ATTRIBUTE;

  /**
   * The number of structural features of the the '<em>EData Object Any Type</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_ANY_TYPE_FEATURE_COUNT = XMLTypePackage.ANY_TYPE_FEATURE_COUNT + 0;

  /**
   * The meta object id for the '{@link org.eclipse.emf.ecore.sdo.impl.EDataObjectSimpleAnyTypeImpl <em>EData Object Simple Any Type</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.sdo.impl.EDataObjectSimpleAnyTypeImpl
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getEDataObjectSimpleAnyType()
   * @generated
   */
  int EDATA_OBJECT_SIMPLE_ANY_TYPE = 16;

  /**
   * The feature id for the '<em><b>Mixed</b></em>' attribute list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_SIMPLE_ANY_TYPE__MIXED = XMLTypePackage.SIMPLE_ANY_TYPE__MIXED;

  /**
   * The feature id for the '<em><b>Any</b></em>' attribute list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_SIMPLE_ANY_TYPE__ANY = XMLTypePackage.SIMPLE_ANY_TYPE__ANY;

  /**
   * The feature id for the '<em><b>Any Attribute</b></em>' attribute list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_SIMPLE_ANY_TYPE__ANY_ATTRIBUTE = XMLTypePackage.SIMPLE_ANY_TYPE__ANY_ATTRIBUTE;

  /**
   * The feature id for the '<em><b>Raw Value</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_SIMPLE_ANY_TYPE__RAW_VALUE = XMLTypePackage.SIMPLE_ANY_TYPE__RAW_VALUE;

  /**
   * The feature id for the '<em><b>Value</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_SIMPLE_ANY_TYPE__VALUE = XMLTypePackage.SIMPLE_ANY_TYPE__VALUE;

  /**
   * The feature id for the '<em><b>Instance Type</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_SIMPLE_ANY_TYPE__INSTANCE_TYPE = XMLTypePackage.SIMPLE_ANY_TYPE__INSTANCE_TYPE;

  /**
   * The number of structural features of the the '<em>EData Object Simple Any Type</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EDATA_OBJECT_SIMPLE_ANY_TYPE_FEATURE_COUNT = XMLTypePackage.SIMPLE_ANY_TYPE_FEATURE_COUNT + 0;

  /**
   * The meta object id for the '<em>EJava List</em>' data type.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see java.util.List
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getEJavaList()
   * @generated
   */
  int EJAVA_LIST = 17;


  /**
   * The meta object id for the '<em>EObject Stream Exception</em>' data type.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see java.io.ObjectStreamException
   * @see org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl#getEObjectStreamException()
   * @generated
   */
  int EOBJECT_STREAM_EXCEPTION = 18;


  /**
   * Returns the meta object for class '{@link org.eclipse.emf.ecore.sdo.EDataObject <em>EData Object</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>EData Object</em>'.
   * @see org.eclipse.emf.ecore.sdo.EDataObject
   * @generated
   */
  EClass getEDataObject();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.ecore.sdo.EDataGraph <em>EData Graph</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>EData Graph</em>'.
   * @see org.eclipse.emf.ecore.sdo.EDataGraph
   * @generated
   */
  EClass getEDataGraph();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.emf.ecore.sdo.EDataGraph#getResourceSet <em>Resource Set</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Resource Set</em>'.
   * @see org.eclipse.emf.ecore.sdo.EDataGraph#getResourceSet()
   * @see #getEDataGraph()
   * @generated
   */
  EAttribute getEDataGraph_ResourceSet();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.emf.ecore.sdo.EDataGraph#getRootResource <em>Root Resource</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Root Resource</em>'.
   * @see org.eclipse.emf.ecore.sdo.EDataGraph#getRootResource()
   * @see #getEDataGraph()
   * @generated
   */
  EAttribute getEDataGraph_RootResource();

  /**
   * Returns the meta object for the reference '{@link org.eclipse.emf.ecore.sdo.EDataGraph#getEChangeSummary <em>EChange Summary</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>EChange Summary</em>'.
   * @see org.eclipse.emf.ecore.sdo.EDataGraph#getEChangeSummary()
   * @see #getEDataGraph()
   * @generated
   */
  EReference getEDataGraph_EChangeSummary();

  /**
   * Returns the meta object for the reference '{@link org.eclipse.emf.ecore.sdo.EDataGraph#getERootObject <em>ERoot Object</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>ERoot Object</em>'.
   * @see org.eclipse.emf.ecore.sdo.EDataGraph#getERootObject()
   * @see #getEDataGraph()
   * @generated
   */
  EReference getEDataGraph_ERootObject();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.ecore.sdo.EChangeSummary <em>EChange Summary</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>EChange Summary</em>'.
   * @see org.eclipse.emf.ecore.sdo.EChangeSummary
   * @generated
   */
  EClass getEChangeSummary();

  /**
   * Returns the meta object for the reference '{@link org.eclipse.emf.ecore.sdo.EChangeSummary#getEDataGraph <em>EData Graph</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>EData Graph</em>'.
   * @see org.eclipse.emf.ecore.sdo.EChangeSummary#getEDataGraph()
   * @see #getEChangeSummary()
   * @generated
   */
  EReference getEChangeSummary_EDataGraph();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.ecore.sdo.EProperty <em>EProperty</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>EProperty</em>'.
   * @see org.eclipse.emf.ecore.sdo.EProperty
   * @generated
   */
  EClass getEProperty();

  /**
   * Returns the meta object for the reference '{@link org.eclipse.emf.ecore.sdo.EProperty#getEStructuralFeature <em>EStructural Feature</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>EStructural Feature</em>'.
   * @see org.eclipse.emf.ecore.sdo.EProperty#getEStructuralFeature()
   * @see #getEProperty()
   * @generated
   */
  EReference getEProperty_EStructuralFeature();

  /**
   * Returns the meta object for class '{@link commonj.sdo.DataObject <em>Data Object</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Data Object</em>'.
   * @see commonj.sdo.DataObject
   * @model instanceClass="commonj.sdo.DataObject"
   * @generated
   */
  EClass getDataObject();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.ecore.sdo.util.ESequence <em>ESequence</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>ESequence</em>'.
   * @see org.eclipse.emf.ecore.sdo.util.ESequence
   * @model instanceClass="org.eclipse.emf.ecore.sdo.util.ESequence"
   * @generated
   */
  EClass getESequence();

  /**
   * Returns the meta object for class '{@link commonj.sdo.DataGraph <em>Data Graph</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Data Graph</em>'.
   * @see commonj.sdo.DataGraph
   * @model instanceClass="commonj.sdo.DataGraph"
   * @generated
   */
  EClass getDataGraph();

  /**
   * Returns the meta object for the reference '{@link commonj.sdo.DataGraph#getRootObject <em>Root Object</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Root Object</em>'.
   * @see commonj.sdo.DataGraph#getRootObject()
   * @see #getDataGraph()
   * @generated
   */
  EReference getDataGraph_RootObject();

  /**
   * Returns the meta object for the reference '{@link commonj.sdo.DataGraph#getChangeSummary <em>Change Summary</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Change Summary</em>'.
   * @see commonj.sdo.DataGraph#getChangeSummary()
   * @see #getDataGraph()
   * @generated
   */
  EReference getDataGraph_ChangeSummary();

  /**
   * Returns the meta object for class '{@link commonj.sdo.ChangeSummary <em>Change Summary</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Change Summary</em>'.
   * @see commonj.sdo.ChangeSummary
   * @model instanceClass="commonj.sdo.ChangeSummary"
   * @generated
   */
  EClass getChangeSummary();

  /**
   * Returns the meta object for the attribute '{@link commonj.sdo.ChangeSummary#isLogging <em>Logging</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Logging</em>'.
   * @see commonj.sdo.ChangeSummary#isLogging()
   * @see #getChangeSummary()
   * @generated
   */
  EAttribute getChangeSummary_Logging();

  /**
   * Returns the meta object for the reference '{@link commonj.sdo.ChangeSummary#getDataGraph <em>Data Graph</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Data Graph</em>'.
   * @see commonj.sdo.ChangeSummary#getDataGraph()
   * @see #getChangeSummary()
   * @generated
   */
  EReference getChangeSummary_DataGraph();

  /**
   * Returns the meta object for the reference list '{@link commonj.sdo.ChangeSummary#getChangedDataObjects <em>Changed Data Objects</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference list '<em>Changed Data Objects</em>'.
   * @see commonj.sdo.ChangeSummary#getChangedDataObjects()
   * @see #getChangeSummary()
   * @generated
   */
  EReference getChangeSummary_ChangedDataObjects();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.ecore.sdo.EType <em>EType</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>EType</em>'.
   * @see org.eclipse.emf.ecore.sdo.EType
   * @generated
   */
  EClass getEType();

  /**
   * Returns the meta object for the reference '{@link org.eclipse.emf.ecore.sdo.EType#getEClassifier <em>EClassifier</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>EClassifier</em>'.
   * @see org.eclipse.emf.ecore.sdo.EType#getEClassifier()
   * @see #getEType()
   * @generated
   */
  EReference getEType_EClassifier();

  /**
   * Returns the meta object for class '{@link commonj.sdo.Type <em>Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Type</em>'.
   * @see commonj.sdo.Type
   * @model instanceClass="commonj.sdo.Type"
   * @generated
   */
  EClass getType();

  /**
   * Returns the meta object for the attribute '{@link commonj.sdo.Type#getName <em>Name</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Name</em>'.
   * @see commonj.sdo.Type#getName()
   * @see #getType()
   * @generated
   */
  EAttribute getType_Name();

  /**
   * Returns the meta object for the attribute '{@link commonj.sdo.Type#getURI <em>URI</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>URI</em>'.
   * @see commonj.sdo.Type#getURI()
   * @see #getType()
   * @generated
   */
  EAttribute getType_URI();

  /**
   * Returns the meta object for the attribute '{@link commonj.sdo.Type#getInstanceClass <em>Instance Class</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Instance Class</em>'.
   * @see commonj.sdo.Type#getInstanceClass()
   * @see #getType()
   * @generated
   */
  EAttribute getType_InstanceClass();

  /**
   * Returns the meta object for the containment reference list '{@link commonj.sdo.Type#getProperties <em>Properties</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Properties</em>'.
   * @see commonj.sdo.Type#getProperties()
   * @see #getType()
   * @generated
   */
  EReference getType_Properties();

  /**
   * Returns the meta object for class '{@link commonj.sdo.Property <em>Property</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Property</em>'.
   * @see commonj.sdo.Property
   * @model instanceClass="commonj.sdo.Property"
   * @generated
   */
  EClass getProperty();

  /**
   * Returns the meta object for the attribute '{@link commonj.sdo.Property#getName <em>Name</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Name</em>'.
   * @see commonj.sdo.Property#getName()
   * @see #getProperty()
   * @generated
   */
  EAttribute getProperty_Name();

  /**
   * Returns the meta object for the attribute '{@link commonj.sdo.Property#isMany <em>Many</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Many</em>'.
   * @see commonj.sdo.Property#isMany()
   * @see #getProperty()
   * @generated
   */
  EAttribute getProperty_Many();

  /**
   * Returns the meta object for the attribute '{@link commonj.sdo.Property#isContainment <em>Containment</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Containment</em>'.
   * @see commonj.sdo.Property#isContainment()
   * @see #getProperty()
   * @generated
   */
  EAttribute getProperty_Containment();

  /**
   * Returns the meta object for the attribute '{@link commonj.sdo.Property#getDefault <em>Default</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Default</em>'.
   * @see commonj.sdo.Property#getDefault()
   * @see #getProperty()
   * @generated
   */
  EAttribute getProperty_Default();

  /**
   * Returns the meta object for the reference '{@link commonj.sdo.Property#getType <em>Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Type</em>'.
   * @see commonj.sdo.Property#getType()
   * @see #getProperty()
   * @generated
   */
  EReference getProperty_Type();

  /**
   * Returns the meta object for the container reference '{@link commonj.sdo.Property#getContainingType <em>Containing Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the container reference '<em>Containing Type</em>'.
   * @see commonj.sdo.Property#getContainingType()
   * @see #getProperty()
   * @generated
   */
  EReference getProperty_ContainingType();

  /**
   * Returns the meta object for class '{@link commonj.sdo.Sequence <em>Sequence</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Sequence</em>'.
   * @see commonj.sdo.Sequence
   * @model instanceClass="commonj.sdo.Sequence"
   * @generated
   */
  EClass getSequence();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.ecore.sdo.EChangeSummarySetting <em>EChange Summary Setting</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>EChange Summary Setting</em>'.
   * @see org.eclipse.emf.ecore.sdo.EChangeSummarySetting
   * @generated
   */
  EClass getEChangeSummarySetting();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.ecore.sdo.InternalEDataObject <em>Internal EData Object</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Internal EData Object</em>'.
   * @see org.eclipse.emf.ecore.sdo.InternalEDataObject
   * @generated
   */
  EClass getInternalEDataObject();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.ecore.sdo.EDataObjectAnyType <em>EData Object Any Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>EData Object Any Type</em>'.
   * @see org.eclipse.emf.ecore.sdo.EDataObjectAnyType
   * @generated
   */
  EClass getEDataObjectAnyType();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.ecore.sdo.EDataObjectSimpleAnyType <em>EData Object Simple Any Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>EData Object Simple Any Type</em>'.
   * @see org.eclipse.emf.ecore.sdo.EDataObjectSimpleAnyType
   * @generated
   */
  EClass getEDataObjectSimpleAnyType();

  /**
   * Returns the meta object for class '{@link commonj.sdo.ChangeSummary.Setting <em>Change Summary Setting</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Change Summary Setting</em>'.
   * @see commonj.sdo.ChangeSummary.Setting
   * @model instanceClass="commonj.sdo.ChangeSummary$Setting"
   * @generated
   */
  EClass getChangeSummarySetting();

  /**
   * Returns the meta object for the reference '{@link commonj.sdo.ChangeSummary.Setting#getProperty <em>Property</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Property</em>'.
   * @see commonj.sdo.ChangeSummary.Setting#getProperty()
   * @see #getChangeSummarySetting()
   * @generated
   */
  EReference getChangeSummarySetting_Property();

  /**
   * Returns the meta object for data type '{@link java.util.List <em>EJava List</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for data type '<em>EJava List</em>'.
   * @see java.util.List
   * @model instanceClass="java.util.List" serializable="false"
   * @generated
   */
  EDataType getEJavaList();

  /**
   * Returns the meta object for data type '{@link java.io.ObjectStreamException <em>EObject Stream Exception</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for data type '<em>EObject Stream Exception</em>'.
   * @see java.io.ObjectStreamException
   * @model instanceClass="java.io.ObjectStreamException" serializable="false"
   * @generated
   */
  EDataType getEObjectStreamException();

  /**
   * Returns the factory that creates the instances of the model.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the factory that creates the instances of the model.
   * @generated
   */
  SDOFactory getSDOFactory();

} //SDOPackage
