/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: EPropertyImpl.java,v 1.5 2004/12/15 21:11:56 marcelop Exp $
 */
package org.eclipse.emf.ecore.sdo.impl;


import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.EcoreUtil;

import commonj.sdo.Type;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>EProperty</b></em>'.
 * @extends Adapter
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EPropertyImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EPropertyImpl#isMany <em>Many</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EPropertyImpl#isContainment <em>Containment</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EPropertyImpl#getDefault <em>Default</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EPropertyImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EPropertyImpl#getContainingType <em>Containing Type</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EPropertyImpl#getEStructuralFeature <em>EStructural Feature</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class EPropertyImpl extends EObjectImpl implements EProperty, Adapter
{
  /**
   * The default value of the '{@link #getName() <em>Name</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getName()
   * @generated
   * @ordered
   */
  protected static final String NAME_EDEFAULT = null;

  /**
   * The default value of the '{@link #isMany() <em>Many</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isMany()
   * @generated
   * @ordered
   */
  protected static final boolean MANY_EDEFAULT = false;

  /**
   * The default value of the '{@link #isContainment() <em>Containment</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isContainment()
   * @generated
   * @ordered
   */
  protected static final boolean CONTAINMENT_EDEFAULT = false;

  /**
   * The default value of the '{@link #getDefault() <em>Default</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getDefault()
   * @generated
   * @ordered
   */
  protected static final Object DEFAULT_EDEFAULT = null;

  /**
   * The cached value of the '{@link #getEStructuralFeature() <em>EStructural Feature</em>}' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getEStructuralFeature()
   * @generated
   * @ordered
   */
  protected EStructuralFeature eStructuralFeature = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EPropertyImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EClass eStaticClass()
  {
    return SDOPackage.eINSTANCE.getEProperty();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public String getName()
  {
    return eStructuralFeature.getName();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public boolean isMany()
  {
    return eStructuralFeature.isMany();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public boolean isContainment()
  {
    return eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public Object getDefault()
  {
    return eStructuralFeature.getDefaultValue();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public Type getType()
  {
    return SDOUtil.adaptType(eStructuralFeature.getEType());
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public Type getContainingType()
  {
    return SDOUtil.adaptType(eStructuralFeature.getEContainingClass());
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EStructuralFeature getEStructuralFeature()
  {
    return eStructuralFeature;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setEStructuralFeature(EStructuralFeature newEStructuralFeature)
  {
    EStructuralFeature oldEStructuralFeature = eStructuralFeature;
    eStructuralFeature = newEStructuralFeature;
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, SDOPackage.EPROPERTY__ESTRUCTURAL_FEATURE, oldEStructuralFeature, eStructuralFeature));
  }

  public boolean isAdapterForType(Object type)
  {
    return type == EProperty.class;
  }

  public void notifyChanged(Notification msg)
  {
  }

  public Notifier getTarget()
  {
    return getEStructuralFeature();
  }

  public void setTarget(Notifier newTarget)
  {
    setEStructuralFeature((EStructuralFeature)newTarget);
  }

  public boolean isReadOnly()
  {
    return "true".equals(EcoreUtil.getAnnotation(eStructuralFeature, "commonj.sdo", "readOnly"));
  }

  public void setReadOnly(boolean readOnly)
  {
    EcoreUtil.setAnnotation(eStructuralFeature, "commonj.sdo", "readOnly", readOnly ? "true" : "false");
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
  {
    if (eContainerFeatureID >= 0)
    {
      switch (eContainerFeatureID)
      {
        case SDOPackage.EPROPERTY__CONTAINING_TYPE:
          return eContainer.eInverseRemove(this, SDOPackage.TYPE__PROPERTIES, Type.class, msgs);
        default:
          return eDynamicBasicRemoveFromContainer(msgs);
      }
    }
    return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object eGet(EStructuralFeature eFeature, boolean resolve)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.EPROPERTY__NAME:
        return getName();
      case SDOPackage.EPROPERTY__MANY:
        return isMany() ? Boolean.TRUE : Boolean.FALSE;
      case SDOPackage.EPROPERTY__CONTAINMENT:
        return isContainment() ? Boolean.TRUE : Boolean.FALSE;
      case SDOPackage.EPROPERTY__DEFAULT:
        return getDefault();
      case SDOPackage.EPROPERTY__TYPE:
        return getType();
      case SDOPackage.EPROPERTY__CONTAINING_TYPE:
        return getContainingType();
      case SDOPackage.EPROPERTY__ESTRUCTURAL_FEATURE:
        return getEStructuralFeature();
    }
    return eDynamicGet(eFeature, resolve);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eSet(EStructuralFeature eFeature, Object newValue)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.EPROPERTY__ESTRUCTURAL_FEATURE:
        setEStructuralFeature((EStructuralFeature)newValue);
        return;
    }
    eDynamicSet(eFeature, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eUnset(EStructuralFeature eFeature)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.EPROPERTY__ESTRUCTURAL_FEATURE:
        setEStructuralFeature((EStructuralFeature)null);
        return;
    }
    eDynamicUnset(eFeature);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean eIsSet(EStructuralFeature eFeature)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.EPROPERTY__NAME:
        return NAME_EDEFAULT == null ? getName() != null : !NAME_EDEFAULT.equals(getName());
      case SDOPackage.EPROPERTY__MANY:
        return isMany() != MANY_EDEFAULT;
      case SDOPackage.EPROPERTY__CONTAINMENT:
        return isContainment() != CONTAINMENT_EDEFAULT;
      case SDOPackage.EPROPERTY__DEFAULT:
        return DEFAULT_EDEFAULT == null ? getDefault() != null : !DEFAULT_EDEFAULT.equals(getDefault());
      case SDOPackage.EPROPERTY__TYPE:
        return getType() != null;
      case SDOPackage.EPROPERTY__CONTAINING_TYPE:
        return getContainingType() != null;
      case SDOPackage.EPROPERTY__ESTRUCTURAL_FEATURE:
        return eStructuralFeature != null;
    }
    return eDynamicIsSet(eFeature);
  }

} //EPropertyImpl
