/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.change.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.change.ResourceChange;
import org.eclipse.emf.ecore.change.impl.FeatureChangeImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ChangeRecorder
implements Adapter {
    protected boolean recording;
    protected ChangeDescription changeDescription;
    protected List targetObjects = new BasicEList.FastCompare();
    protected boolean loadingTargets;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ChangeRecorder() {
    }

    public ChangeRecorder(EObject rootObject) {
        this.beginRecording(Collections.singleton(rootObject));
    }

    public ChangeRecorder(Resource resource) {
        this.beginRecording(Collections.singleton(resource));
    }

    public ChangeRecorder(ResourceSet resourceSet) {
        this.beginRecording(Collections.singleton(resourceSet));
    }

    public ChangeRecorder(Collection rootObjects) {
        this.beginRecording(rootObjects);
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void dispose() {
        this.recording = false;
        Iterator i = this.targetObjects.iterator();
        while (i.hasNext()) {
            Notifier notifier = (Notifier)i.next();
            notifier.eAdapters().remove((Object)this);
        }
        this.targetObjects.clear();
        this.changeDescription = null;
    }

    public void beginRecording(Collection rootObjects) {
        this.beginRecording(null, rootObjects);
    }

    public void beginRecording(ChangeDescription changeDescription, Collection rootObjects) {
        this.changeDescription = changeDescription == null ? this.createChangeDescription() : changeDescription;
        this.loadingTargets = true;
        Iterator i = rootObjects.iterator();
        while (i.hasNext()) {
            Notifier notifier = (Notifier)i.next();
            this.addAdapter(notifier);
        }
        this.loadingTargets = false;
        if (changeDescription != null) {
            this.prepareChangeDescriptionForResume();
        }
        this.recording = true;
    }

    public ChangeDescription summarize() {
        if (this.isRecording()) {
            this.consolidateChanges();
            return this.changeDescription;
        }
        return null;
    }

    public ChangeDescription endRecording() {
        if (this.isRecording()) {
            this.recording = false;
            this.consolidateChanges();
            return this.changeDescription;
        }
        return null;
    }

    protected void prepareChangeDescriptionForResume() {
        this.loadingTargets = true;
        Iterator i = this.changeDescription.getObjectsToAttach().iterator();
        while (i.hasNext()) {
            Notifier notifier = (Notifier)i.next();
            this.addAdapter(notifier);
        }
        this.loadingTargets = false;
        this.changeDescription.getObjectsToAttach().clear();
        i = this.changeDescription.getObjectChanges().values().iterator();
        while (i.hasNext()) {
            Iterator j = ((List)i.next()).iterator();
            while (j.hasNext()) {
                FeatureChange featureChange = (FeatureChange)j.next();
                featureChange.getValue();
            }
        }
        i = this.changeDescription.getResourceChanges().iterator();
        while (i.hasNext()) {
            ResourceChange resourceChange = (ResourceChange)i.next();
            resourceChange.getValue();
        }
    }

    protected void consolidateChanges() {
        EObject eObject;
        EList orphanedObjects = this.changeDescription.getObjectsToAttach();
        Iterator iter = this.targetObjects.iterator();
        while (iter.hasNext()) {
            Object target = iter.next();
            if (!(target instanceof EObject) || (eObject = (EObject)target).eContainer() != null || eObject.eResource() != null) continue;
            orphanedObjects.add(eObject);
        }
        iter = this.changeDescription.getObjectChanges().iterator();
        while (iter.hasNext()) {
            Map.Entry mapEntry = (Map.Entry)iter.next();
            eObject = (EObject)mapEntry.getKey();
            Iterator featureChangeIter = ((List)mapEntry.getValue()).iterator();
            while (featureChangeIter.hasNext()) {
                this.finalizeChange((FeatureChange)featureChangeIter.next(), eObject);
            }
        }
        iter = this.changeDescription.getResourceChanges().iterator();
        while (iter.hasNext()) {
            ResourceChange resourceChange = (ResourceChange)iter.next();
            this.finalizeChange(resourceChange);
        }
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            Object feature = notification.getFeature();
            if (feature instanceof EReference) {
                EReference eReference;
                this.handleFeature((EStructuralFeature)eReference, (EReference)((eReference = (EReference)feature).isContainment() ? eReference : null), notification, (EObject)notifier);
            } else if (feature != null) {
                this.handleFeature((EStructuralFeature)feature, null, notification, (EObject)notifier);
            }
        } else if (notifier instanceof Resource) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.resource.Resource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            int featureID = notification.getFeatureID((Class)clazz);
            if (this.loadingTargets) {
                if (featureID == 4) {
                    Resource resource = (Resource)notification.getNotifier();
                    Iterator i = resource.getContents().iterator();
                    while (i.hasNext()) {
                        this.addAdapter((Notifier)i.next());
                    }
                    this.loadingTargets = false;
                }
            } else if (featureID == 2) {
                this.handleResource(notification);
            }
        } else if (notifier instanceof ResourceSet) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.emf.ecore.resource.ResourceSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz) == 0 && notification.getEventType() == 3) {
                Notifier newValue = (Notifier)notification.getNewValue();
                this.loadingTargets = true;
                this.addAdapter(newValue);
            }
        }
    }

    protected void handleFeature(EStructuralFeature feature, EReference containment, Notification notification, EObject eObject) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            return;
        }
        List changes = null;
        FeatureChange change = null;
        if (this.isRecording()) {
            changes = this.getFeatureChanges(eObject);
            change = this.getFeatureChange(changes, feature);
        }
        int event = notification.getEventType();
        switch (event) {
            case 1: 
            case 2: {
                Notifier newValue;
                if (change == null && this.isRecording()) {
                    Object oldValue;
                    if (feature.isMany()) {
                        oldValue = new BasicEList((Collection)eObject.eGet(feature));
                        int index = notification.getPosition();
                        if (index != -1) {
                            oldValue.set(index, notification.getOldValue());
                        }
                        change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                    } else {
                        oldValue = notification.getOldValue();
                        change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                    }
                    ((InternalEList)changes).addUnique((Object)change);
                }
                if (containment == null || (newValue = (Notifier)notification.getNewValue()) == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 3: {
                if (change == null && this.isRecording()) {
                    BasicEList oldValue = new BasicEList((Collection)eObject.eGet(feature));
                    oldValue.remove(notification.getPosition());
                    change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                    ((InternalEList)changes).addUnique((Object)change);
                }
                if (containment == null) break;
                Notifier newValue = (Notifier)notification.getNewValue();
                this.addAdapter(newValue);
                break;
            }
            case 5: {
                if (change == null && this.isRecording()) {
                    BasicEList oldValue = new BasicEList((Collection)eObject.eGet(feature));
                    int position = notification.getPosition();
                    int i = ((Collection)notification.getNewValue()).size();
                    while (--i >= 0) {
                        oldValue.remove(position);
                    }
                    change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                    ((InternalEList)changes).addUnique((Object)change);
                }
                if (containment == null) break;
                Collection newValues = (Collection)notification.getNewValue();
                Iterator i = newValues.iterator();
                while (i.hasNext()) {
                    Notifier newValue = (Notifier)i.next();
                    this.addAdapter(newValue);
                }
                break;
            }
            case 4: {
                if (change != null || !this.isRecording()) break;
                BasicEList oldValue = new BasicEList((Collection)eObject.eGet(feature));
                int position = notification.getPosition();
                if (position == -1) {
                    position = 0;
                }
                oldValue.add(position, notification.getOldValue());
                change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                ((InternalEList)changes).addUnique((Object)change);
                break;
            }
            case 6: {
                if (change != null || !this.isRecording()) break;
                List removedValues = (List)notification.getOldValue();
                BasicEList oldValue = new BasicEList((Collection)eObject.eGet(feature));
                int[] positions = (int[])notification.getNewValue();
                if (positions == null) {
                    oldValue.addAll(removedValues);
                } else {
                    int i = 0;
                    while (i < positions.length) {
                        oldValue.add(positions[i], removedValues.get(i));
                        ++i;
                    }
                }
                change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                ((InternalEList)changes).addUnique((Object)change);
                break;
            }
            case 7: {
                if (change != null || !this.isRecording()) break;
                BasicEList oldValue = new BasicEList((Collection)eObject.eGet(feature));
                int position = notification.getPosition();
                int oldPosition = (Integer)notification.getOldValue();
                oldValue.move(oldPosition, position);
                change = this.createFeatureChange(eObject, feature, oldValue, notification.wasSet());
                ((InternalEList)changes).addUnique((Object)change);
            }
        }
    }

    protected void handleResource(Notification notification) {
        Resource resource = null;
        ResourceChange change = null;
        if (this.isRecording()) {
            resource = (Resource)notification.getNotifier();
            change = this.getResourceChange(resource);
        }
        int eventType = notification.getEventType();
        switch (eventType) {
            case 1: 
            case 2: {
                if (change != null || !this.isRecording()) break;
                BasicEList oldValue = new BasicEList((Collection)resource.getContents());
                int index = notification.getPosition();
                if (index != -1) {
                    oldValue.set(index, notification.getOldValue());
                }
                change = this.createResourceChange(resource, (EList)oldValue);
                this.getResourceChanges().add((Object)change);
                Notifier newValue = (Notifier)notification.getNewValue();
                if (newValue == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 3: {
                if (change == null && this.isRecording()) {
                    BasicEList oldValue = new BasicEList((Collection)resource.getContents());
                    oldValue.remove(notification.getPosition());
                    change = this.createResourceChange(resource, (EList)oldValue);
                    this.getResourceChanges().add((Object)change);
                }
                Notifier newValue = (Notifier)notification.getNewValue();
                this.addAdapter(newValue);
                break;
            }
            case 5: {
                if (change == null && this.isRecording()) {
                    BasicEList oldValue = new BasicEList((Collection)resource.getContents());
                    int position = notification.getPosition();
                    int i = ((Collection)notification.getNewValue()).size();
                    while (--i >= 0) {
                        oldValue.remove(position);
                    }
                    change = this.createResourceChange(resource, (EList)oldValue);
                    this.getResourceChanges().add((Object)change);
                }
                Collection newValues = (Collection)notification.getNewValue();
                Iterator i = newValues.iterator();
                while (i.hasNext()) {
                    Notifier newValue = (Notifier)i.next();
                    this.addAdapter(newValue);
                }
                break;
            }
            case 4: {
                if (change != null || !this.isRecording()) break;
                BasicEList oldValue = new BasicEList((Collection)resource.getContents());
                int position = notification.getPosition();
                if (position == -1) {
                    position = 0;
                }
                oldValue.add(position, notification.getOldValue());
                change = this.createResourceChange(resource, (EList)oldValue);
                this.getResourceChanges().add((Object)change);
                break;
            }
            case 6: {
                if (change != null || !this.isRecording()) break;
                List removedValues = (List)notification.getOldValue();
                BasicEList oldValue = new BasicEList((Collection)resource.getContents());
                int[] positions = (int[])notification.getNewValue();
                if (positions == null) {
                    oldValue.addAll((Collection)removedValues);
                } else {
                    int i = 0;
                    while (i < positions.length) {
                        oldValue.add(positions[i], removedValues.get(i));
                        ++i;
                    }
                }
                change = this.createResourceChange(resource, (EList)oldValue);
                this.getResourceChanges().add((Object)change);
                break;
            }
            case 7: {
                if (change != null || !this.isRecording()) break;
                BasicEList oldValue = new BasicEList((Collection)resource.getContents());
                int position = notification.getPosition();
                int oldPosition = (Integer)notification.getOldValue();
                oldValue.move(oldPosition, position);
                change = this.createResourceChange(resource, (EList)oldValue);
                this.getResourceChanges().add((Object)change);
            }
        }
    }

    public void setTarget(Notifier target) {
        EList contents;
        if (!this.targetObjects.add(target)) {
            throw new IllegalStateException("The target should not be set more than once");
        }
        Object object = target instanceof EObject ? ((EObject)target).eContents() : (target instanceof ResourceSet ? ((ResourceSet)target).getResources() : (contents = target instanceof Resource ? ((Resource)target).getContents() : null));
        if (contents != null) {
            Iterator i = contents.iterator();
            while (i.hasNext()) {
                Notifier notifier = (Notifier)i.next();
                this.addAdapter(notifier);
            }
        }
    }

    protected void addAdapter(Notifier notifier) {
        EList eAdapters;
        if (notifier != this.changeDescription && !(eAdapters = notifier.eAdapters()).contains((Object)this)) {
            eAdapters.add((Object)this);
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    protected EList getResourceChanges() {
        return this.changeDescription.getResourceChanges();
    }

    protected ResourceChange getResourceChange(Resource resource) {
        EList resourceChanges = this.getResourceChanges();
        int i = 0;
        int size = resourceChanges.size();
        while (i < size) {
            ResourceChange resourceChange;
            if ((resourceChange = (ResourceChange)resourceChanges.get(i++)).getResource() != resource) continue;
            return resourceChange;
        }
        return null;
    }

    protected List getFeatureChanges(EObject eObject) {
        List featureChanges = (List)this.changeDescription.getObjectChanges().get((Object)eObject);
        if (featureChanges == null) {
            Map.Entry entry = ChangeFactory.eINSTANCE.createEObjectToChangesMapEntry(eObject);
            this.changeDescription.getObjectChanges().add((Object)entry);
            featureChanges = (EList)entry.getValue();
        }
        return featureChanges;
    }

    protected FeatureChange getFeatureChange(List featureChanges, EStructuralFeature eStructuralFeature) {
        EObjectContainmentEList changes = (EObjectContainmentEList)featureChanges;
        int i = 0;
        int size = changes.size();
        while (i < size) {
            FeatureChangeImpl featureChange;
            if ((featureChange = (FeatureChangeImpl)changes.get(i++)).getFeature() != eStructuralFeature) continue;
            return featureChange;
        }
        return null;
    }

    protected void finalizeChange(ResourceChange change) {
        BasicEList.FastCompare oldList = new BasicEList.FastCompare((Collection)change.getResource().getContents());
        EList newList = change.getValue();
        change.getListChanges().clear();
        this.createListChanges((EList)oldList, newList, change.getListChanges());
    }

    protected void finalizeChange(FeatureChange change, EObject eObject) {
        EStructuralFeature feature;
        if (change.isSet() && (feature = change.getFeature()).isMany()) {
            BasicEList oldList = new BasicEList((Collection)((EList)eObject.eGet(feature)));
            EList newList = (EList)change.getValue();
            EList listChanges = change.getListChanges();
            listChanges.clear();
            this.createListChanges((EList)oldList, newList, listChanges);
        }
    }

    protected void createListChanges(EList oldList, EList newList, EList changesList) {
        int index = 0;
        Iterator objects = newList.iterator();
        while (objects.hasNext()) {
            Object newObject = objects.next();
            if (oldList.size() <= index) {
                this.createAddListChange(oldList, changesList, newObject, index);
            } else {
                boolean done;
                do {
                    done = true;
                    Object targetObject = oldList.get(index);
                    if (!(targetObject == null ? newObject != null : !targetObject.equals(newObject))) continue;
                    int position = EcoreUtil.indexOf((List)oldList, newObject, (int)index);
                    if (position != -1) {
                        int targetIndex = EcoreUtil.indexOf((List)newList, (Object)targetObject, (int)index);
                        if (targetIndex == -1) {
                            this.createRemoveListChange(oldList, changesList, newObject, index);
                            done = false;
                            continue;
                        }
                        if (targetIndex > position) {
                            if (oldList.size() <= targetIndex) {
                                targetIndex = oldList.size() - 1;
                            }
                            this.createMoveListChange(oldList, changesList, newObject, index, targetIndex);
                            done = false;
                            continue;
                        }
                        this.createMoveListChange(oldList, changesList, newObject, position, index);
                        continue;
                    }
                    this.createAddListChange(oldList, changesList, newObject, index);
                } while (!done);
            }
            ++index;
        }
        int i = oldList.size();
        while (i > index) {
            this.createRemoveListChange(oldList, changesList, null, --i);
        }
    }

    protected void createAddListChange(EList oldList, EList changesList, Object newObject, int index) {
        ListChange listChange = this.createListChange(changesList, ChangeKind.ADD_LITERAL, index);
        listChange.getValues().add(newObject);
        oldList.add(index, newObject);
    }

    protected void createRemoveListChange(EList oldList, EList changesList, Object newObject, int index) {
        this.createListChange(changesList, ChangeKind.REMOVE_LITERAL, index);
        oldList.remove(index);
    }

    protected void createMoveListChange(EList oldList, EList changesList, Object newObject, int index, int toIndex) {
        ListChange listChange = this.createListChange(changesList, ChangeKind.MOVE_LITERAL, index);
        listChange.setMoveToIndex(toIndex);
        oldList.move(toIndex, index);
    }

    protected ListChange createListChange(EList changesList, ChangeKind kind, int index) {
        ListChange listChange = ChangeFactory.eINSTANCE.createListChange();
        listChange.setKind(kind);
        listChange.setIndex(index);
        changesList.add((Object)listChange);
        return listChange;
    }

    protected FeatureChange createFeatureChange(EObject eObject, EStructuralFeature eStructuralFeature, Object value, boolean isSet) {
        return ChangeFactory.eINSTANCE.createFeatureChange(eStructuralFeature, value, isSet);
    }

    protected ResourceChange createResourceChange(Resource resource, EList value) {
        return ChangeFactory.eINSTANCE.createResourceChange(resource, value);
    }

    protected ChangeDescription createChangeDescription() {
        return ChangeFactory.eINSTANCE.createChangeDescription();
    }
}

