/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class BasicFeatureMap
extends EDataTypeEList
implements FeatureMap.Internal {
    protected final FeatureMapUtil.Validator featureMapValidator;
    static /* synthetic */ Class class$0;

    public BasicFeatureMap(InternalEObject owner, int featureID) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.ecore.util.FeatureMap$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz, owner, featureID);
        this.featureMapValidator = FeatureMapUtil.getValidator(owner.eClass(), this.getEStructuralFeature());
    }

    protected Object validate(int index, Object object) {
        Object result = super.validate(index, object);
        EStructuralFeature eStructuralFeature = ((FeatureMap.Entry)object).getEStructuralFeature();
        if (!eStructuralFeature.isChangeable() || !this.featureMapValidator.isValid(eStructuralFeature)) {
            throw new RuntimeException("Invalid entry feature '" + eStructuralFeature.getEContainingClass().getName() + "." + eStructuralFeature.getName() + "'");
        }
        return result;
    }

    protected FeatureMap.Entry createEntry(EStructuralFeature eStructuralFeature, Object value) {
        return FeatureMapUtil.createEntry(eStructuralFeature, value);
    }

    protected NotificationImpl createNotification(int eventType, EStructuralFeature feature, Object oldObject, Object newObject, int index, boolean wasSet) {
        return new FeatureMapUtil.FeatureENotificationImpl(this.owner, eventType, feature, oldObject, newObject, index, wasSet);
    }

    protected boolean isMany(EStructuralFeature feature) {
        return FeatureMapUtil.isMany(this.owner, feature);
    }

    protected boolean hasInverse() {
        return true;
    }

    protected boolean hasShadow() {
        return true;
    }

    protected int entryIndex(EStructuralFeature feature, int index) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int count = 0;
        int result = this.size;
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        int i = 0;
        while (i < this.size) {
            FeatureMap.Entry entry = entries[i];
            if (validator.isValid(entry.getEStructuralFeature())) {
                if (index == count) {
                    return i;
                }
                ++count;
                result = i + 1;
            }
            ++i;
        }
        if (index == count) {
            return result;
        }
        throw new IndexOutOfBoundsException("index=" + index + ", size=" + count);
    }

    protected boolean isResolveProxies(EStructuralFeature feature) {
        return feature instanceof EReference && ((EReference)feature).isResolveProxies();
    }

    public Object resolveProxy(EStructuralFeature feature, int entryIndex, int index, Object object) {
        EObject resolved = this.resolveProxy((EObject)object);
        if (resolved != object) {
            Object oldObject = this.data[entryIndex];
            FeatureMap.Entry entry = this.createEntry(feature, resolved);
            this.assign(entryIndex, this.validate(entryIndex, entry));
            this.didSet(entryIndex, entry, oldObject);
            if (this.isNotificationRequired()) {
                NotificationImpl notifications = this.createNotification(9, entry.getEStructuralFeature(), object, resolved, index, false);
                notifications.add((Notification)this.createNotification(9, oldObject, entry, index, false));
                notifications.dispatch();
            }
            return resolved;
        }
        return object;
    }

    protected EObject resolveProxy(EObject eObject) {
        return this.owner.eResolveProxy((InternalEObject)eObject);
    }

    public int getModCount() {
        return this.modCount;
    }

    public EStructuralFeature getEStructuralFeature(int index) {
        return ((FeatureMap.Entry)this.get(index)).getEStructuralFeature();
    }

    public Object getValue(int index) {
        return ((FeatureMap.Entry)this.get(index)).getValue();
    }

    public Object setValue(int index, Object value) {
        return ((FeatureMap.Entry)this.set(index, (Object)this.createEntry(this.getEStructuralFeature(index), value))).getValue();
    }

    public NotificationChain shadowAdd(Object object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            NotificationImpl notification;
            FeatureMap.Entry entry = (FeatureMap.Entry)object;
            EStructuralFeature feature = entry.getEStructuralFeature();
            Object value = entry.getValue();
            NotificationImpl notificationImpl = notification = feature.isMany() ? this.createNotification(3, feature, null, value, this.indexOf(feature, value), true) : this.createNotification(1, feature, feature.getDefaultValue(), value, -1, true);
            if (notifications != null) {
                notifications.add((Notification)notification);
            } else {
                notifications = notification;
            }
        }
        return notifications;
    }

    public NotificationChain inverseAdd(Object object, NotificationChain notifications) {
        FeatureMap.Entry entry = (FeatureMap.Entry)object;
        EStructuralFeature feature = entry.getEStructuralFeature();
        if (feature instanceof EReference) {
            InternalEObject internalEObject;
            EReference eReference = (EReference)feature;
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite != null) {
                InternalEObject internalEObject2 = (InternalEObject)entry.getValue();
                if (internalEObject2 != null) {
                    notifications = internalEObject2.eInverseAdd(this.owner, internalEObject2.eClass().getEAllStructuralFeatures().indexOf((Object)eOpposite), null, notifications);
                }
            } else if (eReference.isContainment() && (internalEObject = (InternalEObject)entry.getValue()) != null) {
                InternalEObject cfr_ignored_0 = (InternalEObject)internalEObject.eContainer();
                int containmentFeatureID = this.owner.eClass().getEAllStructuralFeatures().indexOf((Object)eReference);
                notifications = internalEObject.eInverseAdd(this.owner, -1 - (containmentFeatureID == -1 ? this.featureID : containmentFeatureID), null, notifications);
            }
        }
        return notifications;
    }

    public NotificationChain shadowRemove(Object object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            NotificationImpl notification;
            FeatureMap.Entry entry = (FeatureMap.Entry)object;
            EStructuralFeature feature = entry.getEStructuralFeature();
            Object value = entry.getValue();
            NotificationImpl notificationImpl = feature.isMany() ? this.createNotification(4, feature, value, null, this.indexOf(feature, value), true) : (notification = this.createNotification(feature.isUnsettable() ? 2 : 1, feature, value, feature.getDefaultValue(), -1, true));
            if (notifications != null) {
                notifications.add((Notification)notification);
            } else {
                notifications = notification;
            }
        }
        return notifications;
    }

    public NotificationChain inverseRemove(Object object, NotificationChain notifications) {
        FeatureMap.Entry entry = (FeatureMap.Entry)object;
        EStructuralFeature feature = entry.getEStructuralFeature();
        if (feature instanceof EReference) {
            InternalEObject internalEObject;
            EReference eReference = (EReference)feature;
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite != null) {
                InternalEObject internalEObject2 = (InternalEObject)entry.getValue();
                if (internalEObject2 != null) {
                    notifications = internalEObject2.eInverseRemove(this.owner, internalEObject2.eClass().getEAllStructuralFeatures().indexOf((Object)eOpposite), null, notifications);
                }
            } else if (eReference.isContainment() && (internalEObject = (InternalEObject)entry.getValue()) != null) {
                int containmentFeatureID = this.owner.eClass().getEAllStructuralFeatures().indexOf((Object)eReference);
                notifications = internalEObject.eInverseRemove(this.owner, -1 - (containmentFeatureID == -1 ? this.featureID : containmentFeatureID), null, notifications);
            }
        }
        return notifications;
    }

    public NotificationChain shadowSet(Object oldObject, Object newObject, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)oldObject;
            EStructuralFeature feature = entry.getEStructuralFeature();
            Object oldValue = entry.getValue();
            Object newValue = ((FeatureMap.Entry)newObject).getValue();
            NotificationImpl notification = this.createNotification(1, feature, oldValue, newValue, feature.isMany() ? this.indexOf(feature, newValue) : -1, true);
            if (notifications != null) {
                notifications.add((Notification)notification);
            } else {
                notifications = notification;
            }
        }
        return notifications;
    }

    public NotificationChain inverseTouch(Object object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)object;
            EStructuralFeature feature = entry.getEStructuralFeature();
            Object value = entry.getValue();
            NotificationImpl notification = this.createNotification(1, feature, value, value, feature.isMany() ? this.indexOf(feature, value) : -1, true);
            if (notifications != null) {
                notifications.add((Notification)notification);
            } else {
                notifications = notification;
            }
        }
        return notifications;
    }

    public Object move(int targetIndex, int sourceIndex) {
        if (this.isNotificationRequired()) {
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            FeatureMap.Entry sourceEntry = entries[sourceIndex];
            EStructuralFeature feature = sourceEntry.getEStructuralFeature();
            if (this.isMany(feature)) {
                FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
                int featureTargetIndex = -1;
                int featureSourceIndex = -1;
                int count = 0;
                int i = 0;
                while (i < this.size) {
                    FeatureMap.Entry entry = entries[i];
                    if (i == targetIndex) {
                        featureTargetIndex = count;
                    }
                    if (i == sourceIndex) {
                        featureSourceIndex = count;
                    }
                    if (validator.isValid(entry.getEStructuralFeature())) {
                        ++count;
                    }
                    ++i;
                }
                Object result = this.doMove(targetIndex, sourceIndex);
                if (featureSourceIndex != featureTargetIndex) {
                    this.dispatchNotification((Notification)new ENotificationImpl(this.owner, 7, feature, (Object)new Integer(featureSourceIndex), sourceEntry.getValue(), featureTargetIndex));
                }
                return result;
            }
            return this.doMove(targetIndex, sourceIndex);
        }
        return this.doMove(targetIndex, sourceIndex);
    }

    protected Object doMove(int targetIndex, int sourceIndex) {
        return super.move(targetIndex, sourceIndex);
    }

    public Object set(int index, Object object) {
        block5: {
            EStructuralFeature entryFeature;
            block4: {
                FeatureMap.Entry entry = (FeatureMap.Entry)object;
                entryFeature = entry.getEStructuralFeature();
                if (!this.isMany(entryFeature)) break block4;
                if (!entryFeature.isUnique()) break block5;
                FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
                int i = 0;
                while (i < this.size) {
                    FeatureMap.Entry otherEntry = entries[i];
                    if (otherEntry.equals(entry) && i != index) {
                        throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
                    }
                    ++i;
                }
                break block5;
            }
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), entryFeature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry otherEntry = entries[i];
                if (validator.isValid(otherEntry.getEStructuralFeature()) && i != index) {
                    throw new IllegalArgumentException("The multiplicity constraint is violated");
                }
                ++i;
            }
        }
        return this.doSet(index, object);
    }

    public Object doSet(int index, Object object) {
        return super.set(index, object);
    }

    public boolean add(Object object) {
        FeatureMap.Entry entry = (FeatureMap.Entry)object;
        EStructuralFeature entryFeature = entry.getEStructuralFeature();
        if (this.isMany(entryFeature)) {
            if (entryFeature.isUnique() && this.contains(entryFeature, entry.getValue())) {
                return false;
            }
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), entryFeature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry otherEntry = entries[i];
                if (validator.isValid(otherEntry.getEStructuralFeature())) {
                    if (otherEntry.equals(entry)) {
                        return false;
                    }
                    this.doSet(i, object);
                    return true;
                }
                ++i;
            }
        }
        return this.doAdd(object);
    }

    protected boolean doAdd(Object object) {
        return super.add(object);
    }

    public void add(int index, Object object) {
        FeatureMap.Entry entry = (FeatureMap.Entry)object;
        EStructuralFeature entryFeature = entry.getEStructuralFeature();
        if (this.isMany(entryFeature)) {
            if (entryFeature.isUnique()) {
                FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
                int i = 0;
                while (i < this.size) {
                    FeatureMap.Entry otherEntry = entries[i];
                    if (otherEntry.equals(entry) && i != index) {
                        throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
                    }
                    ++i;
                }
            }
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), entryFeature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry otherEntry = entries[i];
                if (validator.isValid(otherEntry.getEStructuralFeature())) {
                    throw new IllegalArgumentException("The multiplicity constraint is violated");
                }
                ++i;
            }
        }
        this.doAdd(index, object);
    }

    public void doAdd(int index, Object object) {
        super.add(index, object);
    }

    public boolean addAll(Collection collection) {
        BasicEList uniqueCollection = new BasicEList(collection.size());
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)i.next();
            EStructuralFeature entryFeature = entry.getEStructuralFeature();
            if (this.isMany(entryFeature)) {
                if (entryFeature.isUnique() && (this.contains(entryFeature, entry.getValue()) || uniqueCollection.contains(entry))) continue;
                uniqueCollection.add(entry);
                continue;
            }
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), entryFeature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            boolean include = true;
            int j = 0;
            while (j < this.size) {
                FeatureMap.Entry otherEntry = entries[j];
                if (validator.isValid(otherEntry.getEStructuralFeature())) {
                    this.doSet(j, entry);
                    include = false;
                    break;
                }
                ++j;
            }
            if (!include) continue;
            uniqueCollection.add(entry);
        }
        return this.doAddAll((Collection)uniqueCollection);
    }

    public boolean doAddAll(Collection collection) {
        return super.addAll(collection);
    }

    public boolean addAll(int index, Collection collection) {
        BasicEList uniqueCollection = new BasicEList(collection.size());
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)i.next();
            EStructuralFeature entryFeature = entry.getEStructuralFeature();
            if (this.isMany(entryFeature)) {
                if (entryFeature.isUnique() && (this.contains(entryFeature, entry.getValue()) || uniqueCollection.contains(entry))) continue;
                uniqueCollection.add(entry);
                continue;
            }
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), entryFeature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            boolean include = true;
            int j = 0;
            while (j < this.size) {
                FeatureMap.Entry otherEntry = entries[j];
                if (validator.isValid(otherEntry.getEStructuralFeature())) {
                    this.doSet(j, entry);
                    include = false;
                    break;
                }
                ++j;
            }
            if (!include) continue;
            uniqueCollection.add(entry);
        }
        return this.doAddAll(index, (Collection)uniqueCollection);
    }

    public boolean doAddAll(int index, Collection collection) {
        return super.addAll(index, collection);
    }

    public int size(EStructuralFeature feature) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int result = 0;
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        int i = 0;
        while (i < this.size) {
            FeatureMap.Entry entry = entries[i];
            if (validator.isValid(entry.getEStructuralFeature())) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public boolean isEmpty(EStructuralFeature feature) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        int i = 0;
        while (i < this.size) {
            FeatureMap.Entry entry = entries[i];
            if (validator.isValid(entry.getEStructuralFeature())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(EStructuralFeature feature, Object object) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        if (FeatureMapUtil.isFeatureMap(feature)) {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature()) && entry.equals(object)) {
                    return true;
                }
                ++i;
            }
        } else if (object != null) {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature()) && object.equals(entry.getValue())) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature()) && entry.getValue() == null) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean containsAll(EStructuralFeature feature, Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (this.contains(feature, i.next())) continue;
            return false;
        }
        return true;
    }

    public int indexOf(EStructuralFeature feature, Object object) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int result = 0;
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        if (FeatureMapUtil.isFeatureMap(feature)) {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (entry.equals(object)) {
                        return result;
                    }
                    ++result;
                }
                ++i;
            }
        } else if (object != null) {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (object.equals(entry.getValue())) {
                        return result;
                    }
                    ++result;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (entry.getValue() == null) {
                        return result;
                    }
                    ++result;
                }
                ++i;
            }
        }
        return -1;
    }

    public int lastIndexOf(EStructuralFeature feature, Object object) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int result = -1;
        int count = 0;
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        if (FeatureMapUtil.isFeatureMap(feature)) {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (entry.equals(object)) {
                        result = count;
                    }
                    ++count;
                }
                ++i;
            }
        } else if (object != null) {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (object.equals(entry.getValue())) {
                        result = count;
                    }
                    ++count;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (entry.getValue() == null) {
                        result = count;
                    }
                    ++count;
                }
                ++i;
            }
        }
        return result;
    }

    public Iterator iterator(EStructuralFeature feature) {
        return feature instanceof EReference && ((EReference)feature).isResolveProxies() ? new ResolvingFeatureEIterator(feature, this) : new FeatureEIterator(feature, this);
    }

    public ListIterator listIterator(EStructuralFeature feature) {
        return feature instanceof EReference && ((EReference)feature).isResolveProxies() ? new ResolvingFeatureEIterator(feature, this) : new FeatureEIterator(feature, this);
    }

    public ListIterator listIterator(EStructuralFeature feature, int index) {
        FeatureEIterator result = feature instanceof EReference && ((EReference)feature).isResolveProxies() ? new ResolvingFeatureEIterator(feature, this) : new FeatureEIterator(feature, this);
        int i = 0;
        while (i < index) {
            result.next();
            ++i;
        }
        return result;
    }

    public FeatureMap.ValueListIterator valueListIterator() {
        return new ValueListIteratorImpl();
    }

    public FeatureMap.ValueListIterator valueListIterator(int index) {
        return new ValueListIteratorImpl(index);
    }

    public EList list(EStructuralFeature feature) {
        return FeatureMapUtil.isFeatureMap(feature) ? new FeatureMapUtil.FeatureFeatureMap(feature, this) : new FeatureMapUtil.FeatureEList(feature, this);
    }

    public EStructuralFeature.Setting setting(EStructuralFeature feature) {
        return this.isMany(feature) ? (EStructuralFeature.Setting)this.list(feature) : new FeatureMapUtil.FeatureValue(feature, this);
    }

    public List basicList(EStructuralFeature feature) {
        return new FeatureMapUtil.FeatureEList.Basic(feature, this);
    }

    public Iterator basicIterator(EStructuralFeature feature) {
        return new FeatureEIterator(feature, this);
    }

    public ListIterator basicListIterator(EStructuralFeature feature) {
        return new FeatureEIterator(feature, this);
    }

    public ListIterator basicListIterator(EStructuralFeature feature, int index) {
        FeatureEIterator result = new FeatureEIterator(feature, this);
        int i = 0;
        while (i < index) {
            result.next();
            ++i;
        }
        return result;
    }

    public Object[] toArray(EStructuralFeature feature) {
        BasicEList result = new BasicEList();
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        if (FeatureMapUtil.isFeatureMap(feature)) {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    result.add(entry);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    result.add(entry.getValue());
                }
                ++i;
            }
        }
        return result.toArray();
    }

    public Object[] toArray(EStructuralFeature feature, Object[] array) {
        BasicEList result = new BasicEList();
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        if (FeatureMapUtil.isFeatureMap(feature)) {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    result.add(entry);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    result.add(entry.getValue());
                }
                ++i;
            }
        }
        return result.toArray(array);
    }

    public void set(EStructuralFeature feature, Object object) {
        if (this.isMany(feature)) {
            EList list = this.list(feature);
            list.clear();
            list.addAll((Collection)object);
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (this.shouldUnset(feature, object)) {
                        this.remove(i);
                    } else {
                        this.doSet(i, FeatureMapUtil.isFeatureMap(feature) ? (FeatureMap.Entry)object : this.createEntry(feature, object));
                    }
                    return;
                }
                ++i;
            }
            if (!this.shouldUnset(feature, object)) {
                this.doAdd(FeatureMapUtil.isFeatureMap(feature) ? (FeatureMap.Entry)object : this.createEntry(feature, object));
            }
        }
    }

    protected boolean shouldUnset(EStructuralFeature feature, Object value) {
        if (!feature.isUnsettable()) {
            Object defaultValue = feature.getDefaultValue();
            return defaultValue == null ? value == null : defaultValue.equals(value);
        }
        return false;
    }

    public void add(int index, EStructuralFeature feature, Object object) {
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        if (this.isMany(feature)) {
            if (feature.isUnique() && this.contains(feature, object)) {
                throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
            }
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature()) && (isFeatureMap ? entry.equals(object) : (object == null ? entry.getValue() == null : object.equals(entry.getValue())))) {
                    throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
                }
                ++i;
            }
        }
        this.doAdd(index, isFeatureMap ? (FeatureMap.Entry)object : this.createEntry(feature, object));
    }

    public boolean add(EStructuralFeature feature, Object object) {
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        if (this.isMany(feature)) {
            if (feature.isUnique() && this.contains(feature, object)) {
                return false;
            }
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (isFeatureMap ? entry.equals(object) : (object == null ? entry.getValue() == null : object.equals(entry.getValue()))) {
                        return false;
                    }
                    this.doSet(i, isFeatureMap ? (FeatureMap.Entry)object : this.createEntry(feature, object));
                    return true;
                }
                ++i;
            }
        }
        return this.doAdd(isFeatureMap ? (FeatureMap.Entry)object : this.createEntry(feature, object));
    }

    public void add(EStructuralFeature feature, int index, Object object) {
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        if (this.isMany(feature)) {
            if (feature.isUnique() && this.contains(feature, object)) {
                throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
            }
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    throw new IllegalArgumentException("The multiplicity constraint is violated");
                }
                ++i;
            }
        }
        this.doAdd(this.entryIndex(feature, index), isFeatureMap ? (FeatureMap.Entry)object : this.createEntry(feature, object));
    }

    public boolean addAll(int index, EStructuralFeature feature, Collection collection) {
        Collection entryCollection;
        if (collection.size() == 0) {
            return false;
        }
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        Collection collection2 = entryCollection = isFeatureMap ? collection : new BasicEList(collection.size());
        if (this.isMany(feature)) {
            if (feature.isUnique()) {
                Iterator i = collection.iterator();
                while (i.hasNext()) {
                    FeatureMap.Entry entry;
                    Object object = i.next();
                    if (this.contains(feature, object) || entryCollection.contains(entry = this.createEntry(feature, object))) continue;
                    entryCollection.add(entry);
                }
            } else if (!isFeatureMap) {
                Iterator i = collection.iterator();
                while (i.hasNext()) {
                    FeatureMap.Entry entry = this.createEntry(feature, i.next());
                    entryCollection.add(entry);
                }
            }
        } else {
            if (collection.size() > 1) {
                throw new IllegalArgumentException("The multiplicity constraint is violated");
            }
            if (isFeatureMap) {
                if (this.contains(feature, collection.iterator().next())) {
                    return false;
                }
            } else {
                FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
                FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
                int i = 0;
                while (i < this.size) {
                    FeatureMap.Entry entry = entries[i];
                    if (validator.isValid(entry.getEStructuralFeature())) {
                        if (collection.contains(entry.getValue())) {
                            return false;
                        }
                        throw new IllegalArgumentException("The multiplicity constraint is violated");
                    }
                    ++i;
                }
                FeatureMap.Entry entry = this.createEntry(feature, collection.iterator().next());
                entryCollection.add(entry);
            }
        }
        return this.doAddAll(index, entryCollection);
    }

    public boolean addAll(EStructuralFeature feature, Collection collection) {
        Collection entryCollection;
        if (collection.size() == 0) {
            return false;
        }
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        Collection collection2 = entryCollection = isFeatureMap ? collection : new BasicEList(collection.size());
        if (this.isMany(feature)) {
            if (feature.isUnique()) {
                Iterator i = collection.iterator();
                while (i.hasNext()) {
                    FeatureMap.Entry entry;
                    Object object = i.next();
                    if (this.contains(feature, object) || entryCollection.contains(entry = this.createEntry(feature, object))) continue;
                    entryCollection.add(entry);
                }
            } else if (!isFeatureMap) {
                Iterator i = collection.iterator();
                while (i.hasNext()) {
                    FeatureMap.Entry entry = this.createEntry(feature, i.next());
                    entryCollection.add(entry);
                }
            }
        } else {
            if (collection.size() > 1) {
                throw new IllegalArgumentException("The multiplicity constraint is violated");
            }
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (collection.contains(isFeatureMap ? entry : entry.getValue())) {
                        return false;
                    }
                    Iterator j = collection.iterator();
                    while (j.hasNext()) {
                        this.doSet(i, isFeatureMap ? j.next() : this.createEntry(feature, j.next()));
                    }
                    return true;
                }
                ++i;
            }
            if (!isFeatureMap) {
                FeatureMap.Entry entry = this.createEntry(feature, collection.iterator().next());
                entryCollection.add(entry);
            }
        }
        return this.doAddAll(entryCollection);
    }

    public boolean addAll(EStructuralFeature feature, int index, Collection collection) {
        Collection entryCollection;
        if (collection.size() == 0) {
            return false;
        }
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        Collection collection2 = entryCollection = isFeatureMap ? collection : new BasicEList(collection.size());
        if (this.isMany(feature)) {
            if (feature.isUnique()) {
                Iterator i = collection.iterator();
                while (i.hasNext()) {
                    Object object = i.next();
                    if (this.contains(feature, object)) {
                        throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
                    }
                    FeatureMap.Entry entry = this.createEntry(feature, object);
                    entryCollection.add(entry);
                }
            } else if (!isFeatureMap) {
                Iterator i = collection.iterator();
                while (i.hasNext()) {
                    FeatureMap.Entry entry = this.createEntry(feature, i.next());
                    entryCollection.add(entry);
                }
            }
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    throw new IllegalArgumentException("The multiplicity constraint is violated");
                }
                ++i;
            }
            if (collection.size() > 1) {
                throw new IllegalArgumentException("The multiplicity constraint is violated");
            }
            if (!isFeatureMap) {
                FeatureMap.Entry entry = this.createEntry(feature, collection.iterator().next());
                entryCollection.add(entry);
            }
        }
        return this.doAddAll(this.entryIndex(feature, index), entryCollection);
    }

    public void addUnique(EStructuralFeature feature, Object object) {
        this.addUnique(this.createEntry(feature, object));
    }

    public void addUnique(EStructuralFeature feature, int index, Object object) {
        this.addUnique(this.entryIndex(feature, index), this.createEntry(feature, object));
    }

    public NotificationChain basicAdd(EStructuralFeature feature, Object object, NotificationChain notifications) {
        FeatureMap.Entry entry;
        if (object == null) {
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry2 = entries[i];
                if (entry2.getEStructuralFeature() == feature) {
                    return super.basicRemove((Object)entry2, notifications);
                }
                ++i;
            }
        }
        FeatureMap.Entry entry3 = entry = FeatureMapUtil.isFeatureMap(feature) ? (FeatureMap.Entry)object : this.createEntry(feature, object);
        if (this.isNotificationRequired()) {
            NotificationImpl notification;
            boolean oldIsSet = !this.isEmpty(feature);
            notifications = this.basicAdd(entry, notifications);
            NotificationImpl notificationImpl = notification = feature.isMany() ? this.createNotification(3, feature, null, object, this.indexOf(feature, object), oldIsSet) : this.createNotification(1, feature, feature.getDefaultValue(), object, -1, oldIsSet);
            if (notifications != null) {
                notifications.add((Notification)notification);
            } else {
                notifications = notification;
            }
        } else {
            notifications = this.basicAdd(entry, notifications);
        }
        return notifications;
    }

    public boolean remove(EStructuralFeature feature, Object object) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        if (FeatureMapUtil.isFeatureMap(feature)) {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature()) && entry.equals(object)) {
                    this.remove(i);
                    return true;
                }
                ++i;
            }
        } else if (object != null) {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature()) && object.equals(entry.getValue())) {
                    this.remove(i);
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature()) && entry.getValue() == null) {
                    this.remove(i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Object remove(EStructuralFeature feature, int index) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        int count = 0;
        int i = 0;
        while (i < this.size) {
            FeatureMap.Entry entry = entries[i];
            if (validator.isValid(entry.getEStructuralFeature())) {
                if (count == index) {
                    this.remove(i);
                    return FeatureMapUtil.isFeatureMap(feature) ? entry : entry.getValue();
                }
                ++count;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException("index=" + index + ", size=" + count);
    }

    public boolean removeAll(EStructuralFeature feature, Collection collection) {
        if (FeatureMapUtil.isFeatureMap(feature)) {
            return this.removeAll(collection);
        }
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        BasicEList entryCollection = new BasicEList(collection.size());
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        int i = this.size;
        while (--i >= 0) {
            FeatureMap.Entry entry = entries[i];
            if (!validator.isValid(entry.getEStructuralFeature()) || !collection.contains(entry.getValue())) continue;
            entryCollection.add(entry);
        }
        return this.removeAll((Collection)entryCollection);
    }

    public NotificationChain basicRemove(EStructuralFeature feature, Object object, NotificationChain notifications) {
        int i;
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int count = 0;
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        FeatureMap.Entry match = null;
        if (FeatureMapUtil.isFeatureMap(feature)) {
            i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (entry.equals(object)) {
                        match = entry;
                        break;
                    }
                    ++count;
                }
                ++i;
            }
        } else if (object != null) {
            i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (object.equals(entry.getValue())) {
                        match = entry;
                        break;
                    }
                    ++count;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (entry.getValue() == null) {
                        match = entry;
                        break;
                    }
                    ++count;
                }
                ++i;
            }
        }
        if (match != null) {
            if (this.isNotificationRequired()) {
                NotificationImpl notification;
                NotificationImpl notificationImpl = feature.isMany() ? this.createNotification(4, feature, object, null, count, true) : (notification = this.createNotification(feature.isUnsettable() ? 2 : 1, feature, object, feature.getDefaultValue(), -1, true));
                if (notifications != null) {
                    notifications.add((Notification)notification);
                } else {
                    notifications = notification;
                }
            }
            notifications = this.basicRemove(match, notifications);
        }
        return notifications;
    }

    public boolean retainAll(EStructuralFeature feature, Collection collection) {
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        BasicEList entryCollection = new BasicEList(collection.size());
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        int i = this.size;
        while (--i >= 0) {
            FeatureMap.Entry entry = entries[i];
            if (!validator.isValid(entry.getEStructuralFeature()) || collection.contains(isFeatureMap ? entry : entry.getValue())) continue;
            entryCollection.add(entry);
        }
        return this.removeAll((Collection)entryCollection);
    }

    public void clear(EStructuralFeature feature) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        BasicEList entryCollection = new BasicEList();
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        int i = this.size;
        while (--i >= 0) {
            FeatureMap.Entry entry = entries[i];
            if (!validator.isValid(entry.getEStructuralFeature())) continue;
            entryCollection.add(entry);
        }
        if (!this.removeAll((Collection)entryCollection)) {
            this.dispatchNotification((Notification)(feature.isMany() ? this.createNotification(6, feature, Collections.EMPTY_LIST, null, -1, false) : this.createNotification(feature.isUnsettable() ? 2 : 1, feature, null, null, -1, false)));
        }
    }

    public void move(EStructuralFeature feature, int index, Object object) {
        this.move(feature, index, this.indexOf(feature, object));
    }

    public Object move(EStructuralFeature feature, int targetIndex, int sourceIndex) {
        if (this.isMany(feature)) {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
            Object result = null;
            int entryTargetIndex = -1;
            int entrySourceIndex = -1;
            int count = 0;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (count == targetIndex) {
                        entryTargetIndex = i;
                    }
                    if (count == sourceIndex) {
                        entrySourceIndex = i;
                        result = entry.getValue();
                    }
                    ++count;
                }
                ++i;
            }
            if (entryTargetIndex == -1) {
                throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + count);
            }
            if (entrySourceIndex == -1) {
                throw new IndexOutOfBoundsException("sourceIndex=" + targetIndex + ", size=" + count);
            }
            this.doMove(entryTargetIndex, entrySourceIndex);
            if (this.isNotificationRequired()) {
                this.dispatchNotification((Notification)this.createNotification(7, feature, new Integer(sourceIndex), result, targetIndex, true));
            }
            return result;
        }
        throw new IllegalArgumentException("The feature must be many-valued to support move");
    }

    public Object get(EStructuralFeature feature, boolean resolve) {
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        if (this.isMany(feature)) {
            return this.list(feature);
        }
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int count = 0;
        int i = 0;
        while (i < this.size) {
            FeatureMap.Entry entry = entries[i];
            if (validator.isValid(entry.getEStructuralFeature())) {
                if (FeatureMapUtil.isFeatureMap(feature)) {
                    return entry;
                }
                Object value = entry.getValue();
                if (value != null && resolve && this.isResolveProxies(feature)) {
                    value = this.resolveProxy(feature, i, count, value);
                }
                return value;
            }
            ++count;
            ++i;
        }
        return feature.getDefaultValue();
    }

    public Object get(EStructuralFeature feature, int index, boolean resolve) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        if (this.isMany(feature)) {
            int count = 0;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (count == index) {
                        if (FeatureMapUtil.isFeatureMap(feature)) {
                            return entry;
                        }
                        Object value = entry.getValue();
                        if (value != null && resolve && this.isResolveProxies(feature)) {
                            value = this.resolveProxy(feature, i, count, entry.getValue());
                        }
                        return value;
                    }
                    ++count;
                }
                ++i;
            }
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + count);
        }
        int count = 0;
        int i = 0;
        while (i < this.size) {
            FeatureMap.Entry entry = entries[i];
            if (validator.isValid(entry.getEStructuralFeature())) {
                if (FeatureMapUtil.isFeatureMap(feature)) {
                    return entry;
                }
                Object value = entry.getValue();
                if (value != null && resolve && this.isResolveProxies(feature)) {
                    value = this.resolveProxy(feature, i, count, value);
                }
                return value;
            }
            ++count;
            ++i;
        }
        return feature.getDefaultValue();
    }

    public Object set(EStructuralFeature feature, int index, Object object) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        if (this.isMany(feature)) {
            int currentIndex;
            if (feature.isUnique() && (currentIndex = this.indexOf(feature, object)) >= 0 && currentIndex != index) {
                throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
            }
            int count = 0;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (count == index) {
                        return this.doSet(i, FeatureMapUtil.isFeatureMap(feature) ? object : this.createEntry(feature, object));
                    }
                    ++count;
                }
                ++i;
            }
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + count);
        }
        int i = 0;
        while (i < this.size) {
            FeatureMap.Entry entry = entries[i];
            if (validator.isValid(entry.getEStructuralFeature())) {
                return FeatureMapUtil.isFeatureMap(feature) ? entry : entry.getValue();
            }
            ++i;
        }
        return null;
    }

    public Object setUnique(EStructuralFeature feature, int index, Object object) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        if (this.isMany(feature)) {
            int count = 0;
            int i = 0;
            while (i < this.size) {
                FeatureMap.Entry entry = entries[i];
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (count == index) {
                        return this.setUnique(i, FeatureMapUtil.isFeatureMap(feature) ? object : this.createEntry(feature, object));
                    }
                    ++count;
                }
                ++i;
            }
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + count);
        }
        int i = 0;
        while (i < this.size) {
            FeatureMap.Entry entry = entries[i];
            if (validator.isValid(entry.getEStructuralFeature())) {
                return this.setUnique(i, FeatureMapUtil.isFeatureMap(feature) ? object : this.createEntry(feature, object));
            }
            ++i;
        }
        return feature.getDefaultValue();
    }

    public boolean isSet(EStructuralFeature feature) {
        return !this.isEmpty(feature);
    }

    public void unset(EStructuralFeature feature) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        List removals = null;
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        int i = 0;
        while (i < this.size) {
            FeatureMap.Entry entry = entries[i];
            if (validator.isValid(entry.getEStructuralFeature())) {
                if (removals == null) {
                    removals = new BasicEList();
                }
                removals.add(entry);
            }
            ++i;
        }
        if (removals != null) {
            this.removeAll(removals);
        }
    }

    public NotificationChain basicRemove(Object object, NotificationChain notifications) {
        if (object instanceof FeatureMap.Entry) {
            return super.basicRemove(object, notifications);
        }
        FeatureMap.Entry match = null;
        ETypedElement feature = null;
        FeatureMap.Entry[] entries = (FeatureMap.Entry[])this.data;
        int i = 0;
        while (i < this.size) {
            FeatureMap.Entry entry = entries[i];
            if (object.equals(entry.getValue()) && (feature = entry.getEStructuralFeature()) instanceof EReference && ((EReference)feature).isContainment()) {
                match = entry;
                break;
            }
            ++i;
        }
        if (match != null) {
            if (this.isNotificationRequired()) {
                NotificationImpl notification;
                NotificationImpl notificationImpl = feature.isMany() ? this.createNotification(4, (EStructuralFeature)feature, object, null, this.indexOf((EStructuralFeature)feature, object), true) : (notification = this.createNotification(feature.isUnsettable() ? 2 : 1, (EStructuralFeature)feature, object, feature.getDefaultValue(), -1, true));
                if (notifications != null) {
                    notifications.add((Notification)notification);
                } else {
                    notifications = notification;
                }
            }
            notifications = this.basicRemove(match, notifications);
        }
        return notifications;
    }

    protected class ValueListIteratorImpl
    extends BasicEList.EListIterator
    implements FeatureMap.ValueListIterator {
        public ValueListIteratorImpl() {
            super((BasicEList)BasicFeatureMap.this);
        }

        public ValueListIteratorImpl(int index) {
            super((BasicEList)BasicFeatureMap.this, index);
        }

        public EStructuralFeature feature() {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            return BasicFeatureMap.this.getEStructuralFeature(this.lastCursor);
        }

        public Object next() {
            return ((FeatureMap.Entry)super.next()).getValue();
        }

        public Object previous() {
            return ((FeatureMap.Entry)super.next()).getValue();
        }

        public void add(Object value) {
            super.add((Object)FeatureMapUtil.createEntry(this.feature(), value));
        }

        public void add(EStructuralFeature eStructuralFeature, Object value) {
            super.add((Object)FeatureMapUtil.createEntry(eStructuralFeature, value));
        }
    }

    public static class FeatureEIterator
    extends FeatureMapUtil.BasicFeatureEIterator {
        public FeatureEIterator(EStructuralFeature eStructuralFeature, FeatureMap.Internal featureMap) {
            super(eStructuralFeature, featureMap);
        }

        protected boolean scanNext() {
            int size = this.featureMap.size();
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])((BasicEList)this.featureMap).data();
            while (this.entryCursor < size) {
                FeatureMap.Entry entry = entries[this.entryCursor];
                if (this.validator.isValid(entry.getEStructuralFeature())) {
                    this.preparedResult = this.extractValue(entry);
                    this.prepared = 2;
                    return true;
                }
                ++this.entryCursor;
            }
            this.prepared = 1;
            this.lastCursor = -1;
            return false;
        }

        protected boolean scanPrevious() {
            FeatureMap.Entry[] entries = (FeatureMap.Entry[])((BasicEList)this.featureMap).data();
            while (--this.entryCursor >= 0) {
                FeatureMap.Entry entry = entries[this.entryCursor];
                if (!this.validator.isValid(entry.getEStructuralFeature())) continue;
                this.preparedResult = this.extractValue(entry);
                this.prepared = -2;
                return true;
            }
            this.prepared = -1;
            this.lastCursor = -1;
            return false;
        }
    }

    public static class ResolvingFeatureEIterator
    extends FeatureEIterator {
        public ResolvingFeatureEIterator(EStructuralFeature eStructuralFeature, FeatureMap.Internal featureMap) {
            super(eStructuralFeature, featureMap);
        }

        protected boolean resolve() {
            return true;
        }
    }

    public static class FeatureMapEObjectImpl
    extends EObjectImpl {
        protected BasicFeatureMap featureMap = new BasicFeatureMap(this, -1);

        public Object eDynamicGet(EStructuralFeature eFeature, boolean resolve) {
            if (eFeature instanceof EReference && ((EReference)eFeature).isContainer()) {
                return this.eSettingDelegate(eFeature).dynamicGet(this, null, -1, true);
            }
            return this.featureMap.setting(eFeature).get(resolve);
        }

        public void eDynamicSet(EStructuralFeature eFeature, Object newValue) {
            if (eFeature instanceof EReference && ((EReference)eFeature).isContainer()) {
                this.eSettingDelegate(eFeature).dynamicSet(this, null, -1, newValue);
            } else {
                Object defaultValue;
                if (!eFeature.isUnsettable() && ((defaultValue = eFeature.getDefaultValue()) == null ? newValue == null : defaultValue.equals(newValue))) {
                    this.featureMap.setting(eFeature).unset();
                    return;
                }
                this.featureMap.setting(eFeature).set(newValue);
            }
        }

        public void eDynamicUnset(EStructuralFeature eFeature) {
            if (eFeature instanceof EReference && ((EReference)eFeature).isContainer()) {
                this.eSettingDelegate(eFeature).dynamicUnset(this, null, -1);
            } else {
                this.featureMap.setting(eFeature).unset();
            }
        }

        public boolean eDynamicIsSet(EStructuralFeature eFeature) {
            if (eFeature instanceof EReference && ((EReference)eFeature).isContainer()) {
                return this.eSettingDelegate(eFeature).dynamicIsSet(this, null, -1);
            }
            return this.featureMap.setting(eFeature).isSet();
        }

        public NotificationChain eDynamicInverseAdd(InternalEObject otherEnd, int featureID, Class inverseClass, NotificationChain notifications) {
            EStructuralFeature.Internal feature = (EStructuralFeature.Internal)this.eClass().getEAllStructuralFeatures().get(featureID);
            if (feature.isMany()) {
                return this.featureMap.basicAdd(feature, otherEnd, notifications);
            }
            if (feature instanceof EReference && ((EReference)((Object)feature)).isContainer()) {
                return this.eSettingDelegate(feature).dynamicInverseAdd(this, null, -1, otherEnd, notifications);
            }
            InternalEObject oldValue = (InternalEObject)this.eDynamicGet(feature, false);
            if (oldValue != null) {
                notifications = oldValue.eInverseRemove(this, oldValue.eClass().getEAllStructuralFeatures().indexOf((Object)((EReference)((Object)feature)).getEOpposite()), null, notifications);
                notifications = this.featureMap.basicRemove(feature, oldValue, notifications);
            }
            return this.featureMap.basicAdd(feature, otherEnd, notifications);
        }

        public NotificationChain eDynamicInverseRemove(InternalEObject otherEnd, int featureID, Class inverseClass, NotificationChain notifications) {
            EStructuralFeature.Internal feature = (EStructuralFeature.Internal)this.eClass().getEAllStructuralFeatures().get(featureID);
            if (feature instanceof EReference && ((EReference)((Object)feature)).isContainer()) {
                return this.eSettingDelegate(feature).dynamicInverseRemove(this, null, -1, otherEnd, notifications);
            }
            return this.featureMap.basicRemove(feature, otherEnd, notifications);
        }

        public FeatureMap featureMap() {
            return this.featureMap;
        }

        public void eNotify(Notification notification) {
            if (notification.getFeatureID(null) != -1) {
                super.eNotify(notification);
            }
        }

        public String toString() {
            String result = super.toString();
            result = "org.eclipse.emf.ecore.impl.EObjectImpl" + result.substring(result.indexOf("@"));
            return result;
        }
    }
}

