/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDRedefinableComponent;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDRedefineContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDComplexTypeDefinitionImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDParticleImpl;
import org.eclipse.xsd.impl.XSDRedefineContentImpl;
import org.eclipse.xsd.impl.XSDSchemaCompositorImpl;
import org.eclipse.xsd.impl.XSDSchemaDirectiveImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDRedefineImpl
extends XSDSchemaCompositorImpl
implements XSDRedefine {
    protected EList annotations = null;
    protected EList contents = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static XSDRedefine createRedefine(Node node) {
        if (XSDConstants.nodeType(node) == 31) {
            XSDRedefine xsdRedefine = XSDFactory.eINSTANCE.createXSDRedefine();
            xsdRedefine.setElement((Element)node);
            return xsdRedefine;
        }
        return null;
    }

    protected XSDRedefineImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDRedefine();
    }

    public EList getAnnotations() {
        if (this.annotations == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.xsd.XSDAnnotation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.annotations = new EObjectEList((Class)clazz, (InternalEObject)this, 8);
        }
        return this.annotations;
    }

    public EList getContents() {
        if (this.contents == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.xsd.XSDRedefineContent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.contents = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 9);
        }
        return this.contents;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove((Object)otherEnd, msgs);
                }
                case 9: {
                    return ((InternalEList)this.getContents()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getSchemaLocation();
            }
            case 6: {
                return this.getResolvedSchema();
            }
            case 7: {
                return this.getIncorporatedSchema();
            }
            case 8: {
                return this.getAnnotations();
            }
            case 9: {
                return this.getContents();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setSchemaLocation((String)newValue);
                return;
            }
            case 6: {
                this.setResolvedSchema((XSDSchema)newValue);
                return;
            }
            case 7: {
                this.setIncorporatedSchema((XSDSchema)newValue);
                return;
            }
            case 8: {
                this.getAnnotations().clear();
                this.getAnnotations().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getContents().clear();
                this.getContents().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(XSDConcreteComponentImpl.ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setSchemaLocation(XSDSchemaDirectiveImpl.SCHEMA_LOCATION_EDEFAULT);
                return;
            }
            case 6: {
                this.setResolvedSchema(null);
                return;
            }
            case 7: {
                this.setIncorporatedSchema(null);
                return;
            }
            case 8: {
                this.getAnnotations().clear();
                return;
            }
            case 9: {
                this.getContents().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return XSDConcreteComponentImpl.ELEMENT_EDEFAULT == null ? this.element != null : !XSDConcreteComponentImpl.ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return XSDSchemaDirectiveImpl.SCHEMA_LOCATION_EDEFAULT == null ? this.schemaLocation != null : !XSDSchemaDirectiveImpl.SCHEMA_LOCATION_EDEFAULT.equals(this.schemaLocation);
            }
            case 6: {
                return this.resolvedSchema != null;
            }
            case 7: {
                return this.incorporatedSchema != null;
            }
            case 8: {
                return this.annotations != null && !this.annotations.isEmpty();
            }
            case 9: {
                return this.contents != null && !this.contents.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public Element createElement() {
        Element newElement = this.createElement(31);
        this.setElement(newElement);
        Iterator contents = this.getContents().iterator();
        while (contents.hasNext()) {
            XSDRedefineContent xsdRedefineContent = (XSDRedefineContent)contents.next();
            Element contentElement = ((XSDConcreteComponentImpl)((Object)xsdRedefineContent)).createElement();
            newElement.appendChild(contentElement);
        }
        return newElement;
    }

    protected void patch() {
        if (this.getSchemaLocation() != null && this.getSchemaLocation().length() > 0) {
            XSDSchemaImpl containingSchema = (XSDSchemaImpl)this.getContainer();
            String oldPendingSchemaLocation = containingSchema.pendingSchemaLocation;
            if (containingSchema.getSchemaLocation() != null) {
                containingSchema.pendingSchemaLocation = containingSchema.getSchemaLocation();
            }
            this.resolve("", this.getSchemaLocation());
            containingSchema.pendingSchemaLocation = oldPendingSchemaLocation;
            super.patch();
            if (oldPendingSchemaLocation == null) {
                List redefinitions = containingSchema.getSchemasToRedefine();
                containingSchema.schemasToRedefine = null;
                Iterator i = redefinitions.iterator();
                while (i.hasNext()) {
                    XSDSchemaImpl schemaToRedefine = (XSDSchemaImpl)i.next();
                    if (schemaToRedefine == containingSchema) continue;
                    schemaToRedefine.forceResolve = true;
                    schemaToRedefine.patch();
                    schemaToRedefine.forceResolve = false;
                    schemaToRedefine.pendingSchemaLocation = null;
                }
            }
        } else {
            super.patch();
        }
    }

    protected void handleResolvedSchema(XSDSchema xsdSchema) {
        if (xsdSchema == null) {
            this.setResolvedSchema(null);
            this.setIncorporatedSchema(null);
        } else {
            ((XSDSchemaImpl)xsdSchema).redefined(this);
        }
    }

    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-redefine", theElement, new String[]{"id", "schemaLocation"});
            XSDComplexTypeDefinition xsdComplexTypeDefinition = (XSDComplexTypeDefinition)this.getSchema().getSchemaForSchema().resolveElementDeclaration("redefine").getTypeDefinition();
            this.checkComplexContent(xsdComplexTypeDefinition, "http://www.w3.org/TR/xmlschema-1/", "element-redefine", theElement);
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-redefine", theElement, "id", false);
        }
        this.checkBuiltInTypeConstraint("anyURI", this.getSchemaLocation(), "http://www.w3.org/TR/xmlschema-1/", "element-redefine", theElement, "schemaLocation", true);
        XSDSchema theResolvedSchema = this.getResolvedSchema();
        if (theResolvedSchema == null) {
            boolean hasRedefinitions = false;
            Iterator i = this.getContents().iterator();
            while (i.hasNext()) {
                if (i.next() instanceof XSDAnnotation) continue;
                hasRedefinitions = true;
                break;
            }
            if (hasRedefinitions) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.1", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
            } else {
                this.createDiagnostic(XSDDiagnosticSeverity.WARNING_LITERAL, "src-redefine.0", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
            }
        } else if (theResolvedSchema.eResource() == null || theResolvedSchema.getElement() == null || XSDConstants.nodeType(theResolvedSchema.getElement()) != 33) {
            this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.2", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
        } else {
            XSDSchema theSchema = this.getSchema();
            if (theSchema.getTargetNamespace() == null ? theResolvedSchema.getTargetNamespace() != null : !theSchema.getTargetNamespace().equals(theResolvedSchema.getTargetNamespace()) && theResolvedSchema.getTargetNamespace() != null) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.3", theResolvedSchema.getTargetNamespace() == null ? "" : theResolvedSchema.getTargetNamespace(), theSchema.getTargetNamespace() == null ? "" : theSchema.getTargetNamespace());
            } else {
                Iterator i = this.getContents().iterator();
                while (i.hasNext()) {
                    Object component;
                    Object j;
                    ArrayList<XSDRedefinableComponent> selfReferences;
                    XSDRedefineContent xsdRedefineContent = (XSDRedefineContent)i.next();
                    if (xsdRedefineContent instanceof XSDTypeDefinition) {
                        XSDTypeDefinition xsdTypeDefinition = (XSDTypeDefinition)xsdRedefineContent;
                        XSDTypeDefinition baseType = xsdTypeDefinition.getBaseType();
                        if (baseType != null && baseType.hasSameNameAndTargetNamespace(xsdTypeDefinition) && this.resolveTypeDefinition(xsdTypeDefinition.getName()).getContainer() != null) continue;
                        this.getDiagnosticTarget(xsdTypeDefinition).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.5", xsdTypeDefinition.getName());
                        continue;
                    }
                    if (xsdRedefineContent instanceof XSDModelGroupDefinition) {
                        XSDModelGroupDefinition xsdModelGroupDefinition = (XSDModelGroupDefinition)xsdRedefineContent;
                        selfReferences = new ArrayList<XSDRedefinableComponent>();
                        j = xsdModelGroupDefinition.eAllContents();
                        while (j.hasNext()) {
                            XSDModelGroupDefinition otherXSDModelGroupDefinition;
                            component = j.next();
                            if (!(component instanceof XSDModelGroupDefinition) || !xsdModelGroupDefinition.hasSameNameAndTargetNamespace((otherXSDModelGroupDefinition = (XSDModelGroupDefinition)component).getResolvedModelGroupDefinition())) continue;
                            selfReferences.add(otherXSDModelGroupDefinition);
                        }
                        if (selfReferences.isEmpty()) {
                            XSDModelGroupDefinition otherXSDModelGroupDefinition = theResolvedSchema.resolveModelGroupDefinition(xsdModelGroupDefinition.getName());
                            if (otherXSDModelGroupDefinition.getContainer() == null) {
                                ((XSDConcreteComponentImpl)((Object)xsdModelGroupDefinition)).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.6.2.1", xsdModelGroupDefinition.getName());
                                continue;
                            }
                            XSDParticle xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
                            xsdParticle.setTerm(xsdModelGroupDefinition.getModelGroup());
                            XSDParticle otherXSDParticle = XSDFactory.eINSTANCE.createXSDParticle();
                            otherXSDParticle.setTerm(otherXSDModelGroupDefinition.getModelGroup());
                            if (((XSDParticleImpl)xsdParticle).isSubset(otherXSDParticle, true)) continue;
                            ((XSDConcreteComponentImpl)((Object)xsdModelGroupDefinition)).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.6.2.2");
                            continue;
                        }
                        j = selfReferences.iterator();
                        XSDModelGroupDefinition otherXSDModelGroupDefinition = (XSDModelGroupDefinition)j.next();
                        XSDParticle xsdParticle = (XSDParticle)otherXSDModelGroupDefinition.getContainer();
                        if (xsdParticle.getMinOccurs() != 1 || xsdParticle.getMaxOccurs() != 1) {
                            ((XSDConcreteComponentImpl)((Object)xsdParticle)).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.6.1.2");
                        }
                        while (j.hasNext()) {
                            XSDConcreteComponentImpl xsdConcreteComponent = (XSDConcreteComponentImpl)j.next();
                            xsdConcreteComponent.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.6.1.1");
                        }
                        continue;
                    }
                    if (!(xsdRedefineContent instanceof XSDAttributeGroupDefinition)) continue;
                    XSDAttributeGroupDefinition xsdAttributeGroupDefinition = (XSDAttributeGroupDefinition)xsdRedefineContent;
                    selfReferences = new ArrayList();
                    j = xsdAttributeGroupDefinition.eAllContents();
                    while (j.hasNext()) {
                        XSDAttributeGroupDefinition otherXSDAttributeGroupDefinition;
                        component = j.next();
                        if (!(component instanceof XSDAttributeGroupDefinition) || !xsdAttributeGroupDefinition.hasSameNameAndTargetNamespace((otherXSDAttributeGroupDefinition = (XSDAttributeGroupDefinition)component).getResolvedAttributeGroupDefinition())) continue;
                        selfReferences.add(otherXSDAttributeGroupDefinition);
                    }
                    if (selfReferences.isEmpty()) {
                        XSDAttributeGroupDefinition otherXSDAttributeGroupDefinition = theResolvedSchema.resolveAttributeGroupDefinition(xsdAttributeGroupDefinition.getName());
                        if (otherXSDAttributeGroupDefinition.getContainer() == null) {
                            ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupDefinition)).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.7.2.1", xsdAttributeGroupDefinition.getName());
                            continue;
                        }
                        XSDComplexTypeDefinitionImpl.validateAttributeGroup((XSDConcreteComponentImpl)((Object)xsdAttributeGroupDefinition), xsdAttributeGroupDefinition.getAttributeWildcardContent(), otherXSDAttributeGroupDefinition.getAttributeUses(), xsdAttributeGroupDefinition.getAttributeUses(), otherXSDAttributeGroupDefinition.getAttributeWildcard(), xsdAttributeGroupDefinition.getAttributeWildcard());
                        continue;
                    }
                    j = selfReferences.iterator();
                    j.next();
                    while (j.hasNext()) {
                        XSDConcreteComponentImpl xsdConcreteComponent = (XSDConcreteComponentImpl)j.next();
                        xsdConcreteComponent.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.7.1");
                    }
                }
            }
        }
    }

    protected void handleUnreconciledElement(Element child, List newContents, List remainingContents) {
        XSDRedefineContent xsdRedefineContent = XSDRedefineContentImpl.createRedefineContent(child);
        if (xsdRedefineContent != null) {
            newContents.add(xsdRedefineContent);
        }
    }

    protected void handleReconciliation(List newContents, List remainingContents) {
        if (!remainingContents.isEmpty()) {
            this.getContents().removeAll((Collection)remainingContents);
        }
        XSDConcreteComponentImpl.setListContentAndOrder(this.getContents(), newContents);
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDRedefineImpl clonedRedefine = (XSDRedefineImpl)this.getXSDFactory().createXSDRedefine();
        clonedRedefine.isReconciling = true;
        clonedRedefine.setSchemaLocation(this.getSchemaLocation());
        if (deep && !this.getContents().isEmpty()) {
            clonedRedefine.getContents().addAll((Collection)XSDConcreteComponentImpl.cloneConcreteComponents((List)this.getContents(), true, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedRedefine.setElement(this.getElement());
        }
        clonedRedefine.isReconciling = shareDOM;
        return clonedRedefine;
    }
}

