/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.w3c.dom.Element;

public class XMISaveImpl
extends XMLSaveImpl {
    protected boolean xmiType;
    protected static final String XMI_ID_NS = "xmi:id";
    protected static final String XMI_TAG_NS = "xmi:XMI";
    protected static final String XMI_TYPE_NS = "xmi:type";
    protected static final String XMI_VER_NS = "xmi:version";
    protected static final String XMI_XMLNS = "xmlns:xmi";

    public XMISaveImpl(XMLHelper helper) {
        super(helper);
        this.idAttributeName = XMI_ID_NS;
    }

    public XMISaveImpl(Map options, XMLHelper helper, String encoding) {
        super(options, helper, encoding);
        this.xmiType = Boolean.TRUE.equals(options.get("USE_XMI_TYPE"));
        this.idAttributeName = XMI_ID_NS;
    }

    protected void init(XMLResource resource, Map options) {
        super.init(resource, options);
        this.xmiType = Boolean.TRUE.equals(options.get("USE_XMI_TYPE"));
        this.helper.getPrefixToNamespaceMap().put((Object)"xmi", (Object)"http://www.omg.org/XMI");
    }

    public Object writeTopObjects(List contents) {
        if (!this.toDOM) {
            this.doc.startElement(XMI_TAG_NS);
            Object mark = this.doc.mark();
            int i = 0;
            int size = contents.size();
            while (i < size) {
                EObject top = (EObject)contents.get(i);
                EClass eClass = top.eClass();
                String name = this.helper.getQName(eClass);
                this.doc.startElement(name);
                this.saveElementID(top);
                ++i;
            }
            this.doc.endElement();
            return mark;
        }
        this.currentNode = this.document.createElementNS("http://www.omg.org/XMI", XMI_TAG_NS);
        this.document.appendChild(this.currentNode);
        int i = 0;
        int size = contents.size();
        while (i < size) {
            EObject top = (EObject)contents.get(i);
            EClass eClass = top.eClass();
            this.helper.populateNameInfo(this.nameInfo, eClass);
            this.currentNode = this.currentNode.appendChild(this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName()));
            this.handler.recordValues(this.currentNode, null, null, top);
            this.saveElementID(top);
            ++i;
        }
        return null;
    }

    protected void saveTypeAttribute(EClass eClass) {
        if (this.xmiType) {
            if (!this.toDOM) {
                this.doc.addAttribute(XMI_TYPE_NS, this.helper.getQName(eClass));
            } else {
                ((Element)this.currentNode).setAttributeNS("http://www.omg.org/XMI", XMI_TYPE_NS, this.helper.getQName(eClass));
            }
        } else {
            super.saveTypeAttribute(eClass);
        }
    }

    public void addNamespaceDeclarations() {
        if (!this.toDOM) {
            this.doc.addAttribute(XMI_VER_NS, "2.0");
            this.doc.addAttribute(XMI_XMLNS, "http://www.omg.org/XMI");
        } else {
            ((Element)this.currentNode).setAttributeNS("http://www.omg.org/XMI", XMI_VER_NS, "2.0");
            ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2000/xmlns/", XMI_XMLNS, "http://www.omg.org/XMI");
        }
        super.addNamespaceDeclarations();
    }

    public boolean isDuplicateURI(String nsURI) {
        return "http://www.omg.org/XMI".equals(nsURI);
    }
}

