/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: EChangeSummaryImpl.java,v 1.14 2005/02/08 21:08:38 marcelop Exp $
 */
package org.eclipse.emf.ecore.sdo.impl;


import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.InternalEDataObject;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>EChange Summary</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EChangeSummaryImpl#isLogging <em>Logging</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EChangeSummaryImpl#getDataGraph <em>Data Graph</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EChangeSummaryImpl#getChangedDataObjects <em>Changed Data Objects</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EChangeSummaryImpl#getEDataGraph <em>EData Graph</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class EChangeSummaryImpl extends ChangeDescriptionImpl implements EChangeSummary, InternalEDataObject
{
  /**
   * The default value of the '{@link #isLogging() <em>Logging</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #isLogging()
   * @generated
   * @ordered
   */
  protected static final boolean LOGGING_EDEFAULT = false;

  /**
   * The cached value of the '{@link #getEDataGraph() <em>EData Graph</em>}' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getEDataGraph()
   * @generated
   * @ordered
   */
  protected EDataGraph eDataGraph = null;

  protected ChangeRecorder changeRecorder = null;
  protected EList cachedObjectsToDetach = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EChangeSummaryImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EClass eStaticClass()
  {
    return SDOPackage.eINSTANCE.getEChangeSummary();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public boolean isLogging()
  {
    return changeRecorder != null;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EDataGraph getEDataGraph()
  {
    return eDataGraph;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain basicSetEDataGraph(EDataGraph newEDataGraph, NotificationChain msgs)
  {
    EDataGraph oldEDataGraph = eDataGraph;
    eDataGraph = newEDataGraph;
    if (eNotificationRequired())
    {
      ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SDOPackage.ECHANGE_SUMMARY__EDATA_GRAPH, oldEDataGraph, newEDataGraph);
      if (msgs == null) msgs = notification; else msgs.add(notification);
    }
    return msgs;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setEDataGraph(EDataGraph newEDataGraph)
  {
    if (newEDataGraph != eDataGraph)
    {
      NotificationChain msgs = null;
      if (eDataGraph != null)
        msgs = ((InternalEObject)eDataGraph).eInverseRemove(this, SDOPackage.EDATA_GRAPH__ECHANGE_SUMMARY, EDataGraph.class, msgs);
      if (newEDataGraph != null)
        msgs = ((InternalEObject)newEDataGraph).eInverseAdd(this, SDOPackage.EDATA_GRAPH__ECHANGE_SUMMARY, EDataGraph.class, msgs);
      msgs = basicSetEDataGraph(newEDataGraph, msgs);
      if (msgs != null) msgs.dispatch();
    }
    else if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, SDOPackage.ECHANGE_SUMMARY__EDATA_GRAPH, newEDataGraph, newEDataGraph));
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public void beginLogging()
  {
    if (isLogging())
    {
      throw new IllegalStateException("Already logging");
    }

    getObjectsToAttach().clear();
    getObjectChanges().clear();
    getResourceChanges().clear();

    oldContainmentInformation = null;
    changeRecorder = new SDOChangeRecorder();
    changeRecorder.beginRecording(Collections.singleton(getEDataGraph().getRootResource()));
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, SDOPackage.ECHANGE_SUMMARY__LOGGING, false, true));
  }
  
  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public void resumeLogging()
  {
    if (isLogging())
    {
      throw new IllegalStateException("Already logging");
    }

    oldContainmentInformation = null;
    
    changeRecorder = new SDOChangeRecorder();
    changeRecorder.beginRecording(this, Collections.singleton(getEDataGraph().getRootResource()));

    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, SDOPackage.ECHANGE_SUMMARY__LOGGING, false, true));
  }  

  protected class SDOChangeRecorder extends ChangeRecorder
  {
    public SDOChangeRecorder()
    {
      super();
    }
    
    public void beginRecording(ChangeDescription changeDescription, Collection rootObjects)
    {
      deletedObjects = null;
      cachedObjectsToDetach = null;
      super.beginRecording(changeDescription, rootObjects);
    }

    protected ChangeDescription createChangeDescription()
    {
      return EChangeSummaryImpl.this;
    }

    protected FeatureChange createFeatureChange(EObject eObject, EStructuralFeature eStructuralFeature, Object value, boolean isSet)
    {
      EProperty eProperty = SDOUtil.adaptProperty(eStructuralFeature);
      if (eProperty.isReadOnly())
      {
        if (SDOUtil.getDataGraph(eObject) != null)
        {
          throw 
            new IllegalStateException
              ("The property '" + eProperty.getName() + "' of type '" + 
                 SDOUtil.adaptType(eStructuralFeature.getEContainingClass()).getName() + "' is read only");
        }
      }
      return SDOFactory.eINSTANCE.createEChangeSummarySetting(eStructuralFeature, value, isSet);
    }
    
    protected void consolidateChanges()
    {
      deletedObjects = null;
      cachedObjectsToDetach = null;
      super.consolidateChanges();
    }    
  } 

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public void endLogging()
  {
    if (!isLogging())
    {
      throw new IllegalStateException("Not currently logging");
    }
    
    changeRecorder.endRecording();
    changeRecorder.dispose();
    changeRecorder = null;
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, SDOPackage.ECHANGE_SUMMARY__LOGGING, true, false));
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public boolean isCreated(DataObject dataObject)
  {
    return getObjectsToDetach().contains(dataObject);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public boolean isDeleted(DataObject dataObject)
  {
    return getDeletedObjects().contains(dataObject);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public List getOldValues(DataObject dataObject)
  {
    return (List)getObjectChanges().get(dataObject);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public void summarize()
  {
    if (!isLogging())
    {
      throw new IllegalStateException("Not currently logging");
    }
    
    changeRecorder.summarize();
  }

  public boolean isChanged(DataObject dataObject)
  {
    return getObjectChanges().containsKey(dataObject) && !isDeleted(dataObject) && !isCreated(dataObject);
  }

  public Setting getOldValue(DataObject dataObject, Property property)
  {
    for (Iterator i = getOldValues(dataObject).iterator(); i.hasNext(); )
    {
      Setting setting = (Setting)i.next();
      if (setting.getProperty() == property)
      {
        return setting;
      }
    }

    return null;
  }

  public DataObject getOldContainer(DataObject dataObject)
  {
    return (DataObject)getOldContainer((EObject)dataObject);
  }

  public Property getOldContainmentProperty(DataObject dataObject)
  {
    return SDOUtil.adaptProperty(getOldContainmentFeature((EObject)dataObject));
  }
  
  public EList getObjectsToDetach()
  {
    if (cachedObjectsToDetach == null)
    {
      cachedObjectsToDetach = super.getObjectsToDetach();
    }
    return cachedObjectsToDetach;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object get(String path)
  {
    return SDOUtil.get(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void set(String path, Object value)
  {
    SDOUtil.set(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean isSet(String path)
  {
    return SDOUtil.isSet(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void unset(String path)
  {
    SDOUtil.unset(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object get(int propertyIndex)
  {
    return SDOUtil.get(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void set(int propertyIndex, Object value)
  {
    SDOUtil.set(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean isSet(int propertyIndex)
  {
    return SDOUtil.isSet(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void unset(int propertyIndex)
  {
    SDOUtil.unset(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object get(Property property)
  {
    return SDOUtil.get(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void set(Property property, Object value)
  {
    SDOUtil.set(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean isSet(Property property)
  {
    return SDOUtil.isSet(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void unset(Property property)
  {
    SDOUtil.unset(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DataObject getContainer()
  {
    return SDOUtil.getContainer(this);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Property getContainmentProperty()
  {
    return SDOUtil.getContainmentProperty(this);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public DataGraph getDataGraph()
  {
    return getEDataGraph();
  }

  protected Set deletedObjects;

  protected void preApply(boolean reverse)
  {
    super.preApply(reverse);
    deletedObjects = null;
  }

  protected Set getDeletedObjects()
  {
    if (deletedObjects == null)
    {
      deletedObjects = new HashSet();
      for (Iterator i = EcoreUtil.getAllContents(getObjectsToAttach()); i.hasNext(); )
      {
        deletedObjects.add(i.next());
      }
    }
    return deletedObjects;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public EList getChangedDataObjectsGen()
  {
    EList result = new UniqueEList.FastCompare(getDeletedObjects());
    result.addAll(getObjectsToDetach());
    for (Iterator i = getObjectChanges().iterator(); i.hasNext(); )
    {
      Map.Entry entry = (Map.Entry)i.next();
      result.add(entry.getKey());
    }
    return result;
  }

  public List getChangedDataObjects()
  {
    return getChangedDataObjectsGen();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Type getType()
  {
    return SDOUtil.getType(this);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public BigDecimal getBigDecimal(String path)
  {
    return SDOUtil.getBigDecimal(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public BigInteger getBigInteger(String path)
  {
    return SDOUtil.getBigInteger(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean getBoolean(String path)
  {
    return SDOUtil.getBoolean(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public byte getByte(String path)
  {
    return SDOUtil.getByte(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public byte[] getBytes(String path)
  {
    return SDOUtil.getBytes(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public char getChar(String path)
  {
    return SDOUtil.getChar(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DataObject getDataObject(String path)
  {
    return SDOUtil.getDataObject(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Date getDate(String path)
  {
    return SDOUtil.getDate(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public double getDouble(String path)
  {
    return SDOUtil.getDouble(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public float getFloat(String path)
  {
    return SDOUtil.getFloat(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public int getInt(String path)
  {
    return SDOUtil.getInt(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public List getList(String path)
  {
    return SDOUtil.getList(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public long getLong(String path)
  {
    return SDOUtil.getLong(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Sequence getSequence(String path)
  {
    return SDOUtil.getSequence(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public short getShort(String path)
  {
    return SDOUtil.getShort(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String getString(String path)
  {
    return SDOUtil.getString(this, path);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBigDecimal(String path, BigDecimal value)
  {
    SDOUtil.setBigDecimal(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBigInteger(String path, BigInteger value)
  {
    SDOUtil.setBigInteger(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBoolean(String path, boolean value)
  {
    SDOUtil.setBoolean(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setByte(String path, byte value)
  {
    SDOUtil.setByte(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBytes(String path, byte[] value)
  {
    SDOUtil.setBytes(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setChar(String path, char value)
  {
    SDOUtil.setChar(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setDataObject(String path, DataObject value)
  {
    SDOUtil.setDataObject(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setDate(String path, Date value)
  {
    SDOUtil.setDate(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setDouble(String path, double value)
  {
    SDOUtil.setDouble(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setFloat(String path, float value)
  {
    SDOUtil.setFloat(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setInt(String path, int value)
  {
    SDOUtil.setInt(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setList(String path, List value)
  {
    SDOUtil.setList(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setLong(String path, long value)
  {
    SDOUtil.setLong(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setShort(String path, short value)
  {
    SDOUtil.setShort(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setString(String path, String value)
  {
    SDOUtil.setString(this, path, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public BigDecimal getBigDecimal(int propertyIndex)
  {
    return SDOUtil.getBigDecimal(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public BigInteger getBigInteger(int propertyIndex)
  {
    return SDOUtil.getBigInteger(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean getBoolean(int propertyIndex)
  {
    return SDOUtil.getBoolean(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public byte getByte(int propertyIndex)
  {
    return SDOUtil.getByte(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public byte[] getBytes(int propertyIndex)
  {
    return SDOUtil.getBytes(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public char getChar(int propertyIndex)
  {
    return SDOUtil.getChar(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DataObject getDataObject(int propertyIndex)
  {
    return SDOUtil.getDataObject(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Date getDate(int propertyIndex)
  {
    return SDOUtil.getDate(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public double getDouble(int propertyIndex)
  {
    return SDOUtil.getDouble(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public float getFloat(int propertyIndex)
  {
    return SDOUtil.getFloat(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public int getInt(int propertyIndex)
  {
    return SDOUtil.getInt(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public List getList(int propertyIndex)
  {
    return SDOUtil.getList(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public long getLong(int propertyIndex)
  {
    return SDOUtil.getLong(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Sequence getSequence(int propertyIndex)
  {
    return SDOUtil.getSequence(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public short getShort(int propertyIndex)
  {
    return SDOUtil.getShort(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String getString(int propertyIndex)
  {
    return SDOUtil.getString(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBigDecimal(int propertyIndex, BigDecimal value)
  {
    SDOUtil.setBigDecimal(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBigInteger(int propertyIndex, BigInteger value)
  {
    SDOUtil.setBigInteger(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBoolean(int propertyIndex, boolean value)
  {
    SDOUtil.setBoolean(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setByte(int propertyIndex, byte value)
  {
    SDOUtil.setByte(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBytes(int propertyIndex, byte[] value)
  {
    SDOUtil.setBytes(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setChar(int propertyIndex, char value)
  {
    SDOUtil.setChar(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setDataObject(int propertyIndex, DataObject value)
  {
    SDOUtil.setDataObject(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setDate(int propertyIndex, Date value)
  {
    SDOUtil.setDate(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setDouble(int propertyIndex, double value)
  {
    SDOUtil.setDouble(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setFloat(int propertyIndex, float value)
  {
    SDOUtil.setFloat(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setInt(int propertyIndex, int value)
  {
    SDOUtil.setInt(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setList(int propertyIndex, List value)
  {
    SDOUtil.setList(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setLong(int propertyIndex, long value)
  {
    SDOUtil.setLong(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setShort(int propertyIndex, short value)
  {
    SDOUtil.setShort(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setString(int propertyIndex, String value)
  {
    SDOUtil.setString(this, propertyIndex, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public BigDecimal getBigDecimal(Property property)
  {
    return SDOUtil.getBigDecimal(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public BigInteger getBigInteger(Property property)
  {
    return SDOUtil.getBigInteger(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean getBoolean(Property property)
  {
    return SDOUtil.getBoolean(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public byte getByte(Property property)
  {
    return SDOUtil.getByte(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public byte[] getBytes(Property property)
  {
    return SDOUtil.getBytes(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public char getChar(Property property)
  {
    return SDOUtil.getChar(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DataObject getDataObject(Property property)
  {
    return SDOUtil.getDataObject(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Date getDate(Property property)
  {
    return SDOUtil.getDate(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public double getDouble(Property property)
  {
    return SDOUtil.getDouble(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public float getFloat(Property property)
  {
    return SDOUtil.getFloat(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public int getInt(Property property)
  {
    return SDOUtil.getInt(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public List getList(Property property)
  {
    return SDOUtil.getList(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public long getLong(Property property)
  {
    return SDOUtil.getLong(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Sequence getSequence(Property property)
  {
    return SDOUtil.getSequence(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public short getShort(Property property)
  {
    return SDOUtil.getShort(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String getString(Property property)
  {
    return SDOUtil.getString(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBigDecimal(Property property, BigDecimal value)
  {
    SDOUtil.setBigDecimal(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBigInteger(Property property, BigInteger value)
  {
    SDOUtil.setBigInteger(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBoolean(Property property, boolean value)
  {
    SDOUtil.setBoolean(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setByte(Property property, byte value)
  {
    SDOUtil.setByte(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setBytes(Property property, byte[] value)
  {
    SDOUtil.setBytes(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setChar(Property property, char value)
  {
    SDOUtil.setChar(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setDataObject(Property property, DataObject value)
  {
    SDOUtil.setDataObject(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setDate(Property property, Date value)
  {
    SDOUtil.setDate(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setDouble(Property property, double value)
  {
    SDOUtil.setDouble(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setFloat(Property property, float value)
  {
    SDOUtil.setFloat(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setInt(Property property, int value)
  {
    SDOUtil.setInt(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setList(Property property, List value)
  {
    SDOUtil.setList(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setLong(Property property, long value)
  {
    SDOUtil.setLong(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setShort(Property property, short value)
  {
    SDOUtil.setShort(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setString(Property property, String value)
  {
    SDOUtil.setString(this, property, value);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DataObject createDataObject(String propertyName)
  {
    return SDOUtil.createDataObject(this, propertyName);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DataObject createDataObject(int propertyIndex)
  {
    return SDOUtil.createDataObject(this, propertyIndex);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DataObject createDataObject(Property property)
  {
    return SDOUtil.createDataObject(this, property);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DataObject createDataObject(String propertyName, String namespaceURI, String typeName)
  {
    return SDOUtil.createDataObject(this, propertyName, namespaceURI, typeName);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DataObject createDataObject(int propertyIndex, String namespaceURI, String typeName)
  {
    return SDOUtil.createDataObject(this, propertyIndex, namespaceURI, typeName);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DataObject createDataObject(Property property, Type type)
  {
    return SDOUtil.createDataObject(this, property, type);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void delete()
  {
    SDOUtil.delete(this);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public List getInstanceProperties()
  {
    return SDOUtil.getInstanceProperties(this);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object writeReplace() throws ObjectStreamException
  {
    return SDOUtil.writeReplace(this);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    if (featureID >= 0)
    {
      switch (eDerivedStructuralFeatureID(featureID, baseClass))
      {
        case SDOPackage.ECHANGE_SUMMARY__EDATA_GRAPH:
          if (eDataGraph != null)
            msgs = ((InternalEObject)eDataGraph).eInverseRemove(this, SDOPackage.EDATA_GRAPH__ECHANGE_SUMMARY, EDataGraph.class, msgs);
          return basicSetEDataGraph((EDataGraph)otherEnd, msgs);
        default:
          return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
      }
    }
    if (eContainer != null)
      msgs = eBasicRemoveFromContainer(msgs);
    return eBasicSetContainer(otherEnd, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    if (featureID >= 0)
    {
      switch (eDerivedStructuralFeatureID(featureID, baseClass))
      {
        case SDOPackage.ECHANGE_SUMMARY__OBJECT_CHANGES:
          return ((InternalEList)getObjectChanges()).basicRemove(otherEnd, msgs);
        case SDOPackage.ECHANGE_SUMMARY__OBJECTS_TO_ATTACH:
          return ((InternalEList)getObjectsToAttach()).basicRemove(otherEnd, msgs);
        case SDOPackage.ECHANGE_SUMMARY__RESOURCE_CHANGES:
          return ((InternalEList)getResourceChanges()).basicRemove(otherEnd, msgs);
        case SDOPackage.ECHANGE_SUMMARY__EDATA_GRAPH:
          return basicSetEDataGraph(null, msgs);
        default:
          return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
      }
    }
    return eBasicSetContainer(null, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object eGet(EStructuralFeature eFeature, boolean resolve)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.ECHANGE_SUMMARY__OBJECT_CHANGES:
        return getObjectChanges();
      case SDOPackage.ECHANGE_SUMMARY__OBJECTS_TO_DETACH:
        return getObjectsToDetach();
      case SDOPackage.ECHANGE_SUMMARY__OBJECTS_TO_ATTACH:
        return getObjectsToAttach();
      case SDOPackage.ECHANGE_SUMMARY__RESOURCE_CHANGES:
        return getResourceChanges();
      case SDOPackage.ECHANGE_SUMMARY__LOGGING:
        return isLogging() ? Boolean.TRUE : Boolean.FALSE;
      case SDOPackage.ECHANGE_SUMMARY__DATA_GRAPH:
        return getDataGraph();
      case SDOPackage.ECHANGE_SUMMARY__CHANGED_DATA_OBJECTS:
        return getChangedDataObjects();
      case SDOPackage.ECHANGE_SUMMARY__EDATA_GRAPH:
        return getEDataGraph();
    }
    return eDynamicGet(eFeature, resolve);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eSet(EStructuralFeature eFeature, Object newValue)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.ECHANGE_SUMMARY__OBJECT_CHANGES:
        getObjectChanges().clear();
        getObjectChanges().addAll((Collection)newValue);
        return;
      case SDOPackage.ECHANGE_SUMMARY__OBJECTS_TO_DETACH:
        getObjectsToDetach().clear();
        getObjectsToDetach().addAll((Collection)newValue);
        return;
      case SDOPackage.ECHANGE_SUMMARY__OBJECTS_TO_ATTACH:
        getObjectsToAttach().clear();
        getObjectsToAttach().addAll((Collection)newValue);
        return;
      case SDOPackage.ECHANGE_SUMMARY__RESOURCE_CHANGES:
        getResourceChanges().clear();
        getResourceChanges().addAll((Collection)newValue);
        return;
      case SDOPackage.ECHANGE_SUMMARY__EDATA_GRAPH:
        setEDataGraph((EDataGraph)newValue);
        return;
    }
    eDynamicSet(eFeature, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eUnset(EStructuralFeature eFeature)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.ECHANGE_SUMMARY__OBJECT_CHANGES:
        getObjectChanges().clear();
        return;
      case SDOPackage.ECHANGE_SUMMARY__OBJECTS_TO_DETACH:
        getObjectsToDetach().clear();
        return;
      case SDOPackage.ECHANGE_SUMMARY__OBJECTS_TO_ATTACH:
        getObjectsToAttach().clear();
        return;
      case SDOPackage.ECHANGE_SUMMARY__RESOURCE_CHANGES:
        getResourceChanges().clear();
        return;
      case SDOPackage.ECHANGE_SUMMARY__EDATA_GRAPH:
        setEDataGraph((EDataGraph)null);
        return;
    }
    eDynamicUnset(eFeature);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean eIsSet(EStructuralFeature eFeature)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.ECHANGE_SUMMARY__OBJECT_CHANGES:
        return objectChanges != null && !objectChanges.isEmpty();
      case SDOPackage.ECHANGE_SUMMARY__OBJECTS_TO_DETACH:
        return cachedObjectsToDetach != null && !cachedObjectsToDetach.isEmpty();
      case SDOPackage.ECHANGE_SUMMARY__OBJECTS_TO_ATTACH:
        return objectsToAttach != null && !objectsToAttach.isEmpty();
      case SDOPackage.ECHANGE_SUMMARY__RESOURCE_CHANGES:
        return resourceChanges != null && !resourceChanges.isEmpty();
      case SDOPackage.ECHANGE_SUMMARY__LOGGING:
        return isLogging() != LOGGING_EDEFAULT;
      case SDOPackage.ECHANGE_SUMMARY__DATA_GRAPH:
        return getDataGraph() != null;
      case SDOPackage.ECHANGE_SUMMARY__CHANGED_DATA_OBJECTS:
        return !getChangedDataObjects().isEmpty();
      case SDOPackage.ECHANGE_SUMMARY__EDATA_GRAPH:
        return eDataGraph != null;
    }
    return eDynamicIsSet(eFeature);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public int eBaseStructuralFeatureID(int derivedFeatureID, Class baseClass)
  {
    if (baseClass == ChangeSummary.class)
    {
      switch (derivedFeatureID)
      {
        case SDOPackage.ECHANGE_SUMMARY__LOGGING: return SDOPackage.CHANGE_SUMMARY__LOGGING;
        case SDOPackage.ECHANGE_SUMMARY__DATA_GRAPH: return SDOPackage.CHANGE_SUMMARY__DATA_GRAPH;
        case SDOPackage.ECHANGE_SUMMARY__CHANGED_DATA_OBJECTS: return SDOPackage.CHANGE_SUMMARY__CHANGED_DATA_OBJECTS;
        default: return -1;
      }
    }
    return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass)
  {
    if (baseClass == ChangeSummary.class)
    {
      switch (baseFeatureID)
      {
        case SDOPackage.CHANGE_SUMMARY__LOGGING: return SDOPackage.ECHANGE_SUMMARY__LOGGING;
        case SDOPackage.CHANGE_SUMMARY__DATA_GRAPH: return SDOPackage.ECHANGE_SUMMARY__DATA_GRAPH;
        case SDOPackage.CHANGE_SUMMARY__CHANGED_DATA_OBJECTS: return SDOPackage.ECHANGE_SUMMARY__CHANGED_DATA_OBJECTS;
        default: return -1;
      }
    }
    return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
  }

} //EChangeSummaryImpl
