/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.rose2ecore.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.Util;

public class RoseNode {
    public static final int STRING = 0;
    public static final int STRING_SEQ = 1;
    public static final int OBJECT = 2;
    public static final int LIST = 3;
    public static final int VALUE = 4;
    protected String key;
    protected String value;
    protected RoseNode parent;
    protected List nodes = new ArrayList();
    protected int type;
    protected String id;
    protected boolean commit = true;
    protected Object node;
    protected static final Pattern FEATURE_VALUE_PATTERN = Pattern.compile("\\s*\\(\\s*\"FeatureKind\"\\s+([0-9]+)\\s*\\)");
    protected static final Pattern CONTENT_VALUE_PATTERN = Pattern.compile("\\s*\\(\\s*\"ContentKind\"\\s+([0-9]+)\\s*\\)");
    public static final int VISIBILITY_UNSPECIFIED = 0;
    public static final int VISIBILITY_NONE = 1;
    public static final int VISIBILITY_READ_ONLY = 2;
    public static final int VISIBILITY_READ_WRITE = 3;
    public static final int VISIBILITY_READ_ONLY_UNSETTABLE = 4;
    public static final int VISIBILITY_READ_WRITE_UNSETTABLE = 5;
    protected static final Pattern VISIBILITY_VALUE_PATTERN = Pattern.compile("\\s*\\(\\s*\"VisibilityKind\"\\s+([0-9]+)\\s*\\)");

    public RoseNode(String key, String value, int type) {
        this.key = key;
        this.value = value;
        this.type = type;
    }

    public void setParent(RoseNode parent) {
        this.parent = parent;
    }

    public RoseNode getParent() {
        return this.parent;
    }

    public RoseNode getRoot() {
        RoseNode result = this;
        RoseNode root = this.getParent();
        while (root != null) {
            result = root;
            root = root.getParent();
        }
        return result;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getAllValues() {
        return this.getAllValues(false);
    }

    public String getAllValues(boolean preserveSpace) {
        if (this.type == 1) {
            StringBuffer temp = new StringBuffer();
            int i = 0;
            while (i < this.nodes.size()) {
                RoseNode n = (RoseNode)this.nodes.get(i);
                temp.append(n.getValue());
                if (preserveSpace && i < this.nodes.size() - 1) {
                    temp.append('\n');
                }
                ++i;
            }
            return temp.toString();
        }
        return preserveSpace ? Util.trimQuotes(this.value) : this.value;
    }

    public String getFilteredValues(String filter) {
        if (this.type == 1) {
            StringBuffer temp = new StringBuffer();
            int i = 0;
            while (i < this.nodes.size()) {
                RoseNode n = (RoseNode)this.nodes.get(i);
                if (i != 0 || !Util.getWord(n.getValue(), 1).equals(filter)) {
                    temp.append(n.getValue());
                    if (i < this.nodes.size() - 1) {
                        temp.append('\n');
                    }
                }
                ++i;
            }
            return temp.toString();
        }
        String val = Util.trimQuotes(this.value);
        return Util.getWord(val, 1).equals(filter) ? "" : val;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean getCommit() {
        return this.commit;
    }

    public void setCommit(boolean b) {
        this.commit = b;
    }

    public String getId() {
        return this.id;
    }

    public String getAtId() {
        int ind = this.value.lastIndexOf("@");
        return ind != -1 ? this.value.substring(ind + 1) : null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getRoseNodeType() {
        return this.type;
    }

    public List getNodes() {
        return this.nodes;
    }

    public void addNode(RoseNode n) {
        n.parent = this;
        this.nodes.add(n);
    }

    public void deleteNode(RoseNode n) {
        if (n != null) {
            this.nodes.remove(n);
        }
    }

    public RoseNode findNodeWithKey(String key) {
        int i = 0;
        while (i < this.nodes.size()) {
            RoseNode node = (RoseNode)this.nodes.get(i);
            if (key.equals(node.getKey())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public RoseNode findNodeWithValue(String value) {
        int i = 0;
        while (i < this.nodes.size()) {
            RoseNode node = (RoseNode)this.nodes.get(i);
            if (value.equals(node.getValue())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public RoseNode findNodeWithWord(String w) {
        int i = 0;
        while (i < this.nodes.size()) {
            RoseNode node = (RoseNode)this.nodes.get(i);
            String value = node.getValue();
            StringTokenizer st = new StringTokenizer(value);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (!tok.equals(w)) continue;
                return node;
            }
            ++i;
        }
        return null;
    }

    public String getRoseId() {
        RoseNode node = this.findNodeWithKey("quid");
        return node != null ? node.getValue() : null;
    }

    public String getRoseRefId() {
        RoseNode node = this.findNodeWithKey("quidu");
        return node != null ? node.getValue() : null;
    }

    public String getRoseSupplier() {
        RoseNode node = this.findNodeWithKey("supplier");
        return node != null ? Util.trimQuotes(node.getValue()) : null;
    }

    public void setNode(Object node) {
        this.node = node;
    }

    public Object getNode() {
        return this.node;
    }

    public String getType() {
        String attributeValue = this.getAttributeValue("type");
        return attributeValue;
    }

    public String getStereotype() {
        String attributeValue = this.getAttributeValue("stereotype");
        return attributeValue;
    }

    public boolean isDerived() {
        String attributeValue = this.getAttributeValue("derived");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isAbstract() {
        String attributeValue = this.getAttributeValue("abstract");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isNavigable() {
        String attributeValue = this.getAttributeValue("is_navigable");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isAggregate() {
        String attributeValue = this.getAttributeValue("is_aggregate");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public String getContainment() {
        String attributeValue = this.getAttributeValue("Containment");
        return attributeValue;
    }

    public String getConstraints() {
        String attributeValue = this.getAttributeValue("Constraints");
        return attributeValue;
    }

    public String getResult() {
        String attributeValue = this.getAttributeValue("result");
        return attributeValue;
    }

    public String getExceptions() {
        String attributeValue = this.getAttributeValue("exceptions");
        return attributeValue;
    }

    public String getSemantics() {
        RoseNode semantics = this.findNodeWithKey("semantics");
        return semantics == null ? null : semantics.getAttributeValue("PDL");
    }

    public String getInitV() {
        String attributeValue = this.getAttributeValue("initv");
        return attributeValue;
    }

    public String getDocumentation() {
        String attributeValue = this.getAttributeValue("documentation");
        return attributeValue;
    }

    public boolean isLoaded() {
        String attributeValue = this.getAttributeValue("is_loaded");
        return attributeValue == null || "true".equalsIgnoreCase(attributeValue);
    }

    protected String getAttributeValue(String key) {
        Iterator i = this.getNodes().iterator();
        while (i.hasNext()) {
            RoseNode roseNode = (RoseNode)i.next();
            if (roseNode.getRoseNodeType() == 0) {
                String nodeKey = roseNode.getKey();
                String nodeValue = roseNode.getValue();
                if (!nodeKey.equals(key)) continue;
                nodeValue = RoseNode.dequote(nodeValue);
                return nodeValue;
            }
            if (roseNode.getRoseNodeType() != 1 || !roseNode.getKey().equals(key)) continue;
            String separator = System.getProperty("line.separator");
            List subNodes = roseNode.getNodes();
            StringBuffer result = new StringBuffer();
            Iterator j = subNodes.iterator();
            while (j.hasNext()) {
                RoseNode subNode = (RoseNode)j.next();
                if (subNode.getRoseNodeType() != 0) continue;
                if (subNode.getValue().equals("")) {
                    result.append(separator);
                    continue;
                }
                if (result.length() != 0) {
                    result.append(separator);
                }
                result.append(subNode.getValue());
            }
            return result.toString();
        }
        return null;
    }

    public String getUML2MOFCorbaType() {
        String attributeValue = this.getAttributeValue("MOF", "uml2mof.corbaType");
        return attributeValue;
    }

    public boolean isTransient() {
        String attributeValue = this.getAttributeValue("Ecore", "isTransient");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isVolatile() {
        String attributeValue = this.getAttributeValue("Ecore", "isVolatile");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isChangeable() {
        String attributeValue = this.getAttributeValue("Ecore", "isChangeable");
        return !"false".equalsIgnoreCase(attributeValue);
    }

    public boolean isResolveProxies() {
        String attributeValue = this.getAttributeValue("Ecore", "isResolveProxies");
        return !"false".equalsIgnoreCase(attributeValue);
    }

    public boolean isUnsettable() {
        String attributeValue = this.getAttributeValue("Ecore", "isUnsettable");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isID() {
        String attributeValue = this.getAttributeValue("Ecore", "isID");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isUnique() {
        String attributeValue = this.getAttributeValue("Ecore", "isUnique");
        return !"false".equalsIgnoreCase(attributeValue);
    }

    public String getBasePackage() {
        String attributeValue = this.getAttributeValue("Ecore", "basePackage");
        return attributeValue;
    }

    public String getPrefix() {
        String attributeValue = this.getAttributeValue("Ecore", "prefix");
        return attributeValue;
    }

    public String getPackageName() {
        String attributeValue = this.getAttributeValue("Ecore", "packageName");
        return attributeValue;
    }

    public String getClassifierName() {
        String attributeValue = this.getAttributeValue("Ecore", "classifierName");
        return attributeValue;
    }

    public String getEcoreConstraints() {
        String attributeValue = this.getAttributeValue("Ecore", "constraints");
        return attributeValue;
    }

    public String getReferenceName() {
        String attributeValue = this.getAttributeValue("Ecore", "referenceName");
        return attributeValue;
    }

    public String getAttributeName() {
        String attributeValue = this.getAttributeValue("Ecore", "attributeName");
        return attributeValue;
    }

    public String getOperationName() {
        String attributeValue = this.getAttributeValue("Ecore", "operationName");
        return attributeValue;
    }

    public String getNsPrefix() {
        String attributeValue = this.getAttributeValue("Ecore", "nsPrefix");
        if (attributeValue == null || attributeValue.length() == 0) {
            attributeValue = this.getAttributeValue("Ecore", "nsName");
        }
        return attributeValue;
    }

    public String getNsURI() {
        String attributeValue = this.getAttributeValue("Ecore", "nsURI");
        return attributeValue;
    }

    public String getXMLName() {
        String attributeValue = this.getAttributeValue("Ecore", "xmlName");
        return attributeValue;
    }

    public String getXMLNamespace() {
        String attributeValue = this.getAttributeValue("Ecore", "xmlNamespace");
        return attributeValue;
    }

    public int getXMLFeatureKind() {
        Matcher matcher;
        String attributeValue = this.getAttributeValue("Ecore", "xmlFeatureKind");
        if (attributeValue != null && (matcher = FEATURE_VALUE_PATTERN.matcher(attributeValue)).matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }

    public int getXMLContentKind() {
        Matcher matcher;
        String attributeValue = this.getAttributeValue("Ecore", "xmlContentKind");
        if (attributeValue != null && (matcher = CONTENT_VALUE_PATTERN.matcher(attributeValue)).matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }

    public int getVisibility() {
        Matcher matcher;
        String attributeValue = this.getAttributeValue("Ecore", "visibility");
        if (attributeValue != null && (matcher = VISIBILITY_VALUE_PATTERN.matcher(attributeValue)).matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }

    public String getAnnotation() {
        String attributeValue = this.getAttributeValue("Ecore", "annotation");
        if ("".equals(attributeValue)) {
            attributeValue = null;
        }
        return attributeValue;
    }

    protected String getAttributeValue(String tool, String name) {
        String result = this.basicGetAttributeValue(tool, name);
        if (result == null && "Ecore".equals(tool)) {
            result = this.basicGetAttributeValue("eCore", name);
        }
        return result;
    }

    protected String basicGetAttributeValue(String tool, String name) {
        RoseNode attributeListNode = this.findNodeWithKey("attributes");
        String value = this.getAttributeValueInAttributeList(attributeListNode, tool, name);
        if (value == null) {
            value = this.getAttributeValueInAttributeList(this.getDefaultAttributeList(tool), tool, name);
        }
        return value;
    }

    private String getAttributeValueInAttributeList(RoseNode attributeListNode, String tool, String name) {
        List attributeNodes;
        if (attributeListNode != null && (attributeNodes = attributeListNode.getNodes()) != null) {
            Iterator i = attributeNodes.iterator();
            while (i.hasNext()) {
                RoseNode attributeNode = (RoseNode)i.next();
                List nodes = attributeNode.getNodes();
                if (nodes == null) continue;
                String setName = "";
                String tagName = "";
                String valueName = "";
                Iterator j = nodes.iterator();
                while (j.hasNext()) {
                    List stringNodes;
                    String stringV;
                    RoseNode node = (RoseNode)j.next();
                    if (node.getRoseNodeType() == 0) {
                        stringV = RoseNode.dequote(node.getValue());
                        if (node.getKey().equals("tool")) {
                            setName = stringV;
                            continue;
                        }
                        if (node.getKey().equals("name")) {
                            tagName = stringV;
                            continue;
                        }
                        if (!node.getKey().equals("value")) continue;
                        valueName = stringV;
                        continue;
                    }
                    if (node.getRoseNodeType() == 1) {
                        node.getNodes();
                        stringV = "";
                        Iterator k = node.getNodes().iterator();
                        while (k.hasNext()) {
                            RoseNode subSubNode = (RoseNode)k.next();
                            if (subSubNode.getRoseNodeType() != 0) continue;
                            if (stringV.length() > 0) {
                                stringV = String.valueOf(stringV) + " ";
                            }
                            stringV = String.valueOf(stringV) + subSubNode.getValue();
                        }
                        if (node.getKey().equals("tool")) {
                            setName = stringV;
                            continue;
                        }
                        if (node.getKey().equals("name")) {
                            tagName = stringV;
                            continue;
                        }
                        if (!node.getKey().equals("value")) continue;
                        valueName = stringV;
                        continue;
                    }
                    if (node.getRoseNodeType() != 4 || (stringNodes = node.getNodes()) == null || stringNodes.size() != 1) continue;
                    RoseNode stringNode = (RoseNode)stringNodes.get(0);
                    String stringV2 = "";
                    if (stringNode.getRoseNodeType() == 0) {
                        stringV2 = stringNode.getValue();
                    } else if (stringNode.getRoseNodeType() == 1) {
                        Iterator k = stringNode.getNodes().iterator();
                        while (k.hasNext()) {
                            RoseNode subSubNode = (RoseNode)k.next();
                            if (subSubNode.getRoseNodeType() != 0) continue;
                            if (stringV2.length() > 0) {
                                stringV2 = String.valueOf(stringV2) + " ";
                            }
                            stringV2 = String.valueOf(stringV2) + subSubNode.getValue();
                        }
                    }
                    stringV2 = RoseNode.dequote(stringV2);
                    if (node.getKey().equals("tool")) {
                        setName = stringV2;
                        continue;
                    }
                    if (node.getKey().equals("name")) {
                        tagName = stringV2;
                        continue;
                    }
                    if (!node.getKey().equals("value")) continue;
                    valueName = stringV2;
                }
                if (!setName.equals(tool) || !tagName.equals(name)) continue;
                return valueName;
            }
        }
        return null;
    }

    private RoseNode getDefaultAttributeList(String tool) {
        RoseNode attributeListNode = null;
        RoseNode rootNode = this.getRoot();
        String rootNodeValue = rootNode.getValue();
        rootNode.getKey();
        String rootObjectType = Util.getType(rootNodeValue);
        if (rootObjectType.equals("Design")) {
            String objectType = Util.getType(this.getValue());
            RoseNode defaultProperties = rootNode.findNodeWithKey("properties");
            if (defaultProperties != null) {
                RoseNode attributes = defaultProperties.findNodeWithKey("attributes");
                Iterator i = attributes.getNodes().iterator();
                while (i.hasNext()) {
                    RoseNode attribute = (RoseNode)i.next();
                    RoseNode toolNode = attribute.findNodeWithKey("tool");
                    if (toolNode == null || !Util.trimQuotes(toolNode.getValue()).equals(tool)) continue;
                    RoseNode nameNode = attribute.findNodeWithKey("name");
                    String theName = Util.trimQuotes(nameNode.getValue());
                    if (objectType.equals("ClassAttribute") && theName.equals("default__Attribute")) {
                        attributeListNode = attribute.findNodeWithKey("value");
                        break;
                    }
                    if (objectType.equals("Class") && theName.equals("default__Class")) {
                        attributeListNode = attribute.findNodeWithKey("value");
                        break;
                    }
                    if (objectType.equals("Class_Category") && theName.equals("default__Category")) {
                        attributeListNode = attribute.findNodeWithKey("value");
                        break;
                    }
                    if (objectType.equals("Operation") && theName.equals("default__Operation")) {
                        attributeListNode = attribute.findNodeWithKey("value");
                        break;
                    }
                    if (!objectType.equals("Role") || !theName.equals("default__Role")) continue;
                    attributeListNode = attribute.findNodeWithKey("value");
                    break;
                }
            }
        }
        return attributeListNode;
    }

    public String getRoleMultiplicity() {
        List nodes = this.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            RoseNode node = (RoseNode)nodes.get(i);
            if (node.getRoseNodeType() == 4) {
                String objKey = node.getKey();
                String objType = Util.getType(node.getValue());
                Util.getName(node.getValue());
                if (objKey.equals("client_cardinality") && objType.equals("cardinality")) {
                    List subNodes = node.getNodes();
                    String value = "";
                    int j = 0;
                    while (j < subNodes.size()) {
                        RoseNode subNode = (RoseNode)subNodes.get(j);
                        if (subNode.getRoseNodeType() == 0) {
                            value = subNode.getValue();
                            value = value.substring(1, value.length() - 1);
                        } else if (subNode.getRoseNodeType() == 1) {
                            List subSubNodes = subNode.getNodes();
                            int k = 0;
                            while (k < subSubNodes.size()) {
                                RoseNode subSubNode = (RoseNode)subSubNodes.get(k);
                                if (subSubNode.getRoseNodeType() == 0) {
                                    value = String.valueOf(subSubNode.getValue()) + "|#" + value;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    return value;
                }
            }
            ++i;
        }
        return null;
    }

    protected static String dequote(String s) {
        if (s != null && s.length() >= 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
            int i = s.indexOf("\\\\");
            while (i != -1) {
                s = String.valueOf(s.substring(0, i)) + s.substring(i + 1, s.length());
                i = s.indexOf("\\\\");
            }
        }
        return s;
    }
}

