/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SetCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = EMFEditPlugin.INSTANCE.getString("_UI_SetCommand_label");
    protected static final String DESCRIPTION = EMFEditPlugin.INSTANCE.getString("_UI_SetCommand_description");
    protected EObject owner;
    protected EStructuralFeature feature;
    protected EList ownerList;
    protected Object value;
    protected Object oldValue;
    protected int index;
    protected boolean canUndo = true;
    protected static final EcorePackage ecorePackage = EcorePackage.eINSTANCE;
    static /* synthetic */ Class class$0;

    public static Command create(EditingDomain domain, Object owner, Object feature, Object value) {
        return SetCommand.create(domain, owner, feature, value, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Command create(EditingDomain domain, final Object owner, Object feature, Object value, int index) {
        Class<?> clazz;
        block30: {
            EReference eOtherEnd;
            EReference eReference;
            block31: {
                if (!(owner instanceof EObject) || !((EObject)owner).eClass().getEAllReferences().contains(feature)) break block30;
                eReference = (EReference)feature;
                if (eReference.isMany() && index == -1) {
                    List values = (List)value;
                    List oldValues = (List)((EObject)owner).eGet((EStructuralFeature)eReference);
                    if (values.isEmpty() && oldValues.isEmpty()) {
                        return new IdentityCommand(LABEL, DESCRIPTION, owner){

                            public Collection getAffectedObjects() {
                                return Collections.singleton(owner);
                            }
                        };
                    }
                    CompoundCommand compound = new CompoundCommand(Integer.MIN_VALUE, LABEL, DESCRIPTION){

                        public Collection getAffectedObjects() {
                            return Collections.singleton(owner);
                        }
                    };
                    if (!oldValues.isEmpty()) {
                        if (!values.isEmpty()) {
                            BasicEList.FastCompare removedValues = new BasicEList.FastCompare((Collection)oldValues);
                            removedValues.removeAll(values);
                            if (!removedValues.equals(oldValues)) {
                                if (!removedValues.isEmpty()) {
                                    compound.append(RemoveCommand.create(domain, owner, feature, (Collection)new BasicEList((Collection)removedValues)));
                                }
                                BasicEList.FastCompare remainingValues = new BasicEList.FastCompare((Collection)oldValues);
                                remainingValues.removeAll((Collection<?>)removedValues);
                                int count = -1;
                                Iterator i = values.iterator();
                                while (true) {
                                    if (!i.hasNext()) break;
                                    Object object = i.next();
                                    int position = remainingValues.indexOf(object);
                                    if (position == -1 || position == ++count) continue;
                                    compound.append(MoveCommand.create(domain, owner, feature, object, count));
                                }
                                BasicEList.FastCompare addedValues = new BasicEList.FastCompare((Collection)values);
                                addedValues.removeAll((Collection<?>)remainingValues);
                                ListIterator i2 = values.listIterator();
                                while (true) {
                                    if (!i2.hasNext()) {
                                        return compound;
                                    }
                                    Object object = i2.next();
                                    if (!addedValues.contains(object)) continue;
                                    compound.append(AddCommand.create(domain, owner, feature, object, i2.previousIndex()));
                                }
                            }
                        }
                        compound.append(RemoveCommand.create(domain, owner, feature, (Collection)new BasicEList((Collection)oldValues)));
                    }
                    if (values.isEmpty()) return compound;
                    compound.append(AddCommand.create(domain, owner, feature, values));
                    return compound;
                }
                if (eReference.getEOpposite() == null) break block30;
                eOtherEnd = eReference.getEOpposite();
                if (!eOtherEnd.isMany()) break block31;
                if (eReference.isMany()) {
                    EObject oldValue;
                    EList oppositeList;
                    EList list = (EList)((EObject)owner).eGet((EStructuralFeature)eReference);
                    if (index == list.size() - 1 && (oppositeList = (EList)(oldValue = (EObject)list.get(index)).eGet((EStructuralFeature)eOtherEnd)).get(oppositeList.size() - 1) != owner) {
                        CompoundCommand compound = new CompoundCommand(Integer.MIN_VALUE, LABEL, DESCRIPTION){

                            public Collection getAffectedObjects() {
                                return Collections.singleton(owner);
                            }
                        };
                        compound.append(RemoveCommand.create(domain, (Object)oldValue, (Object)eOtherEnd, owner));
                        compound.append(AddCommand.create(domain, owner, feature, value));
                        return compound;
                    }
                    break block30;
                } else {
                    Object oldValue = ((EObject)owner).eGet((EStructuralFeature)eReference);
                    if (value == null) {
                        Class<?> clazz2;
                        if (oldValue != null) return RemoveCommand.create(domain, oldValue, (Object)eOtherEnd, Collections.singleton(owner));
                        Class<?> clazz3 = class$0;
                        Class<?> clazz4 = clazz3;
                        if (clazz3 != null) return domain.createCommand(clazz4, new CommandParameter(owner, (Object)eReference, value));
                        try {
                            clazz2 = Class.forName("org.eclipse.emf.edit.command.SetCommand");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz4 = class$0 = clazz2;
                        return domain.createCommand(clazz4, new CommandParameter(owner, (Object)eReference, value));
                    }
                    CommandWrapper addCommand = new CommandWrapper(AddCommand.create(domain, value, (Object)eOtherEnd, Collections.singleton(owner))){

                        public Collection getAffectedObjects() {
                            return Collections.singleton(owner);
                        }
                    };
                    if (oldValue == null) {
                        return addCommand;
                    }
                    CompoundCommand compound = new CompoundCommand(Integer.MIN_VALUE, LABEL, DESCRIPTION);
                    compound.append(RemoveCommand.create(domain, oldValue, (Object)eOtherEnd, Collections.singleton(owner)));
                    compound.append((Command)addCommand);
                    return compound;
                }
            }
            if (eOtherEnd.isContainment()) {
                if (value != null) {
                    return new CommandWrapper(SetCommand.create(domain, value, eOtherEnd, owner)){

                        public Collection getResult() {
                            return Collections.singleton(owner);
                        }

                        public Collection getAffectedObjects() {
                            return Collections.singleton(owner);
                        }
                    };
                }
            } else if (value instanceof EObject && ((EObject)value).eGet((EStructuralFeature)eOtherEnd) != null) {
                Class<?> clazz5;
                CompoundCommand compound = new CompoundCommand(Integer.MIN_VALUE){

                    public boolean canUndo() {
                        return true;
                    }
                };
                if (eReference.isMany()) {
                    compound.append(SetCommand.create(domain, value, eOtherEnd, null));
                } else {
                    Class<?> clazz6 = class$0;
                    if (clazz6 == null) {
                        Class<?> clazz7;
                        try {
                            clazz7 = Class.forName("org.eclipse.emf.edit.command.SetCommand");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz6 = class$0 = clazz7;
                    }
                    compound.append(domain.createCommand(clazz6, new CommandParameter(value, (Object)eOtherEnd, null)));
                }
                if ((clazz5 = class$0) == null) {
                    Class<?> clazz8;
                    try {
                        clazz8 = Class.forName("org.eclipse.emf.edit.command.SetCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz5 = class$0 = clazz8;
                }
                compound.append(domain.createCommand(clazz5, new CommandParameter(owner, (Object)eReference, value, index)));
                return compound;
            }
        }
        Class<?> clazz9 = class$0;
        Class<?> clazz10 = clazz9;
        if (clazz9 != null) return domain.createCommand(clazz10, new CommandParameter(owner, feature, value, index));
        try {
            clazz = Class.forName("org.eclipse.emf.edit.command.SetCommand");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        clazz10 = class$0 = clazz;
        return domain.createCommand(clazz10, new CommandParameter(owner, feature, value, index));
    }

    public SetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.feature = feature;
        this.value = value;
        this.index = -1;
    }

    public SetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.feature = feature;
        this.value = value;
        this.index = index;
        if (index != -1) {
            this.ownerList = AbstractOverrideableCommand.getOwnerList(owner, feature);
        }
    }

    public EObject getOwner() {
        return this.owner;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public EList getOwnerList() {
        return this.ownerList;
    }

    public int getIndex() {
        return this.index;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    protected boolean prepare() {
        boolean result = false;
        if (this.owner != null) {
            if (this.domain.isReadOnly(this.owner.eResource())) {
                return false;
            }
            EClass eMetaObject = this.owner.eClass();
            if (eMetaObject.getEAllAttributes().contains((Object)this.feature)) {
                EAttribute eAttribute = (EAttribute)this.feature;
                EClassifier eType = eAttribute.getEType();
                if (this.ownerList != null) {
                    if (!(this.index < 0 || this.index >= this.ownerList.size() || !eType.isInstance(this.value) || eAttribute.isUnique() && this.ownerList.contains(this.value))) {
                        this.oldValue = this.ownerList.get(this.index);
                        result = true;
                    }
                } else if (eAttribute.isMany()) {
                    if (this.owner.eIsSet((EStructuralFeature)eAttribute)) {
                        this.oldValue = new BasicEList((Collection)((EList)this.owner.eGet(this.feature)));
                    }
                    if (this.value == null) {
                        result = true;
                    } else if (this.value instanceof Collection) {
                        Collection collection = (Collection)this.value;
                        result = true;
                        Iterator objects = collection.iterator();
                        while (objects.hasNext()) {
                            if (eType.isInstance(objects.next())) continue;
                            result = false;
                            break;
                        }
                    }
                } else {
                    if (this.owner.eIsSet((EStructuralFeature)eAttribute)) {
                        this.oldValue = this.owner.eGet(this.feature);
                    }
                    result = this.value == null || eType.isInstance(this.value);
                }
            } else if (eMetaObject.getEAllReferences().contains((Object)this.feature)) {
                EReference eReference = (EReference)this.feature;
                if (this.ownerList != null) {
                    if (!(this.index < 0 || this.index >= this.ownerList.size() || !eReference.getEType().isInstance(this.value) || eReference.isUnique() && this.ownerList.contains(this.value))) {
                        this.oldValue = this.ownerList.get(this.index);
                        result = true;
                    }
                } else if (!eReference.isMany()) {
                    this.oldValue = this.owner.eGet(this.feature);
                    if (this.value == null || eReference.getEType().isInstance(this.value)) {
                        result = true;
                    }
                }
                if (result && eReference.isContainment()) {
                    EObject container = this.owner;
                    while (container != null) {
                        if (this.value == container) {
                            result = false;
                            break;
                        }
                        container = container.eContainer();
                    }
                }
                if (result && eReference.getEOpposite() != null) {
                    EReference eOtherEnd = eReference.getEOpposite();
                    if (eOtherEnd.isMany()) {
                        if (this.oldValue != null) {
                            EList oppositeList = (EList)((EObject)this.oldValue).eGet((EStructuralFeature)eOtherEnd);
                            this.canUndo = oppositeList.get(oppositeList.size() - 1) == this.owner;
                        }
                    } else {
                        this.canUndo = this.value == null || ((EObject)this.value).eGet((EStructuralFeature)eOtherEnd) == null;
                    }
                }
            }
        }
        return result;
    }

    public void doExecute() {
        if (this.ownerList != null) {
            this.ownerList.set(this.index, this.value);
        } else if (this.value == null) {
            this.owner.eUnset(this.feature);
        } else {
            this.owner.eSet(this.feature, this.value);
        }
    }

    public boolean doCanUndo() {
        return this.canUndo;
    }

    public void doUndo() {
        if (this.ownerList != null) {
            this.ownerList.set(this.index, this.oldValue);
        } else if (this.oldValue == null) {
            this.owner.eUnset(this.feature);
        } else {
            this.owner.eSet(this.feature, this.oldValue);
        }
    }

    public void doRedo() {
        if (this.ownerList != null) {
            this.ownerList.set(this.index, this.value);
        } else if (this.value == null) {
            this.owner.eUnset(this.feature);
        } else {
            this.owner.eSet(this.feature, this.value);
        }
    }

    public Collection doGetResult() {
        return Collections.singleton(this.owner);
    }

    public Collection doGetAffectedObjects() {
        return Collections.singleton(this.owner);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (feature: " + this.feature + ")");
        if (this.ownerList != null) {
            result.append(" (ownerList: " + this.ownerList + ")");
            result.append(" (index: " + this.index + ")");
        }
        result.append(" (value: " + this.value + ")");
        result.append(" (oldValue: " + this.oldValue + ")");
        return result.toString();
    }
}

