/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ant.taskdefs.codegen.ecore;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.eclipse.emf.ant.taskdefs.EMFTask;
import org.eclipse.emf.codegen.ecore.Generator;

public abstract class GeneratorTask
extends EMFTask {
    private static final int GENMODEL_OVERWRITE = 0;
    private static final int GENMODEL_KEEP = 1;
    private static final int GENMODEL_RELOAD = 2;
    private File model;
    private File genModel;
    private File modelProject;
    private String modelPluginID;
    private String modelProjectFragmentPath;
    private File templatePath;
    private String copyright;
    private boolean sdo = false;
    private int reconcileGenModel = 0;
    private boolean generateJavaCode = true;
    protected Commandline commandline;
    protected boolean useModelAttribute = true;
    protected boolean generateModelProject = true;
    protected boolean generateEditProject = true;
    protected boolean generateEditorProject = true;

    public void setModel(File model) {
        this.model = model;
    }

    public void setGenModel(File genModel) {
        this.genModel = genModel;
    }

    public void setModelProject(File modelProject) {
        this.modelProject = modelProject;
    }

    public void setModelProjectFragmentPath(String modelProjectFragmentPath) {
        this.modelProjectFragmentPath = modelProjectFragmentPath;
    }

    public void setModelPluginID(String modelPluginID) {
        this.modelPluginID = modelPluginID;
    }

    public Commandline.Argument createArg() {
        return this.getCommandline().createArgument();
    }

    public void setTemplatePath(File templatePath) {
        this.templatePath = templatePath;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setSDO(boolean sdo) {
        this.sdo = sdo;
    }

    public void setReconcileGenModel(ReconcileGenModelType type) {
        String value = type.getValue();
        if ("overwrite".equals(value)) {
            this.reconcileGenModel = 0;
        } else if ("keep".equals(value)) {
            this.reconcileGenModel = 1;
        } else if ("reload".equals(value)) {
            this.reconcileGenModel = 2;
        }
    }

    public void setGenerateJavaCode(boolean generateJavaCode) {
        this.generateJavaCode = generateJavaCode;
    }

    protected Commandline getCommandline() {
        if (this.commandline == null) {
            this.commandline = new Commandline();
        }
        return this.commandline;
    }

    protected void checkAttributes() throws BuildException {
        if (this.useModelAttribute) {
            EMFTask.assertTrue("The 'model' attribute must be specified.", this.model != null);
        }
        if (this.reconcileGenModel != 2) {
            EMFTask.assertTrue("The 'modelProject' attribute must be specified.", this.modelProject != null);
        }
        EMFTask.assertTrue("The 'genModel' attribute must be specified.", this.genModel != null);
        EMFTask.assertTrue("The specifed 'templatePath' attribute is not a valid directory.", this.templatePath == null || this.templatePath.isDirectory());
    }

    protected void doExecute() throws Exception {
        switch (this.reconcileGenModel) {
            case 1: {
                if (this.genModel.exists()) break;
            }
            case 0: 
            case 2: {
                this.addGenModelArguments();
                this.adjustEditAndEditorProjects();
                this.createGenModel(this.getCommandline().getArguments());
            }
        }
        if (this.generateJavaCode) {
            List arguments = this.getGeneratorArguments();
            this.generateCodeFromGenModel(arguments.toArray(new String[arguments.size()]));
        }
    }

    protected abstract void createGenModel(String[] var1) throws Exception;

    protected void addGenModelArguments() {
        if (this.genModel != null) {
            this.getCommandline().createArgument(true).setValue(this.genModel.getAbsolutePath());
            if (this.reconcileGenModel == 2) {
                this.getCommandline().createArgument().setValue("-reload");
            }
        }
        if (this.model != null) {
            this.getCommandline().createArgument(true).setValue(this.model.getAbsolutePath());
        }
        if (this.modelProject != null) {
            this.getCommandline().createArgument().setValue("-modelProject");
            this.getCommandline().createArgument().setValue(this.modelProject.getAbsolutePath());
        }
        if (this.modelProjectFragmentPath != null) {
            this.getCommandline().createArgument().setValue(this.modelProjectFragmentPath);
        }
        if (this.templatePath != null) {
            this.getCommandline().createArgument().setValue("-templatePath");
            this.getCommandline().createArgument().setValue(this.templatePath.getAbsolutePath());
        }
        if (this.modelPluginID != null) {
            this.getCommandline().createArgument().setValue("-modelPluginID");
            this.getCommandline().createArgument().setValue(this.modelPluginID);
        }
        if (this.copyright != null) {
            this.getCommandline().createArgument().setValue("-copyright");
            this.getCommandline().createArgument().setValue(this.copyright);
        }
        if (this.sdo) {
            this.getCommandline().createArgument().setValue("-sdo");
        }
    }

    protected void adjustEditAndEditorProjects() {
        String arguments = this.getCommandline().toString();
        if (arguments.indexOf("-editProject") < 0) {
            this.generateEditProject = false;
            if (this.modelProject != null) {
                this.getCommandline().createArgument().setValue("-editProject");
                this.getCommandline().createArgument().setValue(String.valueOf(this.modelProject.getAbsolutePath()) + ".edit");
                if (this.modelProjectFragmentPath != null) {
                    this.getCommandline().createArgument().setValue(this.modelProjectFragmentPath);
                }
            }
        }
        if (arguments.indexOf("-editorProject") < 0) {
            this.generateEditorProject = false;
            if (this.modelProject != null) {
                this.getCommandline().createArgument().setValue("-editorProject");
                this.getCommandline().createArgument().setValue(String.valueOf(this.modelProject.getAbsolutePath()) + ".editor");
                if (this.modelProjectFragmentPath != null) {
                    this.getCommandline().createArgument().setValue(this.modelProjectFragmentPath);
                }
            }
        }
    }

    protected List getGeneratorArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.generateModelProject) {
            arguments.add("-model");
        }
        if (this.generateEditProject) {
            arguments.add("-edit");
        }
        if (this.generateEditorProject) {
            arguments.add("-editor");
        }
        arguments.add(this.genModel.getAbsolutePath());
        return arguments;
    }

    protected void generateCodeFromGenModel(String[] arguments) {
        new Generator().run((Object)arguments);
    }

    public static class ReconcileGenModelType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"overwrite", "keep", "reload"};
        }
    }
}

